/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import cn.hutool.core.io.FileUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.byh.outpatient.api.dto.MinioResponseDTO;
import com.byh.outpatient.api.model.MinioFileEntity;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.web.mvc.config.MinioConfig;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.mvc.utils.MinioClientUtils;
import com.byh.outpatient.web.service.MinioFileService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u6587\u4ef6\u5904\u7406\u6a21\u5757"})
@RestController
@CrossOrigin
@RequestMapping(value={"/minioFile"})
public class MinioFileController {
    private static final Logger log = LoggerFactory.getLogger(MinioFileController.class);
    @Resource
    private MinioClientUtils minioClientUtils;
    @Resource
    private MinioConfig minioConfig;
    @Autowired
    private MinioFileService minioFileService;
    @Autowired
    private CommonRequest commonRequest;

    @PostMapping(value={"/uploadFile"})
    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6,\u652f\u6301\u6279\u91cf\u4e0a\u4f20")
    @ApiImplicitParam(name="files", value="\u6587\u4ef6\u5bf9\u8c61", dataType="File")
    public ResponseData<List<MinioResponseDTO>> uploadFile(@RequestParam(value="files") List<MultipartFile> files) {
        log.info(files.toString());
        Integer tenant = this.commonRequest.getTenant();
        if (CollectionUtils.isEmpty(files)) {
            return ResponseData.error((String)"\u672a\u9009\u62e9\u6587\u4ef6\uff01");
        }
        ArrayList<MinioResponseDTO> MinioResponseDTOList = new ArrayList<MinioResponseDTO>();
        for (MultipartFile file : files) {
            String originalFilename = file.getOriginalFilename();
            String extName = FileUtil.extName((String)originalFilename);
            log.info("\u6587\u4ef6\u62d3\u5c55\u540d:" + extName);
            long millSeconds = Instant.now().toEpochMilli();
            String minioFileName = millSeconds + RandomStringUtils.randomNumeric((int)12) + "." + extName;
            String contentType = file.getContentType();
            log.info("\u6587\u4ef6mime:{}", (Object)contentType);
            long size = file.getSize();
            log.info("\u6587\u4ef6\u5927\u5c0f\uff1a" + size);
            try {
                String bucketName = this.minioConfig.getBucketName();
                this.minioClientUtils.putObject(bucketName, file, minioFileName);
                String fileUrl = this.minioClientUtils.getObjectUrl(bucketName, minioFileName);
                MinioFileEntity minioFile = new MinioFileEntity();
                minioFile.setOriginalFileName(originalFilename);
                minioFile.setFileExtName(extName);
                minioFile.setFileName(minioFileName);
                minioFile.setFileSize(Long.valueOf(size));
                minioFile.setMime(contentType);
                minioFile.setTenantId(tenant);
                minioFile.setCreateTime(new Date());
                minioFile.setIsDelete(Boolean.valueOf(NumberUtils.INTEGER_ZERO != 0));
                minioFile.setFileUrl(fileUrl);
                boolean insert = this.minioFileService.save(minioFile);
                if (!insert) continue;
                MinioResponseDTO minioResponseDTO = new MinioResponseDTO();
                minioResponseDTO.setFileId(minioFile.getId());
                minioResponseDTO.setOriginalFileName(originalFilename);
                minioResponseDTO.setFileUrl(fileUrl);
                minioResponseDTO.setMinioFileName(minioFileName);
                MinioResponseDTOList.add(minioResponseDTO);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u4e0a\u4f20\u6587\u4ef6\u51fa\u9519:{}", (Throwable)e);
                return ResponseData.error((String)"\u4e0a\u4f20\u6587\u4ef6\u51fa\u9519");
            }
        }
        return ResponseData.success(MinioResponseDTOList);
    }

    @ApiOperation(value="\u5220\u9664\u6587\u4ef6", notes="\u5220\u9664\u6587\u4ef6")
    @RequestMapping(value={"/deleteMinioFile"}, method={RequestMethod.GET})
    public ResponseData<?> deleteMinioFile(@RequestParam String minioFileName) {
        try {
            String bucketName = this.minioConfig.getBucketName();
            this.minioClientUtils.removeObject(bucketName, minioFileName);
            MinioFileEntity minioFile = this.minioFileService.getOne((QueryWrapper)new QueryWrapper().eq((Object)"file_name", (Object)minioFileName));
            if (minioFile == null) {
                log.error("\u6587\u4ef6\u4e0d\u5b58\u5728\u6570\u636e\u5e93\u8868\u4e2d\uff01");
                return ResponseData.error((String)"\u6587\u4ef6\u4e0d\u5b58\u5728\u6570\u636e\u5e93\u8868\u4e2d\uff01");
            }
            this.minioFileService.removeById(minioFile);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff01");
            return ResponseData.error((String)"\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff01");
        }
        return ResponseData.success((Object)"\u5220\u9664\u6587\u4ef6\u6210\u529f");
    }
}

