/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import com.byh.outpatient.api.model.DiseaseSalesStatisticsEntity;
import com.byh.outpatient.api.model.HsSalesStatisticsEntity;
import com.byh.outpatient.api.model.treatment.hsSalesStatisticsDetailEntity;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.StringUtil;
import com.byh.outpatient.data.repository.DiseaseSalesStatisticsMapper;
import com.byh.outpatient.web.service.DiseaseSalesStatisticsService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DiseaseSalesStatisticsServiceImpl
implements DiseaseSalesStatisticsService {
    @Autowired
    private DiseaseSalesStatisticsMapper diseaseSalesStatisticsMapper;

    public ResponseData<List<DiseaseSalesStatisticsEntity>> querySalesStatisticsByTotal(DiseaseSalesStatisticsEntity entity) {
        String time = entity.getTime();
        if (StringUtil.isBlank((String)time)) {
            return ResponseData.error((String)"\u67e5\u8be2\u65e5\u671f\u4e0d\u53ef\u4e3a\u7a7a!");
        }
        List list = this.diseaseSalesStatisticsMapper.querySalesStatisticsByTotal(entity);
        return ResponseData.success((Object)list);
    }

    public ResponseData<List<DiseaseSalesStatisticsEntity>> querySalesStatisticsByDrugType(DiseaseSalesStatisticsEntity entity) {
        String time = entity.getTime();
        if (StringUtil.isBlank((String)time)) {
            return ResponseData.error((String)"\u67e5\u8be2\u65e5\u671f\u4e0d\u53ef\u4e3a\u7a7a!");
        }
        List list = this.diseaseSalesStatisticsMapper.querySalesStatisticsByDrugType(entity);
        return ResponseData.success((Object)list);
    }

    public ResponseData<HsSalesStatisticsEntity> querySalesStatistics2(DiseaseSalesStatisticsEntity entity) {
        HsSalesStatisticsEntity data = new HsSalesStatisticsEntity();
        this.getJsrc(entity, data);
        this.getJsrs(entity, data);
        this.getYlzfy(entity, data);
        this.getYbzf(entity, data);
        this.getCjfy(entity, data);
        this.getMzMmt(entity, data);
        this.getBdylfy(entity, data);
        this.getSwylfy(entity, data);
        this.getSnList(entity, data);
        this.getHzpmList(entity, data);
        this.getBzpmList(entity, data);
        this.getYppmList(entity, data);
        return ResponseData.success((Object)data);
    }

    public void getJsrc(DiseaseSalesStatisticsEntity entity, HsSalesStatisticsEntity data) {
        entity.setQueryType("day");
        Integer jsrc = this.diseaseSalesStatisticsMapper.queryJsrc(entity);
        entity.setQueryType("now");
        Integer jsrcNow = this.diseaseSalesStatisticsMapper.queryJsrc(entity);
        entity.setQueryType("previous");
        Integer jsrcPrevious = this.diseaseSalesStatisticsMapper.queryJsrc(entity);
        BigDecimal divide = new BigDecimal(jsrcNow - jsrcPrevious).divide(new BigDecimal(jsrcPrevious), 3, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
        data.setJsrc(jsrc);
        data.setJsrczf(divide.stripTrailingZeros().toString() + "%");
    }

    public void getJsrs(DiseaseSalesStatisticsEntity entity, HsSalesStatisticsEntity data) {
        entity.setQueryType("day");
        Integer jsrs = this.diseaseSalesStatisticsMapper.queryJsrs(entity);
        entity.setQueryType("now");
        Integer jsrsNow = this.diseaseSalesStatisticsMapper.queryJsrs(entity);
        entity.setQueryType("previous");
        Integer jsrsPrevious = this.diseaseSalesStatisticsMapper.queryJsrs(entity);
        BigDecimal divide1 = new BigDecimal(jsrsNow - jsrsPrevious).divide(new BigDecimal(jsrsPrevious), 3, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
        data.setJsrs(jsrs);
        data.setJsrszf(divide1.stripTrailingZeros().toString() + "%");
    }

    public void getYlzfy(DiseaseSalesStatisticsEntity entity, HsSalesStatisticsEntity data) {
        entity.setQueryType("day");
        String ylzfy = this.diseaseSalesStatisticsMapper.queryYlzfy(entity);
        entity.setQueryType("now");
        String ylzfyNow = this.diseaseSalesStatisticsMapper.queryYlzfy(entity);
        entity.setQueryType("previous");
        String ylzfyPrevious = this.diseaseSalesStatisticsMapper.queryYlzfy(entity);
        BigDecimal divide2 = new BigDecimal(ylzfyNow).subtract(new BigDecimal(ylzfyPrevious)).divide(new BigDecimal(ylzfyPrevious), 3, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
        data.setYlzfy(new BigDecimal(ylzfy).stripTrailingZeros().toString());
        data.setYlzfyzf(divide2.stripTrailingZeros().toString() + "%");
    }

    public void getYbzf(DiseaseSalesStatisticsEntity entity, HsSalesStatisticsEntity data) {
        entity.setQueryType("day");
        String ybzf = this.diseaseSalesStatisticsMapper.queryYbzf(entity);
        entity.setQueryType("now");
        String ybzfNow = this.diseaseSalesStatisticsMapper.queryYbzf(entity);
        entity.setQueryType("previous");
        String ybzfPrevious = this.diseaseSalesStatisticsMapper.queryYbzf(entity);
        BigDecimal divide3 = new BigDecimal(ybzfNow).subtract(new BigDecimal(ybzfPrevious)).divide(new BigDecimal(ybzfPrevious), 3, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
        data.setYbzf(new BigDecimal(ybzf).stripTrailingZeros().toString());
        data.setYbzfzf(divide3.stripTrailingZeros().toString() + "%");
    }

    public void getCjfy(DiseaseSalesStatisticsEntity entity, HsSalesStatisticsEntity data) {
        entity.setQueryType("day");
        String cjfy = this.diseaseSalesStatisticsMapper.queryCjfy(entity);
        entity.setQueryType("now");
        String cjfyNow = this.diseaseSalesStatisticsMapper.queryCjfy(entity);
        entity.setQueryType("previous");
        String cjfyPrevious = this.diseaseSalesStatisticsMapper.queryCjfy(entity);
        BigDecimal divide4 = new BigDecimal(cjfyNow).subtract(new BigDecimal(cjfyPrevious)).divide(new BigDecimal(cjfyPrevious), 3, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
        data.setCjfy(new BigDecimal(cjfy).stripTrailingZeros().toString());
        data.setCjfyzf(divide4.stripTrailingZeros().toString() + "%");
    }

    public void getMzMmt(DiseaseSalesStatisticsEntity entity, HsSalesStatisticsEntity data) {
        entity.setQueryType("day");
        Object ptmz = "";
        Object mmt = "";
        List maps = this.diseaseSalesStatisticsMapper.queryYllbzb(entity);
        for (Map map : maps) {
            String medType = map.get("med_type").toString();
            String medfeeSumamt = map.get("medfee_sumamt").toString();
            if (medType.equals("11")) {
                ptmz = medfeeSumamt;
                continue;
            }
            mmt = medfeeSumamt;
        }
        Object ptmzNow = "";
        Object mmtNow = "";
        entity.setQueryType("now");
        List mapsNow = this.diseaseSalesStatisticsMapper.queryYllbzb(entity);
        for (Map map : mapsNow) {
            String medType = map.get("med_type").toString();
            String medfeeSumamt = map.get("medfee_sumamt").toString();
            if (medType.equals("11")) {
                ptmzNow = medfeeSumamt;
                continue;
            }
            mmtNow = medfeeSumamt;
        }
        String ptmzPrevious = "";
        String mmtPrevious = "";
        entity.setQueryType("previous");
        List mapsPrevious = this.diseaseSalesStatisticsMapper.queryYllbzb(entity);
        for (Map map : mapsPrevious) {
            String medType = map.get("med_type").toString();
            String medfeeSumamt = map.get("medfee_sumamt").toString();
            if (medType.equals("11")) {
                ptmzPrevious = medfeeSumamt;
                continue;
            }
            mmtPrevious = medfeeSumamt;
        }
        BigDecimal divide5 = new BigDecimal((String)ptmzNow).subtract(new BigDecimal(ptmzPrevious)).divide(new BigDecimal(ptmzPrevious), 3, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
        BigDecimal divide6 = new BigDecimal((String)mmtNow).subtract(new BigDecimal(mmtPrevious)).divide(new BigDecimal(mmtPrevious), 3, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
        BigDecimal multiply = new BigDecimal((String)ptmz).divide(new BigDecimal(data.getYlzfy()), 3, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
        data.setPtfy(new BigDecimal((String)ptmz).stripTrailingZeros().toString());
        data.setPtfyzf(divide5.stripTrailingZeros().toString() + "%");
        data.setPtfyzb(multiply.stripTrailingZeros().toString() + "%");
        BigDecimal multiply1 = new BigDecimal((String)mmt).divide(new BigDecimal(data.getYlzfy()), 3, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
        data.setMmtfy(new BigDecimal((String)mmt).stripTrailingZeros().toString());
        data.setMmtfyzf(divide6.stripTrailingZeros().toString() + "%");
        data.setMmtfyzb(multiply1.stripTrailingZeros().toString() + "%");
    }

    public void getBdylfy(DiseaseSalesStatisticsEntity entity, HsSalesStatisticsEntity data) {
        entity.setQueryType("day");
        entity.setAddress("bd");
        List mapsBd = this.diseaseSalesStatisticsMapper.queryYlfyzb(entity);
        String amountBd = "0";
        for (Map map : mapsBd) {
            String amount = map.get("amount").toString();
            amountBd = new BigDecimal(amountBd).add(new BigDecimal(amount)).toString();
        }
        entity.setQueryType("now");
        String amountBdNow = "0";
        List mapsBdNow = this.diseaseSalesStatisticsMapper.queryYlfyzb(entity);
        for (Map map : mapsBdNow) {
            String amount = map.get("amount").toString();
            amountBdNow = new BigDecimal(amountBdNow).add(new BigDecimal(amount)).toString();
        }
        entity.setQueryType("previous");
        String amountBdPrevious = "0";
        List mapsBdPrevious = this.diseaseSalesStatisticsMapper.queryYlfyzb(entity);
        for (Map map : mapsBdPrevious) {
            String amount = map.get("amount").toString();
            amountBdPrevious = new BigDecimal(amountBdPrevious).add(new BigDecimal(amount)).toString();
        }
        BigDecimal multiply2 = new BigDecimal(amountBd).divide(new BigDecimal(data.getYlzfy()), 5, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
        BigDecimal divide7 = new BigDecimal(amountBdNow).subtract(new BigDecimal(amountBdPrevious)).divide(new BigDecimal(amountBdPrevious), 3, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
        data.setBdylfy(new BigDecimal(amountBd).stripTrailingZeros().toString());
        data.setBdylfyzb(multiply2.stripTrailingZeros().toString() + "%");
        data.setBdylfyzf(divide7.stripTrailingZeros().toString() + "%");
    }

    public void getSwylfy(DiseaseSalesStatisticsEntity entity, HsSalesStatisticsEntity data) {
        entity.setQueryType("day");
        entity.setAddress("sw");
        List mapsSw = this.diseaseSalesStatisticsMapper.queryYlfyzb(entity);
        String amountSw = "0";
        for (Map map : mapsSw) {
            if (map == null) continue;
            String amount = map.get("amount").toString();
            amountSw = new BigDecimal(amountSw).add(new BigDecimal(amount)).toString();
        }
        entity.setQueryType("now");
        String amountSwNow = "0";
        List mapsSwNow = this.diseaseSalesStatisticsMapper.queryYlfyzb(entity);
        for (Map map : mapsSwNow) {
            if (map == null) continue;
            String amount = map.get("amount").toString();
            amountSwNow = new BigDecimal(amountSwNow).add(new BigDecimal(amount)).toString();
        }
        entity.setQueryType("previous");
        String amountSwPrevious = "0";
        List mapsSwPrevious = this.diseaseSalesStatisticsMapper.queryYlfyzb(entity);
        for (Map map : mapsSwPrevious) {
            String amount = map.get("amount").toString();
            amountSwPrevious = new BigDecimal(amountSwPrevious).add(new BigDecimal(amount)).toString();
        }
        BigDecimal multiply3 = new BigDecimal(amountSw).divide(new BigDecimal(data.getYlzfy()), 5, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
        BigDecimal divide8 = new BigDecimal(amountSwNow).subtract(new BigDecimal(amountSwPrevious)).divide(new BigDecimal(amountSwPrevious), 3, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
        data.setSwylfy(new BigDecimal(amountSw).stripTrailingZeros().toString());
        data.setSwylfyzb(multiply3.stripTrailingZeros().toString() + "%");
        data.setSwylfyzf(divide8.stripTrailingZeros().toString() + "%");
    }

    public void getSnList(DiseaseSalesStatisticsEntity entity, HsSalesStatisticsEntity data) {
        ArrayList<hsSalesStatisticsDetailEntity> snList = new ArrayList<hsSalesStatisticsDetailEntity>();
        String[] names = new String[]{"\u4e5d\u6c5f", "\u4e0a\u9976", "\u629a\u5dde", "\u5b9c\u6625", "\u5409\u5b89", "\u8d63\u5dde", "\u666f\u5fb7\u9547", "\u840d\u4e61", "\u65b0\u4f59", "\u9e70\u6f6d", "\u6c5f\u897f"};
        entity.setQueryType("day");
        entity.setAddress("sn");
        List mapsSn = this.diseaseSalesStatisticsMapper.queryYlfyzb(entity);
        entity.setQueryType("now");
        List mapsSnNow = this.diseaseSalesStatisticsMapper.queryYlfyzb(entity);
        entity.setQueryType("previous");
        List mapsSnPrevious = this.diseaseSalesStatisticsMapper.queryYlfyzb(entity);
        for (String name : names) {
            Object map2;
            hsSalesStatisticsDetailEntity item = new hsSalesStatisticsDetailEntity();
            String amountSn = "0";
            for (Object map2 : mapsSn) {
                String amount;
                String label = map2.get("label").toString();
                if (!name.equals("\u6c5f\u897f")) {
                    if (!label.contains(name)) continue;
                    amount = map2.get("amount").toString();
                    amountSn = new BigDecimal(amountSn).add(new BigDecimal(amount)).toString();
                    continue;
                }
                if (!label.equals("\u6c5f\u897f\u7701") && !label.equals("\u6c5f\u897f\u7701-\u6c5f\u897f\u7701\u7701\u672c\u7ea7")) continue;
                amount = map2.get("amount").toString();
                amountSn = new BigDecimal(amountSn).add(new BigDecimal(amount)).toString();
            }
            entity.setQueryType("now");
            String amountSnNow = "0";
            map2 = mapsSnNow.iterator();
            while (map2.hasNext()) {
                String amount;
                Map map3 = (Map)map2.next();
                String label = map3.get("label").toString();
                if (!name.equals("\u6c5f\u897f")) {
                    if (!label.contains(name)) continue;
                    amount = map3.get("amount").toString();
                    amountSnNow = new BigDecimal(amountSnNow).add(new BigDecimal(amount)).toString();
                    continue;
                }
                if (!label.equals("\u6c5f\u897f\u7701") && !label.equals("\u6c5f\u897f\u7701-\u6c5f\u897f\u7701\u7701\u672c\u7ea7")) continue;
                amount = map3.get("amount").toString();
                amountSnNow = new BigDecimal(amountSnNow).add(new BigDecimal(amount)).toString();
            }
            entity.setQueryType("previous");
            String amountSnPrevious = "0";
            for (Map map4 : mapsSnPrevious) {
                String amount;
                String label = map4.get("label").toString();
                if (!name.equals("\u6c5f\u897f")) {
                    if (!label.contains(name)) continue;
                    amount = map4.get("amount").toString();
                    amountSnPrevious = new BigDecimal(amountSnPrevious).add(new BigDecimal(amount)).toString();
                    continue;
                }
                if (!label.equals("\u6c5f\u897f\u7701") && !label.equals("\u6c5f\u897f\u7701-\u6c5f\u897f\u7701\u7701\u672c\u7ea7")) continue;
                amount = map4.get("amount").toString();
                amountSnPrevious = new BigDecimal(amountSnPrevious).add(new BigDecimal(amount)).toString();
            }
            BigDecimal multiply4 = new BigDecimal(amountSn).divide(new BigDecimal(data.getYlzfy()), 3, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
            BigDecimal divide9 = new BigDecimal(amountSnNow).subtract(new BigDecimal(amountSnPrevious)).divide(new BigDecimal(amountSnPrevious), 3, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
            item.setName(name);
            item.setValue(new BigDecimal(amountSn).stripTrailingZeros().toString());
            item.setZf(divide9.stripTrailingZeros().toString() + "%");
            item.setZb(multiply4.stripTrailingZeros().toString() + "%");
            snList.add(item);
        }
        data.setSnList(snList);
    }

    public void getHzpmList(DiseaseSalesStatisticsEntity entity, HsSalesStatisticsEntity data) {
        ArrayList<hsSalesStatisticsDetailEntity> hzpmList = new ArrayList<hsSalesStatisticsDetailEntity>();
        List maps2 = this.diseaseSalesStatisticsMapper.queryZfpmhz(entity);
        for (Map map : maps2) {
            String name = map.get("name").toString();
            String value = map.get("value").toString();
            hsSalesStatisticsDetailEntity item = new hsSalesStatisticsDetailEntity();
            item.setName(name);
            item.setValue(new BigDecimal(value).stripTrailingZeros().toString());
            hzpmList.add(item);
        }
        data.setHzpmList(hzpmList);
    }

    public void getBzpmList(DiseaseSalesStatisticsEntity entity, HsSalesStatisticsEntity data) {
        ArrayList<hsSalesStatisticsDetailEntity> bzpmList = new ArrayList<hsSalesStatisticsDetailEntity>();
        List maps3 = this.diseaseSalesStatisticsMapper.queryZfpmbz(entity);
        for (Map map : maps3) {
            String name = map.get("name").toString();
            String value = map.get("value").toString();
            hsSalesStatisticsDetailEntity item = new hsSalesStatisticsDetailEntity();
            item.setName(name);
            item.setValue(new BigDecimal(value).stripTrailingZeros().toString());
            bzpmList.add(item);
        }
        data.setBzpmList(bzpmList);
    }

    public void getYppmList(DiseaseSalesStatisticsEntity entity, HsSalesStatisticsEntity data) {
        ArrayList<hsSalesStatisticsDetailEntity> yppmList = new ArrayList<hsSalesStatisticsDetailEntity>();
        List maps4 = this.diseaseSalesStatisticsMapper.queryZfpmyp(entity);
        for (Map map : maps4) {
            String name = map.get("name").toString();
            String value = map.get("value").toString();
            hsSalesStatisticsDetailEntity item = new hsSalesStatisticsDetailEntity();
            item.setName(name);
            item.setValue(new BigDecimal(value).stripTrailingZeros().toString());
            yppmList.add(item);
        }
        data.setYppmList(yppmList);
    }
}

