/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.outpatient.api.dto.hsSettlement.ReconciliationTotalDto;
import com.byh.outpatient.api.dto.order.OutpatientDaySettlementDto;
import com.byh.outpatient.api.dto.order.PaymentRecordsDto;
import com.byh.outpatient.api.dto.order.QueryFeeDetailsListDto;
import com.byh.outpatient.api.enums.PaymentMethodEnum;
import com.byh.outpatient.api.enums.PaymentRecordsStatusEnum;
import com.byh.outpatient.api.enums.PaymentStatusEnum;
import com.byh.outpatient.api.enums.PendingStatusEnum;
import com.byh.outpatient.api.model.BaseEntity;
import com.byh.outpatient.api.model.OutpatientDaySettlementEntity;
import com.byh.outpatient.api.model.admission.AdmissionEntity;
import com.byh.outpatient.api.model.hsSettlement.HsSettlementInfoEntity;
import com.byh.outpatient.api.model.order.OutOrderPayment;
import com.byh.outpatient.api.model.order.OutOrderPaymentRecord;
import com.byh.outpatient.api.model.pending.OutPendingAccountRecords;
import com.byh.outpatient.api.model.pending.OutPendingItems;
import com.byh.outpatient.api.sysModel.respones.SysUserVo;
import com.byh.outpatient.api.util.DateUtils;
import com.byh.outpatient.api.util.HyposensitizationUtil;
import com.byh.outpatient.api.util.PageResult;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.StringUtil;
import com.byh.outpatient.api.vo.hsSettlement.TotalHsSettlmentRes;
import com.byh.outpatient.api.vo.order.FeeDetail;
import com.byh.outpatient.api.vo.order.FeeDetailRes;
import com.byh.outpatient.api.vo.order.OutpatientDaySettlementVo;
import com.byh.outpatient.api.vo.order.PayMethodDetail;
import com.byh.outpatient.api.vo.order.PayVo;
import com.byh.outpatient.api.vo.order.PaymentDetailsVo;
import com.byh.outpatient.api.vo.order.PaymethodDetailRes;
import com.byh.outpatient.api.vo.order.QueryFeeOrderDetailsVo;
import com.byh.outpatient.api.vo.order.QueryFeeOrderPaidItemsVo;
import com.byh.outpatient.api.vo.order.QueryPaymentRecordDetailsItemVo;
import com.byh.outpatient.api.vo.order.QueryPaymentRecordDetailsPrintVo;
import com.byh.outpatient.api.vo.order.QueryPaymentRecordDetailsVo;
import com.byh.outpatient.api.vo.order.QueryPaymentRecords;
import com.byh.outpatient.api.vo.order.QueryPaymentRecordsDetails;
import com.byh.outpatient.api.vo.order.QueryPaymentRecordsVo;
import com.byh.outpatient.api.vo.order.RegCountRes;
import com.byh.outpatient.api.vo.order.SelfSettlementRes;
import com.byh.outpatient.api.vo.order.TotalSettlementRes;
import com.byh.outpatient.data.repository.AdmissionMapper;
import com.byh.outpatient.data.repository.OutHsSettlementInfoMapper;
import com.byh.outpatient.data.repository.OutOrderMapper;
import com.byh.outpatient.data.repository.OutOrderPaymentMapper;
import com.byh.outpatient.data.repository.OutOrderPaymentRecordMapper;
import com.byh.outpatient.data.repository.OutPendingAccountRecordsMapper;
import com.byh.outpatient.data.repository.OutPendingItemsMapper;
import com.byh.outpatient.data.repository.OutTreatmentItemsMapper;
import com.byh.outpatient.data.repository.OutpatientDaySettlementMapper;
import com.byh.outpatient.web.feign.SysServiceFeign;
import com.byh.outpatient.web.mvc.exception.RunDisplayException;
import com.byh.outpatient.web.service.OutOrderPaymentService;
import com.byh.outpatient.web.service.OutOrderService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class OutOrderPaymentServiceImpl
implements OutOrderPaymentService {
    private static final Logger log = LoggerFactory.getLogger(OutOrderPaymentServiceImpl.class);
    @Autowired
    private OutOrderPaymentRecordMapper outOrderPaymentRecordMapper;
    @Autowired
    private OutOrderPaymentMapper outOrderPaymentMapper;
    @Autowired
    private OutOrderMapper outOrderMapper;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private OutPendingAccountRecordsMapper outPendingAccountRecordsMapper;
    @Autowired
    private OutPendingItemsMapper outPendingItemsMapper;
    @Autowired
    private OutpatientDaySettlementMapper outpatientDaySettlementMapper;
    @Autowired
    private OutHsSettlementInfoMapper outHsSettlementInfoMapper;
    @Autowired
    private SysServiceFeign sysServiceFeign;
    @Autowired
    private OutOrderService outOrderService;
    @Autowired
    private OutTreatmentItemsMapper outTreatmentItemsMapper;

    public ResponseData<PageResult<QueryPaymentRecords>> paymentRecords(PaymentRecordsDto parameter) {
        Integer tenantId = parameter.getTenantId();
        if (!StringUtil.isEmpty((String)parameter.getStarTime()) && !StringUtil.isEmpty((String)parameter.getEndTime())) {
            parameter.setStarTime(parameter.getStarTime() + " 00:00:00");
            parameter.setEndTime(parameter.getEndTime() + " 23:59:59");
        }
        if (parameter.getSize() != null && parameter.getSize() == -1) {
            parameter.setSize(Integer.valueOf(9999999));
        }
        PageHelper.startPage((int)parameter.getCurrent(), (int)parameter.getSize());
        long start = new Date().getTime();
        List queryPaymentRecords = this.outOrderPaymentMapper.paymentRecords(parameter);
        long end = new Date().getTime();
        System.out.println(end - start + "-----------------------------------------------");
        for (QueryPaymentRecords queryPaymentRecord : queryPaymentRecords) {
            String payOrderNo = queryPaymentRecord.getPayOrderNo();
            PaymentRecordsDto paymentRecordsDto = new PaymentRecordsDto();
            paymentRecordsDto.setTenantId(tenantId);
            paymentRecordsDto.setPayOrderNo(payOrderNo);
            List maps = this.outOrderPaymentMapper.queryPaymentRecordDetailsItem(paymentRecordsDto);
            queryPaymentRecord.setDetailsList(maps);
            ArrayList<PayMethodDetail> payMethodDetailList = new ArrayList<PayMethodDetail>();
            if (!Objects.isNull(queryPaymentRecord.getOwnPayAmount())) {
                PayMethodDetail payMethodDetail2 = new PayMethodDetail();
                payMethodDetail2.setPayMethod(queryPaymentRecord.getPaymentMethod());
                payMethodDetail2.setAmount(queryPaymentRecord.getOwnPayAmount());
                payMethodDetailList.add(payMethodDetail2);
                PayMethodDetail payMethodDetail1 = new PayMethodDetail();
                payMethodDetail1.setPayMethod(PaymentMethodEnum.PAY_MEDICAL_INSURANCE.getValue());
                payMethodDetail1.setAmount(queryPaymentRecord.getHsPayAmount());
                payMethodDetailList.add(payMethodDetail1);
            } else {
                PayMethodDetail payMethodDetail = new PayMethodDetail();
                payMethodDetail.setPayMethod(queryPaymentRecord.getPaymentMethod());
                payMethodDetail.setAmount(queryPaymentRecord.getActualPayment());
                payMethodDetailList.add(payMethodDetail);
            }
            queryPaymentRecord.setPayMethodDetail(payMethodDetailList);
        }
        for (QueryPaymentRecords record : queryPaymentRecords) {
            String patientName = HyposensitizationUtil.hyposensitizationForName((String)record.getPatientName());
            record.setPatientName(patientName);
        }
        PageInfo pageInfo = new PageInfo(queryPaymentRecords);
        PageResult pageResult = new PageResult(parameter.getCurrent().intValue(), parameter.getSize().intValue());
        pageResult.setTotal(Integer.parseInt(String.valueOf(pageInfo.getTotal())));
        pageResult.setPages(pageInfo.getPages());
        pageResult.setRecords(queryPaymentRecords);
        pageResult.setCurrent(parameter.getCurrent().intValue());
        pageResult.setSize(parameter.getSize().intValue());
        return ResponseData.success((Object)pageResult);
    }

    public ResponseData<PageResult<QueryPaymentRecordsDetails>> paymentRecordsDetails(PaymentRecordsDto parameter) {
        Integer tenantId = parameter.getTenantId();
        if (!StringUtil.isEmpty((String)parameter.getStarTime()) && !StringUtil.isEmpty((String)parameter.getEndTime())) {
            parameter.setStarTime(parameter.getStarTime() + " 00:00:00");
            parameter.setEndTime(parameter.getEndTime() + " 23:59:59");
        }
        PageHelper.startPage((int)parameter.getCurrent(), (int)parameter.getSize());
        List queryPaymentRecords = this.outOrderPaymentMapper.paymentRecords(parameter);
        ArrayList<QueryPaymentRecordsDetails> detailsList = new ArrayList<QueryPaymentRecordsDetails>();
        PageInfo queryPaymentRecordsPageInfo = new PageInfo(queryPaymentRecords);
        queryPaymentRecordsPageInfo.getTotal();
        for (QueryPaymentRecords queryPaymentRecord : queryPaymentRecords) {
            QueryPaymentRecordsDetails queryPaymentRecordsDetails = new QueryPaymentRecordsDetails();
            BeanUtils.copyProperties((Object)queryPaymentRecord, (Object)queryPaymentRecordsDetails);
            String payOrderNo = queryPaymentRecord.getPayOrderNo();
            PaymentRecordsDto paymentRecordsDto = new PaymentRecordsDto();
            paymentRecordsDto.setTenantId(tenantId);
            paymentRecordsDto.setPayOrderNo(payOrderNo);
            List maps = this.outOrderPaymentMapper.queryPaymentRecordDetailsItem(paymentRecordsDto);
            for (QueryFeeOrderDetailsVo queryFeeOrderDetailsVo : maps) {
                String orderType = queryFeeOrderDetailsVo.getOrderType();
                if (queryFeeOrderDetailsVo.getPaymentStatus() != 20) continue;
                switch (orderType) {
                    case "10": {
                        queryPaymentRecordsDetails.setGuaHao(queryFeeOrderDetailsVo.getTotalAmount().add(new BigDecimal(queryPaymentRecordsDetails.getGuaHao())).toString());
                        break;
                    }
                    case "20": {
                        queryPaymentRecordsDetails.setXiYao(queryFeeOrderDetailsVo.getTotalAmount().add(new BigDecimal(queryPaymentRecordsDetails.getXiYao())).toString());
                        break;
                    }
                    case "30": {
                        queryPaymentRecordsDetails.setZhongCaoYao(queryFeeOrderDetailsVo.getTotalAmount().add(new BigDecimal(queryPaymentRecordsDetails.getZhongCaoYao())).toString());
                        break;
                    }
                    case "40": {
                        queryPaymentRecordsDetails.setZhongChengYao(queryFeeOrderDetailsVo.getTotalAmount().add(new BigDecimal(queryPaymentRecordsDetails.getZhongChengYao())).toString());
                        break;
                    }
                    case "50": {
                        queryPaymentRecordsDetails.setJianYan(queryFeeOrderDetailsVo.getTotalAmount().add(new BigDecimal(queryPaymentRecordsDetails.getJianYan())).toString());
                        break;
                    }
                    case "51": {
                        queryPaymentRecordsDetails.setJianCha(queryFeeOrderDetailsVo.getTotalAmount().add(new BigDecimal(queryPaymentRecordsDetails.getJianCha())).toString());
                        break;
                    }
                    case "53": {
                        queryPaymentRecordsDetails.setZhiLiao(queryFeeOrderDetailsVo.getTotalAmount().add(new BigDecimal(queryPaymentRecordsDetails.getZhiLiao())).toString());
                        break;
                    }
                    case "54": {
                        queryPaymentRecordsDetails.setShouShu(queryFeeOrderDetailsVo.getTotalAmount().add(new BigDecimal(queryPaymentRecordsDetails.getShouShu())).toString());
                        break;
                    }
                    case "55": {
                        queryPaymentRecordsDetails.setMaZui(queryFeeOrderDetailsVo.getTotalAmount().add(new BigDecimal(queryPaymentRecordsDetails.getMaZui())).toString());
                        break;
                    }
                    case "56": {
                        queryPaymentRecordsDetails.setHuLi(queryFeeOrderDetailsVo.getTotalAmount().add(new BigDecimal(queryPaymentRecordsDetails.getHuLi())).toString());
                        break;
                    }
                    case "57": {
                        queryPaymentRecordsDetails.setYinShi(queryFeeOrderDetailsVo.getTotalAmount().add(new BigDecimal(queryPaymentRecordsDetails.getYinShi())).toString());
                        break;
                    }
                    case "58": {
                        queryPaymentRecordsDetails.setShuYang(queryFeeOrderDetailsVo.getTotalAmount().add(new BigDecimal(queryPaymentRecordsDetails.getShuYang())).toString());
                        break;
                    }
                    case "59": {
                        queryPaymentRecordsDetails.setCaiLiao(queryFeeOrderDetailsVo.getTotalAmount().add(new BigDecimal(queryPaymentRecordsDetails.getCaiLiao())).toString());
                        break;
                    }
                    case "60": {
                        queryPaymentRecordsDetails.setXunZhen(queryFeeOrderDetailsVo.getTotalAmount().add(new BigDecimal(queryPaymentRecordsDetails.getXunZhen())).toString());
                        break;
                    }
                    case "70": {
                        queryPaymentRecordsDetails.setQiTa(queryFeeOrderDetailsVo.getTotalAmount().add(new BigDecimal(queryPaymentRecordsDetails.getQiTa())).toString());
                    }
                }
            }
            detailsList.add(queryPaymentRecordsDetails);
        }
        PageInfo pageInfo = new PageInfo(detailsList);
        PageResult pageResult = new PageResult(parameter.getCurrent().intValue(), parameter.getSize().intValue());
        pageResult.setTotal(Integer.parseInt(String.valueOf(pageInfo.getTotal())));
        pageResult.setPages(pageInfo.getPages());
        pageResult.setRecords(detailsList);
        pageResult.setCurrent(parameter.getCurrent().intValue());
        pageResult.setSize(parameter.getSize().intValue());
        pageResult.setPages(queryPaymentRecordsPageInfo.getPages());
        pageResult.setTotal((int)queryPaymentRecordsPageInfo.getTotal());
        return ResponseData.success((Object)pageResult);
    }

    public ResponseData<PageResult<Map<String, Object>>> paymentRecordsByDept(PaymentRecordsDto parameter) {
        List admissionEntities;
        List admissionEntities2;
        List strings;
        if (!StringUtil.isEmpty((String)parameter.getStarTime()) && !StringUtil.isEmpty((String)parameter.getEndTime())) {
            parameter.setStarTime(parameter.getStarTime() + " 00:00:00");
            parameter.setEndTime(parameter.getEndTime() + " 23:59:59");
        }
        PageHelper.startPage((int)parameter.getCurrent(), (int)99999);
        List queryPaymentRecords = this.outOrderPaymentMapper.paymentRecordsByDept(parameter);
        ResponseData doctorResp = this.sysServiceFeign.doctor(parameter.getTenantId() + "");
        List docs = (List)doctorResp.getData();
        HashMap docByDept = new HashMap();
        HashMap<String, String> docCompare = new HashMap<String, String>();
        for (Map doc : docs) {
            String deptId = (String)doc.get("departmentId");
            int docId = Integer.parseInt(doc.get("id") + "");
            docCompare.put(docId + "", deptId);
            List strings2 = (List)docByDept.get(deptId);
            if (strings2 == null) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(docId + "");
                docByDept.put(deptId, list);
                continue;
            }
            strings2.add(docId + "");
        }
        String groupType = parameter.getGroupType();
        boolean flag = groupType == null || !groupType.equals("doctor");
        BigDecimal totalAmount = new BigDecimal(0);
        BigDecimal actualPayment = new BigDecimal(0);
        List admissionList = this.admissionMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().or(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(AdmissionEntity::getStatus, (Object)99)).or()).between(AdmissionEntity::getStatus, (Object)20, (Object)39);
        })).between(BaseEntity::getCreateTime, (Object)(parameter.getStarTime() + " 00:00:00"), (Object)(parameter.getEndTime() + " 23:59:59"))).groupBy(AdmissionEntity::getDoctorId));
        List doctorIds = admissionList.stream().map(admission -> {
            Integer doctorId = admission.getDoctorId();
            return doctorId;
        }).collect(Collectors.toList());
        ArrayList l = new ArrayList();
        List deptIds = admissionList.stream().map(admission -> {
            Integer doctorId = admission.getDoctorId();
            Integer deptId = admission.getDeptId();
            List strings = (List)docByDept.get(deptId + "");
            if (!strings.contains(doctorId + "")) {
                String s = (String)docCompare.get(doctorId + "");
                return Integer.valueOf(s);
            }
            return deptId;
        }).collect(Collectors.toList());
        ArrayList<Integer> queryPaymentRecordDoctorIds = new ArrayList<Integer>();
        ArrayList<Integer> queryPaymentRecordDeptIds = new ArrayList<Integer>();
        for (Object queryPaymentRecord : queryPaymentRecords) {
            totalAmount = totalAmount.add(queryPaymentRecord.get("totalAmount") != null ? (BigDecimal)queryPaymentRecord.get("totalAmount") : new BigDecimal(0));
            actualPayment = actualPayment.add(queryPaymentRecord.get("actualPayment") != null ? (BigDecimal)queryPaymentRecord.get("actualPayment") : new BigDecimal(0));
            if (flag) {
                Integer deptId = (Integer)queryPaymentRecord.get("deptId");
                strings = (List)docByDept.get(deptId + "");
                admissionEntities2 = this.admissionMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().or(wrapper -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(AdmissionEntity::getStatus, (Object)99)).or()).between(AdmissionEntity::getStatus, (Object)20, (Object)39);
                })).between(BaseEntity::getCreateTime, (Object)(parameter.getStarTime() + " 00:00:00"), (Object)(parameter.getEndTime() + " 23:59:59"))).in(AdmissionEntity::getDoctorId, (Collection)strings)).groupBy(AdmissionEntity::getPatientCardNo));
                queryPaymentRecord.put("count", admissionEntities2.size());
                queryPaymentRecordDeptIds.add(deptId);
                continue;
            }
            Integer doctorId = (Integer)queryPaymentRecord.get("doctorId");
            admissionEntities = this.admissionMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().or(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(AdmissionEntity::getStatus, (Object)99)).or()).between(AdmissionEntity::getStatus, (Object)20, (Object)39);
            })).eq(AdmissionEntity::getDoctorId, (Object)doctorId)).between(BaseEntity::getCreateTime, (Object)(parameter.getStarTime() + " 00:00:00"), (Object)(parameter.getEndTime() + " 23:59:59"))).groupBy(AdmissionEntity::getPatientCardNo));
            queryPaymentRecord.put("count", admissionEntities.size());
            queryPaymentRecordDoctorIds.add(doctorId);
        }
        HashMap<String, Object> stringObjectHashMap = new HashMap<String, Object>();
        if (!flag) {
            for (Integer doctorId : doctorIds) {
                if (queryPaymentRecordDoctorIds.contains(doctorId)) continue;
                admissionEntities = this.admissionMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().or(wrapper -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(AdmissionEntity::getStatus, (Object)99)).or()).between(AdmissionEntity::getStatus, (Object)20, (Object)39);
                })).eq(AdmissionEntity::getDoctorId, (Object)doctorId)).between(BaseEntity::getCreateTime, (Object)(parameter.getStarTime() + " 00:00:00"), (Object)(parameter.getEndTime() + " 23:59:59"))).groupBy(AdmissionEntity::getPatientCardNo));
                String doctorName = ((AdmissionEntity)admissionEntities.get(0)).getDoctorName();
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("doctorName", doctorName);
                data.put("count", admissionEntities.size());
                data.put("guahao", 0);
                data.put("yaopin", 0);
                data.put("yiliao", 0);
                data.put("actualPayment", 0);
                data.put("totalAmount", 0);
                queryPaymentRecords.add(data);
            }
        } else {
            for (Integer deptId : deptIds) {
                if (queryPaymentRecordDeptIds.contains(deptId)) continue;
                strings = (List)docByDept.get(deptId + "");
                admissionEntities2 = this.admissionMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().or(wrapper -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(AdmissionEntity::getStatus, (Object)99)).or()).between(AdmissionEntity::getStatus, (Object)20, (Object)39);
                })).in(AdmissionEntity::getDoctorId, (Collection)strings)).between(BaseEntity::getCreateTime, (Object)(parameter.getStarTime() + " 00:00:00"), (Object)(parameter.getEndTime() + " 23:59:59"))).groupBy(AdmissionEntity::getPatientCardNo));
                String deptName = ((AdmissionEntity)admissionEntities2.get(0)).getDeptName();
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("deptName", deptName);
                data.put("count", admissionEntities2.size());
                data.put("guahao", 0);
                data.put("yaopin", 0);
                data.put("yiliao", 0);
                data.put("actualPayment", 0);
                data.put("totalAmount", 0);
                queryPaymentRecords.add(data);
            }
        }
        stringObjectHashMap.put("doctorName", "\u5408\u8ba1");
        stringObjectHashMap.put("deptName", "\u5408\u8ba1");
        stringObjectHashMap.put("totalAmount", totalAmount);
        stringObjectHashMap.put("actualPayment", actualPayment);
        Boolean isTotal = parameter.getIsTotal() == null ? false : parameter.getIsTotal();
        ArrayList maps = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", queryPaymentRecords);
        map.put("total", totalAmount);
        maps.add(map);
        PageInfo pageInfo = new PageInfo(queryPaymentRecords);
        PageResult pageResult = new PageResult(parameter.getCurrent().intValue(), parameter.getSize().intValue());
        pageResult.setTotal(Integer.parseInt(String.valueOf(pageInfo.getTotal())));
        pageResult.setPages(pageInfo.getPages());
        pageResult.setRecords(maps);
        pageResult.setCurrent(parameter.getCurrent().intValue());
        pageResult.setSize(parameter.getSize().intValue());
        return ResponseData.success((Object)pageResult);
    }

    public ResponseData<QueryPaymentRecordsVo> paymentRecordsDetails(QueryFeeDetailsListDto parameter) {
        QueryPaymentRecordsVo queryPaymentRecordsVo = new QueryPaymentRecordsVo();
        QueryFeeOrderPaidItemsVo queryFeeOrderPaidItemsVo = this.outOrderMapper.queryExpenseDetailsByProjectId(parameter.getTenantId(), parameter.getOrderNo());
        if (queryFeeOrderPaidItemsVo == null) {
            return ResponseData.error((String)"\u627e\u4e0d\u5230\u8ba2\u5355\uff01");
        }
        BeanUtils.copyProperties((Object)queryFeeOrderPaidItemsVo, (Object)queryPaymentRecordsVo);
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"outpatient_no", (Object)queryFeeOrderPaidItemsVo.getOutpatientNo());
        AdmissionEntity admissionEntity = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)query);
        if (admissionEntity == null) {
            return ResponseData.error((String)"\u4fe1\u606f\u67e5\u8be2\u5931\u8d25!");
        }
        BeanUtils.copyProperties((Object)admissionEntity, (Object)queryPaymentRecordsVo);
        queryPaymentRecordsVo.setGender(admissionEntity.getPatientSex());
        queryPaymentRecordsVo.setAge(admissionEntity.getPatientAge());
        queryPaymentRecordsVo.setPatientCardNo(null);
        return ResponseData.success((Object)queryPaymentRecordsVo);
    }

    public ResponseData<PayVo> paymentDetails(QueryFeeDetailsListDto parameter) {
        QueryWrapper query = new QueryWrapper();
        ((QueryWrapper)query.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"pay_order_no", (Object)(Objects.isNull(parameter.getOrderNo()) ? parameter.getPayOrderNo() : parameter.getOrderNo()));
        OutOrderPayment outOrderPayment = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)query);
        if (outOrderPayment == null) {
            return ResponseData.error((String)"\u627e\u4e0d\u5230\u8bb0\u5f55\uff01");
        }
        PayVo payVo = new PayVo();
        BeanUtils.copyProperties((Object)outOrderPayment, (Object)payVo);
        payVo.setName(outOrderPayment.getPatientName());
        if (!StringUtil.isEmpty((String)parameter.getTransactionNumber())) {
            QueryWrapper queryOrder = new QueryWrapper();
            ((QueryWrapper)queryOrder.eq((Object)"transaction_number", (Object)parameter.getTransactionNumber())).eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
            List outOrderPaymentRecords = this.outOrderPaymentRecordMapper.selectList((Wrapper)queryOrder);
            if (CollectionUtils.isEmpty((Collection)outOrderPaymentRecords)) {
                return ResponseData.error((String)"\u4ea4\u6613\u5355\u53f7\u627e\u4e0d\u5230\u8bb0\u5f55\uff01");
            }
            BigDecimal amount = outOrderPaymentRecords.stream().map(OutOrderPaymentRecord::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal actualPayment = outOrderPaymentRecords.stream().map(OutOrderPaymentRecord::getActualPayment).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalAmount = outOrderPaymentRecords.stream().map(OutOrderPaymentRecord::getTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            payVo.setAmount(amount);
            payVo.setTotalAmount(totalAmount);
            payVo.setActualPayment(actualPayment);
            if (!(outOrderPayment.getSettlementMethod() != 3 && outOrderPayment.getSettlementMethod() != 4 || outOrderPayment.getPaymentMethod() < 40 && outOrderPayment.getPaymentMethod() >= 30)) {
                payVo.setActualPayment(outOrderPayment.getOwnCost());
            }
            payVo.setTransactionNumber(((OutOrderPaymentRecord)outOrderPaymentRecords.get(0)).getTransactionNumber());
            payVo.setOperationType(((OutOrderPaymentRecord)outOrderPaymentRecords.get(0)).getOperationType());
        } else {
            QueryWrapper queryOrder = new QueryWrapper();
            ((QueryWrapper)queryOrder.eq((Object)"pay_order_no", (Object)(Objects.isNull(parameter.getOrderNo()) ? parameter.getPayOrderNo() : parameter.getOrderNo()))).eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
            List outOrderPaymentRecords = this.outOrderPaymentRecordMapper.selectList((Wrapper)queryOrder);
            if (CollectionUtils.isEmpty((Collection)outOrderPaymentRecords)) {
                return ResponseData.error((String)"\u652f\u4ed8\u5355\u53f7\u627e\u4e0d\u5230\u8bb0\u5f55\uff01");
            }
            BigDecimal amount = outOrderPaymentRecords.stream().map(OutOrderPaymentRecord::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal actualPayment = outOrderPaymentRecords.stream().map(OutOrderPaymentRecord::getActualPayment).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalAmount = outOrderPaymentRecords.stream().map(OutOrderPaymentRecord::getTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            payVo.setAmount(amount);
            payVo.setTotalAmount(totalAmount);
            payVo.setActualPayment(actualPayment);
            if (!(outOrderPayment.getSettlementMethod() != 3 && outOrderPayment.getSettlementMethod() != 4 || outOrderPayment.getPaymentMethod() < 40 && outOrderPayment.getPaymentMethod() >= 30)) {
                payVo.setActualPayment(outOrderPayment.getOwnCost());
            }
            payVo.setTransactionNumber(((OutOrderPaymentRecord)outOrderPaymentRecords.get(0)).getTransactionNumber());
            payVo.setOperationType(((OutOrderPaymentRecord)outOrderPaymentRecords.get(0)).getOperationType());
        }
        return ResponseData.success((Object)payVo);
    }

    public ResponseData<PaymentDetailsVo> queryPendingPaymentOrder(QueryFeeDetailsListDto parameter) {
        if (ObjectUtils.isEmpty((Object)parameter.getOutpatientNo())) {
            return ResponseData.error((String)"\u95e8\u8bca\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"outpatient_no", (Object)parameter.getOutpatientNo())).in((Object)"payment_status", Arrays.asList(PaymentStatusEnum.PAYMENT_PENDING.getValue(), PaymentStatusEnum.PAYMENT_REQUIRE_CUSTOMER_PASSWORD.getValue()));
        List outOrderPayment = this.outOrderPaymentMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)outOrderPayment)) {
            return ResponseData.success((Object)new PaymentDetailsVo());
        }
        PaymentDetailsVo paymentDetailsVo = new PaymentDetailsVo();
        BeanUtils.copyProperties(outOrderPayment.get(0), (Object)paymentDetailsVo);
        return ResponseData.success((Object)paymentDetailsVo);
    }

    public ResponseData<QueryPaymentRecordDetailsVo> paymentRecordDetails(QueryFeeDetailsListDto parameter) {
        List orderNoList;
        QueryPaymentRecordDetailsVo queryPaymentRecordDetailsVo = this.outOrderMapper.paymentRecordsDetails(parameter.getTenantId(), parameter.getOrderNo(), parameter.getPaymentStatus());
        if (queryPaymentRecordDetailsVo == null) {
            return ResponseData.error((String)"\u627e\u4e0d\u5230\u8be5\u8bb0\u5f55!");
        }
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"outpatient_no", (Object)queryPaymentRecordDetailsVo.getOutpatientNo());
        AdmissionEntity admissionEntity = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)query);
        if (admissionEntity == null) {
            return ResponseData.error((String)"\u4fe1\u606f\u67e5\u8be2\u5931\u8d25!");
        }
        List detailsList = queryPaymentRecordDetailsVo.getDetailsList();
        if (parameter.getToBePaidFlag().booleanValue() && !CollectionUtils.isEmpty((Collection)detailsList) && !CollectionUtils.isEmpty(orderNoList = detailsList.stream().filter(x -> PaymentStatusEnum.PAYMENT_REFUNDED.getValue().equals(x.getPaymentStatus())).map(QueryPaymentRecordDetailsItemVo::getOrderNo).distinct().collect(Collectors.toList()))) {
            List collect = detailsList.stream().filter(x -> !orderNoList.contains(x.getOrderNo())).collect(Collectors.toList());
            queryPaymentRecordDetailsVo.setDetailsList(collect);
        }
        BeanUtils.copyProperties((Object)admissionEntity, (Object)queryPaymentRecordDetailsVo);
        queryPaymentRecordDetailsVo.setVisitTime(admissionEntity.getRegTime());
        queryPaymentRecordDetailsVo.setGender(admissionEntity.getPatientSex());
        queryPaymentRecordDetailsVo.setAge(admissionEntity.getPatientAge());
        if (PaymentMethodEnum.PAY_PENDINGACCOUNT.getValue().equals(queryPaymentRecordDetailsVo.getPaymentMethod())) {
            QueryWrapper outPendingAccountRecordsQueryWrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)outPendingAccountRecordsQueryWrapper.in((Object)"status", Arrays.asList(PendingStatusEnum.STATUS_NORMAL.getValue(), PendingStatusEnum.STATUS_DISABLED.getValue()))).eq((Object)"pay_order_no", (Object)queryPaymentRecordDetailsVo.getPayOrderNo())).eq((Object)"tenant_id", (Object)parameter.getTenantId());
            OutPendingAccountRecords pendingAccountRecords = (OutPendingAccountRecords)this.outPendingAccountRecordsMapper.selectOne((Wrapper)outPendingAccountRecordsQueryWrapper);
            if (pendingAccountRecords == null) {
                throw new RunDisplayException("\u6302\u8d26\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01");
            }
            QueryWrapper outPendingItemsQueryWrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)outPendingItemsQueryWrapper.in((Object)"status", Arrays.asList(PendingStatusEnum.STATUS_NORMAL.getValue(), PendingStatusEnum.STATUS_DISABLED.getValue()))).eq((Object)"project_no", (Object)pendingAccountRecords.getProjectNo())).eq((Object)"tenant_id", (Object)parameter.getTenantId());
            OutPendingItems outPendingItems = (OutPendingItems)this.outPendingItemsMapper.selectOne((Wrapper)outPendingItemsQueryWrapper);
            if (outPendingItems != null) {
                queryPaymentRecordDetailsVo.setContractNo(outPendingItems.getContractNo());
                queryPaymentRecordDetailsVo.setSigningName(outPendingItems.getSigningName());
                queryPaymentRecordDetailsVo.setProjectName(outPendingItems.getProjectName());
                queryPaymentRecordDetailsVo.setProjectNo(outPendingItems.getProjectNo());
                queryPaymentRecordDetailsVo.setSigningName(outPendingItems.getSigningName());
            }
        }
        queryPaymentRecordDetailsVo.setPatientCardNo(admissionEntity.getPatientCardNo());
        return ResponseData.success((Object)queryPaymentRecordDetailsVo);
    }

    public ResponseData<String> changeRemarks(QueryFeeDetailsListDto parameter) {
        if (ObjectUtils.isEmpty((Object)parameter.getPayOrderNo())) {
            return ResponseData.error((String)"\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryWrapper query = new QueryWrapper();
        ((QueryWrapper)query.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"pay_order_no", (Object)parameter.getPayOrderNo());
        OutOrderPayment outOrderPayment = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)query);
        if (outOrderPayment == null) {
            return ResponseData.error((String)"\u627e\u4e0d\u5230\u8bb0\u5f55\uff01");
        }
        outOrderPayment.setRemark(parameter.getRemark());
        this.outOrderPaymentMapper.updateById((Object)outOrderPayment);
        return ResponseData.success((Object)"\u6210\u529f");
    }

    public ResponseData<OutpatientDaySettlementVo> outpatientDaySettlement(OutpatientDaySettlementDto parameter) {
        OutpatientDaySettlementVo outpatientDaySettlementVo = new OutpatientDaySettlementVo();
        parameter.setPaymentStatus(PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
        TotalSettlementRes totalSettlementRes = this.outOrderPaymentMapper.queryTotalSettlementPrice(parameter);
        List list = this.outOrderPaymentMapper.queryPayMethodStatistics(parameter);
        SelfSettlementRes selfSettlementRes = new SelfSettlementRes();
        for (PaymethodDetailRes paymethodDetailRes : list) {
            switch (paymethodDetailRes.getPayMethod()) {
                case 1: {
                    selfSettlementRes.setActualCashPay(paymethodDetailRes.getAmount());
                    break;
                }
                case 10: {
                    selfSettlementRes.setWechatTotal(paymethodDetailRes.getAmount());
                    break;
                }
                case 20: {
                    selfSettlementRes.setAlipayTotal(paymethodDetailRes.getAmount());
                    break;
                }
                case 50: {
                    selfSettlementRes.setBankCardTotal(paymethodDetailRes.getAmount());
                    break;
                }
                case 40: {
                    selfSettlementRes.setPayPendingTotal(paymethodDetailRes.getAmount());
                    break;
                }
                case 11: {
                    selfSettlementRes.setOtherTotal(paymethodDetailRes.getAmount());
                }
            }
        }
        OutpatientDaySettlementDto outpatientDaySettlementDto = new OutpatientDaySettlementDto();
        BeanUtils.copyProperties((Object)parameter, (Object)outpatientDaySettlementDto);
        outpatientDaySettlementDto.setPaymentStatus(PaymentStatusEnum.PAYMENT_REFUNDED.getValue());
        List paymethodDetailRes1 = this.outOrderPaymentMapper.queryPayMethodStatisticsRefund(outpatientDaySettlementDto);
        for (PaymethodDetailRes paymethodDetailRes : paymethodDetailRes1) {
            switch (paymethodDetailRes.getPayMethod()) {
                case 1: {
                    selfSettlementRes.setActualCashRefund(paymethodDetailRes.getAmount());
                    break;
                }
                case 10: {
                    selfSettlementRes.setWechatRefundTotal(paymethodDetailRes.getAmount());
                    break;
                }
                case 20: {
                    selfSettlementRes.setAlipayRefundTotal(paymethodDetailRes.getAmount());
                    break;
                }
                case 50: {
                    selfSettlementRes.setBankCardRefundTotal(paymethodDetailRes.getAmount());
                    break;
                }
                case 40: {
                    selfSettlementRes.setPayPendingRefundTotal(paymethodDetailRes.getAmount());
                    break;
                }
                case 11: {
                    selfSettlementRes.setOtherRefundTotal(paymethodDetailRes.getAmount());
                }
            }
        }
        selfSettlementRes.setActualCashPay(selfSettlementRes.getActualCashPay().subtract(selfSettlementRes.getActualCashRefund()));
        selfSettlementRes.setWechatTotal(selfSettlementRes.getWechatTotal().subtract(selfSettlementRes.getWechatRefundTotal()));
        selfSettlementRes.setAlipayTotal(selfSettlementRes.getAlipayTotal().subtract(selfSettlementRes.getAlipayRefundTotal()));
        selfSettlementRes.setBankCardTotal(selfSettlementRes.getBankCardTotal().subtract(selfSettlementRes.getBankCardRefundTotal()));
        selfSettlementRes.setPayPendingTotal(selfSettlementRes.getPayPendingTotal().subtract(selfSettlementRes.getPayPendingRefundTotal()));
        selfSettlementRes.setOtherTotal(selfSettlementRes.getOtherTotal().subtract(selfSettlementRes.getOtherRefundTotal()));
        outpatientDaySettlementVo.setSelfSettlementRes(selfSettlementRes);
        ReconciliationTotalDto reconciliationTotalDto = new ReconciliationTotalDto();
        reconciliationTotalDto.setStartDate(parameter.getStartDate());
        reconciliationTotalDto.setEndDate(parameter.getEndDate());
        reconciliationTotalDto.setCheckerId(parameter.getCheckerId());
        TotalHsSettlmentRes totalHsSettlmentRes = this.outOrderPaymentMapper.queryHsSettlmentTotal(reconciliationTotalDto);
        TotalHsSettlmentRes totalHsSettlmentRefundRes = this.outOrderPaymentMapper.queryHsSettlmentRefundTotal(reconciliationTotalDto);
        this.handleHsSettlementAmount(totalHsSettlmentRes, totalHsSettlmentRefundRes);
        outpatientDaySettlementVo.setTotalHsSettlmentRes(totalHsSettlmentRes);
        if (!Objects.isNull(totalSettlementRes)) {
            totalSettlementRes.setWeAliOthe(selfSettlementRes.getWechatTotal().add(selfSettlementRes.getAlipayTotal()).add(selfSettlementRes.getOtherTotal()));
            totalSettlementRes.setBankCard(selfSettlementRes.getBankCardTotal());
            totalSettlementRes.setPending(selfSettlementRes.getPayPendingTotal());
            totalSettlementRes.setCash(selfSettlementRes.getActualCashPay());
            totalSettlementRes.setExcludeHsAmount(totalSettlementRes.getWeAliOthe().add(totalSettlementRes.getBankCard()).add(totalSettlementRes.getPending().add(totalSettlementRes.getCash())));
            BigDecimal refundAmount = selfSettlementRes.getActualCashRefund().add(selfSettlementRes.getWechatRefundTotal()).add(selfSettlementRes.getAlipayRefundTotal()).add(selfSettlementRes.getBankCardRefundTotal()).add(selfSettlementRes.getPayPendingRefundTotal().add(selfSettlementRes.getOtherRefundTotal()));
            if (!Objects.isNull(totalHsSettlmentRefundRes.getFundPaySumamt())) {
                refundAmount = refundAmount.add(new BigDecimal(totalHsSettlmentRefundRes.getFundPaySumamt()));
            }
            if (!Objects.isNull(totalHsSettlmentRefundRes.getAcctPay())) {
                refundAmount = refundAmount.add(new BigDecimal(totalHsSettlmentRefundRes.getAcctPay()));
            }
            if (!Objects.isNull(totalHsSettlmentRefundRes.getAcctMulaidPay())) {
                refundAmount = refundAmount.add(totalHsSettlmentRefundRes.getAcctMulaidPay());
            }
            totalSettlementRes.setActualPayment(String.valueOf(new BigDecimal(Objects.isNull(totalSettlementRes.getTotalAmount()) ? "0.00" : totalSettlementRes.getTotalAmount()).subtract(refundAmount)));
        }
        outpatientDaySettlementVo.setTotalSettlementRes(totalSettlementRes);
        FeeDetail feeDetail = new FeeDetail();
        this.handleDetailRefund(feeDetail, parameter);
        outpatientDaySettlementVo.setFeeDetail(feeDetail);
        RegCountRes regCountRes = this.outOrderPaymentMapper.queryRegOrderInfo(parameter);
        if (!Objects.isNull(regCountRes)) {
            regCountRes.setGuahao(regCountRes.getRegTotal());
            RegCountRes refundRegOrder = this.outOrderPaymentMapper.queryRefundRegOrderInfo(parameter);
            if (!Objects.isNull(refundRegOrder)) {
                this.handleRegOrder(regCountRes, refundRegOrder);
                regCountRes.setRefundRegCount(refundRegOrder.getRegCount());
                regCountRes.setRegRefundTotal(refundRegOrder.getRegTotal());
            }
        }
        outpatientDaySettlementVo.setRegCountRes(regCountRes);
        outpatientDaySettlementVo.setNo(DateUtils.getCurrentDateTimeString() + "_" + (Objects.isNull(parameter.getCheckerId()) ? "1" : parameter.getCheckerId()));
        try {
            this.saveDaySettlementVo(outpatientDaySettlementVo, feeDetail, totalSettlementRes, totalHsSettlmentRes, selfSettlementRes, regCountRes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ResponseData.success((Object)outpatientDaySettlementVo);
    }

    private void handleRegOrder(RegCountRes total, RegCountRes refund) {
        total.setRegCount(Integer.valueOf(total.getRegCount() - refund.getRegCount()));
        total.setRefundRegCount(refund.getRegCount());
        total.setSelfPay(Integer.valueOf(total.getSelfPay() - refund.getSelfPay()));
        total.setHsPay(Integer.valueOf(total.getHsPay() - refund.getHsPay()));
        total.setProHsPay(Integer.valueOf(total.getProHsPay() - refund.getProHsPay()));
        total.setInProvincePay(Integer.valueOf(total.getInProvincePay() - refund.getInProvincePay()));
        total.setOutProvincePay(Integer.valueOf(total.getOutProvincePay() - refund.getOutProvincePay()));
        total.setIndustrialInjury(Integer.valueOf(total.getIndustrialInjury() - refund.getIndustrialInjury()));
        total.setAgriculture(Integer.valueOf(total.getAgriculture() - refund.getAgriculture()));
        total.setOther(Integer.valueOf(total.getOther() - refund.getOther()));
        total.setRegTotal(total.getRegTotal().subtract(refund.getRegTotal()));
        total.setRegRefundTotal(refund.getRegTotal());
        total.setCashPay(total.getCashPay().subtract(refund.getCashPay()));
        total.setAlipay(total.getAlipay().subtract(refund.getAlipay()));
        total.setWechat(total.getWechat().subtract(refund.getWechat()));
        total.setOtherPayment(total.getOtherPayment().subtract(refund.getOtherPayment()));
        total.setPayCost(total.getPayCost().subtract(refund.getPayCost()));
        total.setProvPayCost(total.getProvPayCost().subtract(refund.getProvPayCost()));
        total.setInProvincePayCost(total.getInProvincePayCost().subtract(refund.getInProvincePayCost()));
        total.setOutProvincePayCost(total.getOutProvincePayCost().subtract(refund.getOutProvincePayCost()));
        total.setPubCost(total.getPubCost().subtract(refund.getPubCost()));
        total.setProvPubCost(total.getProvPubCost().subtract(refund.getProvPubCost()));
        total.setInProvincePubCost(total.getInProvincePubCost().subtract(refund.getInProvincePubCost()));
        total.setOutProvincePubCost(total.getOutProvincePubCost().subtract(refund.getOutProvincePubCost()));
        total.setIndustrialInjuryCost(total.getIndustrialInjuryCost().subtract(refund.getIndustrialInjuryCost()));
        total.setGuahao(total.getRegTotal());
        total.setJiancha(total.getJiancha().subtract(refund.getJiancha()));
        total.setZhencha(total.getZhencha().subtract(refund.getZhencha()));
        total.setBingliben(total.getBingliben().subtract(refund.getBingliben()));
    }

    private void handleDetailRefund(FeeDetail feeDetail, OutpatientDaySettlementDto parameter) {
        List feeDetailResList = this.outOrderPaymentMapper.queryPaymentRecordDetailsItemByDate(parameter);
        BigDecimal yaopinFee = new BigDecimal(0.0);
        BigDecimal yiliaoFee = new BigDecimal(0.0);
        BigDecimal total = new BigDecimal(0.0);
        block97: for (FeeDetailRes feeDetailRes : feeDetailResList) {
            switch (feeDetailRes.getOrderType()) {
                case "10": {
                    feeDetail.setGuaHao(feeDetailRes.getAmount());
                    continue block97;
                }
                case "15": {
                    feeDetail.setXianShang(feeDetailRes.getAmount());
                    yiliaoFee = yiliaoFee.add(feeDetailRes.getAmount());
                    total = total.add(feeDetailRes.getAmount());
                    continue block97;
                }
                case "11": {
                    feeDetail.setZhenLiao(feeDetailRes.getAmount());
                    yiliaoFee = yiliaoFee.add(feeDetailRes.getAmount());
                    total = total.add(feeDetailRes.getAmount());
                    continue block97;
                }
                case "20": {
                    feeDetail.setXiYao(feeDetailRes.getAmount());
                    yaopinFee = yaopinFee.add(feeDetailRes.getAmount());
                    total = total.add(feeDetailRes.getAmount());
                    continue block97;
                }
                case "40": {
                    feeDetail.setZhongChengYao(feeDetailRes.getAmount());
                    yaopinFee = yaopinFee.add(feeDetailRes.getAmount());
                    total = total.add(feeDetailRes.getAmount());
                    continue block97;
                }
                case "30": {
                    feeDetail.setZhongCaoYao(feeDetailRes.getAmount());
                    yaopinFee = yaopinFee.add(feeDetailRes.getAmount());
                    total = total.add(feeDetailRes.getAmount());
                    continue block97;
                }
                case "50": {
                    feeDetail.setJianYan(feeDetailRes.getAmount());
                    yiliaoFee = yiliaoFee.add(feeDetailRes.getAmount());
                    total = total.add(feeDetailRes.getAmount());
                    continue block97;
                }
                case "51": {
                    feeDetail.setJianCha(feeDetailRes.getAmount());
                    yiliaoFee = yiliaoFee.add(feeDetailRes.getAmount());
                    total = total.add(feeDetailRes.getAmount());
                    continue block97;
                }
                case "53": {
                    feeDetail.setZhiLiao(feeDetailRes.getAmount());
                    yiliaoFee = yiliaoFee.add(feeDetailRes.getAmount());
                    total = total.add(feeDetailRes.getAmount());
                    continue block97;
                }
                case "59": 
                case "63": {
                    feeDetail.setCaiLiao(feeDetailRes.getAmount());
                    yiliaoFee = yiliaoFee.add(feeDetailRes.getAmount());
                    total = total.add(feeDetailRes.getAmount());
                    continue block97;
                }
                case "62": {
                    feeDetail.setFuWu(feeDetailRes.getAmount());
                    yiliaoFee = yiliaoFee.add(feeDetailRes.getAmount());
                    total = total.add(feeDetailRes.getAmount());
                    continue block97;
                }
                case "56": {
                    feeDetail.setHuLi(feeDetailRes.getAmount());
                    yiliaoFee = yiliaoFee.add(feeDetailRes.getAmount());
                    total = total.add(feeDetailRes.getAmount());
                    continue block97;
                }
                case "58": {
                    feeDetail.setShuYang(feeDetailRes.getAmount());
                    yiliaoFee = yiliaoFee.add(feeDetailRes.getAmount());
                    total = total.add(feeDetailRes.getAmount());
                    continue block97;
                }
                case "61": {
                    feeDetail.setShuXue(feeDetailRes.getAmount());
                    yiliaoFee = yiliaoFee.add(feeDetailRes.getAmount());
                    total = total.add(feeDetailRes.getAmount());
                    continue block97;
                }
                case "54": {
                    feeDetail.setShouShu(feeDetailRes.getAmount());
                    yiliaoFee = yiliaoFee.add(feeDetailRes.getAmount());
                    total = total.add(feeDetailRes.getAmount());
                    continue block97;
                }
                case "55": {
                    feeDetail.setMaZui(feeDetailRes.getAmount());
                    yiliaoFee = yiliaoFee.add(feeDetailRes.getAmount());
                    total = total.add(feeDetailRes.getAmount());
                    continue block97;
                }
                case "57": {
                    feeDetail.setYinShi(feeDetailRes.getAmount());
                    yiliaoFee = yiliaoFee.add(feeDetailRes.getAmount());
                    total = total.add(feeDetailRes.getAmount());
                    continue block97;
                }
                case "31": {
                    feeDetail.setYYFKeLi(feeDetailRes.getAmount());
                    yaopinFee = yaopinFee.add(feeDetailRes.getAmount());
                    total = total.add(feeDetailRes.getAmount());
                    continue block97;
                }
                case "32": {
                    feeDetail.setYYFYingPian(feeDetailRes.getAmount());
                    yaopinFee = yaopinFee.add(feeDetailRes.getAmount());
                    total = total.add(feeDetailRes.getAmount());
                    continue block97;
                }
                case "21": {
                    feeDetail.setYYFXiYao(feeDetailRes.getAmount());
                    yaopinFee = yaopinFee.add(feeDetailRes.getAmount());
                    total = total.add(feeDetailRes.getAmount());
                    continue block97;
                }
                case "41": {
                    feeDetail.setYYFZhongCheng(feeDetailRes.getAmount());
                    yaopinFee = yaopinFee.add(feeDetailRes.getAmount());
                    total = total.add(feeDetailRes.getAmount());
                    continue block97;
                }
                case "60": {
                    feeDetail.setXunZhen(feeDetailRes.getAmount());
                    yiliaoFee = yiliaoFee.add(feeDetailRes.getAmount());
                    total = total.add(feeDetailRes.getAmount());
                    continue block97;
                }
            }
            feeDetail.setOther(feeDetailRes.getAmount());
            yiliaoFee = yiliaoFee.add(feeDetailRes.getAmount());
            total = total.add(feeDetailRes.getAmount());
        }
        List refundFeeDetailResList = this.outOrderPaymentMapper.queryPaymentRefundRecordDetailsItemByDate(parameter);
        block98: for (FeeDetailRes refund : refundFeeDetailResList) {
            switch (refund.getOrderType()) {
                case "10": {
                    feeDetail.setGuaHao(feeDetail.getGuaHao().subtract(refund.getAmount()));
                    continue block98;
                }
                case "15": {
                    feeDetail.setXianShang(feeDetail.getXianShang().subtract(refund.getAmount()));
                    yiliaoFee = yiliaoFee.subtract(refund.getAmount());
                    total = total.subtract(refund.getAmount());
                    continue block98;
                }
                case "11": {
                    feeDetail.setZhenLiao(feeDetail.getZhenLiao().subtract(refund.getAmount()));
                    yiliaoFee = yiliaoFee.subtract(refund.getAmount());
                    total = total.subtract(refund.getAmount());
                    continue block98;
                }
                case "20": {
                    feeDetail.setXiYao(feeDetail.getXiYao().subtract(refund.getAmount()));
                    yaopinFee = yaopinFee.subtract(refund.getAmount());
                    total = total.subtract(refund.getAmount());
                    continue block98;
                }
                case "40": {
                    feeDetail.setZhongChengYao(feeDetail.getZhongChengYao().subtract(refund.getAmount()));
                    yaopinFee = yaopinFee.subtract(refund.getAmount());
                    total = total.subtract(refund.getAmount());
                    continue block98;
                }
                case "30": {
                    feeDetail.setZhongCaoYao(feeDetail.getZhongCaoYao().subtract(refund.getAmount()));
                    yaopinFee = yaopinFee.subtract(refund.getAmount());
                    total = total.subtract(refund.getAmount());
                    continue block98;
                }
                case "50": {
                    feeDetail.setJianYan(feeDetail.getJianYan().subtract(refund.getAmount()));
                    yiliaoFee = yiliaoFee.subtract(refund.getAmount());
                    total = total.subtract(refund.getAmount());
                    continue block98;
                }
                case "51": {
                    feeDetail.setJianCha(feeDetail.getJianCha().subtract(refund.getAmount()));
                    yiliaoFee = yiliaoFee.subtract(refund.getAmount());
                    total = total.subtract(refund.getAmount());
                    continue block98;
                }
                case "53": {
                    feeDetail.setZhiLiao(feeDetail.getZhiLiao().subtract(refund.getAmount()));
                    yiliaoFee = yiliaoFee.subtract(refund.getAmount());
                    total = total.subtract(refund.getAmount());
                    continue block98;
                }
                case "59": {
                    feeDetail.setCaiLiao(feeDetail.getCaiLiao().subtract(refund.getAmount()));
                    yiliaoFee = yiliaoFee.subtract(refund.getAmount());
                    total = total.subtract(refund.getAmount());
                    continue block98;
                }
                case "62": {
                    feeDetail.setFuWu(feeDetail.getFuWu().subtract(refund.getAmount()));
                    yiliaoFee = yiliaoFee.subtract(refund.getAmount());
                    total = total.subtract(refund.getAmount());
                    continue block98;
                }
                case "56": {
                    feeDetail.setHuLi(feeDetail.getHuLi().subtract(refund.getAmount()));
                    yiliaoFee = yiliaoFee.subtract(refund.getAmount());
                    total = total.subtract(refund.getAmount());
                    continue block98;
                }
                case "58": {
                    feeDetail.setShuYang(feeDetail.getShuYang().subtract(refund.getAmount()));
                    yiliaoFee = yiliaoFee.subtract(refund.getAmount());
                    total = total.subtract(refund.getAmount());
                    continue block98;
                }
                case "61": {
                    feeDetail.setShuXue(feeDetail.getShuXue().subtract(refund.getAmount()));
                    yiliaoFee = yiliaoFee.subtract(refund.getAmount());
                    total = total.subtract(refund.getAmount());
                    continue block98;
                }
                case "54": {
                    feeDetail.setShouShu(feeDetail.getShouShu().subtract(refund.getAmount()));
                    yiliaoFee = yiliaoFee.subtract(refund.getAmount());
                    total = total.subtract(refund.getAmount());
                    continue block98;
                }
                case "55": {
                    feeDetail.setMaZui(feeDetail.getMaZui().subtract(refund.getAmount()));
                    yiliaoFee = yiliaoFee.subtract(refund.getAmount());
                    total = total.subtract(refund.getAmount());
                    continue block98;
                }
                case "57": {
                    feeDetail.setYinShi(feeDetail.getYinShi().subtract(refund.getAmount()));
                    yiliaoFee = yiliaoFee.subtract(refund.getAmount());
                    total = total.subtract(refund.getAmount());
                    continue block98;
                }
                case "31": {
                    feeDetail.setYYFKeLi(feeDetail.getYYFKeLi().subtract(refund.getAmount()));
                    yaopinFee = yaopinFee.subtract(refund.getAmount());
                    total = total.subtract(refund.getAmount());
                    continue block98;
                }
                case "32": {
                    feeDetail.setYYFYingPian(feeDetail.getYYFYingPian().subtract(refund.getAmount()));
                    yaopinFee = yaopinFee.subtract(refund.getAmount());
                    total = total.subtract(refund.getAmount());
                    continue block98;
                }
                case "21": {
                    feeDetail.setYYFXiYao(feeDetail.getYYFXiYao().subtract(refund.getAmount()));
                    yaopinFee = yaopinFee.subtract(refund.getAmount());
                    total = total.subtract(refund.getAmount());
                    continue block98;
                }
                case "41": {
                    feeDetail.setYYFZhongCheng(feeDetail.getYYFZhongCheng().subtract(refund.getAmount()));
                    yaopinFee = yaopinFee.subtract(refund.getAmount());
                    total = total.subtract(refund.getAmount());
                    continue block98;
                }
                case "60": {
                    feeDetail.setXunZhen(feeDetail.getXunZhen().subtract(refund.getAmount()));
                    yiliaoFee = yiliaoFee.subtract(refund.getAmount());
                    total = total.subtract(refund.getAmount());
                    continue block98;
                }
            }
            feeDetail.setOther(feeDetail.getOther().subtract(refund.getAmount()));
            yiliaoFee = yiliaoFee.subtract(refund.getAmount());
            total = total.subtract(refund.getAmount());
        }
        feeDetail.setTotal(total);
        feeDetail.setYiliaoFee(yiliaoFee);
        feeDetail.setYaopinFee(yaopinFee);
    }

    private void handleHsSettlementAmount(TotalHsSettlmentRes total, TotalHsSettlmentRes refund) {
        total.setCityAcctPay(total.getCityAcctPay().subtract(refund.getCityAcctPay()));
        total.setProvAcctPay(total.getProvAcctPay().subtract(refund.getProvAcctPay()));
        total.setInProvinceAcctPay(total.getInProvinceAcctPay().subtract(refund.getInProvinceAcctPay()));
        total.setOutProvinceAcctPay(total.getOutProvinceAcctPay().subtract(refund.getOutProvinceAcctPay()));
        total.setCityFundPaySumamt(total.getCityFundPaySumamt().subtract(refund.getCityFundPaySumamt()));
        total.setProvFundPaySumamt(total.getProvFundPaySumamt().subtract(refund.getProvFundPaySumamt()));
        total.setInProvinceFundPaySumamt(total.getInProvinceFundPaySumamt().subtract(refund.getInProvinceFundPaySumamt()));
        total.setOutProvinceFundPaySumamt(total.getOutProvinceFundPaySumamt().subtract(refund.getOutProvinceFundPaySumamt()));
        total.setCityHifobPay(total.getCityHifobPay().subtract(refund.getCityHifobPay()));
        total.setProvHifobPay(total.getProvHifobPay().subtract(refund.getProvHifobPay()));
        total.setInProvinceHifobPay(total.getInProvinceHifobPay().subtract(refund.getInProvinceHifobPay()));
        total.setOutProvinceHifobPay(total.getOutProvinceHifobPay().subtract(refund.getOutProvinceHifobPay()));
        total.setCityMafPay(total.getCityMafPay().subtract(refund.getCityMafPay()));
        total.setInProvinceMafPay(total.getInProvinceMafPay().subtract(refund.getInProvinceMafPay()));
        total.setOutProvinceMafPay(total.getOutProvinceMafPay().subtract(refund.getOutProvinceMafPay()));
        total.setCityOthPay(total.getCityOthPay().subtract(refund.getCityOthPay()));
        total.setInProvinceOthPay(total.getInProvinceOthPay().subtract(refund.getInProvinceOthPay()));
        total.setOutProvinceOthPay(total.getOutProvinceOthPay().subtract(refund.getOutProvinceOthPay()));
        total.setCityHifesPay(total.getCityHifesPay().subtract(refund.getCityHifesPay()));
        total.setInProvinceHifesPay(total.getInProvinceHifesPay().subtract(refund.getInProvinceHifesPay()));
        total.setOutProvinceHifesPay(total.getOutProvinceHifesPay().subtract(refund.getOutProvinceHifesPay()));
        total.setCityHifmiPay(total.getCityHifmiPay().subtract(refund.getCityHifmiPay()));
        total.setInProvinceHifmiPay(total.getInProvinceHifmiPay().subtract(refund.getInProvinceHifmiPay()));
        total.setOutProvinceHifmiPay(total.getOutProvinceHifmiPay().subtract(refund.getOutProvinceHifmiPay()));
        total.setCityCvlservPay(total.getCityCvlservPay().subtract(refund.getCityCvlservPay()));
        total.setProvCvlservPay(total.getProvCvlservPay().subtract(refund.getProvCvlservPay()));
        total.setInProvinceCvlservPay(total.getInProvinceCvlservPay().subtract(refund.getInProvinceCvlservPay()));
        total.setOutProvinceCvlservPay(total.getOutProvinceCvlservPay().subtract(refund.getOutProvinceCvlservPay()));
        total.setProvHifesPay(total.getProvHifesPay().subtract(refund.getProvHifesPay()));
        total.setProvSpecFundPaySumamt(total.getProvSpecFundPaySumamt().subtract(refund.getProvSpecFundPaySumamt()));
        total.setAcctMulaidPay(total.getAcctMulaidPay().subtract(refund.getAcctMulaidPay()));
        total.setIndustrialInjuryCost(total.getIndustrialInjuryCost().subtract(refund.getIndustrialInjuryCost()));
        total.setWjwAcctMulaidPay(total.getWjwAcctMulaidPay().subtract(refund.getWjwAcctMulaidPay()));
        total.setWjwSelfMulaidPay(total.getWjwSelfMulaidPay().subtract(refund.getWjwSelfMulaidPay()));
        total.setHifdmPay(total.getHifdmPay().subtract(refund.getHifdmPay()));
        total.setProvHifmiPay(total.getProvHifmiPay().subtract(refund.getProvHifmiPay()));
        total.setOthFunPay(total.getOthFunPay().subtract(refund.getOthFunPay()));
    }

    private void saveDaySettlementVo(OutpatientDaySettlementVo outpatientDaySettlementVo, FeeDetail feeDetail, TotalSettlementRes totalSettlementRes, TotalHsSettlmentRes totalHsSettlmentRes, SelfSettlementRes selfSettlementRes, RegCountRes regCountRes) {
        OutpatientDaySettlementEntity entity = new OutpatientDaySettlementEntity();
        BeanUtils.copyProperties((Object)outpatientDaySettlementVo, (Object)entity);
        if (!Objects.isNull(feeDetail)) {
            BeanUtils.copyProperties((Object)feeDetail, (Object)entity);
            if (feeDetail.getGuaHao() != null) {
                entity.setGuaHao1(feeDetail.getGuaHao());
            }
            if (feeDetail.getJianYan() != null) {
                entity.setJianYan1(feeDetail.getJianYan());
            }
            if (feeDetail.getJianCha() != null) {
                entity.setJianCha1(feeDetail.getJianCha());
            }
        }
        if (!Objects.isNull(totalSettlementRes)) {
            BeanUtils.copyProperties((Object)totalSettlementRes, (Object)entity);
        }
        if (!Objects.isNull(totalHsSettlmentRes)) {
            BeanUtils.copyProperties((Object)totalHsSettlmentRes, (Object)entity);
        }
        if (!Objects.isNull(selfSettlementRes)) {
            BeanUtils.copyProperties((Object)selfSettlementRes, (Object)entity);
        }
        if (!Objects.isNull(regCountRes)) {
            BeanUtils.copyProperties((Object)regCountRes, (Object)entity);
            if (regCountRes.getOther() != null) {
                entity.setRegOther(regCountRes.getOther());
            }
            if (regCountRes.getPayCost() != null) {
                entity.setRegPayCost(regCountRes.getPayCost());
            }
            if (regCountRes.getPubCost() != null) {
                entity.setRegPubCost(regCountRes.getPubCost());
            }
            if (regCountRes.getIndustrialInjuryCost() != null) {
                entity.setRegIndustrialInjuryCost(regCountRes.getIndustrialInjuryCost());
            }
        }
        this.outpatientDaySettlementMapper.insert((Object)entity);
    }

    public ResponseData<QueryPaymentRecordDetailsPrintVo> paymentRecordItemDetailsPrint(QueryFeeDetailsListDto parameter) {
        HsSettlementInfoEntity hsSettlementInfoEntity;
        QueryPaymentRecordDetailsPrintVo queryPaymentRecordDetailsPrintVo = new QueryPaymentRecordDetailsPrintVo();
        QueryPaymentRecordDetailsVo queryPaymentRecordDetailsVo = this.outOrderMapper.paymentRecordsDetails(parameter.getTenantId(), parameter.getPayOrderNo(), parameter.getPaymentStatus());
        if (queryPaymentRecordDetailsVo == null) {
            return ResponseData.error((String)"\u627e\u4e0d\u5230\u8be5\u8bb0\u5f55!");
        }
        BeanUtils.copyProperties((Object)queryPaymentRecordDetailsVo, (Object)queryPaymentRecordDetailsPrintVo);
        AdmissionEntity admission = this.admissionMapper.queryAdmissionByOutpatientNo(queryPaymentRecordDetailsVo.getOutpatientNo(), parameter.getTenantId());
        queryPaymentRecordDetailsPrintVo.setMedicalRecordNo(admission.getMedicalRecordNo());
        queryPaymentRecordDetailsPrintVo.setPatientName(admission.getPatientName());
        queryPaymentRecordDetailsPrintVo.setGender(admission.getPatientSex());
        queryPaymentRecordDetailsPrintVo.setAge(admission.getPatientAge());
        queryPaymentRecordDetailsPrintVo.setPhone(admission.getPhone());
        queryPaymentRecordDetailsPrintVo.setDeptName(admission.getDeptName());
        queryPaymentRecordDetailsPrintVo.setDoctorName(admission.getDoctorName());
        queryPaymentRecordDetailsPrintVo.setVisitTime(admission.getRegTime());
        queryPaymentRecordDetailsPrintVo.setOutpatientNo(admission.getOutpatientNo());
        queryPaymentRecordDetailsPrintVo.setOutpatientType(admission.getOutpatientType());
        queryPaymentRecordDetailsPrintVo.setOutpatientTypeName(admission.getOutpatientTypeName());
        queryPaymentRecordDetailsPrintVo.setMedicalOutpatientType(admission.getMedicalOutpatientType());
        queryPaymentRecordDetailsPrintVo.setMedicalType(admission.getMedicalType());
        queryPaymentRecordDetailsPrintVo.setRefundTime(queryPaymentRecordDetailsVo.getRefundTime());
        List detailsList = queryPaymentRecordDetailsVo.getDetailsList();
        List orderNoList = detailsList.stream().map(o -> o.getOrderNo()).distinct().collect(Collectors.toList());
        List queryFeeDetailsListVos = this.outOrderService.queryFeeDetailsByOrderNo(orderNoList);
        queryPaymentRecordDetailsPrintVo.setFeeDetailListVo(queryFeeDetailsListVos);
        if (!Objects.isNull(queryPaymentRecordDetailsVo.getSetlId()) && !Objects.isNull(hsSettlementInfoEntity = this.outHsSettlementInfoMapper.queryHsSettlmentInfo(queryPaymentRecordDetailsVo.getSetlId()))) {
            queryPaymentRecordDetailsPrintVo.setFundPaySumamt(hsSettlementInfoEntity.getFund_pay_sumamt());
            queryPaymentRecordDetailsPrintVo.setHifpPay(hsSettlementInfoEntity.getHifp_pay());
            queryPaymentRecordDetailsPrintVo.setPsnCashPay(hsSettlementInfoEntity.getPsn_cash_pay());
            queryPaymentRecordDetailsPrintVo.setCvlservPay(hsSettlementInfoEntity.getCvlserv_pay());
            queryPaymentRecordDetailsPrintVo.setMafPay(hsSettlementInfoEntity.getMaf_pay());
            queryPaymentRecordDetailsPrintVo.setBalc(hsSettlementInfoEntity.getBalc());
            queryPaymentRecordDetailsPrintVo.setOthPay(hsSettlementInfoEntity.getOth_pay());
            queryPaymentRecordDetailsPrintVo.setHifobPay(hsSettlementInfoEntity.getHifob_pay());
            queryPaymentRecordDetailsPrintVo.setHifdmPay(hsSettlementInfoEntity.getHifdm_pay());
            queryPaymentRecordDetailsPrintVo.setHospPartAmt(hsSettlementInfoEntity.getHosp_part_amt());
            queryPaymentRecordDetailsPrintVo.setHifmiPay(hsSettlementInfoEntity.getHifmi_pay());
            queryPaymentRecordDetailsPrintVo.setAcctMulaidPay(hsSettlementInfoEntity.getAcct_mulaid_pay());
            queryPaymentRecordDetailsPrintVo.setMedType(hsSettlementInfoEntity.getMed_type());
            queryPaymentRecordDetailsPrintVo.setAcctPay(hsSettlementInfoEntity.getAcct_pay());
        }
        return ResponseData.success((Object)queryPaymentRecordDetailsPrintVo);
    }

    public ResponseData<QueryPaymentRecordDetailsPrintVo> paymentRecordItemPrint(QueryFeeDetailsListDto parameter) {
        HsSettlementInfoEntity hsSettlementInfoEntity;
        QueryPaymentRecordDetailsPrintVo queryPaymentRecordDetailsPrintVo = new QueryPaymentRecordDetailsPrintVo();
        QueryPaymentRecordDetailsVo queryPaymentRecordDetailsVo = this.outOrderMapper.paymentRecordsDetails(parameter.getTenantId(), parameter.getPayOrderNo(), parameter.getPaymentStatus());
        if (queryPaymentRecordDetailsVo == null) {
            return ResponseData.error((String)"\u627e\u4e0d\u5230\u8be5\u8bb0\u5f55!");
        }
        BeanUtils.copyProperties((Object)queryPaymentRecordDetailsVo, (Object)queryPaymentRecordDetailsPrintVo);
        AdmissionEntity admission = this.admissionMapper.queryAdmissionByOutpatientNo(queryPaymentRecordDetailsVo.getOutpatientNo(), parameter.getTenantId());
        queryPaymentRecordDetailsPrintVo.setMedicalRecordNo(admission.getMedicalRecordNo());
        queryPaymentRecordDetailsPrintVo.setPatientName(admission.getPatientName());
        queryPaymentRecordDetailsPrintVo.setGender(admission.getPatientSex());
        queryPaymentRecordDetailsPrintVo.setAge(admission.getPatientAge());
        queryPaymentRecordDetailsPrintVo.setPhone(admission.getPhone());
        queryPaymentRecordDetailsPrintVo.setDeptName(admission.getDeptName());
        queryPaymentRecordDetailsPrintVo.setDoctorName(admission.getDoctorName());
        queryPaymentRecordDetailsPrintVo.setVisitTime(admission.getRegTime());
        queryPaymentRecordDetailsPrintVo.setOutpatientNo(admission.getOutpatientNo());
        queryPaymentRecordDetailsPrintVo.setOutpatientType(admission.getOutpatientType());
        queryPaymentRecordDetailsPrintVo.setOutpatientTypeName(admission.getOutpatientTypeName());
        queryPaymentRecordDetailsPrintVo.setMedicalOutpatientType(admission.getMedicalOutpatientType());
        queryPaymentRecordDetailsPrintVo.setMedicalType(admission.getMedicalType());
        queryPaymentRecordDetailsPrintVo.setRefundTime(queryPaymentRecordDetailsVo.getRefundTime());
        List detailsList = queryPaymentRecordDetailsVo.getDetailsList();
        List orderNoList = detailsList.stream().map(o -> o.getOrderNo()).distinct().collect(Collectors.toList());
        List queryFeeDetailsListVos = this.outOrderService.queryFeeItemByOrderNo(orderNoList);
        queryPaymentRecordDetailsPrintVo.setFeeDetailListVo(queryFeeDetailsListVos);
        if (!Objects.isNull(queryPaymentRecordDetailsVo.getSetlId()) && !Objects.isNull(hsSettlementInfoEntity = this.outHsSettlementInfoMapper.queryHsSettlmentInfo(PaymentStatusEnum.PAYMENT_REFUNDED.getValue().equals(queryPaymentRecordDetailsVo.getPaymentStatus()) ? queryPaymentRecordDetailsVo.getRefundSetlId() : queryPaymentRecordDetailsVo.getSetlId()))) {
            queryPaymentRecordDetailsPrintVo.setFundPaySumamt(hsSettlementInfoEntity.getFund_pay_sumamt());
            queryPaymentRecordDetailsPrintVo.setHifpPay(hsSettlementInfoEntity.getHifp_pay());
            queryPaymentRecordDetailsPrintVo.setPsnCashPay(hsSettlementInfoEntity.getPsn_cash_pay());
            queryPaymentRecordDetailsPrintVo.setCvlservPay(hsSettlementInfoEntity.getCvlserv_pay());
            queryPaymentRecordDetailsPrintVo.setMafPay(hsSettlementInfoEntity.getMaf_pay());
            queryPaymentRecordDetailsPrintVo.setBalc(hsSettlementInfoEntity.getBalc());
            queryPaymentRecordDetailsPrintVo.setOthPay(hsSettlementInfoEntity.getOth_pay());
            queryPaymentRecordDetailsPrintVo.setHifobPay(hsSettlementInfoEntity.getHifob_pay());
            queryPaymentRecordDetailsPrintVo.setHifdmPay(hsSettlementInfoEntity.getHifdm_pay());
            queryPaymentRecordDetailsPrintVo.setHospPartAmt(hsSettlementInfoEntity.getHosp_part_amt());
            queryPaymentRecordDetailsPrintVo.setHifmiPay(hsSettlementInfoEntity.getHifmi_pay());
            queryPaymentRecordDetailsPrintVo.setAcctMulaidPay(hsSettlementInfoEntity.getAcct_mulaid_pay());
            queryPaymentRecordDetailsPrintVo.setMedType(hsSettlementInfoEntity.getMed_type());
            queryPaymentRecordDetailsPrintVo.setAcctPay(hsSettlementInfoEntity.getAcct_pay());
        }
        return ResponseData.success((Object)queryPaymentRecordDetailsPrintVo);
    }

    public ResponseData queryRecordByNumber(String transactionNumber, Integer tenant) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"tenant_id", (Object)tenant);
        queryWrapper.eq((Object)"transaction_number", (Object)transactionNumber);
        List outOrderPaymentRecords = this.outOrderPaymentRecordMapper.selectList((Wrapper)queryWrapper);
        return ResponseData.success((Object)outOrderPaymentRecords);
    }

    public ResponseData<PaymentDetailsVo> queryPaymentOrder(QueryFeeDetailsListDto parameter) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"pay_order_no", (Object)parameter.getPayOrderNo());
        OutOrderPayment outOrderPayment = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)queryWrapper);
        if (outOrderPayment == null) {
            return ResponseData.success((Object)new PaymentDetailsVo());
        }
        PaymentDetailsVo paymentDetailsVo = new PaymentDetailsVo();
        BeanUtils.copyProperties((Object)outOrderPayment, (Object)paymentDetailsVo);
        return ResponseData.success((Object)paymentDetailsVo);
    }

    public List<SysUserVo> getTollCollector(Integer tenant) {
        return this.outOrderPaymentMapper.getTollCollector(tenant);
    }
}

