/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.byh.outpatient.api.dto.HsSettlementReportDto;
import com.byh.outpatient.api.dto.hsSettlement.ExcelHsSettlementInfo;
import com.byh.outpatient.api.dto.hsSettlement.HsInfoDto;
import com.byh.outpatient.api.dto.hsSettlement.HsSettlementDetailDto;
import com.byh.outpatient.api.dto.hsSettlement.HsSettlementInfoDto;
import com.byh.outpatient.api.dto.hsSettlement.HsSettlementReportListDto;
import com.byh.outpatient.api.dto.hsSettlement.QueryDetailDto;
import com.byh.outpatient.api.dto.hsSettlement.ReconciliationTotalDto;
import com.byh.outpatient.api.dto.hsSettlement.TendencyDto;
import com.byh.outpatient.api.excel.ExcelHsSettlementInfoByHifmi;
import com.byh.outpatient.api.excel.ExcelHsSettlementInfoNew;
import com.byh.outpatient.api.excel.ExcelHsSettlementInfoSummary;
import com.byh.outpatient.api.excel.ExcelHsSettlementInfoSummaryByClrType;
import com.byh.outpatient.api.excel.ExcelHsSettlementInfoSummaryByClrTypeDetail;
import com.byh.outpatient.api.excel.ExcelHsSettlementInfoSummaryByOffsite;
import com.byh.outpatient.api.excel.ExcelHsSettlementInfoSummaryByOffsiteDetail;
import com.byh.outpatient.api.excel.ExcelHsSettlementInfoSummaryByOffsiteDetailSW;
import com.byh.outpatient.api.excel.ExcelHsSettlementInfoSummaryByOffsiteSW;
import com.byh.outpatient.api.hsModel.respones.ReconciliationTotalResponse;
import com.byh.outpatient.api.model.hsSettlement.HsSettlementInfoEntity;
import com.byh.outpatient.api.util.EasyExcelUtil;
import com.byh.outpatient.api.util.PageResult;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.vo.hsSettlement.HsSettlementReportListVo;
import com.byh.outpatient.web.aspect.UserOptLogger;
import com.byh.outpatient.web.mvc.config.NodeConfig;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.HsSettlementReportService;
import io.swagger.annotations.ApiOperation;
import io.swagger.v3.oas.annotations.Operation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hsSettlementReport"})
public class HsSettlementReportController {
    @Autowired
    private CommonRequest commonRequest;
    @Autowired
    private NodeConfig nodeConfig;
    @Autowired
    private HsSettlementReportService hsSettlementReportService;

    @ApiOperation(value="\u5c06\u533b\u4fdd\u4e2d\u5fc3\u7684\u7ed3\u7b97\u4fe1\u606f\u63d2\u5165\u533b\u4fdd\u7ed3\u7b97\u4fe1\u606f\u8868\uff08\u4ec5\u4f9b\u5185\u90e8\u4f7f\u7528\uff0c\u524d\u7aef\u4e0d\u4f7f\u7528\uff09")
    @PostMapping(value={"/insertHsCerterInfo"})
    public ResponseData insertHsCerterInfo(@RequestBody HsSettlementInfoDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.hsSettlementReportService.insertHsCerterInfo(dto);
        return ResponseData.success((Object)"\u65b0\u589e\u6210\u529f\uff01");
    }

    @PostMapping(value={"/getHsInfoForPieChart"})
    @ApiOperation(value="\u83b7\u53d6\u533b\u4fdd\u62a5\u8868\u4fe1\u606f\uff08\u997c\u56fe\u6a21\u5f0f\uff09")
    public ResponseData getHsInfoForPieChart(@RequestBody @Valid HsInfoDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.hsSettlementReportService.getHsInfoForPieChart(dto));
    }

    @PostMapping(value={"/getHsInfoForCard"})
    @ApiOperation(value="\u83b7\u53d6\u533b\u4fdd\u62a5\u8868\u4fe1\u606f\uff08\u5361\u7247\u6a21\u5f0f\uff09")
    public ResponseData getHsInfoForCard(@RequestBody @Valid HsInfoDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.hsSettlementReportService.getHsInfoForCard(dto));
    }

    @PostMapping(value={"/getTendencyInfo"})
    @ApiOperation(value="\u83b7\u53d6\u533b\u4fdd\u62a5\u8868\u8d8b\u52bf\u56fe\u4fe1\u606f")
    public ResponseData getTendencyInfo(@RequestBody @Valid TendencyDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.hsSettlementReportService.getTendencyInfo(dto));
    }

    @PostMapping(value={"/exportHsSettlementInfoReport"})
    @ApiOperation(value="\u5bfc\u51fa\u533b\u4fdd\u7ed3\u7b97\u4fe1\u606f\u7edf\u8ba1\u62a5\u8868")
    @UserOptLogger(operation="\u5bfc\u51fa\u533b\u4fdd\u7ed3\u7b97\u4fe1\u606f\u7edf\u8ba1\u62a5\u8868")
    public void exportHsSettlementInfoReport(HttpServletResponse response, @RequestBody HsSettlementReportDto dto) {
        this.hsSettlementReportService.exportHsSettlementInfoReport(response, dto);
        dto.setTenantId(this.commonRequest.getTenant());
    }

    @PostMapping(value={"/insertDetailList"})
    @ApiOperation(value="\u83b7\u53d6\u533b\u4fdd\u7ed3\u7b97\u4fe1\u606f-\u660e\u7ec6\u5217\u8868\u4fe1\u606f\u5e76\u63d2\u5165\u8868\u4e2d")
    public ResponseData insertDetailList(@RequestBody QueryDetailDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.hsSettlementReportService.insertDetailList(dto);
        return ResponseData.success((Object)"\u751f\u6210\u5b8c\u6210\uff01");
    }

    @PostMapping(value={"/hsSettlementList"})
    @ApiOperation(value="\u533b\u4fdd\u7ed3\u7b97\u6e05\u5355\u5217\u8868", httpMethod="POST", notes="\u533b\u4fdd\u7ed3\u7b97\u6e05\u5355\u5217\u8868")
    public ResponseData<PageResult<HsSettlementReportListVo>> hsSettlementList(@RequestBody HsSettlementReportListDto hsSettlementReportListDto) {
        Integer tenantId = this.commonRequest.getTenant();
        hsSettlementReportListDto.setTenantId(tenantId);
        return this.hsSettlementReportService.hsSettlementList(hsSettlementReportListDto);
    }

    @UserOptLogger(operation="\u533b\u4fdd\u7ed3\u7b97\u8be6\u60c5")
    @PostMapping(value={"/hsSettlementDetail"})
    @ApiOperation(value="\u533b\u4fdd\u7ed3\u7b97\u8be6\u60c5", httpMethod="POST", notes="\u533b\u4fdd\u7ed3\u7b97\u8be6\u60c5")
    public ResponseData<?> hsSettlementDetail(@RequestBody HsSettlementDetailDto hsSettlementDetailDto) {
        Integer tenantId = this.commonRequest.getTenant();
        hsSettlementDetailDto.setTenantId(tenantId);
        hsSettlementDetailDto.setSignNo(this.commonRequest.getSignNo());
        hsSettlementDetailDto.setOpter(this.commonRequest.getUserId().toString());
        hsSettlementDetailDto.setOpterName(this.commonRequest.getUserName());
        hsSettlementDetailDto.setOpterType(this.nodeConfig.getOpterType());
        return this.hsSettlementReportService.hsSettlementDetail(hsSettlementDetailDto);
    }

    @UserOptLogger(operation="\u533b\u4fdd\u7ed3\u7b97\u8be6\u60c5\u672c\u5730\u5e93")
    @PostMapping(value={"/hsSettlementDetailLocal"})
    @ApiOperation(value="\u533b\u4fdd\u7ed3\u7b97\u8be6\u60c5\u672c\u5730\u5e93", httpMethod="POST", notes="\u533b\u4fdd\u7ed3\u7b97\u8be6\u60c5\u672c\u5730\u5e93")
    public ResponseData<HsSettlementInfoEntity> hsSettlementDetailLocal(@RequestBody HsSettlementDetailDto hsSettlementDetailDto) {
        Integer tenantId = this.commonRequest.getTenant();
        hsSettlementDetailDto.setTenantId(tenantId);
        hsSettlementDetailDto.setSignNo(this.commonRequest.getSignNo());
        hsSettlementDetailDto.setOpter(this.commonRequest.getUserId().toString());
        hsSettlementDetailDto.setOpterName(this.commonRequest.getUserName());
        hsSettlementDetailDto.setOpterType(this.nodeConfig.getOpterType());
        return this.hsSettlementReportService.hsSettlementDetailLocal(hsSettlementDetailDto);
    }

    @UserOptLogger(operation="\u533b\u4fdd\u5bf9\u603b\u8d26")
    @PostMapping(value={"/reconciliationTotal"})
    @ApiOperation(value="\u533b\u4fdd\u5bf9\u603b\u8d26", httpMethod="POST", notes="\u533b\u4fdd\u5bf9\u603b\u8d26")
    public ResponseData<List<ReconciliationTotalResponse>> reconciliationTotal(@RequestBody ReconciliationTotalDto reconciliationTotalDto) {
        Integer tenantId = this.commonRequest.getTenant();
        reconciliationTotalDto.setTenantId(tenantId);
        reconciliationTotalDto.setSignNo(this.commonRequest.getSignNo());
        reconciliationTotalDto.setOpter(String.valueOf(this.commonRequest.getUserId()));
        reconciliationTotalDto.setOpterName(this.commonRequest.getUserName());
        reconciliationTotalDto.setOpterType(this.nodeConfig.getOpterType());
        return this.hsSettlementReportService.reconciliationTotalNew(reconciliationTotalDto);
    }

    @PostMapping(value={"/exportHsSettlementInfo"})
    @ApiOperation(value="\u4e0b\u8f7d\u7ed3\u7b97\u8be6\u60c5\u8868", httpMethod="POST", notes="\u4e0b\u8f7d\u7ed3\u7b97\u8be6\u60c5\u8868")
    public void exportHsSettlementInfo(HttpServletResponse response, @RequestBody ReconciliationTotalDto reconciliationTotalDto) {
        Integer tenantId = this.commonRequest.getTenant();
        reconciliationTotalDto.setTenantId(tenantId);
        List excelHsSettlementInfos = this.hsSettlementReportService.exportHsSettlementInfoList(reconciliationTotalDto);
        String excelName = reconciliationTotalDto.getMonth() + "\u533b\u4fdd\u6708\u7ed3\u7b97\u8be6\u60c5";
        String sheetName = "" + reconciliationTotalDto.getYear() + reconciliationTotalDto.getMonth();
        EasyExcelUtil.normalExport((HttpServletResponse)response, (String)excelName, (String)sheetName, (List)excelHsSettlementInfos, ExcelHsSettlementInfo.class);
    }

    @PostMapping(value={"/cityWorkerHsSettlementInfo"})
    @ApiOperation(value="\u5e02\u533b\u4fdd\u804c\u5de5\u660e\u7ec6", httpMethod="POST", notes="\u5e02\u533b\u4fdd\u804c\u5de5\u660e\u7ec6")
    public void cityWorkerHsSettlementInfo(HttpServletResponse response, @RequestBody ReconciliationTotalDto reconciliationTotalDto) {
        Integer tenantId = this.commonRequest.getTenant();
        reconciliationTotalDto.setTenantId(tenantId);
        List excelHsSettlementInfos = this.hsSettlementReportService.cityWorkerHsSettlementInfo(reconciliationTotalDto);
        String excelName = reconciliationTotalDto.getMonth() + "\u533b\u4fdd\u6708\u7ed3\u7b97\u8be6\u60c5";
        String sheetName = "" + reconciliationTotalDto.getYear() + reconciliationTotalDto.getMonth();
        EasyExcelUtil.normalExport((HttpServletResponse)response, (String)excelName, (String)sheetName, (List)excelHsSettlementInfos, ExcelHsSettlementInfo.class);
    }

    @PostMapping(value={"/urbanEmployeesHsSettlementInfo"})
    @Operation(description="\u57ce\u9547\u804c\u5de5\u95e8\u8bca\u660e\u7ec6\u5bfc\u51fa")
    @ApiOperation(value="\u57ce\u9547\u804c\u5de5\u95e8\u8bca\u660e\u7ec6\u5bfc\u51fa", httpMethod="POST", notes="\u57ce\u9547\u804c\u5de5\u95e8\u8bca\u660e\u7ec6\u5bfc\u51fa")
    public void urbanEmployeesHsSettlementInfo(HttpServletResponse response, @RequestBody ReconciliationTotalDto reconciliationTotalDto) {
        Integer tenantId = this.commonRequest.getTenant();
        reconciliationTotalDto.setTenantId(tenantId);
        List excelHsSettlementInfos = this.hsSettlementReportService.urbanEmployeesHsSettlementInfo(reconciliationTotalDto);
        String excelName = reconciliationTotalDto.getMonth() + "\u57ce\u9547\u804c\u5de5\u95e8\u8bca\u660e\u7ec6\u5bfc\u51fa";
        String sheetName = "" + reconciliationTotalDto.getYear() + reconciliationTotalDto.getMonth();
        EasyExcelUtil.normalExport((HttpServletResponse)response, (String)excelName, (String)sheetName, (List)excelHsSettlementInfos, ExcelHsSettlementInfoNew.class);
    }

    @PostMapping(value={"/hsSettlmentInfoSummary"})
    @Operation(description="\u533b\u4fdd\u95e8\u8bca\u8d39\u7528\u660e\u7ec6\u6c47\u603b")
    @ApiOperation(value="\u533b\u4fdd\u95e8\u8bca\u8d39\u7528\u660e\u7ec6\u6c47\u603b", httpMethod="POST", notes="\u533b\u4fdd\u95e8\u8bca\u8d39\u7528\u660e\u7ec6\u6c47\u603b")
    public void hsSettlmentInfoSummary(HttpServletResponse response, @RequestBody ReconciliationTotalDto entity) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Integer tenantId = this.commonRequest.getTenant();
        entity.setTenantId(tenantId);
        List excelHsSettlementInfoSummaries = this.hsSettlementReportService.hsSettlmentInfoSummary(entity);
        ArrayList<Class<ExcelHsSettlementInfoSummary>> classList = new ArrayList<Class<ExcelHsSettlementInfoSummary>>();
        HashMap map = new HashMap();
        for (ExcelHsSettlementInfoSummary excelHsSettlementInfoSummary : excelHsSettlementInfoSummaries) {
            List<ExcelHsSettlementInfoSummary> list;
            classList.add(ExcelHsSettlementInfoSummary.class);
            String medType = excelHsSettlementInfoSummary.getMedType();
            if (map.containsKey(medType)) {
                list = (List)map.get(medType);
                list.add(excelHsSettlementInfoSummary);
                continue;
            }
            list = new ArrayList();
            list.add(excelHsSettlementInfoSummary);
            map.put(medType, list);
        }
        ArrayList<List> data = new ArrayList<List>();
        ArrayList<String> sheetNames = new ArrayList<String>();
        for (String s : map.keySet()) {
            List list = (List)map.get(s);
            Collections.reverse(list);
            data.add(list);
            sheetNames.add(s);
        }
        EasyExcelUtil.exportExcelPaging((HttpServletResponse)response, (String)"\u533b\u4fdd\u95e8\u8bca\u8d39\u7528\u660e\u7ec6\u6c47\u603b", sheetNames, data, classList);
    }

    @PostMapping(value={"/hsSettlmentInfoSummaryByMedType"})
    @Operation(description="\u5357\u660c\u5e02\u53ca\u7701\u5185\u5f02\u5730\u7ed3\u7b97\u8868")
    @ApiOperation(value="\u5357\u660c\u5e02\u53ca\u7701\u5185\u5f02\u5730\u7ed3\u7b97\u8868", httpMethod="POST", notes="\u5357\u660c\u5e02\u53ca\u7701\u5185\u5f02\u5730\u7ed3\u7b97\u8868")
    public void hsSettlmentInfoSummaryByMedType(HttpServletResponse response, @RequestBody ReconciliationTotalDto entity) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Integer tenantId = this.commonRequest.getTenant();
        entity.setTenantId(tenantId);
        List data = this.hsSettlementReportService.hsSettlmentInfoSummaryByMedType(entity);
        ArrayList<Class<ExcelHsSettlementInfoByHifmi>> classList = new ArrayList<Class<ExcelHsSettlementInfoByHifmi>>();
        for (int i = 0; i < data.size(); ++i) {
            if (i < 6) {
                classList.add(ExcelHsSettlementInfoSummary.class);
                continue;
            }
            if (i < 10) {
                classList.add(ExcelHsSettlementInfoNew.class);
                continue;
            }
            if (i == 10) {
                classList.add(ExcelHsSettlementInfoSummaryByOffsite.class);
                continue;
            }
            if (i == 11) {
                classList.add(ExcelHsSettlementInfoSummaryByOffsiteDetail.class);
                continue;
            }
            if (i == 12) {
                classList.add(ExcelHsSettlementInfoSummaryByOffsiteSW.class);
                continue;
            }
            if (i == 13) {
                classList.add(ExcelHsSettlementInfoSummaryByOffsiteDetailSW.class);
                continue;
            }
            classList.add(ExcelHsSettlementInfoByHifmi.class);
        }
        ArrayList<String> sheetNames = new ArrayList<String>();
        sheetNames.add("\u5357\u660c\u5e02\u804c\u5de5\u666e\u901a\u95e8\u8bca\u6c47\u603b");
        sheetNames.add("\u5357\u660c\u5e02\u804c\u5de5\u6162\u75c5\u95e8\u8bca\u6c47\u603b");
        sheetNames.add("\u5357\u660c\u5e02\u804c\u5de5\u5927\u75c5\u95e8\u8bca\u6c47\u603b");
        sheetNames.add("\u5357\u660c\u5e02\u5c45\u6c11\u666e\u901a\u95e8\u8bca\u6c47\u603b");
        sheetNames.add("\u5357\u660c\u5e02\u5c45\u6c11\u6162\u75c5\u95e8\u8bca\u6c47\u603b");
        sheetNames.add("\u5357\u660c\u5e02\u5c45\u6c11\u5927\u75c5\u95e8\u8bca\u6c47\u603b");
        sheetNames.add("\u5357\u660c\u5e02\u804c\u5de5\u666e\u901a\u95e8\u8bca\u660e\u7ec6");
        sheetNames.add("\u5357\u660c\u5e02\u804c\u5de5\u6162\u75c5\u95e8\u8bca\u660e\u7ec6");
        sheetNames.add("\u5357\u660c\u5e02\u5c45\u6c11\u666e\u901a\u95e8\u8bca\u660e\u7ec6");
        sheetNames.add("\u5357\u660c\u5e02\u5c45\u6c11\u6162\u75c5\u95e8\u8bca\u660e\u7ec6");
        sheetNames.add("\u7701\u5185\u5f02\u5730\u6c47\u603b");
        sheetNames.add("\u7701\u5185\u5f02\u5730\u660e\u7ec6");
        sheetNames.add("\u7701\u5916\u5f02\u5730\u6c47\u603b");
        sheetNames.add("\u7701\u5916\u5f02\u5730\u660e\u7ec6");
        sheetNames.add("\u804c\u5de5\u5927\u75c5\u95e8\u8bca\u660e\u7ec6");
        sheetNames.add("\u5c45\u6c11\u5927\u75c5\u95e8\u8bca\u660e\u7ec6");
        EasyExcelUtil.exportExcelPaging((HttpServletResponse)response, (String)"\u533b\u4fdd\u95e8\u8bca\u8d39\u7528\u660e\u7ec6\u6c47\u603b", sheetNames, (List)data, classList);
    }

    @PostMapping(value={"/hsSettlmentInfoSummaryByClrType"})
    @Operation(description="\u7701 \u673a\u5173\u6216\u4f01\u4e1a\u533b\u4fdd\u95e8\u8bca\u8d39\u7528\u5bfc\u51fa")
    @ApiOperation(value="\u7701 \u673a\u5173\u6216\u4f01\u4e1a\u533b\u4fdd\u95e8\u8bca\u8d39\u7528\u5bfc\u51fa", httpMethod="POST", notes="\u7701 \u673a\u5173\u6216\u4f01\u4e1a\u533b\u4fdd\u95e8\u8bca\u8d39\u7528\u5bfc\u51fa")
    public void hsSettlmentInfoSummaryByClrType(HttpServletResponse response, @RequestBody ReconciliationTotalDto entity) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        List data = this.hsSettlementReportService.hsSettlmentInfoSummaryByClrType(entity);
        ArrayList<Class> classList = new ArrayList<Class>();
        for (int i = 0; i < data.size(); ++i) {
            if (i == 0 || i == 2 || i == 4) {
                classList.add(ExcelHsSettlementInfoSummaryByClrType.class);
                continue;
            }
            classList.add(ExcelHsSettlementInfoSummaryByClrTypeDetail.class);
        }
        ArrayList<String> sheetNames = new ArrayList<String>();
        sheetNames.add("\u673a\u5173\u6c47\u603b");
        sheetNames.add("\u673a\u5173\u660e\u7ec6");
        sheetNames.add("\u4f01\u4e1a\u6c47\u603b");
        sheetNames.add("\u4f01\u4e1a\u660e\u7ec6");
        sheetNames.add("\u79bb\u4f11\u6c47\u603b");
        sheetNames.add("\u79bb\u4f11\u660e\u7ec6");
        EasyExcelUtil.exportExcelPaging((HttpServletResponse)response, (String)"\u533b\u4fdd\u95e8\u8bca\u8d39\u7528\u660e\u7ec6\u6c47\u603b", sheetNames, (List)data, classList);
    }
}

