/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.outpatient.api.dto.infusionOfFluids.GetInfusionListDto;
import com.byh.outpatient.api.dto.infusionOfFluids.GetInfusionPageDto;
import com.byh.outpatient.api.dto.infusionOfFluids.OperateInfusionDto;
import com.byh.outpatient.api.dto.infusionOfFluids.SaveInfusionOfFluidsDetailDto;
import com.byh.outpatient.api.dto.infusionOfFluids.SaveInfusionOfFluidsDto;
import com.byh.outpatient.api.enums.AdmissionStatusEnum;
import com.byh.outpatient.api.enums.GenderEnum;
import com.byh.outpatient.api.enums.OutInfusionOperateCodeEnum;
import com.byh.outpatient.api.enums.OutInfusionStatusEnum;
import com.byh.outpatient.api.enums.OutOrderStatusEnum;
import com.byh.outpatient.api.enums.PaymentStatusEnum;
import com.byh.outpatient.api.enums.PrescriptionStatusEnum;
import com.byh.outpatient.api.enums.PrescriptionTypeEnum;
import com.byh.outpatient.api.exception.BusinessException;
import com.byh.outpatient.api.model.admission.AdmissionEntity;
import com.byh.outpatient.api.model.infusionOfFluids.OutInfusionOfFluidsEntity;
import com.byh.outpatient.api.model.infusionOfFluids.OutInfusionOfFluidsRecordEntity;
import com.byh.outpatient.api.model.order.OutOrder;
import com.byh.outpatient.api.model.prescription.OutPrescription;
import com.byh.outpatient.api.util.ExceptionUtils;
import com.byh.outpatient.api.vo.hsSettlement.DictValueVo;
import com.byh.outpatient.api.vo.inFusionOfFluids.GetHospitalInfoVo;
import com.byh.outpatient.api.vo.inFusionOfFluids.GetInfsuionVo;
import com.byh.outpatient.api.vo.inFusionOfFluids.GetInfusionListVo;
import com.byh.outpatient.api.vo.inFusionOfFluids.GetInfusionPageVo;
import com.byh.outpatient.api.vo.inFusionOfFluids.GetInfusionPrintDetailVo;
import com.byh.outpatient.api.vo.inFusionOfFluids.GetInfusionPrintVo;
import com.byh.outpatient.data.repository.AdmissionMapper;
import com.byh.outpatient.data.repository.OutHsSettlementInfoMapper;
import com.byh.outpatient.data.repository.OutInfusionOfFluidsMapper;
import com.byh.outpatient.data.repository.OutInfusionOfFluidsRecordMapper;
import com.byh.outpatient.data.repository.OutOrderMapper;
import com.byh.outpatient.data.repository.OutPrescriptionMapper;
import com.byh.outpatient.web.service.OutInfusionOfFluidsService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OutInfusionOfFluidsServiceImpl
implements OutInfusionOfFluidsService {
    private static final Logger log = LoggerFactory.getLogger(OutInfusionOfFluidsServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(OutInfusionOfFluidsServiceImpl.class);
    @Resource
    private OutInfusionOfFluidsMapper outInfusionOfFluidsMapper;
    @Resource
    private OutInfusionOfFluidsRecordMapper outInfusionOfFluidsRecordMapper;
    @Resource
    private AdmissionMapper admissionMapper;
    @Resource
    private OutHsSettlementInfoMapper outHsSettlementInfoMapper;
    @Resource
    private OutOrderMapper outOrderMapper;
    @Resource
    private OutPrescriptionMapper outPrescriptionMapper;

    public GetInfusionPrintVo selectPrintData(GetInfusionListDto dto) {
        List list;
        Map map;
        String hospitalName;
        Integer tenantId = dto.getTenantId();
        GetHospitalInfoVo hospitalInfoVo = this.outInfusionOfFluidsMapper.selectHosptialById(dto.getTenantId());
        if (hospitalInfoVo == null) {
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)("\u6839\u636e\u79df\u6237ID\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u673a\u6784\u4fe1\u606f\uff01\u79df\u6237ID\uff1a" + tenantId));
        }
        if (StrUtil.isEmpty((CharSequence)(hospitalName = hospitalInfoVo.getName()))) {
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)("\u5f53\u524d\u533b\u9662\u673a\u6784\u7684\u540d\u79f0\u4e3a\u7a7a\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u7ef4\u62a4\uff01\u79df\u6237ID\uff1a" + tenantId));
        }
        List firstList = (map = (Map)(list = this.outInfusionOfFluidsMapper.selectListByOutpatientNo(dto)).stream().collect(Collectors.groupingBy(entity -> entity.getPrescriptionNo() + entity.getGroupNo() + entity.getExecCount(), LinkedHashMap::new, Collectors.toList()))).isEmpty() ? Collections.emptyList() : (List)map.values().iterator().next();
        OutInfusionOfFluidsEntity infusion = (OutInfusionOfFluidsEntity)firstList.get(0);
        GetInfusionPrintVo infusionPrintVo = new GetInfusionPrintVo();
        if (firstList.isEmpty()) {
            return infusionPrintVo;
        }
        infusionPrintVo.setHospitalName(hospitalName);
        infusionPrintVo.setOutpatientNo(infusion.getOutpatientNo());
        infusionPrintVo.setPatientName(infusion.getPatientName());
        infusionPrintVo.setGenderName(infusion.getGenderName());
        infusionPrintVo.setPatientAge(infusion.getPatientAge());
        ArrayList<GetInfusionPrintDetailVo> detailList = new ArrayList<GetInfusionPrintDetailVo>();
        for (Map.Entry entry : map.entrySet()) {
            List infusionList = (List)entry.getValue();
            String drugName = infusionList.stream().map(entity -> entity.getDrugName() + "/" + entity.getDrugSpec()).collect(Collectors.joining("\u3002"));
            String usageName = infusionList.stream().map(OutInfusionOfFluidsEntity::getUsageName).collect(Collectors.joining("\u3002"));
            String singleDose = infusionList.stream().map(entity -> entity.getSingleDose() + "\uff08" + entity.getDoseUnitName() + "\uff09").collect(Collectors.joining("\u3002"));
            GetInfusionPrintDetailVo detailVo = new GetInfusionPrintDetailVo();
            OutInfusionOfFluidsEntity infusionVo = (OutInfusionOfFluidsEntity)infusionList.get(0);
            detailVo.setExecCountInfo(infusionVo.getGroupNo() + "/" + infusionVo.getExecCount());
            detailVo.setDrugName(drugName);
            detailVo.setUsageName(usageName);
            detailVo.setSingleDose(singleDose);
            detailList.add(detailVo);
        }
        infusionPrintVo.setDetailList(detailList);
        return infusionPrintVo;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public String operateInfusion(OperateInfusionDto dto) {
        String operateCode = dto.getOperateCode();
        Integer execCount = dto.getExecCount();
        String outpatientNo = dto.getOutpatientNo();
        String prescNo = dto.getPrescriptionNo();
        Integer groupNo = dto.getGroupNo();
        Integer operatorId = dto.getOperatorId();
        String operatorName = dto.getOperatorName();
        Integer tenantId = dto.getTenantId();
        String operateName = "";
        List infusionList = new ArrayList();
        if (OutInfusionOperateCodeEnum.START.getValue().equals(operateCode) || OutInfusionOperateCodeEnum.END.getValue().equals(operateCode)) {
            infusionList = this.outInfusionOfFluidsMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutInfusionOfFluidsEntity::getOutpatientNo, (Object)outpatientNo)).eq(OutInfusionOfFluidsEntity::getPrescriptionNo, (Object)prescNo)).eq(OutInfusionOfFluidsEntity::getGroupNo, (Object)groupNo)).eq(OutInfusionOfFluidsEntity::getExecCount, (Object)execCount));
            if (infusionList.isEmpty()) {
                this.throwStatusException("\u64cd\u4f5c\u8f93\u6db2\u5355\u65f6\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u8f93\u6db2\u5355\u5217\u8868\u4fe1\u606f\uff01", outpatientNo, prescNo, groupNo, execCount);
            }
            if (OutInfusionOperateCodeEnum.START.getValue().equals(operateCode)) {
                List frontList = this.outInfusionOfFluidsMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutInfusionOfFluidsEntity::getOutpatientNo, (Object)outpatientNo)).eq(OutInfusionOfFluidsEntity::getPrescriptionNo, (Object)prescNo)).eq(OutInfusionOfFluidsEntity::getGroupNo, (Object)groupNo)).lt(OutInfusionOfFluidsEntity::getExecCount, (Object)execCount)).eq(OutInfusionOfFluidsEntity::getStatus, (Object)OutInfusionStatusEnum.READY_INFUSION.getValue()));
                Map<String, List<OutInfusionOfFluidsEntity>> map = frontList.stream().collect(Collectors.groupingBy(entity -> entity.getPrescriptionNo() + entity.getGroupNo() + entity.getExecCount()));
                if (!map.isEmpty()) {
                    StringBuilder errorInfoBuilder = new StringBuilder();
                    errorInfoBuilder.append("\u5f00\u59cb\u8f93\u6db2\u65f6\uff0c\u76d1\u6d4b\u5230\u4e4b\u524d\u5b58\u5728\u672a\u5f00\u59cb\u8f93\u6db2\u7684\u8ba2\u5355\uff1a");
                    for (Map.Entry<String, List<OutInfusionOfFluidsEntity>> entry : map.entrySet()) {
                        OutInfusionOfFluidsEntity infusion = entry.getValue().get(0);
                        errorInfoBuilder.append("\u5904\u65b9\u53f7\uff1a").append(prescNo).append("\uff0c\u7b2c\uff08").append(groupNo).append("\uff09\u7ec4").append("\uff0c\u7b2c\uff08").append(infusion.getExecCount()).append("\uff09\u6b21\u3002");
                    }
                    ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)errorInfoBuilder.toString());
                }
                this.checkInfusionStatus(infusionList, OutInfusionStatusEnum.READY_INFUSION, "\u5f00\u59cb\u8f93\u6db2", outpatientNo, prescNo, groupNo, execCount);
            } else if (OutInfusionOperateCodeEnum.END.getValue().equals(operateCode)) {
                this.checkInfusionStatus(infusionList, OutInfusionStatusEnum.START_INFUSION, "\u7ed3\u675f\u8f93\u6db2", outpatientNo, prescNo, groupNo, execCount);
            }
        }
        if (OutInfusionOperateCodeEnum.DISPENSED.getValue().equals(operateCode)) {
            operateName = "\u7b2c" + execCount + "\u6b21" + OutInfusionOperateCodeEnum.DISPENSED.getLabel();
        } else if (OutInfusionOperateCodeEnum.CHECKED.getValue().equals(operateCode)) {
            operateName = "\u7b2c" + execCount + "\u6b21" + OutInfusionOperateCodeEnum.CHECKED.getLabel();
        } else if (OutInfusionOperateCodeEnum.START.getValue().equals(operateCode)) {
            operateName = "\u7b2c" + execCount + "\u6b21" + OutInfusionOperateCodeEnum.START.getLabel();
        } else if (OutInfusionOperateCodeEnum.END.getValue().equals(operateCode)) {
            operateName = "\u7b2c" + execCount + "\u6b21" + OutInfusionOperateCodeEnum.END.getLabel();
        } else {
            String errorInfo = String.format("\u64cd\u4f5c\u8f93\u6db2\u5355\u65f6\uff0c\u64cd\u4f5c\u7f16\u7801\u9519\u8bef\uff01\u5e94\u4e3a\uff1a\uff08%s\u3001%s\uff09\uff0c\uff08%s\u3001%s\uff09\uff0c\uff08%s\u3001%s\uff09\uff0c\uff08%s\u3001%s\uff09\uff01\u5b9e\u9645\u4e3a\uff1a%s", OutInfusionOperateCodeEnum.DISPENSED.getValue(), OutInfusionOperateCodeEnum.DISPENSED.getLabel(), OutInfusionOperateCodeEnum.CHECKED.getValue(), OutInfusionOperateCodeEnum.CHECKED.getLabel(), OutInfusionOperateCodeEnum.START.getValue(), OutInfusionOperateCodeEnum.START.getLabel(), OutInfusionOperateCodeEnum.END.getValue(), OutInfusionOperateCodeEnum.END.getLabel(), operateCode);
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)errorInfo);
        }
        this.updateOperatorInfo(operateCode, operatorId, operatorName, tenantId, outpatientNo, prescNo, groupNo, execCount);
        dto.setOperateName(operateName);
        this.insertInfusionRecord(dto);
        return operateName;
    }

    private void updateOperatorInfo(String operateCode, Integer operatorId, String operatorName, Integer tenantId, String outpatientNo, String prescNo, Integer groupNo, Integer execCount) {
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.eq(OutInfusionOfFluidsEntity::getTenantId, (Object)tenantId)).eq(OutInfusionOfFluidsEntity::getOutpatientNo, (Object)outpatientNo)).eq(OutInfusionOfFluidsEntity::getPrescriptionNo, (Object)prescNo)).eq(OutInfusionOfFluidsEntity::getGroupNo, (Object)groupNo)).eq(OutInfusionOfFluidsEntity::getExecCount, (Object)execCount);
        if (OutInfusionOperateCodeEnum.DISPENSED.getValue().equals(operateCode)) {
            ((LambdaUpdateWrapper)updateWrapper.set(OutInfusionOfFluidsEntity::getDispenMedicineId, (Object)operatorId)).set(OutInfusionOfFluidsEntity::getDispenMedicineName, (Object)operatorName);
        } else if (OutInfusionOperateCodeEnum.CHECKED.getValue().equals(operateCode)) {
            ((LambdaUpdateWrapper)updateWrapper.set(OutInfusionOfFluidsEntity::getCheckerId, (Object)operatorId)).set(OutInfusionOfFluidsEntity::getCheckerName, (Object)operatorName);
        } else if (OutInfusionOperateCodeEnum.START.getValue().equals(operateCode)) {
            updateWrapper.set(OutInfusionOfFluidsEntity::getStatus, (Object)OutInfusionStatusEnum.START_INFUSION.getValue());
        } else if (OutInfusionOperateCodeEnum.END.getValue().equals(operateCode)) {
            updateWrapper.set(OutInfusionOfFluidsEntity::getStatus, (Object)OutInfusionStatusEnum.END_INFUSION.getValue());
        }
        this.outInfusionOfFluidsMapper.update(null, (Wrapper)updateWrapper);
    }

    private void checkInfusionStatus(List<OutInfusionOfFluidsEntity> infusionList, OutInfusionStatusEnum expectedStatus, String operation, String outpatientNo, String prescNo, Integer groupNo, Integer execCount) {
        boolean errorFlag = infusionList.stream().anyMatch(entity -> !expectedStatus.getValue().equals(entity.getStatus()));
        if (errorFlag) {
            OutInfusionOfFluidsEntity infusion = infusionList.get(0);
            String statusCode = infusion.getStatus();
            String statusName = Optional.ofNullable(OutInfusionStatusEnum.getEnumLabel((String)statusCode)).map(OutInfusionStatusEnum::getLabel).orElse("");
            if (StrUtil.isEmpty((CharSequence)statusName)) {
                this.throwStatusException(operation + "\u65f6\uff0c\u72b6\u6001\u7f16\u7801\u5f02\u5e38\uff01\u72b6\u6001\u7f16\u7801\uff1a" + statusCode, outpatientNo, prescNo, groupNo, execCount);
            }
            this.throwStatusException(String.format("%s\u65f6\uff0c\u72b6\u6001\u7f16\u7801\u5f02\u5e38\uff01\u5e94\u4e3a\uff1a\uff08%s\u3001%s\uff09\uff01\u5b9e\u9645\u4e3a\uff1a\uff08%s\u3001%s\uff09\uff01", operation, expectedStatus.getValue(), expectedStatus.getLabel(), statusCode, statusName), outpatientNo, prescNo, groupNo, execCount);
        }
    }

    private void throwStatusException(String message, String outpatientNo, String prescNo, Integer groupNo, Integer execCount) {
        String errorInfo = String.format("%s\u95e8\u8bca\u53f7\uff08%s\uff09\uff0c\u5904\u65b9\u53f7\uff08%s\uff09\uff0c\u7ec4\u53f7\uff08%s\uff09\uff0c\u5f53\u524d\u6267\u884c\u6b21\u6570\uff08%s\uff09\uff01", message, outpatientNo, prescNo, groupNo, execCount);
        ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)errorInfo);
    }

    private void insertInfusionRecord(OperateInfusionDto dto) {
        Integer tenantId = dto.getTenantId();
        String prescNo = dto.getPrescriptionNo();
        Integer groupNo = dto.getGroupNo();
        String operateCode = dto.getOperateCode();
        String operateName = dto.getOperateName();
        OutInfusionOfFluidsRecordEntity dbRecord = (OutInfusionOfFluidsRecordEntity)this.outInfusionOfFluidsRecordMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutInfusionOfFluidsRecordEntity::getTenantId, (Object)tenantId)).eq(OutInfusionOfFluidsRecordEntity::getPrescriptionNo, (Object)prescNo)).eq(OutInfusionOfFluidsRecordEntity::getGroupNo, (Object)groupNo)).eq(OutInfusionOfFluidsRecordEntity::getOperationCode, (Object)operateCode)).eq(OutInfusionOfFluidsRecordEntity::getOperationName, (Object)operateName));
        if (dbRecord != null) {
            String errorInfo = String.format("\u64cd\u4f5c\u8f93\u6db2\u5355\u65f6\uff0c\u5f53\u524d\u5904\u65b9\uff08%s\uff09\u4e2d\u7b2c\uff08%s\uff09\u7ec4\u836f\u54c1\u5df2\u8fdb\u884c\u8fc7\u8be5\u64cd\u4f5c\uff1a\uff08%s\u3001%s\uff09\uff01", prescNo, groupNo, operateCode, operateName);
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)errorInfo);
        }
        OutInfusionOfFluidsRecordEntity record = new OutInfusionOfFluidsRecordEntity();
        record.setTenantId(tenantId);
        record.setCreateId(dto.getOperatorId());
        record.setCreateName(dto.getOperatorName());
        record.setPrescriptionNo(prescNo);
        record.setGroupNo(groupNo);
        record.setOperationCode(operateCode);
        record.setOperationName(operateName);
        this.outInfusionOfFluidsRecordMapper.insert((Object)record);
    }

    public GetInfsuionVo selectListByOutpatientNo(GetInfusionListDto dto) {
        String hospitalName;
        GetHospitalInfoVo hospitalInfoVo;
        String outpatientNo = dto.getOutpatientNo();
        Integer tenantId = dto.getTenantId();
        List list = this.outInfusionOfFluidsMapper.selectListByOutpatientNo(dto);
        Map map = list.stream().collect(Collectors.groupingBy(entity -> entity.getPrescriptionNo() + entity.getGroupNo() + entity.getExecCount(), LinkedHashMap::new, Collectors.toList()));
        GetInfsuionVo infsuionVo = this.admissionMapper.selectByOutpatientNo(tenantId, outpatientNo);
        if (infsuionVo == null) {
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)("\u67e5\u8be2\u95e8\u8bca\u8f93\u6db2\u5355\u65f6\uff0c\u6839\u636e\u95e8\u8bca\u53f7\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6302\u53f7\u8bb0\u5f55\uff01\u95e8\u8bca\u53f7\uff1a" + outpatientNo));
        }
        if ((hospitalInfoVo = this.outInfusionOfFluidsMapper.selectHosptialById(tenantId)) == null) {
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)("\u6839\u636e\u79df\u6237ID\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u673a\u6784\u4fe1\u606f\uff01\u79df\u6237ID\uff1a" + tenantId));
        }
        if (StrUtil.isEmpty((CharSequence)(hospitalName = hospitalInfoVo.getName()))) {
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)("\u5f53\u524d\u533b\u9662\u673a\u6784\u7684\u540d\u79f0\u4e3a\u7a7a\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u7ef4\u62a4\uff01\u79df\u6237ID\uff1a" + tenantId));
        }
        infsuionVo.setHospitalName(hospitalName);
        ArrayList<GetInfusionListVo> infusionListVoList = new ArrayList<GetInfusionListVo>();
        for (Map.Entry entry : map.entrySet()) {
            List infusionList = (List)entry.getValue();
            OutInfusionOfFluidsEntity infusion = (OutInfusionOfFluidsEntity)infusionList.get(0);
            GetInfusionListVo infusionListVo = new GetInfusionListVo();
            infusionListVo.setTotalExecCount(infusion.getTotalExecCount());
            infusionListVo.setExecCount(infusion.getExecCount());
            String statusCode = infusion.getStatus();
            String statusName = Optional.ofNullable(OutInfusionStatusEnum.getEnumLabel((String)statusCode)).map(OutInfusionStatusEnum::getLabel).orElse("\u72b6\u6001\u5f02\u5e38");
            infusionListVo.setStatusCode(statusCode);
            infusionListVo.setStatusName(statusName);
            infusionListVo.setPrescriptionNo(infusion.getPrescriptionNo());
            infusionListVo.setGroupNo(infusion.getGroupNo());
            infusionListVo.setDispenMedicineId(infusion.getDispenMedicineId());
            infusionListVo.setDispenMedicineName(infusion.getDispenMedicineName());
            infusionListVo.setCheckerId(infusion.getCheckerId());
            infusionListVo.setCheckerName(infusion.getCheckerName());
            infusionListVo.setInfusionOfFluidsList(infusionList);
            infusionListVoList.add(infusionListVo);
        }
        infsuionVo.setInfusionListVoList(infusionListVoList);
        return infsuionVo;
    }

    public Page<GetInfusionPageVo> selectPageList(GetInfusionPageDto dto) {
        Page page = new Page((long)dto.getCurrent().intValue(), (long)dto.getSize().intValue());
        List list = this.outInfusionOfFluidsMapper.selectPageList(page, dto);
        page.setRecords(list);
        return page;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void operateInfusionOfFluids(SaveInfusionOfFluidsDto dto) {
        Integer tenantId = dto.getTenantId();
        String outpatientNo = dto.getOutpatientNo();
        String prescNo = dto.getPrescriptionNo();
        String generateFlag = dto.getGenerateFlag();
        this.outInfusionOfFluidsMapper.delete((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutInfusionOfFluidsEntity::getTenantId, (Object)tenantId)).eq(OutInfusionOfFluidsEntity::getOutpatientNo, (Object)outpatientNo)).eq(OutInfusionOfFluidsEntity::getPrescriptionNo, (Object)prescNo));
        this.outInfusionOfFluidsRecordMapper.delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutInfusionOfFluidsRecordEntity::getTenantId, (Object)tenantId)).eq(OutInfusionOfFluidsRecordEntity::getPrescriptionNo, (Object)prescNo));
        if ("1".equals(generateFlag)) {
            Integer paymentStatus;
            String paymentStatusLabel;
            OutOrder outOrder = (OutOrder)this.outOrderMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutOrder::getStatus, (Object)OutOrderStatusEnum.NORMAL.getValue())).eq(OutOrder::getPrescriptionNo, (Object)prescNo));
            if (outOrder == null) {
                ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)("\u751f\u6210\u8f93\u6db2\u5355\u65f6\uff0c\u6839\u636e\u5904\u65b9\u53f7\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u652f\u4ed8\u8ba2\u5355\uff01\u5904\u65b9\u53f7\uff1a" + prescNo));
            }
            if (StrUtil.isEmpty((CharSequence)(paymentStatusLabel = Optional.ofNullable(PaymentStatusEnum.getValueEnum((Integer)(paymentStatus = outOrder.getPaymentStatus()))).map(PaymentStatusEnum::getDesc).orElse("")))) {
                ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)("\u751f\u6210\u8f93\u6db2\u5355\u65f6\uff0c\u5bf9\u5e94\u7684\u652f\u4ed8\u5355\u72b6\u6001\u7f16\u7801\u5f02\u5e38\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01\u5904\u65b9\u53f7\uff1a" + prescNo));
            }
            if (!PaymentStatusEnum.PAYMENT_REQUIRED.getValue().equals(paymentStatus) && !PaymentStatusEnum.PAYMENT_PENDING.getValue().equals(paymentStatus)) {
                String errorInfo = String.format("\u751f\u6210\u8f93\u6db2\u5355\u65f6\uff0c\u652f\u4ed8\u72b6\u6001\u7f16\u7801\u9519\u8bef\uff01\u5e94\u4e3a\uff1a\uff08%s\u3001%s\uff09\u6216\uff08%s\u3001%s\uff09\uff01\u5b9e\u9645\u4e3a\uff1a\uff08%s\u3001%s\uff09", PaymentStatusEnum.PAYMENT_REQUIRED.getValue(), PaymentStatusEnum.PAYMENT_REQUIRED.getDesc(), PaymentStatusEnum.PAYMENT_PENDING.getValue(), PaymentStatusEnum.PAYMENT_PENDING.getDesc(), paymentStatus, paymentStatusLabel);
                ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)errorInfo);
            }
            this.checkRequiredField(dto);
            this.insertInfusionOfFluids(dto);
        }
        this.updatePrescInfusionFlag(tenantId, outpatientNo, prescNo, generateFlag);
    }

    private void updatePrescInfusionFlag(Integer tenantId, String outpatientNo, String prescNo, String generateFlag) {
        this.outPrescriptionMapper.update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(OutPrescription::getTenantId, (Object)tenantId)).eq(OutPrescription::getOutpatientNo, (Object)outpatientNo)).eq(OutPrescription::getPrescriptionNo, (Object)prescNo)).eq(OutPrescription::getPrescriptionStatus, (Object)PrescriptionStatusEnum.STATUS_NORMAL.getValue())).set(OutPrescription::getGenerateFlag, (Object)generateFlag));
    }

    private void checkRequiredField(SaveInfusionOfFluidsDto dto) {
        String prescNo = dto.getPrescriptionNo();
        List detailList = dto.getDetailList();
        if (detailList == null || detailList.isEmpty()) {
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)"\u751f\u6210\u8f93\u6db2\u5355\u65f6\uff0c\u5bf9\u5e94\u7684\u8f93\u6db2\u836f\u54c1\u5217\u8868\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        for (SaveInfusionOfFluidsDetailDto detailDto : detailList) {
            Integer medicationDays;
            String errorInfo;
            BigDecimal singleDose;
            String errorInfo2;
            String drugName;
            String drugId = detailDto.getDrugsId();
            if (StrUtil.isEmpty((CharSequence)drugId)) {
                ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)("\u751f\u6210\u8f93\u6db2\u5355\u65f6\uff0c\u836f\u54c1\u7f16\u53f7\u4e0d\u53ef\u4e3a\u7a7a\uff01\u5904\u65b9\u53f7\uff1a" + prescNo));
            }
            if (StrUtil.isEmpty((CharSequence)(drugName = detailDto.getDrugsName()))) {
                ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)("\u751f\u6210\u8f93\u6db2\u5355\u65f6\uff0c\u836f\u54c1\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a\uff01\u5904\u65b9\u53f7\uff1a" + prescNo));
            }
            if (detailDto.getGroupNo() == null) {
                errorInfo2 = String.format("\u751f\u6210\u8f93\u6db2\u5355\u65f6\uff0c\u7ec4\u53f7\u4e0d\u53ef\u4e3a\u7a7a\uff01\u836f\u54c1\u540d\u79f0\uff1a\uff08%s\u3001%s\uff09\uff01\u5904\u65b9\u53f7\uff1a%s", drugId, drugName, prescNo);
                ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)errorInfo2);
            }
            if (StrUtil.isEmpty((CharSequence)detailDto.getUsageCode())) {
                errorInfo2 = String.format("\u751f\u6210\u8f93\u6db2\u5355\u65f6\uff0c\u7528\u6cd5\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a\uff01\u836f\u54c1\u540d\u79f0\uff1a\uff08%s\u3001%s\uff09\uff01\u5904\u65b9\u53f7\uff1a%s", drugId, drugName, prescNo);
                ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)errorInfo2);
            }
            if ((singleDose = detailDto.getSingleDose()) == null || singleDose.compareTo(BigDecimal.ZERO) <= 0) {
                errorInfo = String.format("\u751f\u6210\u8f93\u6db2\u5355\u65f6\uff0c\u5355\u6b21\u5242\u91cf\u4e0d\u53ef\u4e3a\u7a7a\u6216\u4e3a0\uff01\u836f\u54c1\u540d\u79f0\uff1a\uff08%s\u3001%s\uff09\uff01\u5904\u65b9\u53f7\uff1a%s", drugId, drugName, prescNo);
                ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)errorInfo);
            }
            if (StrUtil.isEmpty((CharSequence)detailDto.getDoseUnitCode())) {
                errorInfo = String.format("\u751f\u6210\u8f93\u6db2\u5355\u65f6\uff0c\u5355\u6b21\u5242\u91cf\u5355\u4f4d\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a\uff01\u836f\u54c1\u540d\u79f0\uff1a\uff08%s\u3001%s\uff09\uff01\u5904\u65b9\u53f7\uff1a%s", drugId, drugName, prescNo);
                ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)errorInfo);
            }
            if (StrUtil.isEmpty((CharSequence)detailDto.getFrequencyCode())) {
                errorInfo = String.format("\u751f\u6210\u8f93\u6db2\u5355\u65f6\uff0c\u7528\u836f\u9891\u7387\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a\uff01\u836f\u54c1\u540d\u79f0\uff1a\uff08%s\u3001%s\uff09\uff01\u5904\u65b9\u53f7\uff1a%s", drugId, drugName, prescNo);
                ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)errorInfo);
            }
            if ((medicationDays = detailDto.getMedicationDays()) != null && medicationDays != 0) continue;
            String errorInfo3 = String.format("\u751f\u6210\u8f93\u6db2\u5355\u65f6\uff0c\u7528\u836f\u5929\u6570\u4e0d\u53ef\u4e3a\u7a7a\u6216\u4e3a0\uff01\u836f\u54c1\u540d\u79f0\uff1a\uff08%s\u3001%s\uff09\uff01\u5904\u65b9\u53f7\uff1a%s", drugId, drugName, prescNo);
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)errorInfo3);
        }
    }

    private void insertInfusionOfFluids(SaveInfusionOfFluidsDto dto) {
        Integer tenantId = dto.getTenantId();
        String prescNo = dto.getPrescriptionNo();
        Integer operatorId = dto.getOperatorId();
        String operatorName = dto.getOperatorName();
        Integer prescriptionTypeCode = dto.getPrescriptionType();
        if (!PrescriptionTypeEnum.WESTERN_MEDICINE.getValue().equals(prescriptionTypeCode)) {
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)("\u751f\u6210\u8f93\u6db2\u5355\u65f6\uff0c\u95e8\u8bca\u5904\u65b9\u7c7b\u578b\u7f16\u7801\u9519\u8bef\uff01\u5e94\u4e3a\uff1a1\u3001\u897f\u836f\uff0c\u5b9e\u9645\u4e3a\uff1a" + prescriptionTypeCode));
        }
        ArrayList<String> dictTypes = new ArrayList<String>(Arrays.asList("we_medicine_usage", "usage_unit", "we_medicine_frequency"));
        List dictValueVos = this.outHsSettlementInfoMapper.selectDictListByTypes(dictTypes, tenantId);
        Map dictDataMap = dictValueVos.stream().collect(Collectors.groupingBy(DictValueVo::getType, Collectors.toMap(DictValueVo::getValue, Function.identity(), (existing, replacement) -> existing)));
        List detailDtoList = dto.getDetailList();
        Map drugUsageMap = this.getDictMap(dictDataMap, "we_medicine_usage");
        Map doseUnitMap = this.getDictMap(dictDataMap, "usage_unit");
        Map frequencyMap = this.getDictMap(dictDataMap, "we_medicine_frequency");
        for (SaveInfusionOfFluidsDetailDto detail : detailDtoList) {
            String drugId = detail.getDrugsId();
            String drugName = detail.getDrugsName();
            String usageCode = detail.getUsageCode();
            DictValueVo drugUsageDictVo = (DictValueVo)drugUsageMap.get(usageCode);
            if (drugUsageDictVo == null) {
                String errorInfo = String.format("\u751f\u6210\u8f93\u6db2\u5355\u65f6\uff0c\u836f\u54c1\u7528\u6cd5\u7f16\u7801\u9519\u8bef\uff01\u836f\u54c1\u540d\u79f0\uff1a\uff08%s\u3001%s\uff09\uff0c\u5b57\u5178\u7f16\u7801\uff1awe_medicine_usage\uff01\u7f16\u7801\u503c\uff1a%s\uff01", drugId, drugName, usageCode);
                ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)errorInfo);
            }
            detail.setDrugUsage(drugUsageDictVo.getLabel());
            String doseUnitCode = detail.getDoseUnitCode();
            DictValueVo doseUnitDictVo = (DictValueVo)doseUnitMap.get(doseUnitCode);
            if (doseUnitDictVo == null) {
                String errorInfo = String.format("\u751f\u6210\u8f93\u6db2\u5355\u65f6\uff0c\u836f\u54c1\u5355\u6b21\u5242\u91cf\u5355\u4f4d\u7f16\u7801\u9519\u8bef\uff01\u836f\u54c1\u540d\u79f0\uff1a\uff08%s\u3001%s\uff09\uff0c\u5b57\u5178\u7f16\u7801\uff1ausage_unit\uff01\u7f16\u7801\u503c\uff1a%s\uff01", drugId, drugName, doseUnitCode);
                ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)errorInfo);
            }
            detail.setDoseUnit(doseUnitDictVo.getLabel());
            String frequencyCode = detail.getFrequencyCode();
            DictValueVo frequencyDictVo = (DictValueVo)frequencyMap.get(frequencyCode);
            if (frequencyDictVo == null) {
                String errorInfo = String.format("\u751f\u6210\u8f93\u6db2\u5355\u65f6\uff0c\u7528\u836f\u9891\u7387\u7f16\u7801\u9519\u8bef\uff01\u836f\u54c1\u540d\u79f0\uff1a\uff08%s\u3001%s\uff09\uff0c\u5b57\u5178\u7f16\u7801\uff1awe_medicine_frequency\uff01\u7f16\u7801\u503c\uff1a%s\uff01", drugId, drugName, frequencyCode);
                ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)errorInfo);
            }
            detail.setFrequencyName(frequencyDictVo.getLabel());
        }
        AdmissionEntity admission = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AdmissionEntity::getTenantId, (Object)tenantId)).eq(AdmissionEntity::getOutpatientNo, (Object)dto.getOutpatientNo()));
        if (admission == null) {
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)"\u751f\u6210\u8f93\u6db2\u5355\u65f6\uff0c\u6839\u636e\u95e8\u8bca\u53f7\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6302\u53f7\u8bb0\u5f55\uff01");
        }
        Integer admissionStatus = admission.getStatus();
        String outpatientNo = admission.getOutpatientNo();
        if (AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(admissionStatus) || AdmissionStatusEnum.DOCTOR_CANCEL.getValue().equals(admissionStatus) || AdmissionStatusEnum.PATIENT_CANCEL.getValue().equals(admissionStatus) || AdmissionStatusEnum.RETIRMENT.getValue().equals(admissionStatus)) {
            String admissionStatusLabel = Optional.ofNullable(AdmissionStatusEnum.getDesc((Integer)admissionStatus)).orElse("\u6302\u53f7\u72b6\u6001\u5f02\u5e38\uff01");
            String errorInfo = String.format("\u751f\u6210\u8f93\u6db2\u5355\u65f6\uff0c\u5bf9\u5e94\u7684\u6302\u53f7\u8bb0\u5f55\u72b6\u6001\u5f02\u5e38\uff01\u5b9e\u9645\u4e3a\uff1a\uff08%s\u3001%s\uff09\uff0c\u95e8\u8bca\u53f7\uff1a%s", admissionStatus, admissionStatusLabel, outpatientNo);
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)errorInfo);
        }
        Integer patientId = admission.getPatientId();
        String patientName = admission.getPatientName();
        Integer patientAge = admission.getPatientAge();
        String genderCode = admission.getPatientSex();
        String genderName = Optional.ofNullable(GenderEnum.getEnum((Integer)Integer.valueOf(genderCode))).map(GenderEnum::getDesc).orElse("");
        if (StrUtil.isEmpty((CharSequence)genderName)) {
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)("\u751f\u6210\u8f93\u6db2\u5355\u65f6\uff0c\u60a3\u8005\u6027\u522b\u7f16\u7801\u5f02\u5e38\uff01\u5e94\u4e3a\uff1a1\u3001\u7537\uff0c2\u3001\u5973\uff0c\u5b9e\u9645\u4e3a\uff1a" + genderCode));
        }
        Integer visitDeptId = admission.getDeptId();
        String visitDeptName = admission.getDeptName();
        Integer visitDoctorId = admission.getDoctorId();
        String visitDoctorName = admission.getDoctorName();
        ArrayList<OutInfusionOfFluidsEntity> infusionOfFluidsList = new ArrayList<OutInfusionOfFluidsEntity>();
        for (SaveInfusionOfFluidsDetailDto detail : detailDtoList) {
            OutInfusionOfFluidsEntity infusionOfFluids = new OutInfusionOfFluidsEntity();
            infusionOfFluids.setTenantId(tenantId);
            infusionOfFluids.setCreateId(operatorId);
            infusionOfFluids.setCreateName(operatorName);
            infusionOfFluids.setOutpatientNo(outpatientNo);
            infusionOfFluids.setPrescriptionNo(prescNo);
            infusionOfFluids.setGroupNo(detail.getGroupNo());
            infusionOfFluids.setDrugId(detail.getDrugsId());
            infusionOfFluids.setDrugName(detail.getDrugsName());
            infusionOfFluids.setDrugSpec(detail.getSpecifications());
            infusionOfFluids.setSingleDose(detail.getSingleDose());
            infusionOfFluids.setDoseUnitCode(detail.getDoseUnitCode());
            infusionOfFluids.setDoseUnitName(detail.getDoseUnit());
            infusionOfFluids.setUsageCode(detail.getUsageCode());
            infusionOfFluids.setUsageName(detail.getDrugUsage());
            infusionOfFluids.setDrippingVelocity(detail.getDrippingVelocity());
            infusionOfFluids.setPatientId(patientId);
            infusionOfFluids.setPatientName(patientName);
            infusionOfFluids.setPatientAge(patientAge);
            infusionOfFluids.setGenderCode(genderCode);
            infusionOfFluids.setGenderName(genderName);
            infusionOfFluids.setVisitDeptId(visitDeptId);
            infusionOfFluids.setVisitDeptName(visitDeptName);
            infusionOfFluids.setVisitDoctorId(visitDoctorId);
            infusionOfFluids.setVisitDoctorName(visitDoctorName);
            String frequencyCode = detail.getFrequencyCode();
            String frequencyName = detail.getFrequencyName();
            Integer medicationDays = detail.getMedicationDays();
            DictValueVo frequencyDictVo = (DictValueVo)frequencyMap.get(frequencyCode);
            String frequencyConvertStr = frequencyDictVo.getDescription();
            if (StrUtil.isEmpty((CharSequence)frequencyConvertStr)) {
                ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)("\u751f\u6210\u8f93\u6db2\u5355\u65f6\uff0c\u7528\u836f\u9891\u7387\u8f6c\u6362\u7cfb\u6570\u5f02\u5e38\uff01\u8bf7\u5148\u8fdb\u884c\u7ef4\u62a4\uff01\u5b57\u5178\uff1awe_medicine_frequency\uff01\u7f16\u7801\u503c\uff1a" + frequencyCode));
            }
            BigDecimal frequencyConvert = new BigDecimal(frequencyConvertStr);
            Integer totalExecCount = frequencyConvert.multiply(BigDecimal.valueOf(medicationDays.intValue())).setScale(0, RoundingMode.CEILING).intValue();
            infusionOfFluids.setFrequencyCode(frequencyCode);
            infusionOfFluids.setFrequencyName(frequencyName);
            infusionOfFluids.setMedicationDays(medicationDays);
            infusionOfFluids.setTotalExecCount(totalExecCount);
            infusionOfFluids.setFrequencyConvert(frequencyConvert);
            infusionOfFluids.setStatus(OutInfusionStatusEnum.READY_INFUSION.getValue());
            for (int i = 0; i < totalExecCount; ++i) {
                OutInfusionOfFluidsEntity newInfusionOfFluids = new OutInfusionOfFluidsEntity();
                BeanUtils.copyProperties((Object)infusionOfFluids, (Object)newInfusionOfFluids);
                newInfusionOfFluids.setExecCount(Integer.valueOf(i + 1));
                infusionOfFluidsList.add(newInfusionOfFluids);
            }
        }
        this.outInfusionOfFluidsMapper.insertList(infusionOfFluidsList);
        List groupNos = detailDtoList.stream().map(SaveInfusionOfFluidsDetailDto::getGroupNo).distinct().collect(Collectors.toList());
        ArrayList<OutInfusionOfFluidsRecordEntity> recordList = new ArrayList<OutInfusionOfFluidsRecordEntity>();
        for (Integer groupNo : groupNos) {
            OutInfusionOfFluidsRecordEntity record = new OutInfusionOfFluidsRecordEntity();
            record.setTenantId(tenantId);
            record.setCreateId(operatorId);
            record.setCreateName(operatorName);
            record.setPrescriptionNo(prescNo);
            record.setGroupNo(groupNo);
            record.setOperationCode(OutInfusionOperateCodeEnum.GENERATE.getValue());
            record.setOperationName(OutInfusionOperateCodeEnum.GENERATE.getLabel());
            recordList.add(record);
        }
        this.outInfusionOfFluidsRecordMapper.insertList(recordList);
    }

    private Map<String, DictValueVo> getDictMap(Map<String, Map<String, DictValueVo>> dictDataMap, String type) {
        Map<String, DictValueVo> dictMap;
        if (StrUtil.isEmpty((CharSequence)type)) {
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)"\u67e5\u8be2\u5b57\u5178\u5217\u8868\u65f6\uff0c\u4f20\u9012\u7684\u5b57\u5178\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if ((dictMap = dictDataMap.get(type)) == null) {
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)("\u67e5\u8be2\u5b57\u5178\u5217\u8868\u4fe1\u606f\u65f6\uff0c\u6839\u636e\u5b57\u5178\u7c7b\u578b\u6ca1\u6709\u67e5\u627e\u5230\u5bf9\u5e94\u7684\u5b57\u5178\u660e\u7ec6\u5217\u8868\uff0c\u8bf7\u5148\u8fdb\u884c\u7ef4\u62a4\uff01\u5b57\u5178\u7c7b\u578b\uff1a" + type));
        }
        return dictMap;
    }
}

