/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.outpatient.api.dto.ArchivalFileDto;
import com.byh.outpatient.api.dto.FirstPaymentDto;
import com.byh.outpatient.api.dto.medicalRecord.PatientInfoDto;
import com.byh.outpatient.api.dto.patient.CheckCardNoCorrectnessDto;
import com.byh.outpatient.api.dto.patient.ExportPatientDto;
import com.byh.outpatient.api.dto.patient.HsPatientInfoDto;
import com.byh.outpatient.api.dto.patient.PatientNameDto;
import com.byh.outpatient.api.dto.patient.QueryPatientDto;
import com.byh.outpatient.api.enums.MedTypeEnum;
import com.byh.outpatient.api.enums.MedicalInsuranceTypeEnum;
import com.byh.outpatient.api.enums.OutMedicalRecordTypeEnum;
import com.byh.outpatient.api.enums.OutpatientDataStatusEnum;
import com.byh.outpatient.api.enums.ProvInsuplcAdmdvsEnum;
import com.byh.outpatient.api.excel.CustomMergeStrategy;
import com.byh.outpatient.api.hsModel.BaseinfoEntity;
import com.byh.outpatient.api.hsModel.request.ChronicDiseaseRequest;
import com.byh.outpatient.api.hsModel.request.PatientInfoRequest;
import com.byh.outpatient.api.hsModel.respones.HsBaseResponse;
import com.byh.outpatient.api.hsModel.respones.HsPatientInfoResponse;
import com.byh.outpatient.api.hsModel.respones.Insuinfo;
import com.byh.outpatient.api.model.ArchivalFileEntity;
import com.byh.outpatient.api.model.ArchivalRecordsEntity;
import com.byh.outpatient.api.model.OutEtubePatientDossierEntity;
import com.byh.outpatient.api.model.OutEtubePatientInfoEntity;
import com.byh.outpatient.api.model.admission.AdmissionEntity;
import com.byh.outpatient.api.model.hsSettlement.HsSettlementInfoNewEntity;
import com.byh.outpatient.api.model.medicalRecord.OutMedicalRecord;
import com.byh.outpatient.api.model.medicalRecord.OutPatientHealthRecord;
import com.byh.outpatient.api.model.patient.PatientEntity;
import com.byh.outpatient.api.model.patient.PatientFamilyEntity;
import com.byh.outpatient.api.model.prescription.OutPrescription;
import com.byh.outpatient.api.model.prescription.OutPrescriptionDrug;
import com.byh.outpatient.api.sysModel.request.SysDoctorDto;
import com.byh.outpatient.api.sysModel.respones.SysDoctorIdVo;
import com.byh.outpatient.api.util.DateUtils;
import com.byh.outpatient.api.util.EasyExcelUtil;
import com.byh.outpatient.api.util.ExceptionUtils;
import com.byh.outpatient.api.util.HyposensitizationUtil;
import com.byh.outpatient.api.util.PageResult;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.RestTemplateUtils;
import com.byh.outpatient.api.util.StringPinyinUtil;
import com.byh.outpatient.api.util.StringUtil;
import com.byh.outpatient.api.util.UUIDUtils;
import com.byh.outpatient.api.vo.ArchivalFileTypeVo;
import com.byh.outpatient.api.vo.ArchivalRecordsVo;
import com.byh.outpatient.api.vo.admission.AdmissionWithDiagVo;
import com.byh.outpatient.api.vo.patient.CheckCardNoCorrectnessVo;
import com.byh.outpatient.api.vo.patient.ExportPatientInfo;
import com.byh.outpatient.api.vo.patient.ExportPatientInfoVo;
import com.byh.outpatient.api.vo.patient.ExportPatientVo;
import com.byh.outpatient.api.vo.patient.HsPatientInfoVo;
import com.byh.outpatient.data.repository.AdmissionMapper;
import com.byh.outpatient.data.repository.ArchivalFileMapper;
import com.byh.outpatient.data.repository.ArchivalRecordsMapper;
import com.byh.outpatient.data.repository.OutCheckoutPaymentRecordsMapper;
import com.byh.outpatient.data.repository.OutCustomerServiceSettingsMapper;
import com.byh.outpatient.data.repository.OutDrugSellMapper;
import com.byh.outpatient.data.repository.OutEtubePatientDossierMapper;
import com.byh.outpatient.data.repository.OutEtubePatientInfoMapper;
import com.byh.outpatient.data.repository.OutEtubeStudioPatientMapper;
import com.byh.outpatient.data.repository.OutFollowUpTasksMapper;
import com.byh.outpatient.data.repository.OutHsSettlementInfoMapper;
import com.byh.outpatient.data.repository.OutHsSettlementInfoNewMapper;
import com.byh.outpatient.data.repository.OutLisResultMapper;
import com.byh.outpatient.data.repository.OutMedicalRecordDiagnosisMapper;
import com.byh.outpatient.data.repository.OutMedicalRecordMapper;
import com.byh.outpatient.data.repository.OutOrderMapper;
import com.byh.outpatient.data.repository.OutOrderPaymentMapper;
import com.byh.outpatient.data.repository.OutPatientHealthRecordMapper;
import com.byh.outpatient.data.repository.OutPatientRecordTempMapper;
import com.byh.outpatient.data.repository.OutPendingAccountRecordsMapper;
import com.byh.outpatient.data.repository.OutPrescriptionDrugMapper;
import com.byh.outpatient.data.repository.OutPrescriptionMapper;
import com.byh.outpatient.data.repository.PatientFamilyMapper;
import com.byh.outpatient.data.repository.PatientMapper;
import com.byh.outpatient.data.repository.ReservationMapper;
import com.byh.outpatient.web.feign.HsServiceFeign;
import com.byh.outpatient.web.feign.SysServiceFeign;
import com.byh.outpatient.web.mvc.config.NodeConfig;
import com.byh.outpatient.web.mvc.controller.RocketMQProducerController;
import com.byh.outpatient.web.rocket.RocketMQProducer;
import com.byh.outpatient.web.service.ArchivalFileService;
import com.byh.outpatient.web.service.ArchivalRecordsService;
import com.byh.outpatient.web.service.ExpertStudioService;
import com.byh.outpatient.web.service.PatientService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.rocketmq.client.producer.SendCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class PatientServiceImpl
implements PatientService {
    private static final Logger log = LoggerFactory.getLogger(PatientServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(RocketMQProducerController.class);
    private static final String topic = "rocketMQ-out-doctor";
    private static final String patientTopic = "rocketMQ-out-patientTopic";
    private static final String patientPaymentTopic = "rocketMQ-out-patientPaymentTopic";
    private static final String prescriptionDetailTopic = "rocketMQ-out-prescriptionDetailTopic";
    private static final String treatmentItemsTopic = "rocketMQ-out-treatmentItemsTopic";
    @Resource
    private RocketMQProducer rocketMQProducer;
    @Autowired
    private ExpertStudioService expertStudioService;
    @Autowired
    private OutEtubePatientDossierMapper outEtubePatientDossierMapper;
    @Resource
    private OutEtubePatientInfoMapper outEtubePatientInfoMapper;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private PatientFamilyMapper patientFamilyMapper;
    @Autowired
    private NodeConfig nodeConfig;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Resource
    private OutPrescriptionMapper outPrescriptionMapper;
    @Resource
    private OutPrescriptionDrugMapper outPrescriptionDrugMapper;
    @Autowired
    private ArchivalFileMapper archivalFileMapper;
    @Resource
    private OutHsSettlementInfoMapper outHsSettlementInfoMapper;
    @Resource
    private OutHsSettlementInfoNewMapper outHsSettlementInfoNewMapper;
    @Autowired
    private HsServiceFeign hsServiceFeign;
    @Autowired
    private SysServiceFeign sysServiceFeign;
    @Resource
    private ArchivalRecordsMapper archivalRecordsMapper;
    @Resource
    private OutCheckoutPaymentRecordsMapper outCheckoutPaymentRecordsMapper;
    @Resource
    private OutCustomerServiceSettingsMapper outCustomerServiceSettingsMapper;
    @Resource
    private OutDrugSellMapper outDrugSellMapper;
    @Resource
    private OutEtubeStudioPatientMapper outEtubeStudioPatientMapper;
    @Resource
    private OutFollowUpTasksMapper outFollowUpTasksMapper;
    @Resource
    private OutLisResultMapper outLisResultMapper;
    @Resource
    private OutMedicalRecordMapper outMedicalRecordMapper;
    @Resource
    private OutMedicalRecordDiagnosisMapper outMedicalRecordDiagnosisMapper;
    @Resource
    private OutOrderMapper outOrderMapper;
    @Resource
    private OutOrderPaymentMapper outOrderPaymentMapper;
    @Resource
    private OutPatientHealthRecordMapper outPatientHealthRecordMapper;
    @Autowired
    private ArchivalRecordsService archivalRecordsService;
    @Autowired
    private ArchivalFileService archivalFileService;
    @Resource
    private OutPatientRecordTempMapper outPatientRecordTempMapper;
    @Resource
    private OutPendingAccountRecordsMapper outPendingAccountRecordsMapper;
    @Resource
    private ReservationMapper reservationMapper;

    public CheckCardNoCorrectnessVo checkCardNoCorrectness(CheckCardNoCorrectnessDto dto) {
        String url = "https://data-center.scrmzk.com/pr-api/twoElements/idCert";
        String checkName = dto.getName();
        String checkCardNo = dto.getCardNo();
        if (StrUtil.isEmpty((CharSequence)checkName)) {
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)"\u6821\u9a8c\u8bc1\u4ef6\u53f7\u7801\u65f6\uff0c\u59d3\u540d\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isEmpty((CharSequence)checkCardNo)) {
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)"\u6821\u9a8c\u8bc1\u4ef6\u53f7\u7801\u65f6\uff0c\u8bc1\u4ef6\u53f7\u7801\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("userName", (Object)checkName);
        jsonObject.put("idCard", (Object)checkCardNo);
        String responseStr = RestTemplateUtils.submitPost((Map)jsonObject, (String)url);
        JSONObject dataObject = Optional.ofNullable(responseStr).map(JSON::parseObject).map(response -> response.getString("body")).map(JSON::parseObject).map(body -> body.getString("data")).map(JSON::parseObject).orElse(null);
        if (dataObject == null) {
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)"\u8c03\u7528\u6821\u9a8c\u8bc1\u4ef6\u53f7\u7801\u63a5\u53e3\u51fa\u9519\uff01");
        }
        Map<String, String> fields = Stream.of("name", "idCard", "birthday", "sex", "province", "city", "prefecture", "area", "status", "msg").collect(Collectors.toMap(key -> key, key -> Optional.ofNullable(dataObject.get(key)).map(Object::toString).orElse("")));
        String name = fields.get("name");
        String idCard = fields.get("idCard");
        String birthday = fields.get("birthday");
        String sex = fields.get("sex");
        String province = fields.get("province");
        String city = fields.get("city");
        String prefecture = fields.get("prefecture");
        String area = fields.get("area");
        String status = fields.get("status");
        String msg = fields.get("msg");
        CheckCardNoCorrectnessVo vo = new CheckCardNoCorrectnessVo();
        vo.setName(name);
        vo.setCardNo(idCard);
        vo.setBirthday(birthday);
        vo.setSex(sex);
        vo.setProvince(province);
        vo.setCity(city);
        vo.setPrefecture(prefecture);
        vo.setArea(area);
        vo.setStatusCode(status);
        vo.setMessage(msg);
        return vo;
    }

    public void exportPatientInfoList(HttpServletResponse response, ExportPatientDto dto) {
        List list = this.patientMapper.exportPatientInfoList(dto);
        EasyExcelUtil.exportExcelSheet((HttpServletResponse)response, (String)"\u60a3\u8005\u6863\u6848", (String)"\u60a3\u8005\u6863\u6848", (Object)new ExportPatientInfoVo(), (List)list, null);
    }

    public void exportRandomPatientInfoList(HttpServletResponse response) {
        List exportPatientList = this.patientMapper.selectExportPatientList();
        if (!exportPatientList.isEmpty()) {
            List patientIds = exportPatientList.stream().map(ExportPatientVo::getId).distinct().collect(Collectors.toList());
            List admissionWithDiagVos = this.admissionMapper.selectListByPatientId(patientIds);
            Map<Integer, List<AdmissionWithDiagVo>> admissionWithDiagMap = admissionWithDiagVos.stream().collect(Collectors.groupingBy(AdmissionWithDiagVo::getPatientId));
            for (ExportPatientVo vo : exportPatientList) {
                List admissionWithDiags = Optional.ofNullable(admissionWithDiagMap.get(vo.getId())).orElse(new ArrayList());
                vo.setAdmissionWithDiagList(admissionWithDiags);
            }
            List outpatientNos = admissionWithDiagVos.stream().map(AdmissionWithDiagVo::getOutpatientNo).distinct().filter(Objects::nonNull).collect(Collectors.toList());
            LambdaQueryWrapper outPrescQuery = Wrappers.lambdaQuery();
            outPrescQuery.eq(OutPrescription::getPrescriptionStatus, (Object)"1");
            outPrescQuery.in(OutPrescription::getOutpatientNo, outpatientNos);
            List outPrescriptionList = this.outPrescriptionMapper.selectList((Wrapper)outPrescQuery);
            List prescNos = outPrescriptionList.stream().map(OutPrescription::getPrescriptionNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            LambdaQueryWrapper outPrescDrugQuery = Wrappers.lambdaQuery();
            outPrescDrugQuery.eq(OutPrescriptionDrug::getStatus, (Object)"1");
            outPrescDrugQuery.in(OutPrescriptionDrug::getPrescriptionNo, prescNos);
            List outPrescriptionDrugList = this.outPrescriptionDrugMapper.selectList((Wrapper)outPrescDrugQuery);
            Map<String, List<OutPrescriptionDrug>> outPrescDrugMap = outPrescriptionDrugList.stream().collect(Collectors.groupingBy(OutPrescriptionDrug::getPrescriptionNo));
            for (Object outPrescription : outPrescriptionList) {
                List outPrescriptionDrugs = Optional.ofNullable(outPrescDrugMap.get(outPrescription.getPrescriptionNo())).orElse(new ArrayList());
                outPrescription.setOutPrescriptionDrugList(outPrescriptionDrugs);
            }
            Map<String, List<OutPrescription>> outPrescriptionMap = outPrescriptionList.stream().collect(Collectors.groupingBy(OutPrescription::getOutpatientNo));
            for (Object exportPatientVo : exportPatientList) {
                StringBuilder cardNoBuilder = new StringBuilder(exportPatientVo.getCardNo());
                for (int i = 4; i < exportPatientVo.getCardNo().length() - 4; ++i) {
                    cardNoBuilder.setCharAt(i, '*');
                }
                exportPatientVo.setCardNo(cardNoBuilder.toString());
                if (StrUtil.isNotEmpty((CharSequence)exportPatientVo.getPhone())) {
                    StringBuilder phoneBuilder = new StringBuilder(exportPatientVo.getPhone());
                    for (int i = 3; i < exportPatientVo.getPhone().length() - 4; ++i) {
                        phoneBuilder.setCharAt(i, '*');
                    }
                    exportPatientVo.setPhone(phoneBuilder.toString());
                }
                for (AdmissionWithDiagVo vo : exportPatientVo.getAdmissionWithDiagList()) {
                    List outPrescriptions = Optional.ofNullable(outPrescriptionMap.get(vo.getOutpatientNo())).orElse(new ArrayList());
                    vo.setOutPrescriptionList(outPrescriptions);
                }
            }
            ArrayList<ExportPatientInfo> exportPatientInfoList = new ArrayList<ExportPatientInfo>();
            for (ExportPatientVo exportPatientVo : exportPatientList) {
                for (AdmissionWithDiagVo admissionWithDiagVo : exportPatientVo.getAdmissionWithDiagList()) {
                    for (OutPrescription outPrescription : admissionWithDiagVo.getOutPrescriptionList()) {
                        for (OutPrescriptionDrug outPrescriptionDrug : outPrescription.getOutPrescriptionDrugList()) {
                            ExportPatientInfo exportPatientInfo = new ExportPatientInfo();
                            exportPatientInfo.setId(exportPatientVo.getId());
                            exportPatientInfo.setName(exportPatientVo.getName());
                            exportPatientInfo.setSex(exportPatientVo.getSex());
                            exportPatientInfo.setCardNo(exportPatientVo.getCardNo());
                            exportPatientInfo.setAge(exportPatientVo.getAge());
                            exportPatientInfo.setPhone(exportPatientVo.getPhone());
                            exportPatientInfo.setChronicDiseaseCode(exportPatientVo.getChronicDiseaseCode());
                            exportPatientInfo.setChronicDisease(exportPatientVo.getChronicDisease());
                            exportPatientInfo.setOutpatientNo(admissionWithDiagVo.getOutpatientNo());
                            exportPatientInfo.setDeptName(admissionWithDiagVo.getDeptName());
                            exportPatientInfo.setDoctorName(admissionWithDiagVo.getDoctorName());
                            exportPatientInfo.setVisitTime(admissionWithDiagVo.getVisitTime());
                            exportPatientInfo.setIcdCode(admissionWithDiagVo.getIcdCode());
                            exportPatientInfo.setDiagnosis(admissionWithDiagVo.getDiagnosis());
                            exportPatientInfo.setChiefComplaint(admissionWithDiagVo.getChiefComplaint());
                            exportPatientInfo.setPresentMedicalHistory(admissionWithDiagVo.getPresentMedicalHistory());
                            exportPatientInfo.setAllergyGHistoryText(admissionWithDiagVo.getAllergyHistoryText());
                            exportPatientInfo.setMedicalHistory(admissionWithDiagVo.getMedicalHistory());
                            exportPatientInfo.setPhysicalExam(admissionWithDiagVo.getPhysicalExam());
                            exportPatientInfo.setAuxiliaryInpsection(admissionWithDiagVo.getAuxiliaryInspection());
                            exportPatientInfo.setHandleOpinion(admissionWithDiagVo.getHandleOpinion());
                            exportPatientInfo.setDrugName(outPrescriptionDrug.getDrugName());
                            exportPatientInfo.setSpecification(outPrescriptionDrug.getSpecification());
                            exportPatientInfo.setDrugUsage(outPrescriptionDrug.getDrugUsage());
                            exportPatientInfo.setDoseUnit(outPrescriptionDrug.getDoseUnit());
                            exportPatientInfo.setFrequency(outPrescriptionDrug.getFrequency());
                            exportPatientInfo.setMedicationDays(outPrescriptionDrug.getMedicationDays());
                            exportPatientInfo.setQuantity(outPrescriptionDrug.getQuantity());
                            exportPatientInfo.setQuantityUnit(outPrescriptionDrug.getQuantityUnit());
                            exportPatientInfoList.add(exportPatientInfo);
                        }
                    }
                }
            }
            try (ServletOutputStream out = response.getOutputStream();){
                response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                response.setCharacterEncoding("utf-8");
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2");
                String format = LocalDateTime.now(ZoneOffset.ofHours(8)).format(dateTimeFormatter);
                String fileName = URLEncoder.encode("\u60a3\u8005\u5c31\u8bca\u4fe1\u606f" + format, "UTF-8").replaceAll("\\+", "%20");
                response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
                ExcelWriter excelWriter = EasyExcelFactory.write((OutputStream)out).build();
                Object object = null;
                try {
                    WriteSheet writeSheet = ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)EasyExcelFactory.writerSheet((Integer)0, (String)"\u60a3\u8005\u5c31\u8bca\u4fe1\u606f").head(ExportPatientInfo.class)).registerWriteHandler((WriteHandler)new CustomMergeStrategy(Integer.valueOf(exportPatientInfoList.size()), new int[]{0}))).registerWriteHandler((WriteHandler)new CustomMergeStrategy(Integer.valueOf(exportPatientInfoList.size()), new int[]{1}))).registerWriteHandler((WriteHandler)new CustomMergeStrategy(Integer.valueOf(exportPatientInfoList.size()), new int[]{2}))).registerWriteHandler((WriteHandler)new CustomMergeStrategy(Integer.valueOf(exportPatientInfoList.size()), new int[]{3}))).registerWriteHandler((WriteHandler)new CustomMergeStrategy(Integer.valueOf(exportPatientInfoList.size()), new int[]{4}))).registerWriteHandler((WriteHandler)new CustomMergeStrategy(Integer.valueOf(exportPatientInfoList.size()), new int[]{5}))).registerWriteHandler((WriteHandler)new CustomMergeStrategy(Integer.valueOf(exportPatientInfoList.size()), new int[]{6}))).registerWriteHandler((WriteHandler)new CustomMergeStrategy(Integer.valueOf(exportPatientInfoList.size()), new int[]{7}))).registerWriteHandler((WriteHandler)new CustomMergeStrategy(Integer.valueOf(exportPatientInfoList.size()), new int[]{8}))).registerWriteHandler((WriteHandler)new CustomMergeStrategy(Integer.valueOf(exportPatientInfoList.size()), new int[]{9}))).registerWriteHandler((WriteHandler)new CustomMergeStrategy(Integer.valueOf(exportPatientInfoList.size()), new int[]{10}))).registerWriteHandler((WriteHandler)new CustomMergeStrategy(Integer.valueOf(exportPatientInfoList.size()), new int[]{11}))).registerWriteHandler((WriteHandler)new CustomMergeStrategy(Integer.valueOf(exportPatientInfoList.size()), new int[]{12}))).registerWriteHandler((WriteHandler)new CustomMergeStrategy(Integer.valueOf(exportPatientInfoList.size()), new int[]{13}))).registerWriteHandler((WriteHandler)new CustomMergeStrategy(Integer.valueOf(exportPatientInfoList.size()), new int[]{14}))).registerWriteHandler((WriteHandler)new CustomMergeStrategy(Integer.valueOf(exportPatientInfoList.size()), new int[]{15}))).registerWriteHandler((WriteHandler)new CustomMergeStrategy(Integer.valueOf(exportPatientInfoList.size()), new int[]{16}))).registerWriteHandler((WriteHandler)new CustomMergeStrategy(Integer.valueOf(exportPatientInfoList.size()), new int[]{17}))).registerWriteHandler((WriteHandler)new CustomMergeStrategy(Integer.valueOf(exportPatientInfoList.size()), new int[]{18}))).registerWriteHandler((WriteHandler)new CustomMergeStrategy(Integer.valueOf(exportPatientInfoList.size()), new int[]{19}))).registerWriteHandler((WriteHandler)new CustomMergeStrategy(Integer.valueOf(exportPatientInfoList.size()), new int[]{20}))).build();
                    excelWriter.write(exportPatientInfoList, writeSheet);
                    out.flush();
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (excelWriter != null) {
                        if (object != null) {
                            try {
                                excelWriter.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            excelWriter.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public ResponseData insert(PatientEntity patient) {
        if (patient == null) {
            return ResponseData.error((String)"\u5fc5\u8981\u53c2\u6570\u7f3a\u5931");
        }
        CheckCardNoCorrectnessDto dto = new CheckCardNoCorrectnessDto();
        dto.setName(patient.getName());
        dto.setCardNo(patient.getCardNo());
        CheckCardNoCorrectnessVo vo = this.checkCardNoCorrectness(dto);
        if (!"01".equals(vo.getStatusCode())) {
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)vo.getMessage());
        }
        List patientFamilyList = patient.getPatientFamilyList();
        PatientEntity patientEntities = null;
        if (!Objects.isNull(patient.getCardNo())) {
            patientEntities = this.patientMapper.queryPatientByCardNoAndTenantId(patient.getCardNo(), patient.getTenantId());
        }
        if (Objects.isNull(patientEntities)) {
            patient.setMedicalRecordNo(this.generateMedicalRecordNo(patient.getTenantId(), this.patientMapper.queryMaxMedicalNo(patient.getTenantId())));
            patient.setNamePinyin(StringPinyinUtil.toFirstChar((String)patient.getName()));
            this.patientMapper.insert((Object)patient);
        } else {
            patient.setId(patientEntities.getId());
            BeanUtils.copyProperties((Object)patient, (Object)patientEntities);
            this.patientMapper.updateById((Object)patientEntities);
        }
        if (!Objects.isNull(patientFamilyList)) {
            for (PatientFamilyEntity patientFamilyEntity : patientFamilyList) {
                patientFamilyEntity.setPatientId(patient.getId());
                patientFamilyEntity.setTenantId(patient.getTenantId());
                this.patientFamilyMapper.insert((Object)patientFamilyEntity);
            }
        }
        String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
        ArrayList<PatientEntity> westernMedicinePrescriptionsVos1 = new ArrayList<PatientEntity>();
        westernMedicinePrescriptionsVos1.add(patient);
        String msg = JSONObject.toJSONString(westernMedicinePrescriptionsVos1);
        this.rocketMQProducer.asyncSendCallbackTimeoutLevel(patientTopic, "TAG3", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
        return ResponseData.success((Object)patient.getId());
    }

    public ResponseData insertPatientDetail(PatientInfoDto patientInfoDto) {
        int size;
        PatientEntity patient = new PatientEntity();
        BeanUtils.copyProperties((Object)patientInfoDto, (Object)patient);
        CheckCardNoCorrectnessDto dto = new CheckCardNoCorrectnessDto();
        dto.setName(patient.getName());
        dto.setCardNo(patient.getCardNo());
        CheckCardNoCorrectnessVo vo = this.checkCardNoCorrectness(dto);
        if (!"01".equals(vo.getStatusCode())) {
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)vo.getMessage());
        }
        if (patient == null) {
            return ResponseData.error((String)"\u5fc5\u8981\u53c2\u6570\u7f3a\u5931");
        }
        List patientFamilyList = patient.getPatientFamilyList();
        PatientEntity patientEntities = null;
        if (!Objects.isNull(patient.getCardNo())) {
            patientEntities = this.patientMapper.queryPatientByCardNoAndTenantId(patient.getCardNo(), patient.getTenantId());
        }
        if (Objects.isNull(patientEntities)) {
            patient.setMedicalRecordNo(this.generateMedicalRecordNo(patient.getTenantId(), this.patientMapper.queryMaxMedicalNo(patient.getTenantId())));
            patient.setNamePinyin(StringPinyinUtil.toFirstChar((String)patient.getName()));
            this.patientMapper.insert((Object)patient);
        } else {
            patient.setId(patientEntities.getId());
            BeanUtils.copyProperties((Object)patient, (Object)patientEntities);
            this.patientMapper.updateById((Object)patientEntities);
        }
        if (!Objects.isNull(patientFamilyList)) {
            for (PatientFamilyEntity patientFamilyEntity : patientFamilyList) {
                patientFamilyEntity.setPatientId(patient.getId());
                patientFamilyEntity.setTenantId(patient.getTenantId());
                this.patientFamilyMapper.insert((Object)patientFamilyEntity);
            }
        }
        log.info("\u66f4\u65b0\u60a3\u8005\u5065\u5eb7\u6863\u6848-PatientId:{}", (Object)patient.getId());
        if (ObjectUtils.isEmpty((Object)patient) || patient.getId() == null || patient.getTenantId() == null) {
            return ResponseData.error((String)"\u66f4\u65b0\u60a3\u8005\u5065\u5eb7\u6863\u6848\u5931\u8d25\uff01\u60a3\u8005ID\u548c\u79df\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"tenant_id", (Object)patient.getTenantId());
        queryWrapper.eq((Object)"patient_id", (Object)patient.getId());
        OutPatientHealthRecord patientHealthRecord = (OutPatientHealthRecord)this.outPatientHealthRecordMapper.selectOne((Wrapper)queryWrapper);
        OutPatientHealthRecord outPatientHealthRecord = new OutPatientHealthRecord();
        BeanUtils.copyProperties((Object)patientInfoDto, (Object)outPatientHealthRecord);
        outPatientHealthRecord.setPatientId(patient.getId());
        outPatientHealthRecord.setPatientName(patient.getName());
        outPatientHealthRecord.setPatientCardNo(patient.getCardNo());
        outPatientHealthRecord.setMedicalRecordNo(patient.getMedicalRecordNo());
        if (patientHealthRecord == null) {
            outPatientHealthRecord.setCreateId(patientInfoDto.getUserId());
            outPatientHealthRecord.setCreateTime(new Date());
            outPatientHealthRecord.setCreateName(patientInfoDto.getUserName());
            size = this.outPatientHealthRecordMapper.insert((Object)outPatientHealthRecord);
            log.info("\u60a3\u8005\u65b0\u589e\u5065\u5eb7\u6863\u6848\u7ed3\u675f-\u66f4\u65b0\u6570\u91cf:{}-PatientId:{}", (Object)size, (Object)patient.getId());
        } else {
            outPatientHealthRecord.setId(patientHealthRecord.getId());
            outPatientHealthRecord.setUpdateId(patientInfoDto.getUserId());
            outPatientHealthRecord.setUpdateTime(new Date());
            outPatientHealthRecord.setUpdateName(patientInfoDto.getUserName());
            outPatientHealthRecord.setUpdateId(patientHealthRecord.getId());
            size = this.outPatientHealthRecordMapper.updateById((Object)outPatientHealthRecord);
            log.info("\u60a3\u8005\u4fee\u6539\u5065\u5eb7\u6863\u6848\u7ed3\u675f-\u66f4\u65b0\u6570\u91cf:{}-PatientId:{}", (Object)size, (Object)patient.getId());
        }
        PatientEntity patientEntity = this.patientMapper.queryById(patient.getId().intValue());
        if (patientEntity == null) {
            return ResponseData.error((String)"\u627e\u4e0d\u5230\u60a3\u8005\uff01");
        }
        OutMedicalRecord outMedicalRecord = new OutMedicalRecord();
        BeanUtils.copyProperties((Object)patientInfoDto, (Object)outMedicalRecord);
        outMedicalRecord.setSourceHospital("");
        outMedicalRecord.setPatientId(patientEntity.getId());
        outMedicalRecord.setPatientCardNo(patientEntity.getCardNo());
        outMedicalRecord.setPatientName(patientEntity.getName());
        outMedicalRecord.setMedicalRecordNo(patientEntity.getMedicalRecordNo());
        outMedicalRecord.setCreateId(patientInfoDto.getUserId());
        outMedicalRecord.setCreateName(patientInfoDto.getUserName());
        outMedicalRecord.setStatus(OutpatientDataStatusEnum.NORMAL.getStringValue());
        outMedicalRecord.setType(OutMedicalRecordTypeEnum.DISEASE_COURSE.getValue());
        outMedicalRecord.setRecordType("4");
        outMedicalRecord.setRecordContent("\u5c0f\u7a0b\u5e8f\u5efa\u6863\u63d2\u5165");
        int size2 = this.outMedicalRecordMapper.insert((Object)outMedicalRecord);
        String imgUrls = patientInfoDto.getImgUrls();
        if (StringUtil.isNotBlank((String)imgUrls)) {
            ArchivalRecordsEntity entity = new ArchivalRecordsEntity();
            entity.setPatientId(patient.getId());
            entity.setVisitingHospital("\u60a3\u8005\u5efa\u6863");
            entity.setTenantId(patient.getTenantId());
            ResponseData responseData = this.archivalRecordsService.pageList(entity);
            Long checkTypeId = null;
            for (ArchivalRecordsVo datum : (List)responseData.getData()) {
                String visitingHospital = datum.getVisitingHospital();
                if (!visitingHospital.equals("\u60a3\u8005\u5efa\u6863")) continue;
                for (ArchivalFileTypeVo fileType : datum.getFileTypes()) {
                    Long id;
                    String typeName = fileType.getTypeName();
                    if (!typeName.equals("\u5176\u4ed6")) continue;
                    checkTypeId = id = fileType.getId();
                }
            }
            if (checkTypeId == null) {
                ResponseData save = this.archivalRecordsService.save(entity);
                List data = (List)save.getData();
                for (ArchivalRecordsVo datum : data) {
                    String visitingHospital = datum.getVisitingHospital();
                    if (!visitingHospital.equals("\u60a3\u8005\u5efa\u6863")) continue;
                    for (ArchivalFileTypeVo fileType : datum.getFileTypes()) {
                        String typeName = fileType.getTypeName();
                        if (!typeName.equals("\u5176\u4ed6")) continue;
                        Long typeId = fileType.getId();
                        for (String imgUrl : imgUrls.split(",")) {
                            ArchivalFileDto fileEntity = new ArchivalFileDto();
                            fileEntity.setFileTypeId(Integer.valueOf(typeId.intValue()));
                            fileEntity.setTenantId(patient.getTenantId());
                            fileEntity.setUrl(imgUrl);
                            fileEntity.setName("888");
                            this.archivalFileService.save(fileEntity);
                        }
                    }
                }
            } else {
                int delete = this.archivalFileMapper.delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ArchivalFileEntity::getTenantId, (Object)patient.getTenantId())).eq(ArchivalFileEntity::getFileTypeId, checkTypeId));
                if (delete > 0) {
                    for (String imgUrl : imgUrls.split(",")) {
                        ArchivalFileDto fileDto = new ArchivalFileDto();
                        fileDto.setFileTypeId(Integer.valueOf(checkTypeId.intValue()));
                        fileDto.setTenantId(patient.getTenantId());
                        fileDto.setUrl(imgUrl);
                        fileDto.setName("888");
                        this.archivalFileService.save(fileDto);
                    }
                }
            }
        }
        String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
        ArrayList<PatientEntity> westernMedicinePrescriptionsVos1 = new ArrayList<PatientEntity>();
        westernMedicinePrescriptionsVos1.add(patient);
        String msg = JSONObject.toJSONString(westernMedicinePrescriptionsVos1);
        this.rocketMQProducer.asyncSendCallbackTimeoutLevel(patientTopic, "TAG3", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
        return ResponseData.success((Object)patient.getId());
    }

    public ResponseData insertImport(List<PatientEntity> patients) {
        if (patients == null || patients.size() == 0) {
            return ResponseData.error((String)"\u5fc5\u8981\u53c2\u6570\u7f3a\u5931");
        }
        for (PatientEntity patient : patients) {
            List patientFamilyList = patient.getPatientFamilyList();
            PatientEntity patientEntities = null;
            if (!Objects.isNull(patient.getCardNo())) {
                patientEntities = this.patientMapper.queryPatientByCardNoAndTenantId(patient.getCardNo(), patient.getTenantId());
            }
            if (Objects.isNull(patientEntities)) {
                patient.setMedicalRecordNo(this.generateMedicalRecordNo(patient.getTenantId(), this.patientMapper.queryMaxMedicalNo(patient.getTenantId())));
                patient.setNamePinyin(StringPinyinUtil.toFirstChar((String)patient.getName()));
                this.patientMapper.insert((Object)patient);
            } else {
                patient.setId(patientEntities.getId());
                BeanUtils.copyProperties((Object)patient, (Object)patientEntities);
                this.patientMapper.updateById((Object)patientEntities);
            }
            if (!Objects.isNull(patientFamilyList)) {
                for (PatientFamilyEntity patientFamilyEntity : patientFamilyList) {
                    patientFamilyEntity.setPatientId(patient.getId());
                    patientFamilyEntity.setTenantId(patient.getTenantId());
                    this.patientFamilyMapper.insert((Object)patientFamilyEntity);
                }
            }
            String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
            ArrayList<PatientEntity> westernMedicinePrescriptionsVos1 = new ArrayList<PatientEntity>();
            westernMedicinePrescriptionsVos1.add(patient);
            String msg = JSONObject.toJSONString(westernMedicinePrescriptionsVos1);
            this.rocketMQProducer.asyncSendCallbackTimeoutLevel(patientTopic, "TAG3", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
        }
        return ResponseData.success();
    }

    public ResponseData insertPatientFamily(PatientFamilyEntity patientFamily) {
        if (patientFamily == null) {
            return ResponseData.error((String)"\u5fc5\u8981\u53c2\u6570\u7f3a\u5931");
        }
        this.patientFamilyMapper.insert((Object)patientFamily);
        return ResponseData.success();
    }

    private String generateMedicalRecordNo(Integer tenantId, String no) {
        Integer endNo = Objects.isNull(no) ? Integer.valueOf(0) : Integer.valueOf(Integer.parseInt(no));
        String currentDate = DateUtils.getCurrentDate((String)"yyMMdd");
        Integer suffix = tenantId + 1000000 + endNo;
        return currentDate + suffix;
    }

    public ResponseData deleteById(Integer id) {
        if (this.patientMapper.deleteById(id) > 0) {
            return ResponseData.success();
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("patient_id", id);
        this.patientFamilyMapper.deleteByMap(map);
        return ResponseData.error((String)"\u4fee\u6539\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\uff01");
    }

    public ResponseData deletePatientFamilyById(Integer id) {
        if (this.patientFamilyMapper.deleteById((Serializable)id) > 0) {
            return ResponseData.success();
        }
        return ResponseData.error((String)"\u4fee\u6539\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\uff01");
    }

    public ResponseData updateById(PatientEntity patient) {
        CheckCardNoCorrectnessDto dto = new CheckCardNoCorrectnessDto();
        dto.setName(patient.getName());
        dto.setCardNo(patient.getCardNo());
        CheckCardNoCorrectnessVo vo = this.checkCardNoCorrectness(dto);
        if (!"01".equals(vo.getStatusCode())) {
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)vo.getMessage());
        }
        patient.setNamePinyin(StringPinyinUtil.toFirstChar((String)patient.getName()));
        if (this.patientMapper.updateById((Object)patient) > 0) {
            List isEmpty;
            List patientFamilyList = patient.getPatientFamilyList();
            if (!Objects.isNull(patientFamilyList)) {
                this.patientFamilyMapper.deleteByPatientId(patient.getId().intValue());
                patientFamilyList.stream().forEach(patientFamilyEntity -> {
                    patientFamilyEntity.setPatientId(patient.getId());
                    patientFamilyEntity.setPatientName(patient.getName());
                    patientFamilyEntity.setTenantId(patient.getTenantId());
                    this.patientFamilyMapper.insert(patientFamilyEntity);
                });
            }
            if ((isEmpty = this.outEtubePatientInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(OutEtubePatientInfoEntity::getPatientId, (Object)patient.getId()))).size() > 0) {
                OutEtubePatientDossierEntity item;
                OutEtubePatientInfoEntity outEtubePatientInfoEntity = (OutEtubePatientInfoEntity)isEmpty.get(0);
                OutEtubePatientInfoEntity patientInfo = new OutEtubePatientInfoEntity();
                patientInfo.setPatientId(patient.getId());
                patientInfo.setMobilePhone(patient.getPhone());
                patientInfo.setUserName(patient.getName());
                patientInfo.setIdCard(patient.getCardNo());
                Integer sex = null;
                if ("2".equals(patient.getSex())) {
                    sex = 0;
                } else if ("1".equals(patient.getSex())) {
                    sex = 1;
                }
                patientInfo.setSex(sex);
                patientInfo.setAge(patient.getAge());
                patientInfo.setBirthday(patient.getBirthday());
                ResponseData responseData = this.expertStudioService.updatePatient(patientInfo);
                OutEtubePatientDossierEntity dossier = new OutEtubePatientDossierEntity();
                dossier.setTenantId(outEtubePatientInfoEntity.getTenantId());
                dossier.setPatientCode(outEtubePatientInfoEntity.getPatientCode());
                dossier.setPatientId(outEtubePatientInfoEntity.getPatientId());
                List outEtubePatientDossierEntities = this.outEtubePatientDossierMapper.queryRequired(dossier);
                if (!outEtubePatientDossierEntities.isEmpty() && (item = (OutEtubePatientDossierEntity)outEtubePatientDossierEntities.get(0)) != null) {
                    String address;
                    String string = StringUtil.isNotBlank((String)patient.getContactsAddress()) ? patient.getContactsAddress() : (address = "" + (StringUtil.isNotBlank((String)patient.getContactsAddressDetail()) ? patient.getContactsAddressDetail() : ""));
                    String workAdress = StringUtil.isNotBlank((String)patient.getWorkAddress()) ? patient.getWorkAddress() : "" + (StringUtil.isNotBlank((String)patient.getWorkAddressDetail()) ? patient.getWorkAddressDetail() : "");
                    String medicalRecordNo = patient.getMedicalRecordNo();
                    String remark = patient.getRemark();
                    item.setFamilyAddress(address);
                    item.setCompanyAddress(workAdress);
                    item.setMedicalRecordNo(medicalRecordNo);
                    item.setPatientRemark(remark);
                    item.setInviteCode(item.getDoctorCode());
                    this.expertStudioService.updatePatientDossier(item);
                }
            }
            String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
            ArrayList<PatientEntity> westernMedicinePrescriptionsVos1 = new ArrayList<PatientEntity>();
            westernMedicinePrescriptionsVos1.add(patient);
            String msg = JSONObject.toJSONString(westernMedicinePrescriptionsVos1);
            this.rocketMQProducer.asyncSendCallbackTimeoutLevel(patientTopic, "TAG3", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
            return ResponseData.success();
        }
        return ResponseData.error((String)"\u4fee\u6539\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\uff01");
    }

    public ResponseData updatePatientFamilyById(PatientFamilyEntity patientFamily) {
        if (this.patientFamilyMapper.updateById((Object)patientFamily) > 0) {
            return ResponseData.success();
        }
        return ResponseData.error((String)"\u4fee\u6539\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\uff01");
    }

    public ResponseData<PatientEntity> queryById(Integer id) {
        PatientEntity patientEntity = this.patientMapper.queryById(id.intValue());
        if (Objects.isNull(patientEntity)) {
            return ResponseData.error((String)"\u67e5\u8be2\u60a3\u8005\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("patient_id", id);
        List patientFamilyList = this.patientFamilyMapper.selectByMap(map);
        patientEntity.setPatientFamilyList(patientFamilyList);
        Integer realAge = this.getAge(patientEntity.getCardNo(), patientEntity.getBirthday(), patientEntity.getAge());
        patientEntity.setAge(realAge);
        ArchivalRecordsEntity entity = new ArchivalRecordsEntity();
        entity.setPatientId(patientEntity.getId());
        entity.setVisitingHospital("\u60a3\u8005\u5efa\u6863");
        entity.setTenantId(patientEntity.getTenantId());
        String imgUrls = "";
        ResponseData responseData = this.archivalRecordsService.pageList(entity);
        Object checkTypeId = null;
        for (ArchivalRecordsVo datum : (List)responseData.getData()) {
            String visitingHospital = datum.getVisitingHospital();
            if (!visitingHospital.equals("\u60a3\u8005\u5efa\u6863")) continue;
            for (ArchivalFileTypeVo fileType : datum.getFileTypes()) {
                String typeName = fileType.getTypeName();
                if (!typeName.equals("\u5176\u4ed6")) continue;
                ArchivalFileEntity fileEntity = new ArchivalFileEntity();
                fileEntity.setFileTypeId(Integer.valueOf(fileType.getId().intValue()));
                fileEntity.setTenantId(patientEntity.getTenantId());
                ResponseData responseData1 = this.archivalFileService.pageList(fileEntity);
                for (int i = 0; i < ((List)responseData1.getData()).size(); ++i) {
                    ArchivalFileEntity fileEntity1 = (ArchivalFileEntity)((List)responseData1.getData()).get(i);
                    String url = fileEntity1.getUrl();
                    imgUrls = ((List)responseData1.getData()).size() - 1 == i ? imgUrls + url : imgUrls + url + ",";
                }
            }
        }
        patientEntity.setImgUrls(imgUrls);
        return ResponseData.success((Object)patientEntity);
    }

    public ResponseData queryPatientFamilyById(Integer id) {
        PatientFamilyEntity patientFamilyEntity = (PatientFamilyEntity)this.patientFamilyMapper.selectById((Serializable)id);
        return ResponseData.success((Object)patientFamilyEntity);
    }

    public ResponseData<PageResult<PatientEntity>> queryPatient(QueryPatientDto queryPatientDto) {
        SysDoctorDto sysDoctorDto = new SysDoctorDto();
        sysDoctorDto.setId(queryPatientDto.getUserId());
        ResponseData sysDoctorIdVoResponseData = this.sysServiceFeign.doctorById(sysDoctorDto);
        SysDoctorIdVo data = (SysDoctorIdVo)sysDoctorIdVoResponseData.getData();
        PageHelper.startPage((int)queryPatientDto.getCurrent(), (int)queryPatientDto.getSize());
        List patientList = new ArrayList();
        String duties = data.getDuties();
        PageHelper.startPage((int)queryPatientDto.getCurrent(), (int)queryPatientDto.getSize());
        if (StringUtil.isBlank((String)duties) || !"0".equals(duties)) {
            PageHelper.startPage((int)queryPatientDto.getCurrent(), (int)queryPatientDto.getSize());
            patientList = this.patientMapper.queryPatient(queryPatientDto);
        } else {
            PageHelper.startPage((int)queryPatientDto.getCurrent(), (int)queryPatientDto.getSize());
            patientList = this.patientMapper.queryPatientByDoctor(queryPatientDto);
        }
        for (PatientEntity entity : patientList) {
            Integer realAge = this.getAge(entity.getCardNo(), entity.getBirthday(), entity.getAge());
            entity.setAge(realAge);
        }
        for (PatientEntity patient : patientList) {
            String patientName = HyposensitizationUtil.hyposensitizationForName((String)patient.getName());
            String phone = HyposensitizationUtil.hyposensitizationForPhone((String)patient.getPhone());
            String cardNo = HyposensitizationUtil.hyposensitizationForCardNo((String)patient.getCardNo());
            patient.setName(patientName);
            patient.setPhone(phone);
            patient.setCardNo(cardNo);
        }
        PageInfo pageInfo = new PageInfo(patientList);
        PageResult pageResult = new PageResult(queryPatientDto.getCurrent().intValue(), queryPatientDto.getSize().intValue());
        pageResult.setTotal(Integer.parseInt(String.valueOf(pageInfo.getTotal())));
        pageResult.setPages(pageInfo.getPages());
        pageResult.setRecords(patientList);
        pageResult.setCurrent(queryPatientDto.getCurrent().intValue());
        pageResult.setSize(queryPatientDto.getSize().intValue());
        return ResponseData.success((Object)pageResult);
    }

    private Integer getAge(String cardNo, String birthDay, Integer age) {
        String birthDate = "";
        birthDate = StrUtil.isEmpty((CharSequence)birthDay) ? this.getBirthDay(cardNo) : birthDay;
        if (StrUtil.isNotEmpty((CharSequence)birthDate)) {
            Integer realAge;
            LocalDate birthDateLocal = LocalDate.parse(birthDate, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            LocalDate currentDate = LocalDate.now();
            if (currentDate.isBefore(birthDateLocal.plusYears((realAge = Integer.valueOf(currentDate.getYear() - birthDateLocal.getYear())).intValue()))) {
                Integer n = realAge;
                Integer n2 = realAge = Integer.valueOf(realAge - 1);
            }
            return realAge;
        }
        return age;
    }

    private String getBirthDay(String cardNo) {
        if (cardNo.length() != 18) {
            return null;
        }
        String birthDateString = cardNo.substring(6, 14);
        LocalDate birthDate = LocalDate.parse(birthDateString, DateTimeFormatter.BASIC_ISO_DATE);
        return birthDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }

    public ResponseData queryPatientByName(PatientNameDto patientNameDto) {
        List outpatientTypeList = this.patientMapper.queryPatientByName(patientNameDto);
        return ResponseData.success((Object)outpatientTypeList);
    }

    public ResponseData<HsPatientInfoVo> queryPatientInfoByEcCode(HsPatientInfoDto hsPatientInfoDto) {
        AdmissionEntity admission = this.admissionMapper.queryAdmissionByOutpatientNo(hsPatientInfoDto.getOutpatientNo(), hsPatientInfoDto.getTenantId());
        PatientEntity patientEntity = this.patientMapper.queryById(admission.getPatientId().intValue());
        if ("01".equals(hsPatientInfoDto.getMdtrtCertType())) {
            if (Objects.isNull(patientEntity.getCardNo()) || "".equals(patientEntity.getCardNo())) {
                return ResponseData.error((String)"\u8bf7\u5148\u5b8c\u5584\u60a3\u8005\u8eab\u4efd\u4fe1\u606f");
            }
            if (Objects.isNull(hsPatientInfoDto.getCardNo())) {
                hsPatientInfoDto.setCardNo(patientEntity.getCardNo());
                hsPatientInfoDto.setCardType(patientEntity.getCardType());
                hsPatientInfoDto.setName(patientEntity.getName());
                hsPatientInfoDto.setMdtrtCertType("02");
                hsPatientInfoDto.setMdtrtCertNo(patientEntity.getCardNo());
            }
            if (!patientEntity.getCardNo().equalsIgnoreCase(hsPatientInfoDto.getCardNo()) || !patientEntity.getName().equals(hsPatientInfoDto.getName())) {
                return ResponseData.error((String)"\u8eab\u4efd\u4fe1\u606f\u4e0d\u7b26\uff0c\u8bf7\u91cd\u65b0\u626b\u7801\uff01");
            }
        }
        PatientInfoRequest patientInfoRequest = new PatientInfoRequest();
        patientInfoRequest.setMdtrt_cert_type(hsPatientInfoDto.getMdtrtCertType());
        patientInfoRequest.setMdtrt_cert_no(hsPatientInfoDto.getMdtrtCertNo());
        patientInfoRequest.setPsn_name(hsPatientInfoDto.getName());
        patientInfoRequest.setCertno(hsPatientInfoDto.getCardNo());
        patientInfoRequest.setTenantId(hsPatientInfoDto.getTenantId());
        patientInfoRequest.setCard_sn(hsPatientInfoDto.getCardSn());
        patientInfoRequest.setPsn_cert_type(hsPatientInfoDto.getCardType());
        patientInfoRequest.setOpter_type(this.nodeConfig.getOpterType());
        patientInfoRequest.setOpter(String.valueOf(hsPatientInfoDto.getOpter()));
        patientInfoRequest.setOpter_name(hsPatientInfoDto.getOpterName());
        patientInfoRequest.setInsuplc_admdvs(hsPatientInfoDto.getInsuplcAdmdvs());
        ResponseData hsBaseResponseResponseData = this.hsServiceFeign.hsPatientInfo(patientInfoRequest);
        if (Objects.isNull(hsBaseResponseResponseData) || hsBaseResponseResponseData.isError()) {
            return ResponseData.error((String)((HsBaseResponse)hsBaseResponseResponseData.getData()).getErr_msg());
        }
        HsPatientInfoVo hsPatientInfoVo = new HsPatientInfoVo();
        BaseinfoEntity baseinfo = ((HsPatientInfoResponse)((HsBaseResponse)hsBaseResponseResponseData.getData()).getOutput()).getBaseinfo();
        hsPatientInfoVo.setPsnNo(baseinfo.getPsn_no());
        hsPatientInfoVo.setPsnName(baseinfo.getPsn_name());
        hsPatientInfoVo.setAge(baseinfo.getAge());
        hsPatientInfoVo.setGend(baseinfo.getGend());
        hsPatientInfoVo.setBrdy(baseinfo.getBrdy());
        hsPatientInfoVo.setCertno(baseinfo.getCertno());
        hsPatientInfoVo.setInsuinfo(((HsPatientInfoResponse)((HsBaseResponse)hsBaseResponseResponseData.getData()).getOutput()).getInsuinfo());
        patientEntity.setInsuinfo(JSONObject.toJSONString((Object)((HsPatientInfoResponse)((HsBaseResponse)hsBaseResponseResponseData.getData()).getOutput()).getInsuinfo()));
        patientEntity.setPsnNo(baseinfo.getPsn_no());
        if (MedTypeEnum.CHRONIC_IDIOPATHY.getValue().equals(hsPatientInfoDto.getMedType())) {
            ChronicDiseaseRequest chronicDiseaseRequest = new ChronicDiseaseRequest();
            BeanUtils.copyProperties((Object)patientInfoRequest, (Object)chronicDiseaseRequest);
            chronicDiseaseRequest.setPsn_no(hsPatientInfoVo.getPsnNo());
            chronicDiseaseRequest.setInsuplc_admdvs(hsPatientInfoDto.getInsuplcAdmdvs());
            chronicDiseaseRequest.setCertno(hsPatientInfoVo.getCertno());
            chronicDiseaseRequest.setMdtrt_cert_no(hsPatientInfoVo.getCertno());
            chronicDiseaseRequest.setCert_type("02");
            ResponseData medicalChronicResponse = this.hsServiceFeign.chronicDisease(chronicDiseaseRequest);
            if (!Objects.isNull(medicalChronicResponse) && medicalChronicResponse.isSuccess() && !Objects.isNull(((HsBaseResponse)medicalChronicResponse.getData()).getOutput())) {
                if (!((List)((HsBaseResponse)medicalChronicResponse.getData()).getOutput()).isEmpty()) {
                    JSONObject feedetail = new JSONObject();
                    feedetail.put("feedetail", ((HsBaseResponse)medicalChronicResponse.getData()).getOutput());
                    JSONArray jsonArray = new JSONArray();
                    jsonArray.add((Object)feedetail);
                    hsPatientInfoVo.setMedicalChronicList((List)jsonArray);
                }
                List jsonList = (List)JSON.parseObject((String)JSONObject.toJSONString((Object)((HsBaseResponse)medicalChronicResponse.getData()).getOutput()), List.class);
                String chronicDiseaseCode = "";
                String chronicDisease = "";
                for (Object objson : jsonList) {
                    JSONObject jsonObject = JSON.parseObject((String)JSONObject.toJSONString(objson));
                    chronicDiseaseCode = chronicDiseaseCode + "," + jsonObject.get((Object)"opsp_dise_code").toString();
                    chronicDisease = chronicDisease + "," + jsonObject.get((Object)"opsp_dise_name").toString();
                }
                patientEntity.setChronicDiseaseCode(chronicDiseaseCode);
                patientEntity.setChronicDisease(chronicDisease);
            }
        }
        this.patientMapper.updateById((Object)patientEntity);
        return ResponseData.success((Object)hsPatientInfoVo);
    }

    public ResponseData<List<PatientEntity>> queryPatientByCardNo(String cardNo, Integer tenantId) {
        List patientEntityList = this.patientMapper.queryPatientByCardNo(cardNo, tenantId);
        return ResponseData.success((Object)patientEntityList);
    }

    public ResponseData<HsPatientInfoVo> queryRegPatientHsInfo(HsPatientInfoDto hsPatientInfoDto) {
        PatientInfoRequest patientInfoRequest = new PatientInfoRequest();
        patientInfoRequest.setMdtrt_cert_type(hsPatientInfoDto.getMdtrtCertType());
        patientInfoRequest.setMdtrt_cert_no(hsPatientInfoDto.getMdtrtCertNo());
        patientInfoRequest.setPsn_name(hsPatientInfoDto.getName());
        patientInfoRequest.setCertno(hsPatientInfoDto.getCardNo());
        patientInfoRequest.setTenantId(hsPatientInfoDto.getTenantId());
        patientInfoRequest.setPsn_cert_type(hsPatientInfoDto.getCardType());
        patientInfoRequest.setOpter_type(this.nodeConfig.getOpterType());
        patientInfoRequest.setOpter(String.valueOf(hsPatientInfoDto.getOpter()));
        patientInfoRequest.setOpter_name(hsPatientInfoDto.getOpterName());
        patientInfoRequest.setInsuplc_admdvs(StrUtil.isBlank((CharSequence)hsPatientInfoDto.getInsuplcAdmdvs()) ? null : hsPatientInfoDto.getInsuplcAdmdvs());
        ResponseData hsBaseResponseResponseData = this.hsServiceFeign.hsPatientInfo(patientInfoRequest);
        if (Objects.isNull(hsBaseResponseResponseData) || hsBaseResponseResponseData.isError()) {
            return ResponseData.error((String)((HsBaseResponse)hsBaseResponseResponseData.getData()).getErr_msg());
        }
        HsPatientInfoVo hsPatientInfoVo = new HsPatientInfoVo();
        BaseinfoEntity baseinfo = ((HsPatientInfoResponse)((HsBaseResponse)hsBaseResponseResponseData.getData()).getOutput()).getBaseinfo();
        hsPatientInfoVo.setPsnNo(baseinfo.getPsn_no());
        hsPatientInfoVo.setPsnName(baseinfo.getPsn_name());
        hsPatientInfoVo.setAge(baseinfo.getAge());
        hsPatientInfoVo.setGend(baseinfo.getGend());
        hsPatientInfoVo.setBrdy(baseinfo.getBrdy());
        hsPatientInfoVo.setCertno(baseinfo.getCertno());
        hsPatientInfoVo.setInsuinfo(((HsPatientInfoResponse)((HsBaseResponse)hsBaseResponseResponseData.getData()).getOutput()).getInsuinfo());
        ChronicDiseaseRequest chronicDiseaseRequest = new ChronicDiseaseRequest();
        BeanUtils.copyProperties((Object)patientInfoRequest, (Object)chronicDiseaseRequest);
        chronicDiseaseRequest.setPsn_no(hsPatientInfoVo.getPsnNo());
        chronicDiseaseRequest.setInsuplc_admdvs(hsPatientInfoDto.getInsuplcAdmdvs());
        chronicDiseaseRequest.setCertno(hsPatientInfoVo.getCertno());
        chronicDiseaseRequest.setMdtrt_cert_no(hsPatientInfoVo.getCertno());
        chronicDiseaseRequest.setCert_type("02");
        ResponseData medicalChronicResponse = this.hsServiceFeign.chronicDisease(chronicDiseaseRequest);
        if (!Objects.isNull(medicalChronicResponse) && medicalChronicResponse.isSuccess() && !Objects.isNull(((HsBaseResponse)medicalChronicResponse.getData()).getOutput())) {
            if (!((List)((HsBaseResponse)medicalChronicResponse.getData()).getOutput()).isEmpty()) {
                JSONObject feedetail = new JSONObject();
                feedetail.put("feedetail", ((HsBaseResponse)medicalChronicResponse.getData()).getOutput());
                JSONArray jsonArray = new JSONArray();
                jsonArray.add((Object)feedetail);
                hsPatientInfoVo.setMedicalChronicList((List)jsonArray);
            }
            List jsonList = (List)JSON.parseObject((String)JSONObject.toJSONString((Object)((HsBaseResponse)medicalChronicResponse.getData()).getOutput()), List.class);
            String chronicDiseaseCode = "";
            String chronicDisease = "";
            for (Object objson : jsonList) {
                JSONObject jsonObject = JSON.parseObject((String)JSONObject.toJSONString(objson));
                chronicDiseaseCode = chronicDiseaseCode + "," + jsonObject.get((Object)"opsp_dise_code").toString();
                chronicDisease = chronicDisease + "," + jsonObject.get((Object)"opsp_dise_name").toString();
            }
            hsPatientInfoVo.setChronicDiseaseCode(chronicDiseaseCode);
            hsPatientInfoVo.setChronicDisease(chronicDisease);
        }
        if (Objects.isNull(hsPatientInfoVo.getChronicDisease()) || "".equals(hsPatientInfoVo.getChronicDisease())) {
            hsPatientInfoVo.setMedicalOutpatientType(MedTypeEnum.NOR.getValue());
        } else {
            hsPatientInfoVo.setMedicalOutpatientType(MedTypeEnum.CHRONIC_IDIOPATHY.getValue());
        }
        List insuinfo = ((HsPatientInfoResponse)((HsBaseResponse)hsBaseResponseResponseData.getData()).getOutput()).getInsuinfo();
        hsPatientInfoVo.setMedicalType(ProvInsuplcAdmdvsEnum.JX_PROV.getValue().equals(((Insuinfo)insuinfo.get(0)).getInsuplc_admdvs()) ? MedicalInsuranceTypeEnum.PROV_MEDICARE.getValue() : MedicalInsuranceTypeEnum.CITY_MEDICARE.getValue());
        return ResponseData.success((Object)hsPatientInfoVo);
    }

    public ResponseData<PageInfo<FirstPaymentDto>> queryFirstPayment(FirstPaymentDto dto) {
        PageHelper.startPage((int)dto.getCurrent(), (int)dto.getSize());
        List ids = this.patientMapper.firstPaymentPrescriptionNo(dto);
        dto.setPatientIds(ids);
        List firstPaymentDtos = this.patientMapper.firstPayment(dto);
        firstPaymentDtos.forEach(item -> {
            String chronicDisease = item.getChronicDisease();
            if (StringUtil.isNotBlank((String)chronicDisease)) {
                String[] split = chronicDisease.split(",");
                HashSet<String> strings = new HashSet<String>(Arrays.asList(split));
                item.setChronicDisease(strings.toString().substring(2, strings.toString().length() - 1));
            }
            String patientName = HyposensitizationUtil.hyposensitizationForName((String)item.getName());
            String phone = HyposensitizationUtil.hyposensitizationForPhone((String)item.getPhone());
            String cardNo = HyposensitizationUtil.hyposensitizationForCardNo((String)item.getCardNo());
            item.setName(patientName);
            item.setPhone(phone);
            item.setCardNo(cardNo);
        });
        PageInfo info = new PageInfo(ids);
        PageInfo firstPaymentDtoPageInfo = new PageInfo(firstPaymentDtos);
        firstPaymentDtoPageInfo.setTotal(info.getTotal());
        firstPaymentDtoPageInfo.setPages(info.getPages());
        firstPaymentDtoPageInfo.setPageSize(info.getPageSize());
        return ResponseData.success((Object)firstPaymentDtoPageInfo);
    }

    public ResponseData<PageInfo<FirstPaymentDto>> queryFirstPaymentExport(FirstPaymentDto dto) {
        PageHelper.startPage((int)dto.getCurrent(), (int)dto.getSize());
        List firstPaymentDtos = this.patientMapper.firstPaymentExport(dto);
        firstPaymentDtos.forEach(item -> {
            String chronicDisease = item.getChronicDisease();
            if (StringUtil.isNotBlank((String)chronicDisease)) {
                String[] split = chronicDisease.split(",");
                HashSet<String> strings = new HashSet<String>(Arrays.asList(split));
                item.setChronicDisease(strings.toString().substring(2, strings.toString().length() - 1));
            }
        });
        PageInfo firstPaymentDtoPageInfo = new PageInfo(firstPaymentDtos);
        return ResponseData.success((Object)firstPaymentDtoPageInfo);
    }

    public ResponseData<PageInfo<HsSettlementInfoNewEntity>> HsSettlementInfoByPatient(PatientEntity patient) {
        Integer current = patient.getCurrent();
        Integer size = patient.getSize();
        current = current != null ? current : 1;
        size = size != null ? size : 10;
        PageHelper.startPage((int)current, (int)size);
        List hsSettlementInfoEntities = this.outHsSettlementInfoNewMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(HsSettlementInfoNewEntity::getTenantId, (Object)patient.getTenantId())).eq(HsSettlementInfoNewEntity::getCertno, (Object)patient.getCardNo())).eq(HsSettlementInfoNewEntity::getPsnName, (Object)patient.getName()));
        PageInfo hsSettlementInfoEntityPageInfo = new PageInfo(hsSettlementInfoEntities);
        return ResponseData.success((Object)hsSettlementInfoEntityPageInfo);
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

