/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.byh.outpatient.api.model.OutEtubeStudioInfoEntity;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.OutEtubeStudioInfoService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class OutEtubeStudioInfoController {
    @Autowired
    private OutEtubeStudioInfoService outEtubeStudioInfoService;
    @Autowired
    private CommonRequest commonRequest;

    @RequestMapping(value={"/out/etube/studio/info/save"})
    public ResponseData outEtubeStudioInfoSave(@RequestBody @Valid OutEtubeStudioInfoEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timeStr = format.format(new Date());
        entity.setCreateTime(timeStr);
        this.outEtubeStudioInfoService.outEtubeStudioInfoSave(entity);
        return ResponseData.success().save();
    }

    @RequestMapping(value={"/out/etube/studio/info/select"})
    public ResponseData<List<OutEtubeStudioInfoEntity>> outEtubeStudioInfoSelect(@RequestBody @Valid OutEtubeStudioInfoEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        List list = this.outEtubeStudioInfoService.outEtubeStudioInfoSelect(entity);
        return ResponseData.success((Object)list);
    }

    @RequestMapping(value={"/out/etube/studio/info/update"})
    public ResponseData outEtubeStudioInfoUpdate(@RequestBody @Valid OutEtubeStudioInfoEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        this.outEtubeStudioInfoService.outEtubeStudioInfoUpdate(entity);
        return ResponseData.success().update();
    }

    @RequestMapping(value={"/out/etube/studio/info/delete"})
    public ResponseData outEtubeStudioInfoDelete(@RequestBody @Valid OutEtubeStudioInfoEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        return this.outEtubeStudioInfoService.outEtubeStudioInfoDelete(entity);
    }
}

