/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.utils;

import cn.hutool.core.util.StrUtil;
import com.byh.outpatient.api.exception.BusinessException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommonRequest {
    private static final Logger log = LoggerFactory.getLogger(CommonRequest.class);
    @Autowired
    private HttpServletRequest request;

    public String getDrugRoomId() {
        String drugRoomId = this.request.getHeader("drugRoomId");
        if (StrUtil.isNotEmpty((CharSequence)drugRoomId)) {
            return drugRoomId;
        }
        throw new BusinessException("500", "\u836f\u623fid\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public Integer getTenant() {
        String tenantId = this.request.getHeader("tenantId");
        if (StrUtil.isNotEmpty((CharSequence)tenantId)) {
            return Integer.parseInt(tenantId);
        }
        return null;
    }

    public Integer getUserId() {
        String userId = this.request.getHeader("userId");
        if (StrUtil.isNotEmpty((CharSequence)userId)) {
            return Integer.parseInt(userId);
        }
        return null;
    }

    public String getUserName() {
        try {
            return URLDecoder.decode(this.request.getHeader("userName"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return this.request.getHeader("userName");
        }
    }

    public String getSignNo() {
        return Objects.isNull(this.request.getHeader("signNo")) ? "99999" : this.request.getHeader("signNo");
    }
}

