/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.config;

import io.minio.MinioClient;
import io.minio.errors.InvalidPortException;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
@Component
@ConfigurationProperties(prefix="minio")
public class MinioConfig {
    private String endpoint;
    private int port;
    private String accessKey;
    private String secretKey;
    private Boolean secure;
    private String bucketName;

    @Bean
    public MinioClient getMinioClient() throws InvalidPortException {
        MinioClient minioClient = MinioClient.builder().endpoint(this.endpoint).credentials(this.accessKey, this.secretKey).build();
        return minioClient;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public int getPort() {
        return this.port;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public Boolean getSecure() {
        return this.secure;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setSecure(Boolean secure) {
        this.secure = secure;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MinioConfig)) {
            return false;
        }
        MinioConfig other = (MinioConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$accessKey = this.getAccessKey();
        String other$accessKey = other.getAccessKey();
        if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
            return false;
        }
        String this$secretKey = this.getSecretKey();
        String other$secretKey = other.getSecretKey();
        if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
            return false;
        }
        Boolean this$secure = this.getSecure();
        Boolean other$secure = other.getSecure();
        if (this$secure == null ? other$secure != null : !((Object)this$secure).equals(other$secure)) {
            return false;
        }
        String this$bucketName = this.getBucketName();
        String other$bucketName = other.getBucketName();
        return !(this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MinioConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        result = result * 59 + this.getPort();
        String $accessKey = this.getAccessKey();
        result = result * 59 + ($accessKey == null ? 43 : $accessKey.hashCode());
        String $secretKey = this.getSecretKey();
        result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
        Boolean $secure = this.getSecure();
        result = result * 59 + ($secure == null ? 43 : ((Object)$secure).hashCode());
        String $bucketName = this.getBucketName();
        result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
        return result;
    }

    public String toString() {
        return "MinioConfig(endpoint=" + this.getEndpoint() + ", port=" + this.getPort() + ", accessKey=" + this.getAccessKey() + ", secretKey=" + this.getSecretKey() + ", secure=" + this.getSecure() + ", bucketName=" + this.getBucketName() + ")";
    }
}

