/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.byh.outpatient.api.dto.doctorRegFee.InsertDoctorRegFeeDto;
import com.byh.outpatient.api.dto.doctorRegFee.QueryByDoctorIdDto;
import com.byh.outpatient.api.dto.doctorRegFee.QueryDoctorRegFeeDto;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.web.aspect.UserOptLogger;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.OutDoctorRegFeeService;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/doctorRegFee"})
public class OutDoctorRegFeeController {
    @Autowired
    private OutDoctorRegFeeService doctorRegFeeService;
    @Autowired
    private CommonRequest commonRequest;

    @PostMapping(value={"/selectListByDoctorId"})
    @ApiOperation(value="\u6839\u636e\u533b\u751f\u7f16\u53f7\u67e5\u8be2\u5bf9\u5e94\u7684\u95e8\u8bca\u6302\u53f7\u8d39\u7528\u4fe1\u606f")
    public ResponseData selectListByDoctorId(@RequestBody @Valid QueryByDoctorIdDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setDoctorId(this.commonRequest.getUserId());
        return ResponseData.success((Object)this.doctorRegFeeService.selectListByDoctorId(dto));
    }

    @PostMapping(value={"/selectPageList"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u533b\u751f\u6302\u53f7\u8d39\u5173\u8054\u4fe1\u606f")
    public ResponseData selectPageList(@RequestBody QueryDoctorRegFeeDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.doctorRegFeeService.selectPageList(dto));
    }

    @PostMapping(value={"/deleteRelation"})
    @ApiOperation(value="\u5220\u9664\u533b\u751f\u6302\u53f7\u8d39\u5173\u8054\u4fe1\u606f")
    @UserOptLogger(operation="\u5220\u9664\u533b\u751f\u6302\u53f7\u8d39\u5173\u8054\u4fe1\u606f")
    public ResponseData deleteRelation(@RequestBody @Valid InsertDoctorRegFeeDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.doctorRegFeeService.deleteRelation(dto);
        return ResponseData.success((Object)"\u5173\u8054\u4fe1\u606f\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"/updateRelation"})
    @ApiOperation(value="\u7f16\u8f91\u533b\u751f\u6302\u53f7\u8d39\u5173\u8054\u4fe1\u606f")
    @UserOptLogger(operation="\u7f16\u8f91\u533b\u751f\u6302\u53f7\u8d39\u5173\u8054\u4fe1\u606f")
    public ResponseData updateRelation(@RequestBody @Valid InsertDoctorRegFeeDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setOperatorId(this.commonRequest.getUserId());
        dto.setOperatorName(this.commonRequest.getUserName());
        this.doctorRegFeeService.updateRelation(dto);
        return ResponseData.success((Object)"\u5173\u8054\u4fe1\u606f\u7f16\u8f91\u6210\u529f\uff01");
    }

    @PostMapping(value={"/insertRelation"})
    @ApiOperation(value="\u65b0\u589e\u533b\u751f\u6302\u53f7\u8d39\u5173\u8054\u4fe1\u606f")
    @UserOptLogger(operation="\u65b0\u589e\u533b\u751f\u6302\u53f7\u8d39\u5173\u8054\u4fe1\u606f")
    public ResponseData insertRelation(@RequestBody @Valid InsertDoctorRegFeeDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setOperatorId(this.commonRequest.getUserId());
        dto.setOperatorName(this.commonRequest.getUserName());
        this.doctorRegFeeService.insertRelation(dto);
        return ResponseData.success((Object)"\u5173\u8054\u4fe1\u606f\u65b0\u589e\u6210\u529f\uff01");
    }
}

