/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.byh.outpatient.api.model.datacenter.ApprovalDTO;
import com.byh.outpatient.api.model.datacenter.OutPatientRecordTempDTO;
import com.byh.outpatient.api.model.datacenter.OutPatientRecordTempEntity;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.OutApprovalRecordService;
import com.byh.outpatient.web.service.OutPatientRecordTempService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/outPatientCheck"})
public class OutPatientRecordController {
    @Autowired
    private OutPatientRecordTempService outPatientRecordTempService;
    @Autowired
    private OutApprovalRecordService approvalRecordService;
    @Autowired
    private CommonRequest commonRequest;

    @ApiOperation(value="\u67e5\u8be2\u60a3\u8005\u5217\u8868")
    @PostMapping(value={"/pageList"})
    public ResponseData<PageInfo<OutPatientRecordTempEntity>> pageList(@RequestBody OutPatientRecordTempDTO outPatientRecordTempDTO) {
        return ResponseData.success((Object)this.outPatientRecordTempService.pageList(outPatientRecordTempDTO));
    }

    @ApiOperation(value="\u5ba1\u6279")
    @PostMapping(value={"/approval"})
    public ResponseData approval(@RequestBody ApprovalDTO approvalDTO) {
        return this.outPatientRecordTempService.approval(approvalDTO);
    }

    @ApiOperation(value="\u67e5\u8be2\u5ba1\u6279\u5217\u8868")
    @GetMapping(value={"/approvalList"})
    public ResponseData selectApprovalList(@RequestParam(value="id") Long id) {
        return ResponseData.success((Object)this.approvalRecordService.selectApprovalList(id));
    }

    @ApiOperation(value="\u65b0\u589e\u5ba1\u6279")
    @PostMapping(value={"/add"})
    public ResponseData add(@RequestBody OutPatientRecordTempEntity entity) {
        Integer userId = this.commonRequest.getUserId();
        entity.setUserId(userId + "");
        entity.setCreateBy(userId + "");
        Long patientId = entity.getPatientId();
        if (patientId == null) {
            return ResponseData.error((String)"\u60a3\u8005id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ResponseData.success((Object)this.outPatientRecordTempService.add(entity));
    }
}

