/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.outpatient.api.dto.drugSell.GenerateDrugSellDto;
import com.byh.outpatient.api.dto.drugSell.QueryDrugSellDto;
import com.byh.outpatient.api.exception.BusinessException;
import com.byh.outpatient.api.model.drugSell.OutDrugSellEntity;
import com.byh.outpatient.api.model.drugSell.TableTemplateEntity;
import com.byh.outpatient.api.util.ExceptionUtils;
import com.byh.outpatient.api.util.HyposensitizationUtil;
import com.byh.outpatient.api.vo.drugSell.ExportDrugSellVo;
import com.byh.outpatient.api.vo.drugSell.GroupVo;
import com.byh.outpatient.api.vo.drugSell.OutDrugSellVo;
import com.byh.outpatient.api.vo.drugSell.SysDeptVo;
import com.byh.outpatient.data.repository.OutDrugSellMapper;
import com.byh.outpatient.data.repository.TableTemplateMapper;
import com.byh.outpatient.web.service.OutDrugSellService;
import com.byh.outpatient.web.service.impl.OutLisResultServiceImpl;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OutDrugSellServiceImpl
implements OutDrugSellService {
    private static final Logger log = LoggerFactory.getLogger(OutDrugSellServiceImpl.class);
    private Logger logger = LoggerFactory.getLogger(OutLisResultServiceImpl.class);
    @Resource
    private OutDrugSellMapper outDrugSellMapper;
    @Resource
    private TableTemplateMapper tableTemplateMapper;

    public void exportDrugSellList(HttpServletResponse response, QueryDrugSellDto dto) {
        if (StrUtil.isEmpty((CharSequence)dto.getStartDate()) && StrUtil.isEmpty((CharSequence)dto.getEndDate())) {
            LocalDate today = LocalDate.now();
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            String todayStr = today.format(dateTimeFormatter);
            dto.setStartDate(todayStr);
            dto.setEndDate(todayStr);
        }
        List exportList = this.outDrugSellMapper.selectExportList(dto);
        LinkedHashMap exportMap = new LinkedHashMap();
        Map peritonealDrugs = exportList.stream().filter(vo -> "\u8179\u900f\u836f\u623f".equals(vo.getWarehouseName())).collect(Collectors.groupingBy(ExportDrugSellVo::getManufacturer, LinkedHashMap::new, Collectors.toList()));
        exportMap.putAll(peritonealDrugs);
        List oralDrugs = exportList.stream().filter(vo -> !"\u8179\u900f\u836f\u623f".equals(vo.getWarehouseName())).collect(Collectors.toList());
        if (!oralDrugs.isEmpty()) {
            exportMap.put("\u53e3\u670d\u836f", oralDrugs);
        }
        try (ServletOutputStream out = response.getOutputStream();){
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2");
            String format = LocalDateTime.now(ZoneOffset.ofHours(8)).format(dateTimeFormatter);
            String fileName = URLEncoder.encode("\u836f\u54c1\u9500\u552e\u5217\u8868" + format, "UTF-8").replaceAll("\\+", "%20");
            response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
            try (ExcelWriter excelWriter = EasyExcelFactory.write((OutputStream)out).build();){
                int exportCount = 0;
                for (Map.Entry entry : exportMap.entrySet()) {
                    String sheetName = (String)entry.getKey();
                    List list = (List)entry.getValue();
                    List patientIds = list.stream().filter(Objects::nonNull).map(ExportDrugSellVo::getPatientId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    sheetName = sheetName + "\uff08" + patientIds.size() + " \u4eba\uff09";
                    WriteSheet writeSheet = ((ExcelWriterSheetBuilder)EasyExcelFactory.writerSheet((Integer)exportCount, (String)sheetName).head(ExportDrugSellVo.class)).build();
                    excelWriter.write((Collection)list, writeSheet);
                    ++exportCount;
                }
                out.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Map<String, List<Map<Object, Object>>> selectGroupList(Integer tenantId) {
        List manufacturerGroups = this.outDrugSellMapper.getManufacturerGroupList(tenantId);
        ArrayList<Map> manufacturerList = new ArrayList<Map>();
        for (GroupVo manufacturerGroup : manufacturerGroups) {
            if (manufacturerGroup == null || manufacturerGroup.getManufacturer() == null || !StrUtil.isNotEmpty((CharSequence)manufacturerGroup.getManufacturer())) continue;
            manufacturerList.add(this.getObjectValue(manufacturerGroup.getManufacturer(), (Object)manufacturerGroup.getManufacturer()));
        }
        List doctorGroups = this.outDrugSellMapper.selectDoctorGroupList(tenantId);
        ArrayList<Map> doctorList = new ArrayList<Map>();
        for (GroupVo doctorGroup : doctorGroups) {
            if (doctorGroup == null) continue;
            doctorList.add(this.getObjectValue(doctorGroup.getDoctorName(), (Object)doctorGroup.getDoctorId()));
        }
        List customerGroups = this.outDrugSellMapper.selectCustomerGroupList(tenantId);
        ArrayList<Map> customerList = new ArrayList<Map>();
        for (GroupVo customerGroup : customerGroups) {
            if (customerGroup == null) continue;
            customerList.add(this.getObjectValue(customerGroup.getCustomerName(), (Object)customerGroup.getCustomerId()));
        }
        HashMap<String, List<Map<Object, Object>>> map = new HashMap<String, List<Map<Object, Object>>>();
        if (!manufacturerList.isEmpty()) {
            map.put("manufacturer", manufacturerList);
        }
        if (!doctorList.isEmpty()) {
            map.put("doctor", doctorList);
        }
        if (!customerList.isEmpty()) {
            map.put("customer", customerList);
        }
        return map;
    }

    private Map<Object, Object> getObjectValue(String label, Object value) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put("label", label);
        map.put("value", value);
        return map;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void update(OutDrugSellEntity entity) {
        if (entity.getId() == null) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u7f16\u8f91\u836f\u54c1\u9500\u552e\u4fe1\u606f\u65f6\uff0c\u4e3b\u952eID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (entity.getQuantity() <= 0) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u7f16\u8f91\u836f\u54c1\u9500\u552e\u4fe1\u606f\u65f6\uff0c\u9500\u552e\u6570\u91cf\u4e0d\u53ef\u5c0f\u4e8e\u6216\u7b49\u4e8e0\uff01");
        }
        BigDecimal totalAmount = entity.getPrice().multiply(new BigDecimal(entity.getQuantity()));
        entity.setTotalAmount(totalAmount);
        entity.setCreateTime(new Date());
        this.outDrugSellMapper.updateById((Object)entity);
    }

    @Scheduled(cron="0 0 2 * * ?")
    @Transactional(rollbackFor={BusinessException.class})
    public void timingGenerateDrugSell() {
        LocalDate today = LocalDate.now();
        LocalDate yesterday = today.minusDays(2L);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String yesterdayStr = yesterday.format(dateTimeFormatter);
        GenerateDrugSellDto dto = new GenerateDrugSellDto();
        dto.setTenantId(Integer.valueOf(1));
        dto.setCreateId(Integer.valueOf(1));
        dto.setCreateName("\u51cc\u66682\u70b9\u5b9a\u65f6\u751f\u6210\u836f\u54c1\u9500\u552e\u5217\u8868\u4fe1\u606f");
        dto.setStartDate(yesterdayStr);
        dto.setEndDate(yesterdayStr);
        this.generateDrugSell(dto);
    }

    public Page<OutDrugSellVo> selectPageList(QueryDrugSellDto dto) {
        Page page = new Page((long)dto.getCurrent(), (long)dto.getSize());
        List list = this.outDrugSellMapper.selectPageList(page, dto);
        for (OutDrugSellVo record : list) {
            String patientName = HyposensitizationUtil.hyposensitizationForName((String)record.getPatientName());
            String phone = HyposensitizationUtil.hyposensitizationForPhone((String)record.getPhone());
            record.setPatientName(patientName);
            record.setPhone(phone);
        }
        page.setRecords(list);
        return page;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void generateDrugSell(GenerateDrugSellDto dto) {
        List userIds;
        SysDeptVo deptVo = this.outDrugSellMapper.selectDeptByName("\u8179\u900f\u4e1a\u52a1\u90e8", dto.getTenantId());
        if (deptVo == null) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u8179\u900f\u4e1a\u52a1\u90e8\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        if ((userIds = this.outDrugSellMapper.selectDoctorListByDeptId(deptVo.getDeptId(), dto.getTenantId())).isEmpty()) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u8179\u900f\u4e1a\u52a1\u90e8\u5458\u5de5\u6570\u91cf\u4e3a0\uff01");
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        if (StrUtil.isEmpty((CharSequence)dto.getStartDate()) && StrUtil.isEmpty((CharSequence)dto.getEndDate())) {
            LocalDate today = LocalDate.now();
            String todayStr = today.format(dateTimeFormatter);
            dto.setStartDate(todayStr);
            dto.setEndDate(todayStr);
        }
        LambdaQueryWrapper deleteWrapper = Wrappers.lambdaQuery();
        deleteWrapper.eq(OutDrugSellEntity::getTenantId, (Object)dto.getTenantId());
        deleteWrapper.between(OutDrugSellEntity::getOpenDate, (Object)dto.getStartDate(), (Object)dto.getEndDate());
        this.outDrugSellMapper.delete((Wrapper)deleteWrapper);
        dto.setUserIds(userIds);
        List drugSells = this.outDrugSellMapper.getDrugSellList(dto);
        LambdaQueryWrapper tableTemplateQueryWrapper = Wrappers.lambdaQuery();
        List tableTemplateList = this.tableTemplateMapper.selectList((Wrapper)tableTemplateQueryWrapper);
        Map<String, Integer> tableTemplateMap = tableTemplateList.stream().collect(Collectors.toMap(entity -> entity.getPatientName() + entity.getName(), TableTemplateEntity::getQuantity));
        for (OutDrugSellEntity drugSell : drugSells) {
            String key;
            Integer quantity;
            if (!"2024-09-13".equals(drugSell.getOpenDate()) || (quantity = tableTemplateMap.get(key = drugSell.getPatientName() + drugSell.getDrugName())) == null) continue;
            drugSell.setQuantity(quantity);
            drugSell.setTotalAmount(drugSell.getPrice().multiply(BigDecimal.valueOf(quantity.intValue())));
        }
        Integer createId = dto.getCreateId();
        String createName = dto.getCreateName();
        drugSells.forEach(entity -> {
            entity.setCreateId(createId);
            entity.setCreateName(createName);
        });
        if (!drugSells.isEmpty()) {
            this.outDrugSellMapper.insertList(drugSells);
        }
    }
}

