/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller.selfHelp;

import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.byh.outpatient.api.dto.QueryOutpatientTypeDto;
import com.byh.outpatient.api.dto.QueryScheduleRecordDto;
import com.byh.outpatient.api.dto.admission.QuickTreatementDto;
import com.byh.outpatient.api.dto.binding.DoctorTypeDto;
import com.byh.outpatient.api.dto.order.HsPayDto;
import com.byh.outpatient.api.dto.order.HsPreparePayDto;
import com.byh.outpatient.api.dto.order.PaymentRecordsDto;
import com.byh.outpatient.api.dto.order.QueryFeeDetailsDto;
import com.byh.outpatient.api.dto.order.QueryFeeDetailsListDto;
import com.byh.outpatient.api.dto.pay.FeeBillCreationDto;
import com.byh.outpatient.api.dto.pay.HsRefundDto;
import com.byh.outpatient.api.dto.pay.PayDto;
import com.byh.outpatient.api.dto.pay.PayRefundDto;
import com.byh.outpatient.api.dto.schedule.QueryRecordDto;
import com.byh.outpatient.api.dto.selfHelp.PatientInfoDTO;
import com.byh.outpatient.api.enums.PaymentRecordsStatusEnum;
import com.byh.outpatient.api.model.admission.AdmissionEntity;
import com.byh.outpatient.api.model.order.OutOrderPayment;
import com.byh.outpatient.api.util.PageResult;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.UUIDUtils;
import com.byh.outpatient.api.vo.order.QueryFeeDetailsVo;
import com.byh.outpatient.api.vo.order.QueryPaymentRecords;
import com.byh.outpatient.data.repository.OutOrderPaymentMapper;
import com.byh.outpatient.web.feign.SysServiceFeign;
import com.byh.outpatient.web.mvc.exception.RunDisplayException;
import com.byh.outpatient.web.service.AdmissionService;
import com.byh.outpatient.web.service.OutDoctorTypeService;
import com.byh.outpatient.web.service.OutInvoiceService;
import com.byh.outpatient.web.service.OutOrderPaymentService;
import com.byh.outpatient.web.service.OutOrderService;
import com.byh.outpatient.web.service.OutPayService;
import com.byh.outpatient.web.service.OutpatientTypeService;
import com.byh.outpatient.web.service.ScheduleService;
import com.byh.outpatient.web.service.SelfHelpService;
import io.swagger.annotations.ApiOperation;
import io.swagger.v3.oas.annotations.Operation;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/selfHelp"})
public class SelfHelpController {
    private static Logger logger = LoggerFactory.getLogger(SelfHelpController.class);
    private final OutOrderPaymentService outOrderPaymentService;
    private final ScheduleService scheduleService;
    private final OutpatientTypeService outpatientTypeService;
    private final AdmissionService admissionService;
    private final OutPayService outPayService;
    private final OutOrderService outOrderService;
    private final SelfHelpService selfHelpService;
    private final OutDoctorTypeService outDoctorTypeService;
    private final SysServiceFeign sysServiceFeign;
    private final OutOrderPaymentMapper outOrderPaymentMapper;
    @Autowired
    private OutInvoiceService outInvoiceService;

    @GetMapping(value={"/payQuery"})
    @Operation(description="\u652f\u4ed8\u8bb0\u5f55")
    @ApiOperation(value="\u652f\u4ed8\u8bb0\u5f55-\u67e5\u8be2", httpMethod="GET", notes="\u652f\u4ed8\u8bb0\u5f55-\u67e5\u8be2")
    public ResponseData paymentRecords(@Valid PaymentRecordsDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        ResponseData pageResultResponseData = this.outOrderPaymentService.paymentRecords(parameter);
        List records = ((PageResult)pageResultResponseData.getData()).getRecords();
        return ResponseData.success((Object)records);
    }

    @GetMapping(value={"/scheduleRecordQuery"})
    @ApiOperation(value="\u67e5\u8be2\u6392\u73ed\u4fe1\u606f", httpMethod="GET", notes="\u67e5\u8be2\u6392\u73ed\u4fe1\u606f")
    public ResponseData scheduleRecordQuery(QueryScheduleRecordDto queryScheduleRecordDto) {
        queryScheduleRecordDto.setCurrent(Integer.valueOf(1));
        queryScheduleRecordDto.setSize(Integer.valueOf(20));
        queryScheduleRecordDto.setTenantId(Integer.valueOf(1));
        ResponseData pageResultResponseData = this.scheduleService.queryRecord(queryScheduleRecordDto);
        List records = ((PageResult)pageResultResponseData.getData()).getRecords();
        return ResponseData.success((Object)records);
    }

    @GetMapping(value={"/outpatientType"})
    @ApiOperation(value="\u95e8\u8bca\u7c7b\u578b", httpMethod="GET", notes="\u95e8\u8bca\u7c7b\u578b")
    public ResponseData queryOutpatientTypeByName(QueryOutpatientTypeDto queryOutpatientTypeDto) {
        queryOutpatientTypeDto.setTenantId(Integer.valueOf(1));
        ResponseData listResponseData = this.outpatientTypeService.queryOutpatientTypeByName(queryOutpatientTypeDto);
        List records = (List)listResponseData.getData();
        return ResponseData.success((Object)records);
    }

    @PostMapping(value={"/registration"})
    @ApiOperation(value="\u6302\u53f7\u767b\u8bb0", httpMethod="POST", notes="\u6302\u53f7\u767b\u8bb0")
    public ResponseData registration(@RequestBody QuickTreatementDto quickTreatementDto) {
        try {
            quickTreatementDto.setTenantId(Integer.valueOf(1));
            if (quickTreatementDto.getOperatorId() != null && quickTreatementDto.getOperatorId() == 7001) {
                quickTreatementDto.setOperatorName("\u5fae\u76df\u81ea\u52a9\u673a");
            } else {
                quickTreatementDto.setOperatorName("\u79d1\u4e3d\u5c14\u81ea\u52a9\u673a");
            }
            return this.admissionService.registration(quickTreatementDto);
        }
        catch (Exception e) {
            return ResponseData.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"/createPatient"})
    @ApiOperation(value="\u5efa\u6863", httpMethod="POST", notes="\u5efa\u6863")
    public ResponseData createPatient(@RequestBody QuickTreatementDto quickTreatementDto) {
        quickTreatementDto.setTenantId(Integer.valueOf(1));
        quickTreatementDto.setOperatorName("\u81ea\u52a9\u673a");
        try {
            return ResponseData.success((Object)this.admissionService.createPatient(quickTreatementDto));
        }
        catch (Exception e) {
            return ResponseData.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"/orderCharge"})
    @ApiOperation(value="\u652f\u4ed8-\u652f\u4ed8\u8ba2\u5355\u521b\u5efa", httpMethod="POST", notes="\u652f\u4ed8-\u652f\u4ed8\u5355\u521b\u5efa")
    public ResponseData orderCharge(@RequestBody FeeBillCreationDto parameter) {
        parameter.setTenantId(Integer.valueOf(1));
        if (parameter.getOperatorId() != null && parameter.getOperatorId() == 7001) {
            parameter.setOperatorName("\u5fae\u76df\u81ea\u52a9\u673a");
        } else {
            parameter.setOperatorName("\u79d1\u4e3d\u5c14\u81ea\u52a9\u673a");
        }
        return this.outPayService.orderCharge(parameter);
    }

    @PostMapping(value={"/queryChargeItem"})
    @ApiOperation(value="\u95e8\u8bca\u53f7\u67e5\u8be2\u5f85\u6536\u8d39\u9879\u76ee", httpMethod="POST", notes="\u95e8\u8bca\u53f7\u67e5\u8be2\u6536\u8d39\u9879\u76ee")
    public ResponseData<QueryFeeDetailsVo> queryChargeItem(@RequestBody QueryFeeDetailsDto parameter) {
        try {
            parameter.setTenantId(Integer.valueOf(1));
            return this.outOrderService.queryFeeDetails(parameter);
        }
        catch (Exception e) {
            return ResponseData.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"/queryChargeItemDetails"})
    @ApiOperation(value="\u6839\u636e\u8ba2\u5355id\u67e5\u8be2\u6536\u8d39\u9879\u76ee\u660e\u7ec6", httpMethod="POST", notes="\u6839\u636e\u8ba2\u5355id\u67e5\u8be2\u6536\u8d39\u9879\u76ee\u660e\u7ec6")
    public ResponseData queryChargeItemDetails(@RequestBody QueryFeeDetailsListDto parameter) {
        try {
            parameter.setTenantId(Integer.valueOf(1));
            return this.outOrderService.queryFeeDetailsByProjectID(parameter);
        }
        catch (Exception e) {
            return ResponseData.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"/doPayment"})
    @ApiOperation(value="\u652f\u4ed8-H5\u652f\u4ed8", httpMethod="POST", notes="\u652f\u4ed8-H5\u652f\u4ed8")
    public ResponseData doPayment(@RequestBody PayDto parameter) {
        try {
            parameter.setTenantId(Integer.valueOf(1));
            if (parameter.getOperatorId() != null && parameter.getOperatorId() == 7001) {
                parameter.setOperatorName("\u5fae\u76df\u81ea\u52a9\u673a");
            } else {
                parameter.setOperatorName("\u79d1\u4e3d\u5c14\u81ea\u52a9\u673a");
            }
            return this.outPayService.firstPayment(parameter);
        }
        catch (Exception e) {
            return ResponseData.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"/queryPaymentRecordItems"})
    @ApiOperation(value="\u652f\u4ed8\u8bb0\u5f55\u8be6\u60c5-\u67e5\u8be2", httpMethod="POST", notes="\u652f\u4ed8\u8bb0\u5f55\u8be6\u60c5-\u67e5\u8be2")
    public ResponseData paymentRecordDetails(@RequestBody QueryFeeDetailsListDto parameter) {
        parameter.setTenantId(Integer.valueOf(1));
        return this.outOrderPaymentService.paymentRecordDetails(parameter);
    }

    @PostMapping(value={"/doPayRefund"})
    @ApiOperation(value="\u652f\u4ed8\u9000\u6b3e", httpMethod="POST", notes="\u652f\u4ed8\u9000\u6b3e")
    public ResponseData doPayRefund(@RequestBody PayRefundDto parameter) {
        parameter.setTenantId(Integer.valueOf(1));
        parameter.setOperatorName("\u81ea\u52a9\u673a");
        ResponseData payRefundVoResponseData = this.outPayService.firstPayRefund(parameter);
        if (payRefundVoResponseData.isSuccess()) {
            try {
                this.outInvoiceService.batchCancel(parameter.getPayOrderNo(), parameter.getOrderNoList());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return payRefundVoResponseData;
    }

    @PostMapping(value={"/insurPreSettlement"})
    @ApiOperation(value="\u533b\u4fdd\u9884\u7ed3\u7b97", httpMethod="POST", notes="\u533b\u4fdd\u9884\u7ed3\u7b97")
    public ResponseData insurPreSettlement(@RequestBody HsPreparePayDto hsPreparePayDto) {
        try {
            hsPreparePayDto.setTenantId(Integer.valueOf(1));
            if (!StrUtil.isBlank((CharSequence)hsPreparePayDto.getOpter()) && "7001".equals(hsPreparePayDto.getOpter())) {
                hsPreparePayDto.setOpter_name("\u5fae\u76df\u81ea\u52a9\u673a");
            } else {
                hsPreparePayDto.setOpter_name("\u79d1\u4e3d\u5c14\u81ea\u52a9\u673a");
            }
            return this.outPayService.hsPreparePayment(hsPreparePayDto);
        }
        catch (Exception e) {
            return ResponseData.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"/insurSettlement"})
    @ApiOperation(value="\u533b\u4fdd\u7ed3\u7b97", httpMethod="POST", notes="\u533b\u4fdd\u7ed3\u7b97")
    public ResponseData insurSettlement(@RequestBody HsPayDto hsPayDto) {
        try {
            hsPayDto.setTenantId(Integer.valueOf(1));
            if (!StrUtil.isBlank((CharSequence)hsPayDto.getOpter()) && "7001".equals(hsPayDto.getOpter())) {
                hsPayDto.setOpter_name("\u5fae\u76df\u81ea\u52a9\u673a");
            } else {
                hsPayDto.setOpter_name("\u79d1\u4e3d\u5c14\u81ea\u52a9\u673a");
            }
            return this.outPayService.hsPayment(hsPayDto);
        }
        catch (Exception e) {
            return ResponseData.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"/insurRefund"})
    @ApiOperation(value="\u533b\u4fdd\u9000\u6b3e", httpMethod="POST", notes="\u533b\u4fdd\u9000\u6b3e")
    public ResponseData insurRefund(@RequestBody HsRefundDto hsRefundDto) {
        hsRefundDto.setTenantId(Integer.valueOf(1));
        hsRefundDto.setOpterName("\u81ea\u52a9\u673a");
        ResponseData responseData = this.outPayService.hsRefund(hsRefundDto);
        if (responseData.isSuccess()) {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"pay_order_no", (Object)hsRefundDto.getPayOrderNo());
            OutOrderPayment outOrderPayment = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)queryWrapper);
            this.refundSelf(outOrderPayment);
            try {
                this.outInvoiceService.batchCancel(hsRefundDto.getPayOrderNo(), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return responseData;
    }

    @PostMapping(value={"/getPatientInfo"})
    @ApiOperation(value="\u83b7\u53d6\u60a3\u8005\u4fe1\u606f", httpMethod="POST", notes="\u83b7\u53d6\u60a3\u8005\u4fe1\u606f")
    public ResponseData getPatientInfo(@RequestBody PatientInfoDTO patientInfoDTO) {
        patientInfoDTO.setTenantId(Integer.valueOf(1));
        return this.selfHelpService.selectPatientInfo(patientInfoDTO);
    }

    @GetMapping(value={"/queryDoctorType"})
    @ApiOperation(value="\u533b\u751f\u7ed1\u5b9a\u95e8\u8bca\u7c7b\u578b\u5217\u8868", httpMethod="GET", notes="\u533b\u751f\u7ed1\u5b9a\u95e8\u8bca\u7c7b\u578b\u5217\u8868")
    public ResponseData queryDoctorType(DoctorTypeDto dto) {
        List list = this.outDoctorTypeService.queryList(dto);
        return ResponseData.success((Object)list);
    }

    @ApiOperation(value="\u652f\u4ed8\u8bb0\u5f55\u67e5\u8be2")
    @PostMapping(value={"/paymentRecords"})
    public ResponseData<PageResult<QueryPaymentRecords>> paymentRecords(@RequestBody PaymentRecordsDto parameter) {
        parameter.setTenantId(Integer.valueOf(1));
        return this.outOrderPaymentService.paymentRecords(parameter);
    }

    @ApiOperation(value="\u53d6\u6d88\u767b\u8bb0")
    @PostMapping(value={"/cancelRegist"})
    public ResponseData<Integer> cancelRegist(@RequestBody AdmissionEntity admission) {
        admission.setTenantId(Integer.valueOf(1));
        return ResponseData.success((Object)this.admissionService.cancelRegist(admission));
    }

    @PostMapping(value={"/getDoctorAndRegFee"})
    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u65f6\u95f4\u5bf9\u5e94\u79d1\u5ba4\u533b\u751f\u7684\u6392\u73ed\u4fe1\u606f\uff08\u81ea\u52a9\u673a\u8c03\u7528\uff09")
    public ResponseData getDoctorAndRegFee(@RequestBody @Valid QueryRecordDto dto) {
        dto.setTenantId(Integer.valueOf(1));
        return ResponseData.success((Object)this.scheduleService.selectListBySelf(dto));
    }

    public ResponseData refundSelf(OutOrderPayment outOrderPayment) {
        List list;
        boolean exists;
        ResponseData sysDoctorList = this.sysServiceFeign.doctorByDept(Integer.valueOf(25));
        if (sysDoctorList.getData() != null && !((List)sysDoctorList.getData()).isEmpty() && (exists = (list = (List)sysDoctorList.getData()).stream().anyMatch(item -> item.getJobNumber().equals(String.valueOf(outOrderPayment.getCheckerId()))))) {
            logger.info("\u5373\u5c06\u5f00\u59cb\u81ea\u52a9\u673a\u9000\u8d39!!");
            String APP_SECRET = "497B3A0F3B6B4F61918F509B6C6AEBF4";
            String AUTH_URL = "http://171.34.133.170:11111//sys-auth/channel/oauth/token";
            String REFUND_URL = "http://171.34.133.170:11111//jdpay/core/refund";
            JSONObject authJsonObject = new JSONObject();
            authJsonObject.put("appKey", (Object)"1719566108352495");
            authJsonObject.put("appSecret", (Object)"497B3A0F3B6B4F61918F509B6C6AEBF4");
            logger.info("\u81ea\u52a9\u673a\u9000\u8d39\u7edf\u4e00\u6388\u6743\u5165\u53c2\u62a5\u6587\uff1a {}", (Object)authJsonObject.toJSONString());
            String response = HttpRequest.post((String)"http://171.34.133.170:11111//sys-auth/channel/oauth/token").contentType("application/json").body(authJsonObject.toJSONString()).execute().body();
            logger.info("\u81ea\u52a9\u673a\u9000\u8d39\u7edf\u4e00\u6388\u6743\u53cd\u53c2\u62a5\u6587\uff1a {}", (Object)response);
            JSONObject authResponse = JSONObject.parseObject((String)response);
            String accessToken = authResponse.getJSONObject("result").getString("accessToken");
            HashMap<String, Object> refundParam = new HashMap<String, Object>();
            refundParam.put("org_code", "64121");
            refundParam.put("mch_appid", "1719566108352495");
            refundParam.put("mch_order_id", UUIDUtils.getRandom((int)5, (boolean)true));
            refundParam.put("pay_out_trade_no", outOrderPayment.getPaymentTransactionNo());
            refundParam.put("refund_amt", outOrderPayment.getOwnCost().setScale(2, RoundingMode.HALF_UP));
            refundParam.put("refund_reason", "\u4ea4\u6613\u53d6\u6d88-\u9000\u6b3e");
            String signature = SelfHelpController.generateSignature(refundParam, (String)"497B3A0F3B6B4F61918F509B6C6AEBF4");
            refundParam.put("sign", SecureUtil.md5((String)(signature + "497B3A0F3B6B4F61918F509B6C6AEBF4")));
            refundParam.put("sign_type", "MD5");
            logger.info("\u81ea\u52a9\u673a\u9000\u8d39,\u9662\u5185\u652f\u4ed8\u5355\u53f7:{},\u5165\u53c2\u62a5\u6587\uff1a {}", (Object)outOrderPayment.getPayOrderNo(), (Object)JSONObject.toJSONString(refundParam));
            String refundResponse = ((HttpRequest)HttpRequest.post((String)"http://171.34.133.170:11111//jdpay/core/refund").contentType("application/json").header("Authorization-Token", accessToken)).body(JSONObject.toJSONString(refundParam)).execute().body();
            logger.info("\u81ea\u52a9\u673a\u9000\u8d39 \u9662\u5185\u652f\u4ed8\u5355\u53f7:{},\u53cd\u53c2\u62a5\u6587\uff1a {}", (Object)outOrderPayment.getPayOrderNo(), (Object)refundResponse);
            JSONObject refundResJson = JSONObject.parseObject((String)refundResponse);
            if (!refundResJson.getString("code").equals("200")) {
                throw new RunDisplayException(refundResJson.getString("message"));
            }
            String outTradeNo = refundResJson.getJSONObject("result").getString("out_trade_no");
            OutOrderPayment refundPayment = new OutOrderPayment();
            refundPayment.setId(outOrderPayment.getId());
            refundPayment.setRefundTransactionNo(outTradeNo);
            int updateCount = this.outOrderPaymentMapper.updateById((Object)refundPayment);
            logger.info("\u81ea\u52a9\u673a\u9000\u8d39\u4fee\u6539\u652f\u4ed8\u8bb0\u5f55\uff1a {}", (Object)updateCount);
            return ResponseData.success((Object)refundResJson);
        }
        return ResponseData.error((String)"\u6ca1\u627e\u5230\u8bb0\u5f55");
    }

    public static String generateSignature(Map<String, Object> params, String appSecret) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        keys.sort(String::compareTo);
        StringBuilder sb = new StringBuilder();
        for (String key : keys) {
            String value;
            Object valueObj = params.get(key);
            if (valueObj == null || (value = valueObj instanceof String ? (String)valueObj : (valueObj instanceof BigDecimal ? ((BigDecimal)valueObj).toString() : valueObj.toString())).isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(key).append("=").append(value);
        }
        sb.append("&key=").append(appSecret);
        return sb.toString();
    }

    @PostMapping(value={"/unilateralAccount"})
    @ApiOperation(value="\u5355\u8fb9\u8d26\u9000\u8d39 \u7cfb\u7edf\u663e\u793a\u9000\u8d39\u6210\u529f,\u60a3\u8005\u6ca1\u6536\u5230\u94b1")
    public ResponseData unilateralAccount(@RequestParam(value="payOrderNo") String payOrderNo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"pay_order_no", (Object)payOrderNo);
        OutOrderPayment outOrderPayment = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)queryWrapper);
        if (outOrderPayment == null) {
            return ResponseData.error((String)"\u672a\u627e\u5230\u652f\u4ed8\u8ba2\u5355");
        }
        return this.refundSelf(outOrderPayment);
    }

    @GetMapping(value={"/unilateralAccountByWX"})
    @ApiOperation(value="\u79d1\u5229\u5c14\u81ea\u52a9\u673a \u5355\u8fb9\u8d26\u9000\u8d39  \u60a3\u8005\u4ed8\u4e86\u94b1 , \u7cfb\u7edf\u663e\u793a\u672a\u6536\u8d39")
    public ResponseData unilateralAccount(@RequestParam(value="payOutTradeNo") String payOutTradeNo, @RequestParam(value="refundAmt") String refundAmt) {
        BigDecimal REFUND_AMT = new BigDecimal(refundAmt);
        logger.info("\u5373\u5c06\u5f00\u59cb\u81ea\u52a9\u673a\u9000\u8d39!!");
        String APP_SECRET = "497B3A0F3B6B4F61918F509B6C6AEBF4";
        String AUTH_URL = "http://171.34.133.170:11111//sys-auth/channel/oauth/token";
        String REFUND_URL = "http://171.34.133.170:11111//jdpay/core/refund";
        JSONObject authJsonObject = new JSONObject();
        authJsonObject.put("appKey", (Object)"1719566108352495");
        authJsonObject.put("appSecret", (Object)"497B3A0F3B6B4F61918F509B6C6AEBF4");
        logger.info("\u81ea\u52a9\u673a\u9000\u8d39\u7edf\u4e00\u6388\u6743\u5165\u53c2\u62a5\u6587\uff1a {}", (Object)authJsonObject.toJSONString());
        String response = HttpRequest.post((String)"http://171.34.133.170:11111//sys-auth/channel/oauth/token").contentType("application/json").body(authJsonObject.toJSONString()).execute().body();
        logger.info("\u81ea\u52a9\u673a\u9000\u8d39\u7edf\u4e00\u6388\u6743\u53cd\u53c2\u62a5\u6587\uff1a {}", (Object)response);
        JSONObject authResponse = JSONObject.parseObject((String)response);
        String accessToken = authResponse.getJSONObject("result").getString("accessToken");
        HashMap<String, Object> refundParam = new HashMap<String, Object>();
        refundParam.put("org_code", "64121");
        refundParam.put("mch_appid", "1719566108352495");
        refundParam.put("mch_order_id", UUIDUtils.getRandom((int)5, (boolean)true));
        refundParam.put("pay_out_trade_no", payOutTradeNo);
        refundParam.put("refund_amt", REFUND_AMT);
        refundParam.put("refund_reason", "\u4ea4\u6613\u53d6\u6d88-\u9000\u6b3e");
        String signature = SelfHelpController.generateSignature(refundParam, (String)"497B3A0F3B6B4F61918F509B6C6AEBF4");
        refundParam.put("sign", SecureUtil.md5((String)(signature + "497B3A0F3B6B4F61918F509B6C6AEBF4")));
        refundParam.put("sign_type", "MD5");
        logger.info("\u81ea\u52a9\u673a\u9000\u8d39\u53d1\u8d77:{},\u5165\u53c2\u62a5\u6587\uff1a {}", (Object)payOutTradeNo, (Object)JSONObject.toJSONString(refundParam));
        String refundResponse = ((HttpRequest)HttpRequest.post((String)"http://171.34.133.170:11111//jdpay/core/refund").contentType("application/json").header("Authorization-Token", accessToken)).body(JSONObject.toJSONString(refundParam)).execute().body();
        logger.info("\u81ea\u52a9\u673a\u9000\u8d39\u53d1\u8d77:{},\u53cd\u53c2\u62a5\u6587\uff1a {}", (Object)payOutTradeNo, (Object)refundResponse);
        return ResponseData.success((Object)refundResponse);
    }

    @GetMapping(value={"/unilateralRefundByWX"})
    @ApiOperation(value="\u5fae\u76df\u81ea\u52a9\u673a \u5355\u8fb9\u8d26\u9000\u8d39\u60a3\u8005\u4ed8\u4e86\u94b1 , \u7cfb\u7edf\u663e\u793a\u672a\u6536\u8d39")
    public ResponseData unilateralRefund(@RequestParam(value="payOutTradeNo") String payOutTradeNo, @RequestParam(value="refundAmt") String refundAmt) {
        String REFUND_URL = "http://171.34.133.170:9091/wxPay/refund";
        String API_KEY = "3F634C6B6BA3527EFDEAAF3506C4ADDC";
        JSONObject inParam = new JSONObject();
        inParam.put("key", (Object)"3F634C6B6BA3527EFDEAAF3506C4ADDC");
        inParam.put("outRefundNo", (Object)UUIDUtils.getRandom((int)5, (boolean)true));
        inParam.put("outTradeNo", (Object)payOutTradeNo);
        BigDecimal fenFactor = new BigDecimal("100");
        Integer amt = new BigDecimal(refundAmt).setScale(2, RoundingMode.HALF_UP).multiply(fenFactor).intValue();
        inParam.put("totalFee", (Object)amt);
        inParam.put("refundFee", (Object)amt);
        String refundResponse = HttpRequest.post((String)"http://171.34.133.170:9091/wxPay/refund").contentType("application/json").body(inParam.toJSONString()).execute().body();
        logger.info("\u5fae\u76df\u81ea\u52a9\u673a\u9000\u8d39\u53d1\u8d77:{},\u53cd\u53c2\u62a5\u6587\uff1a {}", (Object)payOutTradeNo, (Object)refundResponse);
        return ResponseData.success((Object)refundResponse);
    }

    public SelfHelpController(OutOrderPaymentService outOrderPaymentService, ScheduleService scheduleService, OutpatientTypeService outpatientTypeService, AdmissionService admissionService, OutPayService outPayService, OutOrderService outOrderService, SelfHelpService selfHelpService, OutDoctorTypeService outDoctorTypeService, SysServiceFeign sysServiceFeign, OutOrderPaymentMapper outOrderPaymentMapper) {
        this.outOrderPaymentService = outOrderPaymentService;
        this.scheduleService = scheduleService;
        this.outpatientTypeService = outpatientTypeService;
        this.admissionService = admissionService;
        this.outPayService = outPayService;
        this.outOrderService = outOrderService;
        this.selfHelpService = selfHelpService;
        this.outDoctorTypeService = outDoctorTypeService;
        this.sysServiceFeign = sysServiceFeign;
        this.outOrderPaymentMapper = outOrderPaymentMapper;
    }
}

