/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.rabbitListener;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.outpatient.api.enums.AdmissionStatusEnum;
import com.byh.outpatient.api.model.admission.AdmissionEntity;
import com.byh.outpatient.api.util.ExceptionUtils;
import com.byh.outpatient.data.repository.AdmissionMapper;
import com.byh.outpatient.data.repository.OutPrescriptionMapper;
import com.byh.outpatient.data.repository.OutPrescriptionRecordMapper;
import com.rabbitmq.client.Channel;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Component
public class OutpatientArchivingTimeoutListener {
    private static final Logger logger = LoggerFactory.getLogger(OutpatientArchivingTimeoutListener.class);
    @Resource
    private AdmissionMapper admissionMapper;
    @Resource
    private OutPrescriptionMapper outPrescriptionMapper;
    @Resource
    private OutPrescriptionRecordMapper outPrescriptionRecordMapper;
    @Autowired
    private PlatformTransactionManager transactionManager;

    @RabbitHandler
    @RabbitListener(queues={"outpatient.delayed.outpatientArchivingOvertime.queue"})
    @Transactional(rollbackFor={Exception.class})
    public void outpatientArchivingTimeout(Channel channel, Message message) throws Exception {
        String msg = new String(message.getBody());
        String messageId = message.getMessageProperties().getMessageId();
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)def);
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)msg);
            String outpatientNo = jsonObject.getString("outpatientNo");
            Integer tenantId = jsonObject.getInteger("tenantId");
            LambdaQueryWrapper admissionQuery = Wrappers.lambdaQuery();
            admissionQuery.eq(AdmissionEntity::getOutpatientNo, (Object)outpatientNo);
            admissionQuery.eq(AdmissionEntity::getTenantId, (Object)tenantId);
            AdmissionEntity admission = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)admissionQuery);
            if (admission == null) {
                ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)"\u6839\u636e\u95e8\u8bca\u53f7\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6302\u53f7\u4fe1\u606f\uff01");
            }
            if (AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(admission.getStatus()) || AdmissionStatusEnum.DOCTOR_CANCEL.getValue().equals(admission.getStatus()) || AdmissionStatusEnum.RETIRMENT.getValue().equals(admission.getStatus()) || AdmissionStatusEnum.ARCHIVED.getValue().equals(admission.getStatus())) {
                ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)"\u72b6\u6001\u5f02\u5e38\uff0c\u65e0\u6cd5\u6267\u884c\u5f52\u6863\u64cd\u4f5c");
            }
            admission.setStatus(AdmissionStatusEnum.ARCHIVED.getValue());
            admission.setUpdateId(Integer.valueOf(1));
            admission.setUpdateName("24\u5c0f\u65f6\u75c5\u5386\u5f52\u6863");
            admission.setUpdateTime(new Date());
            int updateCount = this.admissionMapper.updateById((Object)admission);
            if (updateCount < 1) {
                ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)"\u5f52\u6863\u5931\u8d25\uff01");
            }
            channel.basicAck(message.getMessageProperties().getDeliveryTag(), false);
        }
        catch (Exception e) {
            this.transactionManager.rollback(status);
            channel.basicAck(message.getMessageProperties().getDeliveryTag(), false);
            return;
        }
    }
}

