/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.outpatient.api.dto.medicalRecord.ImplementDto;
import com.byh.outpatient.api.dto.medicalRecord.OutpatientInfomationDto;
import com.byh.outpatient.api.dto.medicalRecord.QueryExecutionDto;
import com.byh.outpatient.api.dto.order.SaveOrderDto;
import com.byh.outpatient.api.dto.treatment.PrintItemDto;
import com.byh.outpatient.api.dto.treatment.PrintItemsDto;
import com.byh.outpatient.api.dto.treatment.QueryExecutionRecordsDto;
import com.byh.outpatient.api.dto.treatment.QueryInspectionChecklistDto;
import com.byh.outpatient.api.dto.treatment.QueryItemRecordsDto;
import com.byh.outpatient.api.dto.treatment.QueryItemsDto;
import com.byh.outpatient.api.dto.treatment.SaveTreatmentItemsDto;
import com.byh.outpatient.api.enums.DeliveryStatusEnum;
import com.byh.outpatient.api.enums.GenderEnum;
import com.byh.outpatient.api.enums.OrderTypeEnum;
import com.byh.outpatient.api.enums.OutpatientDataStatusEnum;
import com.byh.outpatient.api.enums.PaymentRecordsStatusEnum;
import com.byh.outpatient.api.enums.PaymentStatusEnum;
import com.byh.outpatient.api.model.admission.AdmissionEntity;
import com.byh.outpatient.api.model.order.OutOrder;
import com.byh.outpatient.api.model.patient.PatientEntity;
import com.byh.outpatient.api.model.treatment.OutTreatmentDetails;
import com.byh.outpatient.api.model.treatment.OutTreatmentImplement;
import com.byh.outpatient.api.model.treatment.OutTreatmentItems;
import com.byh.outpatient.api.sysModel.request.SysDeptDto;
import com.byh.outpatient.api.sysModel.request.SysDictValueDTO;
import com.byh.outpatient.api.sysModel.respones.BasePageEntity;
import com.byh.outpatient.api.sysModel.respones.SysDepartmentVo;
import com.byh.outpatient.api.sysModel.respones.SysDictValueVo;
import com.byh.outpatient.api.sysModel.respones.SysTreatmentChargeVo;
import com.byh.outpatient.api.sysModel.respones.SysTreatmentItemVo;
import com.byh.outpatient.api.util.ExceptionUtils;
import com.byh.outpatient.api.util.HyposensitizationUtil;
import com.byh.outpatient.api.util.PageResult;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.StringUtil;
import com.byh.outpatient.api.util.UUIDUtils;
import com.byh.outpatient.api.vo.OutTreatmentDfmResVo;
import com.byh.outpatient.api.vo.OutTreatmentDfmVo;
import com.byh.outpatient.api.vo.medicalRecord.QueryOutpatientMedicalRecordsVo;
import com.byh.outpatient.api.vo.order.QueryFeeDetailsListVo;
import com.byh.outpatient.api.vo.prescription.QueryExecutionListVo;
import com.byh.outpatient.api.vo.treatment.PrintTemplateVo;
import com.byh.outpatient.api.vo.treatment.QueryExecutionRecordsVo;
import com.byh.outpatient.api.vo.treatment.QueryItemsVo;
import com.byh.outpatient.data.repository.AdmissionMapper;
import com.byh.outpatient.data.repository.OutOrderMapper;
import com.byh.outpatient.data.repository.OutTreatmentDetailsMapper;
import com.byh.outpatient.data.repository.OutTreatmentImplementMapper;
import com.byh.outpatient.data.repository.OutTreatmentItemsMapper;
import com.byh.outpatient.web.feign.SysServiceFeign;
import com.byh.outpatient.web.mvc.controller.RocketMQProducerController;
import com.byh.outpatient.web.mvc.exception.RunDisplayException;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.rocket.RocketMQProducer;
import com.byh.outpatient.web.service.OutMedicalRecordService;
import com.byh.outpatient.web.service.OutOrderService;
import com.byh.outpatient.web.service.TreatmentItemsService;
import com.byh.outpatient.web.service.impl.TreatmentItemsServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.SendCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class TreatmentItemsServiceImpl
implements TreatmentItemsService {
    private static final Logger log = LoggerFactory.getLogger(TreatmentItemsServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(RocketMQProducerController.class);
    private static final Integer maxSize = 204800;
    private static final String topic = "rocketMQ-out-doctor";
    private static final String patientTopic = "rocketMQ-out-patientTopic";
    private static final String patientPaymentTopic = "rocketMQ-out-patientPaymentTopic";
    private static final String admissionTopic = "rocketMQ-out-admissionTopic";
    private static final String prescriptionDetailTopic = "rocketMQ-out-prescriptionDetailTopic";
    private static final String treatmentItemsTopic = "rocketMQ-out-treatmentItemsTopic";
    @Value(value="${remote.wechatPushUrl}")
    private String wechatPushUrl;
    @Autowired
    private CommonRequest commonRequest;
    private final RocketMQProducer rocketMQProducer;
    @Autowired
    private OutTreatmentItemsMapper outTreatmentItemsMapper;
    @Autowired
    private OutTreatmentDetailsMapper outTreatmentDetailsMapper;
    @Autowired
    private OutOrderService outOrderService;
    @Autowired
    private SysServiceFeign sysServiceFeign;
    @Autowired
    private OutMedicalRecordService outMedicalRecordService;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private OutOrderMapper outOrderMapper;
    @Autowired
    private OutTreatmentImplementMapper outTreatmentImplementMapper;

    public ResponseData<List<QueryItemsVo>> queryItems(QueryItemsDto parameter) {
        List outTreatmentItems = this.outTreatmentItemsMapper.queryItems(parameter);
        outTreatmentItems.forEach(queryItemsVo -> {
            queryItemsVo.setOutTreatmentId(queryItemsVo.getId());
            queryItemsVo.setTreatmentCategoryName(OrderTypeEnum.getEnumByProjectType((String)String.valueOf(queryItemsVo.getTreatmentCategory())).getName());
        });
        return ResponseData.success((Object)outTreatmentItems);
    }

    public ResponseData<List<QueryItemsVo>> queryTreatmentItemByOutpatientNo(OutTreatmentItems parameter) {
        PageHelper.startPage((int)1, (int)10);
        List itemsList = this.outTreatmentItemsMapper.queryTreatmentItemByOutpatientNo(parameter);
        PageInfo page = new PageInfo(itemsList);
        return ResponseData.success((Object)itemsList);
    }

    public ResponseData<List<QueryFeeDetailsListVo>> queryItemsDetails(QueryItemsDto parameter) {
        List<Object> list = new ArrayList();
        if (parameter.getOutTreatmentId() == null) {
            Integer[] ids;
            ResponseData listResponseData;
            String treatmentItemsNo = parameter.getTreatmentItemsNo();
            if (StrUtil.isEmpty((CharSequence)treatmentItemsNo)) {
                ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)"\u9879\u76ee\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            }
            if (!(listResponseData = this.sysServiceFeign.selectListWithChargeItems(ids = new Integer[]{Integer.parseInt(treatmentItemsNo)})).isSuccess() || listResponseData.getData() == null) {
                return ResponseData.success();
            }
            for (SysTreatmentItemVo vo : (List)listResponseData.getData()) {
                List chargeList = vo.getSysTreatmentChargeVoList();
                if (chargeList.isEmpty()) {
                    ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)"\u8be5\u8bca\u7597\u9879\u76ee\u672a\u6dfb\u52a0\u5bf9\u5e94\u7684\u6536\u8d39\u9879\u76ee\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u7ef4\u62a4\uff01");
                }
                list = chargeList.stream().map(chargeVo -> {
                    QueryFeeDetailsListVo feeDetailsListVo = new QueryFeeDetailsListVo();
                    feeDetailsListVo.setMedicalInsuranceCode(chargeVo.getMedicalInsuranceCode());
                    feeDetailsListVo.setMedicalInsuranceName(chargeVo.getMedicalInsuranceName());
                    feeDetailsListVo.setInsuranceDrugCode(chargeVo.getMedicalInsuranceCode());
                    feeDetailsListVo.setLevel(chargeVo.getChargeItemLevel());
                    feeDetailsListVo.setName(chargeVo.getChargeItemName());
                    feeDetailsListVo.setDrugPriceAmount(chargeVo.getItemPrice());
                    feeDetailsListVo.setQuantity(BigDecimal.valueOf(chargeVo.getQuantity().intValue()));
                    feeDetailsListVo.setFeeRemark(chargeVo.getFeeRemark());
                    feeDetailsListVo.setUnit(chargeVo.getUnit());
                    return feeDetailsListVo;
                }).collect(Collectors.toList());
            }
        } else {
            Integer outTreatmentId = parameter.getOutTreatmentId();
            if (outTreatmentId == null) {
                ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)"\u5df2\u5f00\u7acb\u7684\u8bca\u7597\u9879\u76ee\u4e3b\u952e\u7f16\u53f7\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            }
            List outTreatmentDetailsList = this.outTreatmentDetailsMapper.selectListWithFeeRemark(outTreatmentId);
            list = outTreatmentDetailsList.stream().map(outTreatmentVo -> {
                QueryFeeDetailsListVo feeDetailsListVo = new QueryFeeDetailsListVo();
                BeanUtils.copyProperties((Object)outTreatmentVo, (Object)feeDetailsListVo);
                feeDetailsListVo.setInsuranceDrugCode(outTreatmentVo.getMedicalInsuranceCode());
                feeDetailsListVo.setName(outTreatmentVo.getTreatmentName());
                BigDecimal price = outTreatmentVo.getUnitPriceAmount();
                BigDecimal quantity = BigDecimal.valueOf(outTreatmentVo.getQuantity().intValue());
                BigDecimal totalAmount = price.multiply(quantity);
                feeDetailsListVo.setDrugPriceAmount(price);
                feeDetailsListVo.setQuantity(quantity);
                feeDetailsListVo.setTotalDrugAmount(totalAmount);
                return feeDetailsListVo;
            }).collect(Collectors.toList());
            System.out.println();
        }
        return ResponseData.success(list);
    }

    public ResponseData<String> saveTreatmentItems(SaveTreatmentItemsDto parameter) {
        QueryWrapper queryAdmissionEntity = new QueryWrapper();
        queryAdmissionEntity.eq((Object)"outpatient_no", (Object)parameter.getOutpatientNo());
        AdmissionEntity admissionEntity = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)queryAdmissionEntity);
        if (ObjectUtils.isEmpty((Object)admissionEntity)) {
            throw new RunDisplayException("\u95e8\u8bca\u8bb0\u5f55\u67e5\u8be2\u5931\u8d25");
        }
        List projectList = parameter.getProjectList();
        if (CollectionUtils.isEmpty((Collection)projectList)) {
            throw new RunDisplayException("\u9879\u76ee\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        List ids = parameter.getProjectList().stream().map(SaveTreatmentItemsDto.Project::getItemsNo).collect(Collectors.toList());
        Integer[] integerArray = (Integer[])ids.stream().map(Integer::parseInt).toArray(Integer[]::new);
        ResponseData listResponseData = this.sysServiceFeign.selectListWithChargeItems(integerArray);
        if (!listResponseData.isSuccess() || listResponseData.getData() == null) {
            ResponseData.success();
        }
        if (ids.size() != ((List)listResponseData.getData()).size()) {
            throw new RunDisplayException("\u67e5\u8be2\u9879\u76ee\u7f3a\u5931\uff01");
        }
        List sysTreatmentItemVos = ((List)listResponseData.getData()).stream().filter(x -> !"1".equals(x.getExecuteDeptFlag())).collect(Collectors.toList());
        SysDepartmentVo sysDepartmentVo = new SysDepartmentVo();
        if (CollectionUtils.isNotEmpty(sysTreatmentItemVos)) {
            SysDeptDto sysDeptDto = new SysDeptDto();
            sysDeptDto.setId(admissionEntity.getDeptId());
            ResponseData sysDepartmentVoResponseData = this.sysServiceFeign.deptInfoById(sysDeptDto);
            if (Objects.isNull(sysDepartmentVoResponseData) || !sysDepartmentVoResponseData.isSuccess()) {
                return ResponseData.error((String)"\u79d1\u5ba4\u4fe1\u606f\u67e5\u8be2\u5931\u8d25{}", (String)JSONObject.toJSONString((Object)sysDepartmentVoResponseData));
            }
            sysDepartmentVo = (SysDepartmentVo)JSON.parseObject((String)JSON.toJSONString((Object)sysDepartmentVoResponseData.getData()), SysDepartmentVo.class);
            if (Objects.isNull(sysDepartmentVo)) {
                return ResponseData.error((String)"\u79d1\u5ba4\u4fe1\u606f\u67e5\u8be2\u5931\u8d25{}", (String)JSONObject.toJSONString((Object)sysDepartmentVo));
            }
        }
        Map itemMap = ((List)listResponseData.getData()).stream().collect(Collectors.toMap(BasePageEntity::getId, Function.identity()));
        ArrayList treatmentDetails = new ArrayList();
        ArrayList<OutTreatmentItems> itemsList = new ArrayList<OutTreatmentItems>();
        ArrayList<AdmissionEntity> admissionList = new ArrayList<AdmissionEntity>();
        for (SaveTreatmentItemsDto.Project project : parameter.getProjectList()) {
            SysTreatmentItemVo itemVo = (SysTreatmentItemVo)itemMap.get(Integer.parseInt(project.getItemsNo()));
            OutTreatmentItems treatmentItems = new OutTreatmentItems();
            treatmentItems.setTreatmentNo(UUIDUtils.getTreatmentNo());
            treatmentItems.setCreateId(parameter.getOperatorId());
            treatmentItems.setTenantId(parameter.getTenantId());
            treatmentItems.setItemsNo(project.getItemsNo());
            treatmentItems.setName(itemVo.getItemName());
            treatmentItems.setUnit(itemVo.getUnit());
            treatmentItems.setOutpatientNo(parameter.getOutpatientNo());
            treatmentItems.setMedicalRecordNo(admissionEntity.getMedicalRecordNo());
            treatmentItems.setTreatmentCategory(Integer.valueOf(itemVo.getTreatmentTypeCode()));
            treatmentItems.setQuantity(project.getQuantity());
            treatmentItems.setAbsenceExecutedQuantity(project.getQuantity());
            treatmentItems.setExecutedQuantity(Integer.valueOf(0));
            treatmentItems.setUnitPriceAmount(itemVo.getTotalPrice());
            treatmentItems.setTotalAmount(treatmentItems.getUnitPriceAmount().multiply(new BigDecimal(treatmentItems.getQuantity())));
            treatmentItems.setRemark(project.getRemark());
            treatmentItems.setPrescribingDoctorId(parameter.getOperatorId());
            treatmentItems.setPrescribingDoctorName(parameter.getOperatorName());
            treatmentItems.setIssueTime(new Date());
            treatmentItems.setStatus(PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
            treatmentItems.setPrescribingDepartmentId(parameter.getPrescribingDepartmentId());
            treatmentItems.setPrescribingDepartmentName(parameter.getPrescribingDepartmentName());
            treatmentItems.setHospitalId(parameter.getHospitalId());
            treatmentItems.setHospitalName(parameter.getHospitalName());
            treatmentItems.setDiagCode(parameter.getDiagCode());
            treatmentItems.setDiagName(parameter.getDiagName());
            if ("1".equals(itemVo.getExecuteDeptFlag())) {
                treatmentItems.setExecutedDeptId(itemVo.getExecuteDeptId());
                treatmentItems.setExecutedDept(itemVo.getExecuteDeptName());
                treatmentItems.setExecutedDeptPosition(itemVo.getExecuteDeptPosition());
            } else {
                treatmentItems.setExecutedDeptId(admissionEntity.getDeptId());
                treatmentItems.setExecutedDept(admissionEntity.getDeptName());
                treatmentItems.setExecutedDeptPosition(sysDepartmentVo.getPosition());
            }
            treatmentItems.setSpecimen(itemVo.getSpecimen());
            treatmentItems.setSpecimenLabel(itemVo.getSpecimenLabel());
            treatmentItems.setInspectType(itemVo.getInspectType());
            treatmentItems.setInspectTypeLabel(itemVo.getInspectTypeLabel());
            treatmentItems.setItemsCode(itemVo.getItemCode());
            if (treatmentItems.getTotalAmount().compareTo(project.getTotalAmount()) != 0) {
                return ResponseData.error((String)"\u91d1\u989d\u6821\u9a8c\u9519\u8bef\uff01");
            }
            this.outTreatmentItemsMapper.insert((Object)treatmentItems);
            itemsList.add(treatmentItems);
            SaveOrderDto saveOrderDto = new SaveOrderDto();
            saveOrderDto.setOperatorId(parameter.getOperatorId());
            saveOrderDto.setOperatorName(parameter.getOperatorName());
            saveOrderDto.setTenantId(parameter.getTenantId());
            saveOrderDto.setPrescriptionNo(String.valueOf(treatmentItems.getId()));
            saveOrderDto.setOutpatientNo(parameter.getOutpatientNo());
            saveOrderDto.setPatientId(admissionEntity.getPatientId());
            saveOrderDto.setPatientName(admissionEntity.getPatientName());
            saveOrderDto.setMedicalRecordNo(admissionEntity.getMedicalRecordNo());
            saveOrderDto.setOrderAmount(treatmentItems.getTotalAmount());
            saveOrderDto.setActualOtherPayment(new BigDecimal(0));
            saveOrderDto.setRegTime(DateUtil.formatDateTime((Date)new Date()));
            saveOrderDto.setPhone(admissionEntity.getPhone());
            saveOrderDto.setPatientCardNo(admissionEntity.getPatientCardNo());
            saveOrderDto.setSettleTypeCode(parameter.getSettleTypeCode());
            saveOrderDto.setSettleTypeName(parameter.getSettleTypeName());
            this.outOrderService.saveOrder(OrderTypeEnum.getEnumByProjectType((String)project.getProjectType()), saveOrderDto);
            SysTreatmentItemVo result = ((List)listResponseData.getData()).stream().filter(item -> itemVo.getItemCode().equals(item.getItemCode())).findFirst().orElse(new SysTreatmentItemVo());
            List detailsList = result.getSysTreatmentChargeVoList().stream().map(SysTreatmentChargeVo2 -> {
                OutTreatmentDetails outTreatmentDetails = new OutTreatmentDetails();
                outTreatmentDetails.setCreateId(parameter.getOperatorId());
                outTreatmentDetails.setTenantId(parameter.getTenantId());
                outTreatmentDetails.setOutTreatmentId(treatmentItems.getId());
                outTreatmentDetails.setUnit(SysTreatmentChargeVo2.getUnit());
                outTreatmentDetails.setTreatmentName(SysTreatmentChargeVo2.getChargeItemName());
                outTreatmentDetails.setMedicalInsuranceCode(SysTreatmentChargeVo2.getMedicalInsuranceCode());
                outTreatmentDetails.setMedicalInsuranceName(SysTreatmentChargeVo2.getMedicalInsuranceName());
                outTreatmentDetails.setInsuranceCode(SysTreatmentChargeVo2.getMedicalInsuranceCode());
                outTreatmentDetails.setInsuranceName(SysTreatmentChargeVo2.getMedicalInsuranceName());
                outTreatmentDetails.setMedicalInsuranceType(SysTreatmentChargeVo2.getMedicalInsuranceTypeCode());
                outTreatmentDetails.setMedicalInsuranceTypeName(SysTreatmentChargeVo2.getMedicalInsuranceTypeName());
                outTreatmentDetails.setLevel(SysTreatmentChargeVo2.getChargeItemLevel());
                Integer quantity = projectList.stream().filter(obj -> treatmentItems.getItemsNo().equals(obj.getItemsNo())).map(SaveTreatmentItemsDto.Project::getQuantity).findFirst().orElse(1);
                outTreatmentDetails.setQuantity(Integer.valueOf(SysTreatmentChargeVo2.getQuantity() * quantity));
                outTreatmentDetails.setUnitPriceAmount(SysTreatmentChargeVo2.getItemPrice());
                outTreatmentDetails.setTotalAmount(outTreatmentDetails.getUnitPriceAmount().multiply(new BigDecimal(outTreatmentDetails.getQuantity())));
                outTreatmentDetails.setTreatmentCode(SysTreatmentChargeVo2.getChargeItemCode());
                return outTreatmentDetails;
            }).collect(Collectors.toList());
            treatmentDetails.addAll(detailsList);
            this.pushWeChatMessage(saveOrderDto, admissionEntity);
        }
        this.outTreatmentDetailsMapper.batchInsert(treatmentDetails);
        try {
            ArrayList<PatientEntity> list = new ArrayList<PatientEntity>();
            PatientEntity patientEntity = new PatientEntity();
            itemsList.forEach(item -> {
                String unit;
                Integer status = item.getStatus();
                switch (status) {
                    case 0: {
                        item.setStatusName("\u5220\u9664");
                        break;
                    }
                    case 1: {
                        item.setStatusName("\u6b63\u5e38");
                        break;
                    }
                    case 2: {
                        item.setStatusName("\u5df2\u8fc7\u671f");
                        break;
                    }
                    case 3: {
                        item.setStatusName("\u5df2\u4f5c\u5e9f");
                    }
                }
                Integer id = item.getId();
                if (id == null) {
                    OutTreatmentItems items = (OutTreatmentItems)this.outTreatmentItemsMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutTreatmentItems::getOutpatientNo, (Object)item.getOutpatientNo())).eq(OutTreatmentItems::getStatus, (Object)item.getStatus())).eq(OutTreatmentItems::getItemsNo, (Object)item.getItemsNo())).eq(OutTreatmentItems::getItemsCode, (Object)item.getItemsCode()));
                    item.setId(items.getId());
                }
                if (StringUtils.isNotBlank((CharSequence)(unit = item.getUnit()))) {
                    SysDictValueDTO dto = new SysDictValueDTO();
                    dto.setValue(unit);
                    dto.setType("charge_unit");
                    ResponseData pageResponseData = this.sysServiceFeign.sysDictValueById(dto, parameter.getTenantId() + "");
                    String label = ((SysDictValueVo)((Page)pageResponseData.getData()).getRecords().get(0)).getLabel();
                    item.setUnitName(label);
                }
            });
            treatmentDetails.forEach(detail -> {
                String unit;
                Integer id = detail.getId();
                if (id == null) {
                    OutTreatmentDetails outTreatmentDetails = (OutTreatmentDetails)this.outTreatmentDetailsMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutTreatmentDetails::getOutTreatmentId, (Object)detail.getOutTreatmentId())).eq(OutTreatmentDetails::getTreatmentName, (Object)detail.getTreatmentName())).eq(OutTreatmentDetails::getTotalAmount, (Object)detail.getTotalAmount()));
                    detail.setId(outTreatmentDetails.getId());
                }
                if (StringUtils.isNotBlank((CharSequence)(unit = detail.getUnit()))) {
                    SysDictValueDTO dto = new SysDictValueDTO();
                    dto.setValue(unit);
                    dto.setType("charge_unit");
                    ResponseData pageResponseData = this.sysServiceFeign.sysDictValueById(dto, parameter.getTenantId() + "");
                    String label = ((SysDictValueVo)((Page)pageResponseData.getData()).getRecords().get(0)).getLabel();
                    detail.setUnitName(label);
                }
            });
            patientEntity.setItemsList(itemsList);
            patientEntity.setTreatmentDetailsList(treatmentDetails);
            admissionList.add(admissionEntity);
            patientEntity.setAdmissionList(admissionList);
            list.add(patientEntity);
            String msg = JSONObject.toJSONString(list);
            String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
            this.rocketMQProducer.asyncSendCallbackTimeoutLevel(treatmentItemsTopic, "TAG6", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ResponseData.success((Object)"\u64cd\u4f5c\u5b8c\u6210\uff01");
    }

    private void pushWeChatMessage(SaveOrderDto saveOrderDto, AdmissionEntity admissionEntity) {
        try {
            LambdaQueryWrapper outOrderLambdaQueryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)outOrderLambdaQueryWrapper.eq(OutOrder::getPrescriptionNo, (Object)saveOrderDto.getPrescriptionNo())).eq(OutOrder::getStatus, (Object)1)).last("limit 1");
            OutOrder outOrder = (OutOrder)this.outOrderMapper.selectOne((Wrapper)outOrderLambdaQueryWrapper);
            JSONObject sonJson = new JSONObject();
            sonJson.put("orderNo", (Object)outOrder.getOrderNo());
            sonJson.put("patientName", (Object)admissionEntity.getPatientName());
            sonJson.put("patientId", (Object)admissionEntity.getPatientId());
            switch (outOrder.getOrderType()) {
                case "10": {
                    sonJson.put("orderType", (Object)"\u6302\u53f7");
                    break;
                }
                case "20": {
                    sonJson.put("orderType", (Object)"\u897f\u836f\u5904\u65b9");
                    break;
                }
                case "30": {
                    sonJson.put("orderType", (Object)"\u4e2d\u836f\u5904\u65b9");
                    break;
                }
                case "40": {
                    sonJson.put("orderType", (Object)"\u4e2d\u6210\u836f\u5904\u65b9");
                    break;
                }
                case "50": {
                    sonJson.put("orderType", (Object)"\u68c0\u9a8c\u8d39");
                    break;
                }
                case "51": {
                    sonJson.put("orderType", (Object)"\u68c0\u67e5\u8d39");
                    break;
                }
                case "53": {
                    sonJson.put("orderType", (Object)"\u6cbb\u7597\u8d39");
                    break;
                }
                case "54": {
                    sonJson.put("orderType", (Object)"\u624b\u672f\u8d39");
                    break;
                }
                default: {
                    sonJson.put("orderType", (Object)"\u533b\u7597\u8d39\u7528");
                }
            }
            sonJson.put("orderDate", (Object)outOrder.getCreateTime());
            sonJson.put("amount", (Object)outOrder.getAmount().setScale(2, RoundingMode.HALF_UP));
            JSONObject totalJson = new JSONObject();
            totalJson.put("cardNo", (Object)admissionEntity.getPatientCardNo());
            totalJson.put("jsonString", (Object)JSONObject.toJSONString((Object)sonJson));
            totalJson.put("type", (Object)"mzjf");
            log.info("\u63a8\u9001\u95e8\u8bca\u7f34\u8d39\u901a\u77e5" + JSONObject.toJSONString((Object)totalJson) + "___" + this.wechatPushUrl);
            String post = HttpUtil.post((String)this.wechatPushUrl, (String)JSONObject.toJSONString((Object)totalJson));
            log.info("\u63a8\u9001\u95e8\u8bca\u7f34\u8d39\u8fd4\u56de" + JSONObject.toJSONString((Object)post));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ResponseData<String> voidItems(QueryItemsDto parameter) {
        if (StringUtils.isEmpty((CharSequence)parameter.getTreatmentItemsNo())) {
            ResponseData.error((String)"\u6cbb\u7597\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
        queryWrapper.eq((Object)"id", (Object)parameter.getOutTreatmentId());
        OutTreatmentItems outTreatmentItems = (OutTreatmentItems)this.outTreatmentItemsMapper.selectOne((Wrapper)queryWrapper);
        if (outTreatmentItems == null) {
            return ResponseData.error((String)"\u6ca1\u6709\u627e\u5230\u9879\u76ee");
        }
        QueryWrapper queryrOrder = new QueryWrapper();
        ((QueryWrapper)queryrOrder.in((Object)"prescription_no", new Object[]{outTreatmentItems.getId()})).eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
        OutOrder outOrder = (OutOrder)this.outOrderMapper.selectOne((Wrapper)queryrOrder);
        if (outOrder == null) {
            return ResponseData.error((String)"\u6ca1\u6709\u627e\u5230\u8ba2\u5355");
        }
        if (!outOrder.getPaymentStatus().equals(PaymentStatusEnum.PAYMENT_PENDING.getValue())) {
            return ResponseData.error((String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01");
        }
        outOrder.setStatus(OutpatientDataStatusEnum.STATUS_VOID.getValue());
        this.outOrderMapper.updateById((Object)outOrder);
        outTreatmentItems.setStatus(PaymentRecordsStatusEnum.STATUS_VOID.getValue());
        outTreatmentItems.setUpdateId(parameter.getOperatorId());
        this.outTreatmentItemsMapper.updateById((Object)outTreatmentItems);
        try {
            ArrayList<PatientEntity> list = new ArrayList<PatientEntity>();
            PatientEntity patientEntity = new PatientEntity();
            ArrayList<AdmissionEntity> admissionList = new ArrayList<AdmissionEntity>();
            AdmissionEntity admissionEntity = new AdmissionEntity();
            ArrayList<OutTreatmentItems> itemsList = new ArrayList<OutTreatmentItems>();
            itemsList.add(outTreatmentItems);
            itemsList.forEach(item -> {
                String unit;
                Integer status = item.getStatus();
                switch (status) {
                    case 0: {
                        item.setStatusName("\u5220\u9664");
                        break;
                    }
                    case 1: {
                        item.setStatusName("\u6b63\u5e38");
                        break;
                    }
                    case 2: {
                        item.setStatusName("\u5df2\u8fc7\u671f");
                        break;
                    }
                    case 3: {
                        item.setStatusName("\u5df2\u4f5c\u5e9f");
                    }
                }
                Integer id = item.getId();
                if (id == null) {
                    OutTreatmentItems items = (OutTreatmentItems)this.outTreatmentItemsMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutTreatmentItems::getOutpatientNo, (Object)item.getOutpatientNo())).eq(OutTreatmentItems::getStatus, (Object)item.getStatus())).eq(OutTreatmentItems::getItemsNo, (Object)item.getItemsNo())).eq(OutTreatmentItems::getItemsCode, (Object)item.getItemsCode()));
                    item.setId(items.getId());
                }
                if (StringUtils.isNotBlank((CharSequence)(unit = item.getUnit()))) {
                    SysDictValueDTO dto = new SysDictValueDTO();
                    dto.setValue(unit);
                    dto.setType("charge_unit");
                    ResponseData pageResponseData = this.sysServiceFeign.sysDictValueById(dto, parameter.getTenantId() + "");
                    String label = ((SysDictValueVo)((Page)pageResponseData.getData()).getRecords().get(0)).getLabel();
                    item.setUnitName(label);
                }
            });
            patientEntity.setItemsList(itemsList);
            admissionList.add(admissionEntity);
            patientEntity.setAdmissionList(admissionList);
            list.add(patientEntity);
            String msg = JSONObject.toJSONString(list);
            String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
            this.rocketMQProducer.asyncSendCallbackTimeoutLevel(treatmentItemsTopic, "TAG6", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ResponseData.success((Object)"\u64cd\u4f5c\u5b8c\u6210");
    }

    public ResponseData<PageResult<QueryExecutionListVo>> queryExecutionList(QueryExecutionDto parameter) {
        if (!StringUtil.isEmpty((String)parameter.getStartTime()) && !StringUtil.isEmpty((String)parameter.getEndTime())) {
            parameter.setStartTime(parameter.getStartTime() + " 00:00:00");
            parameter.setEndTime(parameter.getEndTime() + " 23:59:59");
        }
        if (parameter.getCurrent() == null || parameter.getSize() == null) {
            return ResponseData.error((String)"\u9875\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageHelper.startPage((int)parameter.getCurrent(), (int)parameter.getSize());
        List queryExecutionList = this.outTreatmentItemsMapper.queryExecutionList(parameter);
        for (QueryExecutionListVo record : queryExecutionList) {
            String patientName = HyposensitizationUtil.hyposensitizationForName((String)record.getPatientName());
            record.setPatientName(patientName);
        }
        PageInfo pageInfo = new PageInfo(queryExecutionList);
        PageResult pageResult = new PageResult(parameter.getCurrent().intValue(), parameter.getSize().intValue());
        pageResult.setTotal(Integer.parseInt(String.valueOf(pageInfo.getTotal())));
        pageResult.setPages(pageInfo.getPages());
        pageResult.setRecords(queryExecutionList);
        pageResult.setCurrent(parameter.getCurrent().intValue());
        pageResult.setSize(parameter.getSize().intValue());
        return ResponseData.success((Object)pageResult);
    }

    public ResponseData<PageResult<QueryItemsVo>> queryItemRecords(QueryItemRecordsDto parameter) {
        PageHelper.startPage((int)parameter.getCurrent(), (int)parameter.getSize());
        List queryItemsVos = this.outTreatmentItemsMapper.queryItemRecords(parameter);
        if (!"excel".equals(parameter.getQueryType())) {
            for (QueryItemsVo record : queryItemsVos) {
                String patientName = HyposensitizationUtil.hyposensitizationForName((String)record.getPatientName());
                String cardNo = HyposensitizationUtil.hyposensitizationForCardNo((String)record.getPatientCardNo());
                record.setPatientName(patientName);
                record.setPatientCardNo(cardNo);
            }
        }
        PageInfo pageInfo = new PageInfo(queryItemsVos);
        PageResult pageResult = new PageResult(parameter.getCurrent().intValue(), parameter.getSize().intValue());
        pageResult.setTotal(Integer.parseInt(String.valueOf(pageInfo.getTotal())));
        pageResult.setPages(pageInfo.getPages());
        pageResult.setRecords(queryItemsVos);
        pageResult.setCurrent(parameter.getCurrent().intValue());
        pageResult.setSize(parameter.getSize().intValue());
        return ResponseData.success((Object)pageResult);
    }

    public ResponseData<String> implement(ImplementDto parameter) {
        if (null == parameter.getId()) {
            return ResponseData.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
        queryWrapper.eq((Object)"id", (Object)parameter.getId());
        OutTreatmentItems outTreatmentItems = (OutTreatmentItems)this.outTreatmentItemsMapper.selectOne((Wrapper)queryWrapper);
        if (outTreatmentItems == null) {
            return ResponseData.error((String)"\u6ca1\u6709\u627e\u5230\u9879\u76ee\uff01");
        }
        QueryWrapper queryrOrder = new QueryWrapper();
        ((QueryWrapper)queryrOrder.in((Object)"prescription_no", new Object[]{outTreatmentItems.getId()})).eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
        OutOrder outOrder = (OutOrder)this.outOrderMapper.selectOne((Wrapper)queryrOrder);
        if (outOrder == null) {
            return ResponseData.error((String)"\u6ca1\u6709\u627e\u5230\u8ba2\u5355\uff01");
        }
        if (!PaymentStatusEnum.PAYMENT_COMPLETED.getValue().equals(outOrder.getPaymentStatus())) {
            return ResponseData.error((String)"\u8bf7\u5148\u652f\u4ed8\u8ba2\u5355\uff01");
        }
        OutTreatmentImplement outTreatmentImplement = new OutTreatmentImplement();
        outTreatmentImplement.setTenantId(parameter.getTenantId());
        outTreatmentImplement.setOutTreatmentId(outTreatmentItems.getId());
        outTreatmentImplement.setOperatorId(parameter.getOperatorId());
        outTreatmentImplement.setOperatorName(parameter.getOperatorName());
        outTreatmentImplement.setVerifierId(parameter.getVerifierID());
        outTreatmentImplement.setVerifierName(parameter.getVerifier());
        outTreatmentImplement.setUpdateTime(new Date());
        outTreatmentImplement.setRemark(parameter.getRemarks());
        this.outTreatmentImplementMapper.insert((Object)outTreatmentImplement);
        outTreatmentItems.setAbsenceExecutedQuantity(Integer.valueOf(outTreatmentItems.getAbsenceExecutedQuantity() - 1));
        outTreatmentItems.setExecutedQuantity(Integer.valueOf(outTreatmentItems.getExecutedQuantity() + 1));
        OrderTypeEnum orderTypeEnum = OrderTypeEnum.getEnumByProjectType((String)String.valueOf(outTreatmentItems.getTreatmentCategory()));
        switch (5.$SwitchMap$com$byh$outpatient$api$enums$OrderTypeEnum[orderTypeEnum.ordinal()]) {
            case 1: {
                outOrder.setDeliveryStatus(DeliveryStatusEnum.DELIVERY_SENT.getValue());
                outTreatmentItems.setExecutedTime(new Date());
                break;
            }
            default: {
                if (outTreatmentItems.getAbsenceExecutedQuantity() < 1) {
                    outOrder.setDeliveryStatus(DeliveryStatusEnum.DELIVERY_COMPLETED.getValue());
                    outTreatmentItems.setExecutedTime(new Date());
                    break;
                }
                outOrder.setDeliveryStatus(DeliveryStatusEnum.DELIVERY_IN_PROGRESS.getValue());
            }
        }
        this.outTreatmentItemsMapper.updateById((Object)outTreatmentItems);
        try {
            ArrayList<PatientEntity> list = new ArrayList<PatientEntity>();
            PatientEntity patientEntity = new PatientEntity();
            ArrayList<AdmissionEntity> admissionList = new ArrayList<AdmissionEntity>();
            AdmissionEntity admissionEntity = new AdmissionEntity();
            ArrayList<OutTreatmentItems> itemsList = new ArrayList<OutTreatmentItems>();
            itemsList.add(outTreatmentItems);
            itemsList.forEach(item -> {
                String unit;
                Integer status = item.getStatus();
                switch (status) {
                    case 0: {
                        item.setStatusName("\u5220\u9664");
                        break;
                    }
                    case 1: {
                        item.setStatusName("\u6b63\u5e38");
                        break;
                    }
                    case 2: {
                        item.setStatusName("\u5df2\u8fc7\u671f");
                        break;
                    }
                    case 3: {
                        item.setStatusName("\u5df2\u4f5c\u5e9f");
                    }
                }
                Integer id = item.getId();
                if (id == null) {
                    OutTreatmentItems items = (OutTreatmentItems)this.outTreatmentItemsMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutTreatmentItems::getOutpatientNo, (Object)item.getOutpatientNo())).eq(OutTreatmentItems::getStatus, (Object)item.getStatus())).eq(OutTreatmentItems::getItemsNo, (Object)item.getItemsNo())).eq(OutTreatmentItems::getItemsCode, (Object)item.getItemsCode()));
                    item.setId(items.getId());
                }
                if (StringUtils.isNotBlank((CharSequence)(unit = item.getUnit()))) {
                    SysDictValueDTO dto = new SysDictValueDTO();
                    dto.setValue(unit);
                    dto.setType("charge_unit");
                    ResponseData pageResponseData = this.sysServiceFeign.sysDictValueById(dto, parameter.getTenantId() + "");
                    String label = ((SysDictValueVo)((Page)pageResponseData.getData()).getRecords().get(0)).getLabel();
                    item.setUnitName(label);
                }
            });
            patientEntity.setItemsList(itemsList);
            admissionList.add(admissionEntity);
            patientEntity.setAdmissionList(admissionList);
            list.add(patientEntity);
            String msg = JSONObject.toJSONString(list);
            String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
            this.rocketMQProducer.asyncSendCallbackTimeoutLevel(treatmentItemsTopic, "TAG6", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.outOrderMapper.updateById((Object)outOrder);
        return ResponseData.success((Object)"\u64cd\u4f5c\u5b8c\u6210");
    }

    public ResponseData<String> printBarcode(ImplementDto parameter) {
        if (null == parameter.getId()) {
            return ResponseData.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
        queryWrapper.eq((Object)"id", (Object)parameter.getId());
        OutTreatmentItems outTreatmentItems = (OutTreatmentItems)this.outTreatmentItemsMapper.selectOne((Wrapper)queryWrapper);
        if (outTreatmentItems == null) {
            return ResponseData.error((String)"\u6ca1\u6709\u627e\u5230\u9879\u76ee\uff01");
        }
        QueryWrapper queryrOrder = new QueryWrapper();
        ((QueryWrapper)queryrOrder.in((Object)"prescription_no", new Object[]{outTreatmentItems.getId()})).eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
        OutOrder outOrder = (OutOrder)this.outOrderMapper.selectOne((Wrapper)queryrOrder);
        if (outOrder == null) {
            return ResponseData.error((String)"\u6ca1\u6709\u627e\u5230\u8ba2\u5355\uff01");
        }
        if (!PaymentStatusEnum.PAYMENT_COMPLETED.getValue().equals(outOrder.getPaymentStatus())) {
            return ResponseData.error((String)"\u8bf7\u5148\u652f\u4ed8\u8ba2\u5355\uff01");
        }
        outTreatmentItems.setPrintingTime(new Date());
        this.outTreatmentItemsMapper.updateById((Object)outTreatmentItems);
        try {
            ArrayList<PatientEntity> list = new ArrayList<PatientEntity>();
            PatientEntity patientEntity = new PatientEntity();
            ArrayList<AdmissionEntity> admissionList = new ArrayList<AdmissionEntity>();
            AdmissionEntity admissionEntity = new AdmissionEntity();
            ArrayList<OutTreatmentItems> itemsList = new ArrayList<OutTreatmentItems>();
            itemsList.add(outTreatmentItems);
            itemsList.forEach(item -> {
                String unit;
                Integer status = item.getStatus();
                switch (status) {
                    case 0: {
                        item.setStatusName("\u5220\u9664");
                        break;
                    }
                    case 1: {
                        item.setStatusName("\u6b63\u5e38");
                        break;
                    }
                    case 2: {
                        item.setStatusName("\u5df2\u8fc7\u671f");
                        break;
                    }
                    case 3: {
                        item.setStatusName("\u5df2\u4f5c\u5e9f");
                    }
                }
                Integer id = item.getId();
                if (id == null) {
                    OutTreatmentItems items = (OutTreatmentItems)this.outTreatmentItemsMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutTreatmentItems::getOutpatientNo, (Object)item.getOutpatientNo())).eq(OutTreatmentItems::getStatus, (Object)item.getStatus())).eq(OutTreatmentItems::getItemsNo, (Object)item.getItemsNo())).eq(OutTreatmentItems::getItemsCode, (Object)item.getItemsCode()));
                    item.setId(items.getId());
                }
                if (StringUtils.isNotBlank((CharSequence)(unit = item.getUnit()))) {
                    SysDictValueDTO dto = new SysDictValueDTO();
                    dto.setValue(unit);
                    dto.setType("charge_unit");
                    ResponseData pageResponseData = this.sysServiceFeign.sysDictValueById(dto, parameter.getTenantId() + "");
                    String label = ((SysDictValueVo)((Page)pageResponseData.getData()).getRecords().get(0)).getLabel();
                    item.setUnitName(label);
                }
            });
            patientEntity.setItemsList(itemsList);
            admissionList.add(admissionEntity);
            patientEntity.setAdmissionList(admissionList);
            list.add(patientEntity);
            String msg = JSONObject.toJSONString(list);
            String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
            this.rocketMQProducer.asyncSendCallbackTimeoutLevel(treatmentItemsTopic, "TAG6", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        outOrder.setDeliveryStatus(DeliveryStatusEnum.DELIVERY_PRINTED.getValue());
        this.outOrderMapper.updateById((Object)outOrder);
        return ResponseData.success((Object)outTreatmentItems.getBarcodeNumber());
    }

    public ResponseData<List<QueryItemsVo>> queryInspectionChecklist(QueryInspectionChecklistDto parameter) {
        List outTreatmentItems;
        List ids;
        Integer[] integerArray;
        ResponseData listResponseData;
        if (!StringUtil.isEmpty((String)parameter.getStartTime()) && !StringUtil.isEmpty((String)parameter.getEndTime())) {
            parameter.setStartTime(parameter.getStartTime() + " 00:00:00");
            parameter.setEndTime(parameter.getEndTime() + " 23:59:59");
        }
        if (!(listResponseData = this.sysServiceFeign.selectListWithChargeItems(integerArray = (Integer[])(ids = (outTreatmentItems = this.outTreatmentItemsMapper.queryInspectionChecklist(parameter)).stream().map(QueryItemsVo::getItemsNo).collect(Collectors.toList())).stream().map(Integer::parseInt).toArray(Integer[]::new))).isSuccess() || listResponseData.getData() == null) {
            ResponseData.success();
        }
        Map itemMap = ((List)listResponseData.getData()).stream().collect(Collectors.toMap(BasePageEntity::getId, Function.identity()));
        outTreatmentItems.forEach(queryItemsVo -> {
            SysTreatmentItemVo itemVo = (SysTreatmentItemVo)itemMap.get(Integer.parseInt(queryItemsVo.getItemsNo()));
            queryItemsVo.setNewItems(itemVo);
            queryItemsVo.setOutTreatmentId(queryItemsVo.getId());
            queryItemsVo.setTreatmentCategoryName(OrderTypeEnum.getEnumByProjectType((String)String.valueOf(queryItemsVo.getTreatmentCategory())).getName());
        });
        return ResponseData.success((Object)outTreatmentItems);
    }

    public ResponseData<PageResult<QueryExecutionRecordsVo>> queryExecutionRecords(QueryExecutionRecordsDto parameter) {
        if (parameter.getCurrent() == null || parameter.getSize() == null) {
            return ResponseData.error((String)"\u9875\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageHelper.startPage((int)parameter.getCurrent(), (int)parameter.getSize());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"out_treatment_id", (Object)parameter.getOutTreatmentId());
        List outTreatmentImplements = this.outTreatmentImplementMapper.selectList((Wrapper)queryWrapper);
        List recordsVos = outTreatmentImplements.stream().map(OutTreatmentImplement2 -> {
            QueryExecutionRecordsVo queryExecutionRecordsVo = new QueryExecutionRecordsVo();
            BeanUtils.copyProperties((Object)OutTreatmentImplement2, (Object)queryExecutionRecordsVo);
            return queryExecutionRecordsVo;
        }).collect(Collectors.toList());
        PageInfo pageInfo = new PageInfo(recordsVos);
        PageResult pageResult = new PageResult(parameter.getCurrent().intValue(), parameter.getSize().intValue());
        pageResult.setTotal(Integer.parseInt(String.valueOf(pageInfo.getTotal())));
        pageResult.setPages(pageInfo.getPages());
        pageResult.setRecords(recordsVos);
        pageResult.setCurrent(parameter.getCurrent().intValue());
        pageResult.setSize(parameter.getSize().intValue());
        return ResponseData.success((Object)pageResult);
    }

    public ResponseData<List<PrintTemplateVo>> printTreatment(PrintItemsDto parameter) {
        log.info("=====\u6253\u5370\u5165\u53c2\u4fe1\u606f====={}", (Object)parameter);
        ArrayList<PrintTemplateVo> printTemplateVos = new ArrayList<PrintTemplateVo>();
        List list = parameter.getList();
        String outpatientNo = parameter.getOutpatientNo();
        QueryWrapper admissionEntityQueryWrapper = new QueryWrapper();
        admissionEntityQueryWrapper.eq((Object)"outpatient_no", (Object)outpatientNo);
        AdmissionEntity admissionEntity = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)admissionEntityQueryWrapper);
        if (Objects.isNull(admissionEntity)) {
            throw new RunDisplayException("\u95e8\u8bca\u8bb0\u5f55\u67e5\u8be2\u5931\u8d25");
        }
        List outTreatmentItems = new ArrayList();
        Map<Object, Object> outTreatmentDetailsMap = new HashMap();
        List ids = list.stream().map(PrintItemDto::getOutTreatmentId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)) {
            LambdaQueryWrapper outTreatmentItemsLambdaQueryWrapper = Wrappers.lambdaQuery();
            outTreatmentItemsLambdaQueryWrapper.in(OutTreatmentItems::getId, ids);
            outTreatmentItems = this.outTreatmentItemsMapper.selectList((Wrapper)outTreatmentItemsLambdaQueryWrapper);
            LambdaQueryWrapper outTreatmentDetailsLambdaQueryWrapper = Wrappers.lambdaQuery();
            outTreatmentDetailsLambdaQueryWrapper.in(OutTreatmentDetails::getOutTreatmentId, ids);
            List outTreatmentDetails = this.outTreatmentDetailsMapper.selectList((Wrapper)outTreatmentDetailsLambdaQueryWrapper);
            outTreatmentDetailsMap = outTreatmentDetails.stream().collect(Collectors.groupingBy(OutTreatmentDetails::getOutTreatmentId));
        }
        List<Integer> itemNos = list.stream().filter(x -> Objects.nonNull(x.getTreatmentItemsNo()) && Objects.isNull(x.getOutTreatmentId())).map(PrintItemDto::getTreatmentItemsNo).collect(Collectors.toList());
        Map itemMap = list.stream().filter(x -> Objects.nonNull(x.getTreatmentItemsNo()) && Objects.isNull(x.getOutTreatmentId())).collect(Collectors.toMap(PrintItemDto::getTreatmentItemsNo, Function.identity()));
        if (CollectionUtils.isNotEmpty(itemNos)) {
            Integer[] itemIdArray = itemNos.toArray(new Integer[itemNos.size()]);
            ResponseData listResponseData = this.sysServiceFeign.selectListWithChargeItems(itemIdArray);
            if (!listResponseData.isSuccess() || listResponseData.getData() == null) {
                return ResponseData.error((String)"\u9879\u76ee\u8be6\u60c5\u67e5\u8be2\u5931\u8d25");
            }
            List sysTreatmentItemVos = ((List)listResponseData.getData()).stream().filter(x -> !"1".equals(x.getExecuteDeptFlag())).collect(Collectors.toList());
            SysDepartmentVo sysDepartmentVo = new SysDepartmentVo();
            if (CollectionUtils.isNotEmpty(sysTreatmentItemVos)) {
                SysDeptDto sysDeptDto = new SysDeptDto();
                sysDeptDto.setId(admissionEntity.getDeptId());
                ResponseData sysDepartmentVoResponseData = this.sysServiceFeign.deptInfoById(sysDeptDto);
                if (Objects.isNull(sysDepartmentVoResponseData) || !sysDepartmentVoResponseData.isSuccess()) {
                    return ResponseData.error((String)"\u79d1\u5ba4\u4fe1\u606f\u67e5\u8be2\u5931\u8d25{}", (String)JSONObject.toJSONString((Object)sysDepartmentVoResponseData));
                }
                sysDepartmentVo = (SysDepartmentVo)JSON.parseObject((String)JSON.toJSONString((Object)sysDepartmentVoResponseData.getData()), SysDepartmentVo.class);
                if (Objects.isNull(sysDepartmentVo)) {
                    return ResponseData.error((String)"\u79d1\u5ba4\u4fe1\u606f\u67e5\u8be2\u5931\u8d25{}", (String)JSONObject.toJSONString((Object)sysDepartmentVo));
                }
            }
            for (SysTreatmentItemVo sysTreatmentItemVo : (List)listResponseData.getData()) {
                PrintTemplateVo printTemplateVo = new PrintTemplateVo();
                printTemplateVo.setOutpatientNo(parameter.getOutpatientNo());
                printTemplateVo.setPatientName(admissionEntity.getPatientName());
                printTemplateVo.setPatientSex(StringUtil.isNotEmpty((String)admissionEntity.getPatientSex()) ? GenderEnum.getEnum((Integer)Integer.valueOf(admissionEntity.getPatientSex())).getDesc() : "");
                printTemplateVo.setPatientAge(Objects.nonNull(admissionEntity.getPatientAge()) ? admissionEntity.getPatientAge() + "\u5c81" : "");
                printTemplateVo.setTreatmentCategory(Integer.valueOf(sysTreatmentItemVo.getTreatmentTypeCode()));
                printTemplateVo.setDeptId(admissionEntity.getDeptId());
                printTemplateVo.setDeptName(admissionEntity.getDeptName());
                if ("1".equals(sysTreatmentItemVo.getExecuteDeptFlag())) {
                    printTemplateVo.setExecuteDeptId(sysTreatmentItemVo.getExecuteDeptId());
                    printTemplateVo.setExecuteDeptName(sysTreatmentItemVo.getExecuteDeptName());
                    printTemplateVo.setExecuteDeptPosition(sysTreatmentItemVo.getExecuteDeptPosition());
                } else {
                    printTemplateVo.setExecuteDeptId(admissionEntity.getDeptId());
                    printTemplateVo.setExecuteDeptName(admissionEntity.getDeptName());
                    printTemplateVo.setExecuteDeptPosition(sysDepartmentVo.getPosition());
                }
                printTemplateVo.setPrescribingDoctorId(admissionEntity.getDoctorId());
                printTemplateVo.setPrescribingDoctorName(admissionEntity.getDoctorName());
                PrintItemDto printItemDto = (PrintItemDto)itemMap.get(sysTreatmentItemVo.getId());
                printTemplateVo.setQuantity(Integer.valueOf(Objects.nonNull(printItemDto.getQuantity()) ? printItemDto.getQuantity() : 1));
                printTemplateVo.setUnitPriceAmount(sysTreatmentItemVo.getTotalPrice());
                printTemplateVo.setTotalAmount(sysTreatmentItemVo.getTotalPrice().multiply(new BigDecimal(printTemplateVo.getQuantity())));
                printTemplateVo.setUnit(sysTreatmentItemVo.getUnit());
                printTemplateVo.setProjectName(sysTreatmentItemVo.getItemName());
                List sysTreatmentChargeVoList = sysTreatmentItemVo.getSysTreatmentChargeVoList();
                ArrayList<OutTreatmentDetails> detailsList = new ArrayList<OutTreatmentDetails>();
                for (SysTreatmentChargeVo SysTreatmentChargeVo2 : sysTreatmentChargeVoList) {
                    OutTreatmentDetails outTreatmentDetails = new OutTreatmentDetails();
                    outTreatmentDetails.setCreateId(parameter.getOperatorId());
                    outTreatmentDetails.setTenantId(parameter.getTenantId());
                    outTreatmentDetails.setUnit(SysTreatmentChargeVo2.getUnit());
                    outTreatmentDetails.setTreatmentName(SysTreatmentChargeVo2.getChargeItemName());
                    outTreatmentDetails.setMedicalInsuranceCode(SysTreatmentChargeVo2.getMedicalInsuranceCode());
                    outTreatmentDetails.setMedicalInsuranceName(SysTreatmentChargeVo2.getMedicalInsuranceName());
                    outTreatmentDetails.setInsuranceCode(SysTreatmentChargeVo2.getMedicalInsuranceCode());
                    outTreatmentDetails.setInsuranceName(SysTreatmentChargeVo2.getMedicalInsuranceName());
                    outTreatmentDetails.setMedicalInsuranceType(SysTreatmentChargeVo2.getMedicalInsuranceTypeCode());
                    outTreatmentDetails.setMedicalInsuranceTypeName(SysTreatmentChargeVo2.getMedicalInsuranceTypeName());
                    outTreatmentDetails.setLevel(SysTreatmentChargeVo2.getChargeItemLevel());
                    outTreatmentDetails.setQuantity(SysTreatmentChargeVo2.getQuantity());
                    outTreatmentDetails.setUnitPriceAmount(SysTreatmentChargeVo2.getItemPrice());
                    outTreatmentDetails.setTotalAmount(outTreatmentDetails.getUnitPriceAmount().multiply(new BigDecimal(outTreatmentDetails.getQuantity())));
                    detailsList.add(outTreatmentDetails);
                }
                printTemplateVo.setList(detailsList);
                printTemplateVo.setSamplingSpecimens(sysTreatmentItemVo.getSpecimenLabel());
                OutpatientInfomationDto queryParameter = new OutpatientInfomationDto();
                queryParameter.setTenantId(parameter.getTenantId());
                queryParameter.setOutpatientNo(parameter.getOutpatientNo());
                ResponseData queryOutpatientMedicalRecordsVoResponseData = this.outMedicalRecordService.queryOutpatientMedicalRecords(queryParameter);
                QueryOutpatientMedicalRecordsVo outpatientMedicalRecordsVo = (QueryOutpatientMedicalRecordsVo)queryOutpatientMedicalRecordsVoResponseData.getData();
                if (Objects.nonNull(outpatientMedicalRecordsVo)) {
                    printTemplateVo.setDiagnosis(outpatientMedicalRecordsVo.getAllDiagnosisValue());
                    printTemplateVo.setPresentMedicalHistory(outpatientMedicalRecordsVo.getPresentMedicalHistory());
                }
                printTemplateVos.add(printTemplateVo);
            }
        }
        for (OutTreatmentItems outTreatmentItem : outTreatmentItems) {
            PrintTemplateVo printTemplateVo = new PrintTemplateVo();
            printTemplateVo.setTreatmentNo(outTreatmentItem.getTreatmentNo());
            printTemplateVo.setOutpatientNo(outTreatmentItem.getOutpatientNo());
            printTemplateVo.setPatientName(admissionEntity.getPatientName());
            printTemplateVo.setPatientSex(StringUtil.isNotEmpty((String)admissionEntity.getPatientSex()) ? GenderEnum.getEnum((Integer)Integer.valueOf(admissionEntity.getPatientSex())).getDesc() : "");
            printTemplateVo.setPatientAge(Objects.nonNull(admissionEntity.getPatientAge()) ? admissionEntity.getPatientAge() + "\u5c81" : "");
            printTemplateVo.setTreatmentCategory(outTreatmentItem.getTreatmentCategory());
            printTemplateVo.setDeptId(outTreatmentItem.getPrescribingDepartmentId());
            printTemplateVo.setDeptName(outTreatmentItem.getPrescribingDepartmentName());
            printTemplateVo.setIssueTime(outTreatmentItem.getCreateTime());
            printTemplateVo.setExecuteDeptId(outTreatmentItem.getExecutedDeptId());
            printTemplateVo.setExecuteDeptName(outTreatmentItem.getExecutedDept());
            printTemplateVo.setExecuteDeptPosition(outTreatmentItem.getExecutedDeptPosition());
            printTemplateVo.setPrescribingDoctorId(outTreatmentItem.getPrescribingDoctorId());
            printTemplateVo.setPrescribingDoctorName(outTreatmentItem.getPrescribingDoctorName());
            printTemplateVo.setTotalAmount(outTreatmentItem.getTotalAmount());
            printTemplateVo.setList((List)outTreatmentDetailsMap.get(outTreatmentItem.getId()));
            printTemplateVo.setSamplingSpecimens(outTreatmentItem.getSpecimenLabel());
            printTemplateVo.setQuantity(outTreatmentItem.getQuantity());
            printTemplateVo.setUnitPriceAmount(outTreatmentItem.getUnitPriceAmount());
            printTemplateVo.setTotalAmount(outTreatmentItem.getTotalAmount());
            printTemplateVo.setUnit(outTreatmentItem.getUnit());
            printTemplateVo.setProjectName(outTreatmentItem.getName());
            OutpatientInfomationDto queryParameter = new OutpatientInfomationDto();
            queryParameter.setTenantId(outTreatmentItem.getTenantId());
            queryParameter.setOutpatientNo(outTreatmentItem.getOutpatientNo());
            ResponseData queryOutpatientMedicalRecordsVoResponseData = this.outMedicalRecordService.queryOutpatientMedicalRecords(queryParameter);
            QueryOutpatientMedicalRecordsVo outpatientMedicalRecordsVo = (QueryOutpatientMedicalRecordsVo)queryOutpatientMedicalRecordsVoResponseData.getData();
            if (Objects.nonNull(outpatientMedicalRecordsVo)) {
                printTemplateVo.setDiagnosis(outpatientMedicalRecordsVo.getAllDiagnosisValue());
                printTemplateVo.setPresentMedicalHistory(outpatientMedicalRecordsVo.getPresentMedicalHistory());
            }
            printTemplateVos.add(printTemplateVo);
        }
        return ResponseData.success(printTemplateVos);
    }

    public ResponseData<List<OutTreatmentDfmResVo>> queryItemsByDianfumao(QueryItemsDto parameter) {
        List outTreatmentItems = this.outTreatmentItemsMapper.queryItemsByDianfuma(parameter);
        Map<String, List<OutTreatmentDfmVo>> map = outTreatmentItems.stream().collect(Collectors.groupingBy(OutTreatmentDfmVo::getOutpatientNo));
        ArrayList<OutTreatmentDfmResVo> list = new ArrayList<OutTreatmentDfmResVo>(100);
        for (Map.Entry<String, List<OutTreatmentDfmVo>> entry : map.entrySet()) {
            OutTreatmentDfmResVo v = new OutTreatmentDfmResVo();
            v.setOutpatientNo(entry.getKey());
            v.setList(entry.getValue());
            list.add(v);
        }
        return ResponseData.success(list);
    }

    public ResponseData<QueryItemsVo> queryDiagInfo(QueryItemsDto dto) {
        return ResponseData.success((Object)this.outTreatmentItemsMapper.queryItemsById(dto));
    }

    public List<Map<String, Object>> queryOutpatientDetail(String patientId) {
        PageHelper.startPage((int)1, (int)10);
        List list = this.outTreatmentItemsMapper.queryOutpatientDetail(patientId);
        PageInfo page = new PageInfo(list);
        return list;
    }

    public TreatmentItemsServiceImpl(RocketMQProducer rocketMQProducer) {
        this.rocketMQProducer = rocketMQProducer;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

