/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.byh.outpatient.api.dto.checkout.QueryCheckoutListDto;
import com.byh.outpatient.api.dto.checkout.QueryPendingAccountsDto;
import com.byh.outpatient.api.enums.OrderTypeEnum;
import com.byh.outpatient.api.model.checkout.OutCheckoutPaymentRecords;
import com.byh.outpatient.api.util.EasyExcelUtil;
import com.byh.outpatient.api.util.PageResult;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.vo.checkout.OutCheckListVo;
import com.byh.outpatient.api.vo.checkout.QueryPendingAccountsVo;
import com.byh.outpatient.api.vo.order.ExcelOutCheckoutPaymentRecords;
import com.byh.outpatient.web.aspect.UserOptLogger;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.OutCheckoutService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u7ed3\u8d26")
@RestController
@RequestMapping(value={"/outCheckout"})
public class OutCheckoutController {
    @Resource
    private OutCheckoutService outCheckoutService;
    @Autowired
    private CommonRequest commonRequest;

    @PostMapping(value={"/v1/pendingBillingInformation"})
    @Operation(description="\u67e5\u8be2\u5f85\u7ed3\u8d26\u4fe1\u606f")
    @ApiOperation(value="\u67e5\u8be2\u5f85\u7ed3\u8d26\u4fe1\u606f", httpMethod="POST", notes="\u67e5\u8be2\u5f85\u7ed3\u8d26\u4fe1\u606f")
    public ResponseData<QueryPendingAccountsVo> pendingBillingInformation(@RequestBody @Valid QueryPendingAccountsDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.outCheckoutService.pendingBillingInformation(parameter);
    }

    @UserOptLogger(operation="\u751f\u6210\u7ed3\u8d26\u5355")
    @PostMapping(value={"/v1/generateBillingStatement"})
    @Operation(description="\u751f\u6210\u7ed3\u8d26\u5355")
    @ApiOperation(value="\u751f\u6210\u7ed3\u8d26\u5355", httpMethod="POST", notes="\u751f\u6210\u7ed3\u8d26\u5355")
    public ResponseData<String> generateBillingStatement(@RequestBody @Valid QueryPendingAccountsDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.outCheckoutService.generateBillingStatement(parameter);
    }

    @PostMapping(value={"/v1/queryCheckoutList"})
    @Operation(description="\u67e5\u8be2\u7ed3\u8d26\u5217\u8868")
    @ApiOperation(value="\u67e5\u8be2\u7ed3\u8d26\u5217\u8868", httpMethod="POST", notes="\u67e5\u8be2\u7ed3\u8d26\u5217\u8868")
    public ResponseData<PageResult<OutCheckListVo>> queryCheckoutList(@RequestBody @Valid QueryCheckoutListDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.outCheckoutService.queryCheckoutList(parameter);
    }

    @PostMapping(value={"/v1/queryCheckoutDetails"})
    @Operation(description="\u67e5\u8be2\u7ed3\u8d26\u8be6\u60c5")
    @ApiOperation(value="\u67e5\u8be2\u7ed3\u8d26\u8be6\u60c5", httpMethod="POST", notes="\u67e5\u8be2\u7ed3\u8d26\u8be6\u60c5")
    public ResponseData<QueryPendingAccountsVo> queryCheckoutDetails(@RequestBody @Valid QueryPendingAccountsDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.outCheckoutService.queryCheckoutDetails(parameter);
    }

    @PostMapping(value={"/v1/queryBillingPaymentRecords"})
    @Operation(description="\u67e5\u8be2\u8d26\u5355\u652f\u4ed8\u8bb0\u5f55")
    @ApiOperation(value="\u67e5\u8be2\u8d26\u5355\u652f\u4ed8\u8bb0\u5f55", httpMethod="POST", notes="\u67e5\u8be2\u8d26\u5355\u652f\u4ed8\u8bb0\u5f55")
    public ResponseData<PageResult<OutCheckoutPaymentRecords>> queryBillingPaymentRecords(@RequestBody @Valid QueryCheckoutListDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.outCheckoutService.queryBillingPaymentRecords(parameter);
    }

    @PostMapping(value={"/v1/queryBillingPaymentRecords/export"})
    @Operation(description="\u5bfc\u51fa\u8d26\u5355\u652f\u4ed8\u8bb0\u5f55")
    @ApiOperation(value="\u5bfc\u51fa\u8d26\u5355\u652f\u4ed8\u8bb0\u5f55", httpMethod="POST", notes="\u5bfc\u51fa\u8d26\u5355\u652f\u4ed8\u8bb0\u5f55")
    public void exportBillingPaymentRecords(HttpServletResponse response, @RequestBody QueryCheckoutListDto parameter) {
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        ResponseData pageResultResponseData = this.outCheckoutService.queryBillingPaymentRecords(parameter);
        List records = ((PageResult)pageResultResponseData.getData()).getRecords();
        List excelPaymentRecordsList = records.stream().map(excelPaymentRecords -> {
            ExcelOutCheckoutPaymentRecords paymentRecords = new ExcelOutCheckoutPaymentRecords();
            BeanUtils.copyProperties((Object)excelPaymentRecords, (Object)paymentRecords);
            paymentRecords.setPaymentMethod(excelPaymentRecords.getPaymentMethod());
            paymentRecords.setSource(OrderTypeEnum.getEnum((String)excelPaymentRecords.getOrderType()).getSource());
            return paymentRecords;
        }).collect(Collectors.toList());
        String excelName = "\u7ed3\u8d26\u5355\u652f\u4ed8\u8bb0\u5f55\u5bfc\u51fa";
        String sheetName = "\u666e\u901a";
        EasyExcelUtil.normalExport((HttpServletResponse)response, (String)excelName, (String)sheetName, excelPaymentRecordsList, ExcelOutCheckoutPaymentRecords.class);
    }
}

