/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.byh.outpatient.api.dto.outException.OutExceptionDto;
import com.byh.outpatient.api.dto.outException.OutExceptionSaveDto;
import com.byh.outpatient.api.model.OutExceptionEntity;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.OutExceptionService;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class OutExceptionController {
    @Autowired
    private OutExceptionService outExceptionService;
    @Autowired
    private CommonRequest commonRequest;

    @RequestMapping(value={"/out/exception/save"})
    public ResponseData outExceptionSave(@RequestBody @Valid OutExceptionSaveDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.outExceptionService.outExceptionSave(dto);
        return ResponseData.success().save();
    }

    @RequestMapping(value={"/out/exception/select"})
    public ResponseData outExceptionSelect(@RequestBody @Valid OutExceptionDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        List list = this.outExceptionService.outExceptionSelect(dto);
        return ResponseData.success((Object)list);
    }

    @RequestMapping(value={"/out/exception/update"})
    public ResponseData outExceptionUpdate(@RequestBody @Valid OutExceptionEntity entity) {
        this.outExceptionService.outExceptionUpdate(entity);
        return ResponseData.success().update();
    }

    @RequestMapping(value={"/out/exception/delete"})
    public ResponseData outExceptionDelete(@RequestBody @Valid OutExceptionEntity entity) {
        this.outExceptionService.outExceptionDelete(entity);
        return ResponseData.success().delete();
    }
}

