/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.byh.outpatient.api.dto.pending.QueryPendingItemsDto;
import com.byh.outpatient.api.dto.pending.SavePendingItemsDto;
import com.byh.outpatient.api.dto.pending.UpdateStatePendingItemsDto;
import com.byh.outpatient.api.enums.PendingStatusEnum;
import com.byh.outpatient.api.model.pending.OutEnterprise;
import com.byh.outpatient.api.model.pending.OutPendingItems;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.vo.pending.QueryPendingItemsVo;
import com.byh.outpatient.data.repository.OutEnterpriseMapper;
import com.byh.outpatient.data.repository.OutPendingItemsMapper;
import com.byh.outpatient.web.service.OutPendingItemsService;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OutPendingItemsServiceImpl
implements OutPendingItemsService {
    @Autowired
    private OutPendingItemsMapper outPendingItemsMapper;
    @Autowired
    private OutEnterpriseMapper outEnterpriseMapper;

    public ResponseData<List<QueryPendingItemsVo>> QueryPendingItemsDto(QueryPendingItemsDto parameter) {
        if (StringUtils.isEmpty((CharSequence)parameter.getContractNo())) {
            return ResponseData.error((String)"\u7b7e\u7ea6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        QueryWrapper outPendingItemsQueryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)outPendingItemsQueryWrapper.ne((Object)"status", (Object)PendingStatusEnum.STATUS_DELETE.getValue())).eq((Object)"tenant_id", (Object)parameter.getTenantId())).eq((Object)"contract_no", (Object)parameter.getContractNo());
        List outPendingItems = this.outPendingItemsMapper.selectList((Wrapper)outPendingItemsQueryWrapper);
        List querySigningUnitsVos = outPendingItems.stream().map(OutEnterprise -> {
            QueryPendingItemsVo queryPendingItemsVo = new QueryPendingItemsVo();
            BeanUtils.copyProperties((Object)OutEnterprise, (Object)queryPendingItemsVo);
            return queryPendingItemsVo;
        }).collect(Collectors.toList());
        return ResponseData.success(querySigningUnitsVos);
    }

    public ResponseData<String> savePendingItems(SavePendingItemsDto parameter) {
        QueryWrapper outEnterpriseQueryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)outEnterpriseQueryWrapper.eq((Object)"status", (Object)PendingStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"contract_no", (Object)parameter.getContractNo())).eq((Object)"tenant_id", (Object)parameter.getTenantId());
        OutEnterprise outEnterprise = (OutEnterprise)this.outEnterpriseMapper.selectOne((Wrapper)outEnterpriseQueryWrapper);
        if (outEnterprise == null) {
            return ResponseData.error((String)"\u7b7e\u7ea6\u5355\u4f4d\u4e0d\u5b58\u5728");
        }
        QueryWrapper outPendingItemsQueryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)outPendingItemsQueryWrapper.eq((Object)"status", (Object)PendingStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"project_no", (Object)parameter.getProjectNo())).eq((Object)"tenant_id", (Object)parameter.getTenantId());
        OutPendingItems outPendingItems = (OutPendingItems)this.outPendingItemsMapper.selectOne((Wrapper)outPendingItemsQueryWrapper);
        if (outPendingItems == null) {
            outPendingItems = new OutPendingItems();
            BeanUtils.copyProperties((Object)parameter, (Object)outPendingItems);
            outPendingItems.setCreateId(parameter.getOperatorId());
            outPendingItems.setCreateName(parameter.getOperatorName());
            outPendingItems.setTenantId(parameter.getTenantId());
            outPendingItems.setStatus(PendingStatusEnum.STATUS_NORMAL.getValue());
            outPendingItems.setContractNo(outEnterprise.getContractNo());
            outPendingItems.setSigningName(outEnterprise.getSigningName());
            outPendingItems.setCreationUnitTime(outEnterprise.getCreateTime());
            this.outPendingItemsMapper.insert((Object)outPendingItems);
        } else {
            BeanUtils.copyProperties((Object)parameter, (Object)outPendingItems);
            outPendingItems.setUpdateId(parameter.getOperatorId());
            outPendingItems.setUpdateName(parameter.getOperatorName());
            outPendingItems.setSigningName(outEnterprise.getSigningName());
            outPendingItems.setStatus(PendingStatusEnum.STATUS_NORMAL.getValue());
        }
        outPendingItems.setProjectNo(String.valueOf(outPendingItems.getId()));
        this.outPendingItemsMapper.updateById((Object)outPendingItems);
        return ResponseData.success((Object)"\u4fdd\u5b58\u5b8c\u6210");
    }

    public ResponseData<String> updateStatePendingItems(UpdateStatePendingItemsDto parameter) {
        QueryWrapper outPendingItemsQueryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)outPendingItemsQueryWrapper.in((Object)"status", Arrays.asList(PendingStatusEnum.STATUS_NORMAL.getValue(), PendingStatusEnum.STATUS_DISABLED.getValue()))).eq((Object)"project_no", (Object)parameter.getProjectNo())).eq((Object)"tenant_id", (Object)parameter.getTenantId());
        OutPendingItems outPendingItems = (OutPendingItems)this.outPendingItemsMapper.selectOne((Wrapper)outPendingItemsQueryWrapper);
        if (outPendingItems == null) {
            return ResponseData.error((String)"\u9879\u76ee\u4e0d\u5b58\u5728\uff01");
        }
        if (parameter.getState().equals(PendingStatusEnum.STATUS_DISABLED.getValue())) {
            outPendingItems.setStatus(PendingStatusEnum.STATUS_DISABLED.getValue());
        } else if (parameter.getState().equals(PendingStatusEnum.STATUS_DELETE.getValue())) {
            outPendingItems.setStatus(PendingStatusEnum.STATUS_DELETE.getValue());
        } else if (parameter.getState().equals(PendingStatusEnum.STATUS_NORMAL.getValue())) {
            outPendingItems.setStatus(PendingStatusEnum.STATUS_NORMAL.getValue());
        } else {
            return ResponseData.error((String)"\u72b6\u6001\u4e0d\u5b58\u5728\uff01");
        }
        this.outPendingItemsMapper.updateById((Object)outPendingItems);
        return ResponseData.success((Object)"\u5b8c\u6210");
    }
}

