/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.alibaba.excel.write.style.column.SimpleColumnWidthStyleStrategy;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.outpatient.api.dto.OutDrugDeliveryDto;
import com.byh.outpatient.api.exception.BusinessException;
import com.byh.outpatient.api.model.OutDrugDeliveryEntity;
import com.byh.outpatient.api.util.ExceptionUtils;
import com.byh.outpatient.api.util.HyposensitizationUtil;
import com.byh.outpatient.api.vo.ExportDrugDelivery;
import com.byh.outpatient.api.vo.OutDrugDeliveryVo;
import com.byh.outpatient.data.repository.OutDrugDeliveryMapper;
import com.byh.outpatient.web.service.OutDrugDeliveryService;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OutDrugDeliveryServiceImpl
implements OutDrugDeliveryService {
    private static final Logger log = LoggerFactory.getLogger(OutDrugDeliveryServiceImpl.class);
    private Logger logger = LoggerFactory.getLogger(OutDrugDeliveryServiceImpl.class);
    @Resource
    private OutDrugDeliveryMapper outDrugDeliveryMapper;

    @Scheduled(cron="0 30 1 * * ?")
    @Transactional(rollbackFor={BusinessException.class})
    public void timingGenerateDrugDelivery() {
        LocalDate today = LocalDate.now();
        LocalDate yesterday = today.minusDays(1L);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String yesterdayStr = yesterday.format(dateTimeFormatter);
        OutDrugDeliveryDto dto = new OutDrugDeliveryDto();
        dto.setTenantId(Integer.valueOf(1));
        dto.setCreateId(Integer.valueOf(1));
        dto.setCreateName("\u51cc\u6668\u4e00\u70b9\u534a\u5b9a\u65f6\u751f\u6210\u836f\u54c1\u914d\u9001\u4fe1\u606f");
        dto.setStartDate(yesterdayStr);
        dto.setEndDate(yesterdayStr);
        this.getOutDrugDeliveryList(dto);
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void update(OutDrugDeliveryEntity entity) {
        if (entity.getId() == null) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u7f16\u8f91\u836f\u54c1\u914d\u9001\u4fe1\u606f\u65f6\uff0c\u4e3b\u952eID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (entity.getDeliveryNum() <= 0) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u7f16\u8f91\u836f\u54c1\u914d\u9001\u4fe1\u606f\u65f6\uff0c\u914d\u9001\u6570\u91cf\u4e0d\u53ef\u5c0f\u4e8e\u6216\u7b49\u4e8e0\uff01");
        }
        entity.setCreateTime(new Date());
        this.outDrugDeliveryMapper.updateById((Object)entity);
    }

    public void exportDrugDeliveryList(HttpServletResponse response, OutDrugDeliveryDto dto) {
        List unknowns;
        List exportList;
        Map map;
        if (StrUtil.isEmpty((CharSequence)dto.getStartDate()) && StrUtil.isEmpty((CharSequence)dto.getEndDate())) {
            LocalDate today = LocalDate.now();
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            String todayStr = today.format(dateTimeFormatter);
            dto.setStartDate(todayStr);
            dto.setEndDate(todayStr);
        }
        if ((map = (Map)(exportList = this.outDrugDeliveryMapper.exportDrugDeliveryList(dto)).stream().collect(Collectors.groupingBy(item -> {
            String oldRoute = item.getRoute();
            String route = StrUtil.isEmpty((CharSequence)oldRoute) ? "\u672a\u77e5\u8def\u7ebf" : ("\u5357\u660c\u5e02".equals(oldRoute) || "\u5357\u660c\u53bf".equals(oldRoute) || "\u65b0\u5efa\u53bf".equals(oldRoute) || "\u8fdb\u8d24\u53bf".equals(oldRoute) || "\u5b89\u4e49\u53bf".equals(oldRoute) ? "\u5e02\u5185\u76f4\u914d" : oldRoute.replaceAll("\\s*\\([^\\)]*\\)", "").trim());
            return route;
        }, LinkedHashMap::new, Collectors.toList()))).containsKey("\u672a\u77e5\u8def\u7ebf") && !(unknowns = (List)map.remove("\u672a\u77e5\u8def\u7ebf")).isEmpty()) {
            map.put("\u672a\u77e5\u8def\u7ebf", unknowns);
        }
        LinkedHashMap groupMap = new LinkedHashMap();
        if (map.containsKey("\u5e02\u5185\u76f4\u914d")) {
            groupMap.put("\u5e02\u5185\u76f4\u914d", map.remove("\u5e02\u5185\u76f4\u914d"));
        }
        groupMap.putAll(map);
        LinkedHashMap dataMap = new LinkedHashMap();
        for (Map.Entry entry : groupMap.entrySet()) {
            ArrayList datas = new ArrayList();
            String route = (String)entry.getKey();
            List list = (List)entry.getValue();
            List drugNames = list.stream().map(drug -> {
                String thirdCode = drug.getThirdCode();
                String drugName = drug.getName();
                return StrUtil.isNotEmpty((CharSequence)thirdCode) ? drugName + "\uff08" + thirdCode + "\uff09" : drugName;
            }).distinct().sorted(Comparator.comparingInt(String::length).reversed()).collect(Collectors.toList());
            Map exportMap = list.stream().collect(Collectors.groupingBy(item -> {
                String onlyName = item.getOpenTime() + item.getPatientCardNo();
                return onlyName;
            }, LinkedHashMap::new, Collectors.toList()));
            for (Map.Entry deliveryEntry : exportMap.entrySet()) {
                LinkedHashMap<Object, String> data = new LinkedHashMap<Object, String>();
                List deliveries = (List)deliveryEntry.getValue();
                ExportDrugDelivery drugDelivery = (ExportDrugDelivery)deliveries.get(0);
                Map<String, Integer> deliveryMap = deliveries.stream().collect(Collectors.groupingBy(delivery -> {
                    String thirdCode = delivery.getThirdCode();
                    String drugName = delivery.getName();
                    return StrUtil.isNotEmpty((CharSequence)thirdCode) ? delivery.getName() + "\uff08" + thirdCode + "\uff09" : drugName;
                }, Collectors.summingInt(ExportDrugDelivery::getDeliveryNum)));
                data.put("\u5f00\u836f\u65e5\u671f", drugDelivery.getOpenTime());
                data.put("\u59d3\u540d", drugDelivery.getPatientName());
                data.put("\u624b\u673a\u53f7\u7801", drugDelivery.getPatientPhone());
                data.put("\u8eab\u4efd\u8bc1\u53f7\u7801", drugDelivery.getPatientCardNo());
                data.put("\u914d\u9001\u5730\u5740", drugDelivery.getDeliveryAddress());
                data.put("\u8def\u7ebf", drugDelivery.getRoute());
                for (Object drugName : drugNames) {
                    if ("\u7898\u4f0f\u5e3d\uff08\u5a01\u9ad8\uff09".equals(drugName) || "\u7898\u4f0f\u5e3d\uff08\u767e\u7279\uff09".equals(drugName) || "\u7898\u4f0f\u5e3d\uff08\u8d39\u68ee\uff09".equals(drugName)) {
                        Integer deliveryNum = deliveryMap.getOrDefault(drugName, 0);
                        if (deliveryNum != 0) {
                            int boxCount = deliveryNum / 120;
                            int remainder = deliveryNum % 120;
                            String deliveryNumStr = deliveryNum >= 120 ? (remainder == 0 ? boxCount + "\u76d2" : boxCount + "\u76d2" + remainder + "\u4e2a") : deliveryNum + "\u4e2a";
                            data.put(drugName, deliveryNumStr);
                            continue;
                        }
                        data.put(drugName, null);
                        continue;
                    }
                    data.put(drugName, deliveryMap.getOrDefault(drugName, null));
                }
                data.put("\u5907\u6ce8", drugDelivery.getRemark());
                datas.add(data);
            }
            dataMap.put(route, datas);
        }
        try (ServletOutputStream out = response.getOutputStream();
             ExcelWriter excelWriter = ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)out).registerWriteHandler((WriteHandler)new SimpleColumnWidthStyleStrategy(Integer.valueOf(16)))).registerWriteHandler((WriteHandler)this.createCellStyleStrategy())).build();){
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2");
            String format = LocalDateTime.now(ZoneOffset.ofHours(8)).format(dateTimeFormatter);
            String fileName = URLEncoder.encode("\u836f\u54c1\u914d\u9001" + format, "UTF-8").replaceAll("\\+", "%20");
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
            for (Map.Entry entry : dataMap.entrySet()) {
                String sheetName = (String)entry.getKey();
                List list = (List)entry.getValue();
                ArrayList head = new ArrayList();
                if (!list.isEmpty()) {
                    String info = dto.getStartDate() + " \u2014\u2014 " + dto.getEndDate() + " " + sheetName + " \u4f17\u5eb7\u533b\u9662\uff08\u836f\u54c1\u914d\u9001\uff09";
                    Map firstRow = (Map)list.get(0);
                    for (String key : firstRow.keySet()) {
                        ArrayList<String> headColumn = new ArrayList<String>();
                        headColumn.add(info);
                        if (!("\u5f00\u836f\u65e5\u671f".equals(key) || "\u59d3\u540d".equals(key) || "\u624b\u673a\u53f7\u7801".equals(key) || "\u8eab\u4efd\u8bc1\u53f7\u7801".equals(key) || "\u914d\u9001\u5730\u5740".equals(key) || "\u8def\u7ebf".equals(key) || "\u7898\u4f0f\u5e3d\uff08\u5a01\u9ad8\uff09".equals(key) || "\u7898\u4f0f\u5e3d\uff08\u767e\u7279\uff09".equals(key) || "\u7898\u4f0f\u5e3d\uff08\u8d39\u68ee\uff09".equals(key) || "\u5907\u6ce8".equals(key))) {
                            headColumn.add("\u9001\u8d27\u6570\u91cf\uff08\u888b\uff09");
                        }
                        headColumn.add(key);
                        head.add(headColumn);
                    }
                }
                WriteSheet writeSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((String)sheetName).head(head)).build();
                ArrayList data = new ArrayList();
                for (LinkedHashMap row : list) {
                    ArrayList rowData = new ArrayList();
                    for (String key : row.keySet()) {
                        rowData.add(row.get(key));
                    }
                    data.add(rowData);
                }
                excelWriter.write(data, writeSheet);
                Workbook workbook = excelWriter.writeContext().writeWorkbookHolder().getWorkbook();
                Sheet sheet = workbook.getSheet(sheetName);
                sheet.setColumnWidth(4, 15360);
            }
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private HorizontalCellStyleStrategy createCellStyleStrategy() {
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        headWriteCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headWriteCellStyle.setBorderBottom(BorderStyle.THIN);
        headWriteCellStyle.setBorderLeft(BorderStyle.THIN);
        headWriteCellStyle.setBorderRight(BorderStyle.THIN);
        headWriteCellStyle.setBorderTop(BorderStyle.THIN);
        WriteFont headWriteFont = new WriteFont();
        headWriteFont.setFontHeightInPoints(Short.valueOf((short)12));
        headWriteCellStyle.setWriteFont(headWriteFont);
        headWriteCellStyle.setFillPatternType(FillPatternType.SOLID_FOREGROUND);
        headWriteCellStyle.setFillForegroundColor(Short.valueOf((short)40));
        headWriteCellStyle.setWrapped(Boolean.valueOf(true));
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        contentWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        contentWriteCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        contentWriteCellStyle.setBorderBottom(BorderStyle.THIN);
        contentWriteCellStyle.setBorderLeft(BorderStyle.THIN);
        contentWriteCellStyle.setBorderRight(BorderStyle.THIN);
        contentWriteCellStyle.setBorderTop(BorderStyle.THIN);
        WriteFont contentWriteFont = new WriteFont();
        contentWriteFont.setFontHeightInPoints(Short.valueOf((short)11));
        contentWriteCellStyle.setWriteFont(contentWriteFont);
        contentWriteCellStyle.setWrapped(Boolean.valueOf(true));
        return new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
    }

    public List<String> getManufacturerByGroup(Integer tenantId) {
        return this.outDrugDeliveryMapper.getManufacturerByGroup(tenantId);
    }

    public Page<OutDrugDeliveryVo> selectPageList(OutDrugDeliveryDto dto) {
        Page page = new Page((long)dto.getCurrent(), (long)dto.getSize());
        List list = this.outDrugDeliveryMapper.selectList(page, dto);
        for (OutDrugDeliveryVo record : list) {
            String patientName = HyposensitizationUtil.hyposensitizationForName((String)record.getPatientName());
            String phone = HyposensitizationUtil.hyposensitizationForPhone((String)record.getPatientPhone());
            record.setPatientName(patientName);
            record.setPatientPhone(phone);
        }
        page.setRecords(list);
        return page;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void getOutDrugDeliveryList(OutDrugDeliveryDto dto) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        if (StrUtil.isEmpty((CharSequence)dto.getStartDate()) && StrUtil.isEmpty((CharSequence)dto.getEndDate())) {
            LocalDate today = LocalDate.now();
            String todayStr = today.format(dateTimeFormatter);
            dto.setStartDate(todayStr);
            dto.setEndDate(todayStr);
        }
        LocalDate startDate = LocalDate.parse(dto.getStartDate());
        LocalDate endDate = LocalDate.parse(dto.getEndDate());
        LambdaQueryWrapper deleteWrapper = Wrappers.lambdaQuery();
        deleteWrapper.eq(OutDrugDeliveryEntity::getTenantId, (Object)dto.getTenantId());
        deleteWrapper.between(OutDrugDeliveryEntity::getOpenTime, (Object)startDate, (Object)endDate);
        this.outDrugDeliveryMapper.delete((Wrapper)deleteWrapper);
        List list = this.outDrugDeliveryMapper.getOutDrugDeliveryList(dto);
        Integer createId = dto.getCreateId();
        String createName = dto.getCreateName();
        list.forEach(entity -> {
            entity.setCreateId(createId);
            entity.setCreateName(createName);
        });
        if (!list.isEmpty()) {
            this.outDrugDeliveryMapper.insertList(list);
        }
    }
}

