/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.byh.outpatient.api.dto.medicalRecord.OutPatientHealthRecordDto;
import com.byh.outpatient.api.dto.medicalRecord.Out_AllergyHistoryDto;
import com.byh.outpatient.api.dto.medicalRecord.Out_FamilyHistoryDto;
import com.byh.outpatient.api.dto.medicalRecord.Out_PastHistoryDto;
import com.byh.outpatient.api.dto.medicalRecord.Out_PersonalHistoryDto;
import com.byh.outpatient.api.dto.medicalRecord.QueryPatientHealthRecordDto;
import com.byh.outpatient.api.model.medicalRecord.OutPatientHealthRecord;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.StringUtil;
import com.byh.outpatient.api.vo.medicalRecord.QueryOutPatientHealthRecordVo;
import com.byh.outpatient.data.repository.OutPatientHealthRecordMapper;
import com.byh.outpatient.web.service.OutPatientHealthRecordService;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class OutPatientHealthRecordServiceImpl
implements OutPatientHealthRecordService {
    @Autowired
    private OutPatientHealthRecordMapper outPatientHealthRecordMapper;
    private static Logger log = LoggerFactory.getLogger(OutPatientHealthRecordServiceImpl.class);

    public ResponseData<QueryOutPatientHealthRecordVo> queryPatientHealthRecords(QueryPatientHealthRecordDto parameter) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"tenant_id", (Object)parameter.getTenantId());
        queryWrapper.eq((Object)"patient_id", (Object)parameter.getPatientId());
        OutPatientHealthRecord outPatientHealthRecord = (OutPatientHealthRecord)this.outPatientHealthRecordMapper.selectOne((Wrapper)queryWrapper);
        if (ObjectUtils.isEmpty((Object)outPatientHealthRecord)) {
            return ResponseData.success((Object)new QueryOutPatientHealthRecordVo());
        }
        QueryOutPatientHealthRecordVo queryOutPatientHealthRecordVo = OutPatientHealthRecordServiceImpl.getQueryOutPatientHealthRecordVo((OutPatientHealthRecord)outPatientHealthRecord);
        return ResponseData.success((Object)queryOutPatientHealthRecordVo);
    }

    public ResponseData updatePatientHealthRecords(OutPatientHealthRecordDto parameter) {
        log.info("\u66f4\u65b0\u60a3\u8005\u5065\u5eb7\u6863\u6848-PatientId:{}", (Object)parameter.getPatientId());
        if (ObjectUtils.isEmpty((Object)parameter) || parameter.getPatientId() == null || parameter.getTenantId() == null) {
            return ResponseData.error((String)"\u66f4\u65b0\u60a3\u8005\u5065\u5eb7\u6863\u6848\u5931\u8d25\uff01\u60a3\u8005ID\u548c\u79df\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"tenant_id", (Object)parameter.getTenantId());
        queryWrapper.eq((Object)"patient_id", (Object)parameter.getPatientId());
        OutPatientHealthRecord patientHealthRecord = (OutPatientHealthRecord)this.outPatientHealthRecordMapper.selectOne((Wrapper)queryWrapper);
        OutPatientHealthRecord outPatientHealthRecord = new OutPatientHealthRecord();
        BeanUtils.copyProperties((Object)parameter, (Object)outPatientHealthRecord);
        if (patientHealthRecord == null) {
            outPatientHealthRecord.setCreateId(parameter.getOperator());
            outPatientHealthRecord.setCreateTime(new Date());
            outPatientHealthRecord.setCreateName(parameter.getOperatorName());
            int size = this.outPatientHealthRecordMapper.insert((Object)outPatientHealthRecord);
            log.info("\u60a3\u8005\u65b0\u589e\u5065\u5eb7\u6863\u6848\u7ed3\u675f-\u66f4\u65b0\u6570\u91cf:{}-PatientId:{}", (Object)size, (Object)parameter.getPatientId());
        } else {
            outPatientHealthRecord.setId(patientHealthRecord.getId());
            outPatientHealthRecord.setUpdateId(parameter.getOperator());
            outPatientHealthRecord.setUpdateTime(new Date());
            outPatientHealthRecord.setUpdateName(parameter.getOperatorName());
            outPatientHealthRecord.setUpdateId(patientHealthRecord.getId());
            int size = this.outPatientHealthRecordMapper.updateById((Object)outPatientHealthRecord);
            log.info("\u60a3\u8005\u4fee\u6539\u5065\u5eb7\u6863\u6848\u7ed3\u675f-\u66f4\u65b0\u6570\u91cf:{}-PatientId:{}", (Object)size, (Object)parameter.getPatientId());
        }
        return ResponseData.success((Object)"\u64cd\u4f5c\u5b8c\u6210");
    }

    private static QueryOutPatientHealthRecordVo getQueryOutPatientHealthRecordVo(OutPatientHealthRecord outPatientHealthRecord) {
        QueryOutPatientHealthRecordVo queryOutPatientHealthRecordVo = new QueryOutPatientHealthRecordVo();
        BeanUtils.copyProperties((Object)outPatientHealthRecord, (Object)queryOutPatientHealthRecordVo);
        queryOutPatientHealthRecordVo.setDiseaseHistory(JSON.parseArray((String)outPatientHealthRecord.getDiseaseHistory(), Out_PastHistoryDto.class));
        queryOutPatientHealthRecordVo.setSurgicalHistory(JSON.parseArray((String)outPatientHealthRecord.getSurgicalHistory(), Out_PastHistoryDto.class));
        queryOutPatientHealthRecordVo.setAllergyHistory(JSON.parseArray((String)outPatientHealthRecord.getAllergyHistory(), Out_AllergyHistoryDto.class));
        queryOutPatientHealthRecordVo.setFamilyHistory(JSON.parseArray((String)outPatientHealthRecord.getFamilyHistory(), Out_FamilyHistoryDto.class));
        queryOutPatientHealthRecordVo.setSmokingHistory((Out_PersonalHistoryDto)JSON.parseObject((String)outPatientHealthRecord.getSmokingHistory(), Out_PersonalHistoryDto.class));
        queryOutPatientHealthRecordVo.setDrinkingHistroy((Out_PersonalHistoryDto)JSON.parseObject((String)outPatientHealthRecord.getDrinkingHistroy(), Out_PersonalHistoryDto.class));
        Map birAgeSex = StringUtil.getBirAgeSex((String)outPatientHealthRecord.getPatientCardNo());
        queryOutPatientHealthRecordVo.setGender((String)birAgeSex.get("sexCode"));
        queryOutPatientHealthRecordVo.setAge(ObjectUtils.isEmpty(birAgeSex.get("age")) ? null : Integer.valueOf((String)birAgeSex.get("age")));
        queryOutPatientHealthRecordVo.setPatientCardNo(null);
        return queryOutPatientHealthRecordVo;
    }
}

