/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.alibaba.excel.write.style.column.SimpleColumnWidthStyleStrategy;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.outpatient.api.dto.SysDepartmentDto;
import com.byh.outpatient.api.dto.outRevenueSummary.GetRevenueSummaryDto;
import com.byh.outpatient.api.dto.outRevenueSummary.UpdateRevenueSummaryDto;
import com.byh.outpatient.api.exception.BusinessException;
import com.byh.outpatient.api.model.OutRevenueSummaryEntity;
import com.byh.outpatient.api.sysModel.respones.SysDepartmentVo;
import com.byh.outpatient.api.util.ExceptionUtils;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.StringUtil;
import com.byh.outpatient.api.vo.admission.OutRevenueSummaryVo;
import com.byh.outpatient.data.repository.AdmissionMapper;
import com.byh.outpatient.data.repository.OutPrescriptionMapper;
import com.byh.outpatient.data.repository.OutRevenueSummaryMapper;
import com.byh.outpatient.web.feign.SysServiceFeign;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.OutRevenueSummaryService;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OutRevenueSummaryServiceImpl
implements OutRevenueSummaryService {
    private static final Logger log = LoggerFactory.getLogger(OutRevenueSummaryServiceImpl.class);
    @Autowired
    private SysServiceFeign sysServiceFeign;
    @Resource
    private OutRevenueSummaryMapper outRevenueSummaryMapper;
    @Resource
    private AdmissionMapper admissionMapper;
    @Resource
    private OutPrescriptionMapper prescriptionMapper;
    @Autowired
    private CommonRequest commonRequest;
    private Logger logger = LoggerFactory.getLogger(OutRevenueSummaryServiceImpl.class);

    @Scheduled(cron="0 0 1 * * ?")
    @Transactional(rollbackFor={BusinessException.class})
    public void timingGenerateRevenueSummary() {
        LocalDate today = LocalDate.now();
        LocalDate yesterday = today.minusDays(1L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String yesterdayStr = yesterday.format(formatter);
        GetRevenueSummaryDto dto = new GetRevenueSummaryDto();
        dto.setTenantId(Integer.valueOf(1));
        dto.setCreateId(Integer.valueOf(1));
        dto.setCreateName("\u51cc\u66681\u70b9\u5b9a\u65f6\u751f\u6210\u8425\u6536\u6c47\u603b");
        dto.setStartDate(yesterdayStr);
        dto.setEndDate(yesterdayStr);
        this.getRevenueSummary(dto);
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void updateRevenueSummary(LinkedHashMap<String, Object> map, UpdateRevenueSummaryDto dto) {
        Object revenueDateObj = map.get("\u65e5\u671f");
        Date revenuedate = new Date();
        if (revenueDateObj instanceof String) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                revenuedate = sdf.parse((String)revenueDateObj);
            }
            catch (Exception e) {
                ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)e.getMessage());
            }
        }
        LambdaQueryWrapper deleteWrapper = Wrappers.lambdaQuery();
        deleteWrapper.eq(OutRevenueSummaryEntity::getRevenueDate, (Object)revenuedate);
        this.outRevenueSummaryMapper.delete((Wrapper)deleteWrapper);
        ArrayList<OutRevenueSummaryEntity> list = new ArrayList<OutRevenueSummaryEntity>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if ("\u65e5\u671f".equals(entry.getKey())) continue;
            String key = entry.getKey();
            OutRevenueSummaryEntity outRevenueSummary = new OutRevenueSummaryEntity();
            if ("\u5185\u79d1\uff08\u8179\u900f\uff09".equals(key) || "\u714e\u836f\u6570\uff08\u5242\uff09".equals(key) || "\u7ebf\u4e0a\u5904\u65b9\uff08\u5355\uff09".equals(key) || "\u5316\u9a8c\u8d39".equals(key) || "\u68c0\u67e5\u8d39".equals(key) || "\u6cbb\u7597\u8d39".equals(key) || "\u767b\u8bb0\u5b9a\u70b9\u4eba\u5458".equals(key) || "\u5df2\u5b8c\u6210\u5b9a\u70b9\u4eba\u5458".equals(key)) {
                outRevenueSummary.setBusinessType("2");
            } else {
                outRevenueSummary.setBusinessType("1");
            }
            outRevenueSummary.setTenantId(dto.getTenantId());
            outRevenueSummary.setCreateId(dto.getCreateId());
            outRevenueSummary.setCreateName(dto.getCreateName());
            outRevenueSummary.setRevenueDate(revenuedate);
            outRevenueSummary.setBusinessName(entry.getKey());
            Object valueObj = entry.getValue();
            BigDecimal totalAmount = new BigDecimal(0);
            if (valueObj instanceof Number) {
                totalAmount = BigDecimal.valueOf(((Number)valueObj).doubleValue());
            }
            outRevenueSummary.setTotalAmount(totalAmount);
            list.add(outRevenueSummary);
        }
        this.outRevenueSummaryMapper.insertList(list);
    }

    /*
     * WARNING - void declaration
     */
    public void exportRevenueSummary(HttpServletResponse response, GetRevenueSummaryDto dto) {
        ArrayList dataList = new ArrayList();
        LocalDate startDate = LocalDate.parse(dto.getStartDate());
        LocalDate endDate = LocalDate.parse(dto.getEndDate());
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.between(OutRevenueSummaryEntity::getRevenueDate, (Object)startDate, (Object)endDate);
        queryWrapper.eq(OutRevenueSummaryEntity::getTenantId, (Object)dto.getTenantId());
        ((LambdaQueryWrapper)queryWrapper.orderByAsc(OutRevenueSummaryEntity::getRevenueDate)).orderByAsc(OutRevenueSummaryEntity::getBusinessType);
        List list = this.outRevenueSummaryMapper.selectList((Wrapper)queryWrapper);
        if (!list.isEmpty()) {
            Map outRevenueMap = list.stream().collect(Collectors.groupingBy(OutRevenueSummaryEntity::getRevenueDate, LinkedHashMap::new, Collectors.toList()));
            List firstList = (List)outRevenueMap.values().iterator().next();
            int deptCount = 0;
            for (Object outRevenueSummary : firstList) {
                if (!"1".equals(outRevenueSummary.getBusinessType())) continue;
                ++deptCount;
            }
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            for (Map.Entry entry : outRevenueMap.entrySet()) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                LocalDate revenueDateLocal = ((Date)entry.getKey()).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                String revenueDateStr = revenueDateLocal.format(formatter);
                map.put("\u65e5\u671f", revenueDateStr);
                int n = 0;
                BigDecimal totalAmount = new BigDecimal(0);
                for (OutRevenueSummaryEntity outRevenueSummary : (List)entry.getValue()) {
                    if ("1".equals(outRevenueSummary.getBusinessType())) {
                        totalAmount = totalAmount.add(outRevenueSummary.getTotalAmount());
                    }
                    if (!"1".equals(outRevenueSummary.getBusinessType()) && n < 1) {
                        ++n;
                        map.put("\u5408\u8ba1\u91d1\u989d", totalAmount.stripTrailingZeros().toPlainString());
                    }
                    map.put(outRevenueSummary.getBusinessName(), outRevenueSummary.getTotalAmount().stripTrailingZeros().toPlainString());
                }
                dataList.add(map);
            }
            Map businessNameMap = list.stream().collect(Collectors.groupingBy(OutRevenueSummaryEntity::getBusinessName, LinkedHashMap::new, Collectors.toList()));
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            linkedHashMap.put("\u65e5\u671f", "\u5408\u8ba1");
            int count = 0;
            BigDecimal deptTotalAmount = new BigDecimal(0);
            for (Map.Entry entry : businessNameMap.entrySet()) {
                void var21_50;
                ++count;
                String businessName = (String)entry.getKey();
                List list2 = (List)entry.getValue();
                String businessType = "";
                BigDecimal bigDecimal = new BigDecimal(0);
                for (OutRevenueSummaryEntity outRevenueSummary : list2) {
                    BigDecimal bigDecimal2 = var21_50.add(outRevenueSummary.getTotalAmount());
                    if (!"1".equals(outRevenueSummary.getBusinessType())) continue;
                    deptTotalAmount = deptTotalAmount.add(outRevenueSummary.getTotalAmount());
                }
                if (count == deptCount + 1) {
                    linkedHashMap.put("\u5408\u8ba1\u91d1\u989d", deptTotalAmount);
                }
                linkedHashMap.put(businessName, var21_50);
            }
            dataList.add(linkedHashMap);
            LinkedHashMap yearTotalMap = this.selectRevenueSummaryListAllYear(dto.getTenantId());
            LinkedHashMap<String, Object> linkedHashMap2 = new LinkedHashMap<String, Object>();
            linkedHashMap2.put("\u65e5\u671f", "\u5e74\u5ea6\u5408\u8ba1");
            int yearCount = 0;
            BigDecimal bigDecimal = new BigDecimal(0);
            for (Map.Entry entry : yearTotalMap.entrySet()) {
                void var19_43;
                if (++yearCount <= deptCount) {
                    Object deptAmountObj = entry.getValue();
                    BigDecimal deptAmount = new BigDecimal((String)deptAmountObj);
                    BigDecimal bigDecimal3 = var19_43.add(deptAmount);
                }
                if (yearCount == deptCount + 1) {
                    linkedHashMap2.put("\u5408\u8ba1\u91d1\u989d", var19_43);
                }
                linkedHashMap2.put((String)entry.getKey(), entry.getValue());
            }
            dataList.add(linkedHashMap2);
        }
        try (ServletOutputStream out = response.getOutputStream();){
            ExcelWriter excelWriter = ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)out).registerWriteHandler((WriteHandler)new SimpleColumnWidthStyleStrategy(Integer.valueOf(30)))).registerWriteHandler((WriteHandler)this.createCellStyleStrategy())).build();
            Object object = null;
            try {
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2");
                String string = LocalDateTime.now(ZoneOffset.ofHours(8)).format(dateTimeFormatter);
                String fileName = URLEncoder.encode("\u95e8\u8bca\u8425\u6536\u6c47\u603b" + string, "UTF-8").replaceAll("\\+", "%20");
                response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                response.setCharacterEncoding("utf-8");
                response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
                ArrayList head = new ArrayList();
                if (!dataList.isEmpty()) {
                    Map firstRow = (Map)dataList.get(0);
                    boolean bl = false;
                    for (String string2 : firstRow.keySet()) {
                        void var17_32;
                        ArrayList<String> headColumn = new ArrayList<String>();
                        headColumn.add("\u4f17\u5eb7\u533b\u9662\u8425\u6536\u6c47\u603b");
                        if ("\u5185\u79d1\uff08\u8179\u900f\uff09".equals(string2) || "\u714e\u836f\u6570\uff08\u5242\uff09".equals(string2) || "\u7ebf\u4e0a\u5904\u65b9\uff08\u5355\uff09".equals(string2) || "\u5316\u9a8c\u8d39".equals(string2) || "\u68c0\u67e5\u8d39".equals(string2) || "\u6cbb\u7597\u8d39".equals(string2)) {
                            headColumn.add("\u5de5\u4f5c\u91cf\u7edf\u8ba1");
                        } else if ("\u767b\u8bb0\u5b9a\u70b9\u4eba\u5458".equals(string2) || "\u5df2\u5b8c\u6210\u5b9a\u70b9\u4eba\u5458".equals(string2)) {
                            headColumn.add("\u6162\u75c5\u5b9a\u70b9");
                        } else if (!"\u65e5\u671f".equals(string2)) {
                            headColumn.add("\u79d1\u5ba4");
                        }
                        headColumn.add(string2);
                        head.add(headColumn);
                        ++var17_32;
                    }
                }
                WriteSheet writeSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((String)"\u95e8\u8bca\u8425\u6536\u6c47\u603b").head(head)).build();
                ArrayList arrayList = new ArrayList();
                for (Map map : dataList) {
                    ArrayList rowData = new ArrayList();
                    for (String key : map.keySet()) {
                        rowData.add(map.get(key));
                    }
                    arrayList.add(rowData);
                }
                excelWriter.write(arrayList, writeSheet);
                out.flush();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (excelWriter != null) {
                    if (object != null) {
                        try {
                            excelWriter.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        excelWriter.close();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private HorizontalCellStyleStrategy createCellStyleStrategy() {
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        headWriteCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headWriteCellStyle.setBorderBottom(BorderStyle.THIN);
        headWriteCellStyle.setBorderLeft(BorderStyle.THIN);
        headWriteCellStyle.setBorderRight(BorderStyle.THIN);
        headWriteCellStyle.setBorderTop(BorderStyle.THIN);
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        contentWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        contentWriteCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        contentWriteCellStyle.setBorderBottom(BorderStyle.THIN);
        contentWriteCellStyle.setBorderLeft(BorderStyle.THIN);
        contentWriteCellStyle.setBorderRight(BorderStyle.THIN);
        contentWriteCellStyle.setBorderTop(BorderStyle.THIN);
        return new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
    }

    public List<String> selectBusinessNameGroup(Integer tenantId) {
        return this.outRevenueSummaryMapper.selectBusinessNameGroup(tenantId);
    }

    public LinkedHashMap<String, Object> selectRevenueSummaryListAllYear(Integer tenantId) {
        LocalDate startDate = LocalDate.now().withDayOfYear(1);
        LocalDate endDate = LocalDate.now().withDayOfYear(LocalDate.now().lengthOfYear());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String startDateStr = startDate.format(formatter);
        String endDateStr = endDate.format(formatter);
        List list = this.outRevenueSummaryMapper.selectListByDate(startDateStr, endDateStr, tenantId);
        Map map = list.stream().collect(Collectors.groupingBy(OutRevenueSummaryEntity::getBusinessName, LinkedHashMap::new, Collectors.toList()));
        LinkedHashMap<String, Object> amountMap = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : map.entrySet()) {
            BigDecimal totalAmount = ((List)entry.getValue()).stream().map(OutRevenueSummaryEntity::getTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            amountMap.put((String)entry.getKey(), totalAmount.stripTrailingZeros().toPlainString());
        }
        return amountMap;
    }

    public List<LinkedHashMap<String, Object>> selectRevenueSummaryList(GetRevenueSummaryDto dto) {
        List list = this.outRevenueSummaryMapper.selectListByDate(dto.getStartDate(), dto.getEndDate(), dto.getTenantId());
        Map amountMap = list.stream().collect(Collectors.groupingBy(OutRevenueSummaryEntity::getRevenueDate, LinkedHashMap::new, Collectors.toList()));
        ArrayList<LinkedHashMap<String, Object>> mapList = new ArrayList<LinkedHashMap<String, Object>>();
        for (Map.Entry entry : amountMap.entrySet()) {
            int count = 0;
            LinkedHashMap summaryMap = new LinkedHashMap();
            summaryMap.put("\u65e5\u671f", entry.getKey());
            List entityList = (List)entry.getValue();
            BigDecimal totalAmount = new BigDecimal(0);
            for (OutRevenueSummaryEntity entity : entityList) {
                if ("1".equals(entity.getBusinessType())) {
                    totalAmount = totalAmount.add(entity.getTotalAmount());
                }
                if (!"1".equals(entity.getBusinessType()) && count < 1) {
                    ++count;
                    summaryMap.put("\u5408\u8ba1\u91d1\u989d", totalAmount.stripTrailingZeros().toPlainString());
                }
                summaryMap.put(entity.getBusinessName(), entity.getTotalAmount().stripTrailingZeros().toPlainString());
            }
            mapList.add(summaryMap);
        }
        return mapList;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void getRevenueSummary(GetRevenueSummaryDto dto) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        if (StringUtil.isEmpty((String)dto.getStartDate()) || StringUtil.isEmpty((String)dto.getEndDate())) {
            LocalDate currentDate = LocalDate.now();
            String currentDateStr = currentDate.format(formatter);
            dto.setStartDate(currentDateStr);
            dto.setEndDate(currentDateStr);
        }
        LocalDate startDate = LocalDate.parse(dto.getStartDate());
        LocalDate endDate = LocalDate.parse(dto.getEndDate());
        LambdaQueryWrapper deleteWrapper = Wrappers.lambdaQuery();
        deleteWrapper.between(OutRevenueSummaryEntity::getRevenueDate, (Object)startDate, (Object)endDate);
        this.outRevenueSummaryMapper.delete((Wrapper)deleteWrapper);
        SysDepartmentDto deptDto = new SysDepartmentDto();
        deptDto.setDepartmentType("0");
        deptDto.setTenantId(dto.getTenantId());
        ResponseData responseData = this.sysServiceFeign.selectDeptList(deptDto);
        if (!responseData.isSuccess()) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)responseData.getMsg());
        }
        Object object = responseData.getData();
        List mapList = (List)object;
        List deptList = mapList.stream().map(map -> {
            SysDepartmentVo deptVo = new SysDepartmentVo();
            deptVo.setId((Integer)map.get("id"));
            deptVo.setDepartmentName((String)map.get("departmentName"));
            return deptVo;
        }).collect(Collectors.toList());
        ArrayList<Date> dateList = new ArrayList<Date>();
        while (!startDate.isAfter(endDate)) {
            dateList.add(Date.from(startDate.atStartOfDay(ZoneId.systemDefault()).toInstant()));
            startDate = startDate.plusDays(1L);
        }
        Integer createId = dto.getCreateId();
        String createName = dto.getCreateName();
        ArrayList<OutRevenueSummaryEntity> outRevenueList = new ArrayList<OutRevenueSummaryEntity>();
        for (Date date : dateList) {
            OutRevenueSummaryEntity outRevenueSummary = new OutRevenueSummaryEntity();
            for (Object deptVo : deptList) {
                outRevenueSummary = new OutRevenueSummaryEntity();
                outRevenueSummary.setRevenueDate(date);
                outRevenueSummary.setTenantId(dto.getTenantId());
                outRevenueSummary.setBusinessName(deptVo.getDepartmentName());
                outRevenueSummary.setTotalAmount(BigDecimal.ZERO);
                outRevenueSummary.setBusinessType("1");
                outRevenueSummary.setCreateId(createId);
                outRevenueSummary.setCreateName(createName);
                outRevenueList.add(outRevenueSummary);
            }
            outRevenueSummary = new OutRevenueSummaryEntity();
            outRevenueSummary.setRevenueDate(date);
            outRevenueSummary.setTenantId(dto.getTenantId());
            outRevenueSummary.setBusinessName("\u5185\u79d1\uff08\u8179\u900f\uff09");
            outRevenueSummary.setTotalAmount(BigDecimal.ZERO);
            outRevenueSummary.setBusinessType("2");
            outRevenueSummary.setCreateId(createId);
            outRevenueSummary.setCreateName(createName);
            outRevenueList.add(outRevenueSummary);
            outRevenueSummary = new OutRevenueSummaryEntity();
            outRevenueSummary.setRevenueDate(date);
            outRevenueSummary.setTenantId(dto.getTenantId());
            outRevenueSummary.setBusinessName("\u714e\u836f\u6570\uff08\u5242\uff09");
            outRevenueSummary.setTotalAmount(BigDecimal.ZERO);
            outRevenueSummary.setBusinessType("2");
            outRevenueSummary.setCreateId(createId);
            outRevenueSummary.setCreateName(createName);
            outRevenueList.add(outRevenueSummary);
            outRevenueSummary = new OutRevenueSummaryEntity();
            outRevenueSummary.setRevenueDate(date);
            outRevenueSummary.setTenantId(dto.getTenantId());
            outRevenueSummary.setBusinessName("\u7ebf\u4e0a\u5904\u65b9\uff08\u5355\uff09");
            outRevenueSummary.setTotalAmount(BigDecimal.ZERO);
            outRevenueSummary.setBusinessType("2");
            outRevenueSummary.setCreateId(createId);
            outRevenueSummary.setCreateName(createName);
            outRevenueList.add(outRevenueSummary);
            outRevenueSummary = new OutRevenueSummaryEntity();
            outRevenueSummary.setRevenueDate(date);
            outRevenueSummary.setTenantId(dto.getTenantId());
            outRevenueSummary.setBusinessName("\u5316\u9a8c\u8d39");
            outRevenueSummary.setTotalAmount(BigDecimal.ZERO);
            outRevenueSummary.setBusinessType("2");
            outRevenueSummary.setCreateId(createId);
            outRevenueSummary.setCreateName(createName);
            outRevenueList.add(outRevenueSummary);
            outRevenueSummary = new OutRevenueSummaryEntity();
            outRevenueSummary.setRevenueDate(date);
            outRevenueSummary.setTenantId(dto.getTenantId());
            outRevenueSummary.setBusinessName("\u68c0\u67e5\u8d39");
            outRevenueSummary.setTotalAmount(BigDecimal.ZERO);
            outRevenueSummary.setBusinessType("2");
            outRevenueSummary.setCreateId(createId);
            outRevenueSummary.setCreateName(createName);
            outRevenueList.add(outRevenueSummary);
            outRevenueSummary = new OutRevenueSummaryEntity();
            outRevenueSummary.setRevenueDate(date);
            outRevenueSummary.setTenantId(dto.getTenantId());
            outRevenueSummary.setBusinessName("\u6cbb\u7597\u8d39");
            outRevenueSummary.setTotalAmount(BigDecimal.ZERO);
            outRevenueSummary.setBusinessType("2");
            outRevenueSummary.setCreateId(createId);
            outRevenueSummary.setCreateName(createName);
            outRevenueList.add(outRevenueSummary);
            outRevenueSummary = new OutRevenueSummaryEntity();
            outRevenueSummary.setRevenueDate(date);
            outRevenueSummary.setTenantId(dto.getTenantId());
            outRevenueSummary.setBusinessName("\u767b\u8bb0\u5b9a\u70b9\u4eba\u5458");
            outRevenueSummary.setTotalAmount(BigDecimal.ZERO);
            outRevenueSummary.setBusinessType("2");
            outRevenueSummary.setCreateId(createId);
            outRevenueSummary.setCreateName(createName);
            outRevenueList.add(outRevenueSummary);
            outRevenueSummary = new OutRevenueSummaryEntity();
            outRevenueSummary.setRevenueDate(date);
            outRevenueSummary.setTenantId(dto.getTenantId());
            outRevenueSummary.setBusinessName("\u5df2\u5b8c\u6210\u5b9a\u70b9\u4eba\u5458");
            outRevenueSummary.setTotalAmount(BigDecimal.ZERO);
            outRevenueSummary.setBusinessType("2");
            outRevenueSummary.setCreateId(createId);
            outRevenueSummary.setCreateName(createName);
            outRevenueList.add(outRevenueSummary);
        }
        List outRevenueSummaryList = this.admissionMapper.getRevenueSummaryList(dto.getStartDate(), dto.getEndDate());
        Map map2 = outRevenueSummaryList.stream().collect(Collectors.toMap(outRevenueSummaryVo -> {
            LocalDate revenueDateLocal = outRevenueSummaryVo.getRevenueDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            String revenueDateStr = revenueDateLocal.format(formatter);
            return revenueDateStr + outRevenueSummaryVo.getBusinessName();
        }, Function.identity()));
        List prescNos = this.prescriptionMapper.selectPrescNos("\u8179\u900f\u836f\u623f");
        if (!prescNos.isEmpty()) {
            List peritoneoscopyList = this.admissionMapper.selectAmountForPeritoneoscopy(dto.getStartDate(), dto.getEndDate(), prescNos);
            for (OutRevenueSummaryVo vo : peritoneoscopyList) {
                LocalDate revenueDateLocal = vo.getRevenueDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                String revenueDateStr = revenueDateLocal.format(formatter);
                map2.put(revenueDateStr + vo.getBusinessName(), vo);
            }
        }
        for (OutRevenueSummaryEntity outRevenueSummary : outRevenueList) {
            LocalDate revenueDateLocal = outRevenueSummary.getRevenueDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            String revenueDateStr = revenueDateLocal.format(formatter);
            OutRevenueSummaryVo outRevenueSummaryVo2 = (OutRevenueSummaryVo)map2.get(revenueDateStr + outRevenueSummary.getBusinessName());
            if (outRevenueSummaryVo2 == null) continue;
            outRevenueSummary.setTotalAmount(outRevenueSummaryVo2.getTotalAmount());
        }
        this.outRevenueSummaryMapper.insertList(outRevenueList);
    }
}

