/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.outpatient.api.model.OutFollowUpSettingsEntity;
import com.byh.outpatient.api.model.OutFollowUpTasksEntity;
import com.byh.outpatient.api.sysModel.request.SysDoctorDto;
import com.byh.outpatient.api.sysModel.respones.SysDoctorIdVo;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.vo.TaskByDispense;
import com.byh.outpatient.api.vo.TaskByDrugVo;
import com.byh.outpatient.api.vo.TaskByPatientVo;
import com.byh.outpatient.data.repository.OutFollowUpSettingsMapper;
import com.byh.outpatient.data.repository.OutFollowUpTasksMapper;
import com.byh.outpatient.web.feign.SysServiceFeign;
import com.byh.outpatient.web.service.OutFollowUpSettingsService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OutFollowUpSettingsServiceImpl
implements OutFollowUpSettingsService {
    @Resource
    private OutFollowUpSettingsMapper outFollowUpSettingsMapper;
    @Autowired
    private SysServiceFeign sysServiceFeign;
    @Autowired
    private OutFollowUpTasksMapper tasksMapper;

    public void outFollowUpSettingsSave(OutFollowUpSettingsEntity entity) {
        Integer createId = entity.getCreateId();
        SysDoctorDto doctorDto = new SysDoctorDto();
        doctorDto.setId(createId);
        ResponseData responseData = this.sysServiceFeign.doctorById(doctorDto, entity.getTenantId() + "");
        SysDoctorIdVo vo = (SysDoctorIdVo)responseData.getData();
        entity.setDeptId(Integer.valueOf(Integer.parseInt(vo.getDepartmentId())));
        int insert = this.outFollowUpSettingsMapper.insert((Object)entity);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OutFollowUpSettingsEntity outFollowUpSettingsSelect(OutFollowUpSettingsEntity entity) throws ParseException {
        Integer createId = entity.getCreateId();
        SysDoctorDto doctorDto = new SysDoctorDto();
        doctorDto.setId(createId);
        ResponseData responseData = this.sysServiceFeign.doctorById(doctorDto, entity.getTenantId() + "");
        HashMap map = (HashMap)responseData.getData();
        List list = this.outFollowUpSettingsMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(OutFollowUpSettingsEntity::getDeptId, map.get("departmentId")));
        if (list.size() != 0) return (OutFollowUpSettingsEntity)list.get(0);
        entity.setBeforeEnd(Integer.valueOf(3));
        entity.setAfterEnd(Integer.valueOf(3));
        entity.setAfterEndOver(Integer.valueOf(15));
        entity.setFollowUpInterval(Integer.valueOf(7));
        entity.setDeptId(Integer.valueOf(Integer.parseInt(map.get("departmentId") + "")));
        int insert = this.outFollowUpSettingsMapper.insert((Object)entity);
        if (insert <= 0) return entity;
        return entity;
    }

    public void outFollowUpSettingsUpdate(OutFollowUpSettingsEntity entity) throws ParseException {
        Integer createId = entity.getCreateId();
        SysDoctorDto doctorDto = new SysDoctorDto();
        doctorDto.setId(createId);
        ResponseData responseData = this.sysServiceFeign.doctorById(doctorDto, entity.getTenantId() + "");
        HashMap map = (HashMap)responseData.getData();
        int update = this.outFollowUpSettingsMapper.update((Object)entity, (Wrapper)Wrappers.lambdaUpdate().eq(OutFollowUpSettingsEntity::getDeptId, map.get("departmentId")));
        if (update > 0) {
            // empty if block
        }
    }

    private void checkTask() throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String timeStr = format.format(new Date());
        Calendar calendar = Calendar.getInstance();
        Date nowDay = format.parse(timeStr);
        List taskByPatientVos = this.tasksMapper.queryDispenseDateByTask();
        ArrayList<OutFollowUpTasksEntity> list = new ArrayList<OutFollowUpTasksEntity>();
        block0: for (TaskByPatientVo taskByPatientVo : taskByPatientVos) {
            Integer userId = null;
            Integer patientId = null;
            Integer beforeEnd = taskByPatientVo.getBeforeEnd();
            Integer afterEnd = taskByPatientVo.getAfterEnd();
            Integer afterEndOver = taskByPatientVo.getAfterEndOver();
            for (TaskByDrugVo drugVo : taskByPatientVo.getDrugVos()) {
                List dispenseList = drugVo.getDispenseList();
                String dispenseDate = null;
                String followUpDate = null;
                Integer medicationDays = null;
                String opdId = null;
                String outpatientNo = null;
                String remark = null;
                for (int i = 0; i < dispenseList.size(); ++i) {
                    long followUpDateL;
                    TaskByDispense taskByDispense = (TaskByDispense)dispenseList.get(i);
                    opdId = taskByDispense.getOpdId();
                    outpatientNo = taskByDispense.getOutpatientNo();
                    String voDispenseDateTime = taskByDispense.getDispenseDateTime();
                    String voFollowUpDate = taskByDispense.getFollowUpDate();
                    if (dispenseDate == null) {
                        dispenseDate = voDispenseDateTime;
                        followUpDate = voFollowUpDate.substring(0, 10);
                        continue;
                    }
                    long dspenseDateL = format.parse(dispenseDate).getTime();
                    if (dspenseDateL > (followUpDateL = format.parse(voFollowUpDate).getTime())) break;
                    medicationDays = ((TaskByDispense)dispenseList.get(i - 1)).getMedicationDays() + taskByDispense.getMedicationDays();
                    dispenseDate = voDispenseDateTime;
                    calendar.setTime(format.parse(voDispenseDateTime));
                    calendar.add(5, medicationDays);
                    followUpDate = format.format(calendar.getTime());
                    remark = "\u6b64\u836f\u6709" + (i + 1) + "\u6761\u6570\u636e\u5728\u7528\u836f\u65f6\u95f4\u7ed3\u675f\u524d\u518d\u6b21\u8d2d\u836f\uff0c\u5df2\u6839\u636e\u7528\u836f\u5929\u6570\u5185\u91cd\u5408\u7684\u65f6\u95f4\u7d2f\u52a0\u8ba1\u7b97\u7528\u836f\u7ed3\u675f\u65f6\u95f4";
                }
                if (!StringUtils.isNotBlank(followUpDate)) continue;
                calendar.setTime(format.parse(followUpDate));
                Date followUpDateTime = calendar.getTime();
                calendar.add(5, -afterEndOver.intValue());
                long l = calendar.getTime().getTime() - nowDay.getTime();
                if (l > 0L) continue;
                Integer type = null;
                calendar.setTime(nowDay);
                calendar.add(5, beforeEnd);
                if (calendar.getTime().getTime() - followUpDateTime.getTime() == 0L) {
                    type = 1;
                }
                calendar.setTime(nowDay);
                calendar.add(5, -afterEnd.intValue());
                if (calendar.getTime().getTime() - followUpDateTime.getTime() == 0L) {
                    type = 2;
                }
                if (type == null) continue;
                userId = taskByPatientVo.getUserId();
                patientId = taskByPatientVo.getPatientId();
                OutFollowUpTasksEntity entity = new OutFollowUpTasksEntity();
                entity.setFollowType(type);
                entity.setCreateTime(timeStr);
                entity.setStatus(Integer.valueOf(1));
                entity.setUserId(userId);
                entity.setPatientId(patientId);
                entity.setTenantId(Integer.valueOf(1));
                entity.setDrugName(drugVo.getDrugName());
                entity.setOpdId(opdId);
                entity.setOutpatientNo(outpatientNo);
                entity.setFollowUpDate(followUpDate);
                if (StringUtils.isNotBlank((CharSequence)remark)) {
                    entity.setRemark(remark);
                }
                list.add(entity);
                continue block0;
            }
        }
        if (list.size() > 0) {
            this.tasksMapper.createTask(list);
        }
    }

    public void outFollowUpSettingsDelete(OutFollowUpSettingsEntity entity) {
        int a = this.outFollowUpSettingsMapper.outFollowUpSettingsDelete(entity);
    }
}

