/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.outpatient.api.dto.DataInput;
import com.byh.outpatient.api.dto.Group;
import com.byh.outpatient.api.dto.Indicator;
import com.byh.outpatient.api.dto.RequestDto;
import com.byh.outpatient.api.dto.lisResult.QueryLisResultDto;
import com.byh.outpatient.api.dto.lisResult.QueryTreatmentItemDto;
import com.byh.outpatient.api.dto.pay.Labinfo;
import com.byh.outpatient.api.dto.pay.LisIteminfo;
import com.byh.outpatient.api.dto.pay.LisRecordRequest;
import com.byh.outpatient.api.dto.pay.LisSampleinfo;
import com.byh.outpatient.api.enums.FrontMethodEnum;
import com.byh.outpatient.api.exception.BusinessException;
import com.byh.outpatient.api.model.front.FrontRequest;
import com.byh.outpatient.api.model.front.OutFrontConfig;
import com.byh.outpatient.api.model.lisResult.OutLisResultDetailEntity;
import com.byh.outpatient.api.model.lisResult.OutLisResultEntity;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.StringUtil;
import com.byh.outpatient.api.vo.lisResult.OutListResultVo;
import com.byh.outpatient.api.vo.lisResult.QueryTreatmentItemVo;
import com.byh.outpatient.data.repository.OutFrontConfigMapper;
import com.byh.outpatient.data.repository.OutLisResultDetailMapper;
import com.byh.outpatient.data.repository.OutLisResultMapper;
import com.byh.outpatient.web.feign.HsServiceFeign;
import com.byh.outpatient.web.service.ExpertStudioService;
import com.byh.outpatient.web.service.OutLisResultService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OutLisResultServiceImpl
implements OutLisResultService {
    private static final Logger log = LoggerFactory.getLogger(OutLisResultServiceImpl.class);
    private Logger logger = LoggerFactory.getLogger(OutLisResultServiceImpl.class);
    @Resource
    private OutLisResultMapper outLisResultMapper;
    @Resource
    private OutLisResultDetailMapper outLisResultDetailMapper;
    @Resource
    private OutFrontConfigMapper outFrontConfigMapper;
    @Autowired
    private HsServiceFeign hsServiceFeign;
    @Autowired
    private ExpertStudioService studioService;

    @Scheduled(cron="0 30 2 * * ?")
    @Transactional(rollbackFor={BusinessException.class})
    public void timingGetLisResultList() {
        LocalDate today = LocalDate.now();
        LocalDate yesterday = today.minusDays(1L);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String yesterdayStr = yesterday.format(dateTimeFormatter);
        QueryTreatmentItemDto dto = new QueryTreatmentItemDto();
        dto.setStartDate(yesterdayStr);
        dto.setEndDate(yesterdayStr);
        dto.setTenantId(Integer.valueOf(1));
        List list = this.outLisResultMapper.selectTreatmentItemList(dto);
        if (!list.isEmpty()) {
            List hisIds = list.stream().distinct().filter(Objects::nonNull).map(QueryTreatmentItemVo::getHisId).collect(Collectors.toList());
            Map listMap = list.stream().collect(Collectors.toMap(QueryTreatmentItemVo::getHisId, Function.identity()));
            if (!hisIds.isEmpty()) {
                QueryLisResultDto lisResultDto = new QueryLisResultDto();
                lisResultDto.setHisIds(hisIds);
                OutFrontConfig outFrontConfig = this.outFrontConfigMapper.queryByTenantId(Integer.valueOf(1), FrontMethodEnum.LIS_RESULT_BY_HISIDS.getValue());
                FrontRequest frontRequest = new FrontRequest();
                frontRequest.setBody((Object)lisResultDto);
                String result = HttpUtil.post((String)outFrontConfig.getInterfaceUrl(), (String)JSONObject.toJSONString((Object)frontRequest));
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                String code = jsonObject.getString("code");
                LinkedHashMap uploadMap = new LinkedHashMap();
                if ("1".equals(code)) {
                    String yesterStartDateTime = yesterdayStr + " 00:00:00";
                    String yesterEndDateTime = yesterdayStr + " 23:59:59";
                    LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
                    queryWrapper.eq(OutLisResultEntity::getTenantId, (Object)1);
                    queryWrapper.between(OutLisResultEntity::getTestTime, (Object)yesterStartDateTime, (Object)yesterEndDateTime);
                    List lisResultList = this.outLisResultMapper.selectList((Wrapper)queryWrapper);
                    List lisResultIds = lisResultList.stream().distinct().map(OutLisResultEntity::getId).collect(Collectors.toList());
                    if (!lisResultIds.isEmpty()) {
                        LambdaQueryWrapper deleteWrapper = Wrappers.lambdaQuery();
                        deleteWrapper.in(OutLisResultEntity::getId, lisResultIds);
                        this.outLisResultMapper.delete((Wrapper)deleteWrapper);
                        LambdaQueryWrapper deleteDetailWrapper = Wrappers.lambdaQuery();
                        deleteDetailWrapper.in(OutLisResultDetailEntity::getLisResultId, lisResultIds);
                        this.outLisResultDetailMapper.delete((Wrapper)deleteDetailWrapper);
                    }
                    JSONArray jsonArray = jsonObject.getJSONArray("body");
                    LinkedHashMap<String, List> map = new LinkedHashMap<String, List>();
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        JSONObject object = jsonArray.getJSONObject(i);
                        String hisId = object.getString("hisid");
                        Optional.ofNullable(listMap.get(hisId)).ifPresent(vo -> {
                            object.put("outpatientNo", (Object)vo.getOutpatientNo());
                            object.put("deptId", (Object)vo.getDeptId());
                            object.put("doctorId", (Object)vo.getDoctorId());
                            object.put("patientId", (Object)vo.getPatientId());
                            object.put("treatmentId", (Object)vo.getTreatmentItemId());
                        });
                        map.computeIfAbsent(hisId, k -> new ArrayList()).add(object);
                    }
                    ArrayList<OutLisResultDetailEntity> detailList = new ArrayList<OutLisResultDetailEntity>();
                    for (Map.Entry entry : map.entrySet()) {
                        List jsonObjects = (List)entry.getValue();
                        OutLisResultEntity newLisResult = new OutLisResultEntity();
                        JSONObject detailObject = (JSONObject)jsonObjects.get(0);
                        newLisResult.setTenantId(Integer.valueOf(1));
                        newLisResult.setCreateId(Integer.valueOf(1));
                        newLisResult.setCreateName("\u51cc\u66682\u70b9\u534a\u751f\u6210LIS\u68c0\u9a8c\u7ed3\u679c");
                        newLisResult.setOutpatientNo(detailObject.getString("outpatientNo"));
                        newLisResult.setDeptId(detailObject.getInteger("deptId"));
                        newLisResult.setDeptName(detailObject.getString("department"));
                        newLisResult.setDoctorId(detailObject.getInteger("doctorId"));
                        newLisResult.setDoctorName(detailObject.getString("doctor"));
                        newLisResult.setPatientId(detailObject.getInteger("patientId"));
                        newLisResult.setItemId(detailObject.getInteger("treatmentId"));
                        newLisResult.setItemName(detailObject.getString("feename"));
                        newLisResult.setHisId(detailObject.getString("hisid"));
                        newLisResult.setSpecimenType(detailObject.getString("samplename"));
                        newLisResult.setOpter(detailObject.getString("opter"));
                        newLisResult.setAuditOpter(detailObject.getString("auditopter"));
                        newLisResult.setPrintOpter(detailObject.getString("printopter"));
                        newLisResult.setSampleDate(this.getDateValue(detailObject, "sampledate"));
                        newLisResult.setTestTime(this.getDateValue(detailObject, "testtime"));
                        newLisResult.setAuditTime(this.getDateValue(detailObject, "audittime"));
                        newLisResult.setPrintTime(this.getDateValue(detailObject, "printtime"));
                        newLisResult.setVisitType(detailObject.getString("pattype"));
                        newLisResult.setBarcode(detailObject.getString("barcode"));
                        newLisResult.setBarcodeTime(this.getDateValue(detailObject, "barcodetime"));
                        this.outLisResultMapper.insert((Object)newLisResult);
                        for (JSONObject object : jsonObjects) {
                            OutLisResultDetailEntity detail = new OutLisResultDetailEntity();
                            detail.setLisResultId(newLisResult.getId());
                            detail.setTenantId(Integer.valueOf(1));
                            detail.setCreateId(Integer.valueOf(1));
                            detail.setCreateName("\u51cc\u66682\u70b9\u534a\u751f\u6210LIS\u68c0\u9a8c\u7ed3\u679c");
                            detail.setItemCode(object.getString("itemename"));
                            detail.setItemName(object.getString("itemcname"));
                            detail.setResult(object.getString("result"));
                            detail.setUnit(object.getString("unit"));
                            detail.setResultStatus(object.getString("state"));
                            detail.setReferrenceRange(object.getString("limit"));
                            detailList.add(detail);
                        }
                        uploadMap.put(newLisResult, detailList);
                    }
                    if (!detailList.isEmpty()) {
                        this.outLisResultDetailMapper.insertList(detailList);
                        this.pushEtube(uploadMap);
                    }
                    CompletableFuture.runAsync(() -> this.uploadLisResult(uploadMap));
                }
            }
        }
    }

    private void uploadLisResult(Map<OutLisResultEntity, List<OutLisResultDetailEntity>> uploadMap) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        for (Map.Entry<OutLisResultEntity, List<OutLisResultDetailEntity>> entry : uploadMap.entrySet()) {
            OutLisResultEntity lisResult = entry.getKey();
            List<OutLisResultDetailEntity> detailList = entry.getValue();
            LisRecordRequest request = new LisRecordRequest();
            Labinfo labinfo = new Labinfo();
            labinfo.setAppy_dept_code(String.valueOf(lisResult.getDeptId()));
            labinfo.setAppy_no(String.valueOf(lisResult.getItemId()));
            labinfo.setRpotc_no(String.valueOf(lisResult.getItemId()));
            labinfo.setBilg_dr_codg(String.valueOf(lisResult.getDoctorId()));
            labinfo.setBilg_dr_name(lisResult.getDoctorName());
            labinfo.setExam_item_code(String.valueOf(lisResult.getItemId()));
            labinfo.setExam_item_name(lisResult.getItemName());
            labinfo.setInhosp_exam_item_code(String.valueOf(lisResult.getItemId()));
            labinfo.setInhosp_exam_item_name(lisResult.getItemName());
            labinfo.setMdtrt_id(lisResult.getOutpatientNo());
            labinfo.setMdtrt_sn(lisResult.getOutpatientNo());
            labinfo.setPsn_no(String.valueOf(lisResult.getPatientId()));
            labinfo.setRpot_doc(lisResult.getAuditOpter());
            String testDateStr = dateFormat.format(lisResult.getTestTime());
            labinfo.setRpt_date(testDateStr);
            labinfo.setVali_flag("1");
            request.setLabinfo(labinfo);
            ArrayList<LisSampleinfo> lisSampleinfoList = new ArrayList<LisSampleinfo>();
            LisSampleinfo lisSampleinfo = new LisSampleinfo();
            lisSampleinfo.setAppy_no(String.valueOf(lisResult.getItemId()));
            lisSampleinfo.setRpotc_no(String.valueOf(lisResult.getItemId()));
            lisSampleinfo.setSpcm_no(String.valueOf(lisResult.getItemId()));
            String sampleDateStr = dateFormat.format(lisResult.getSampleDate());
            lisSampleinfo.setSapl_date(sampleDateStr);
            lisSampleinfo.setSpcm_name(lisResult.getSpecimenType());
            lisSampleinfoList.add(lisSampleinfo);
            request.setSampleinfo(lisSampleinfoList);
            if (!detailList.isEmpty()) {
                ArrayList<LisIteminfo> lisIteminfoList = new ArrayList<LisIteminfo>();
                for (OutLisResultDetailEntity detail : detailList) {
                    LisIteminfo iteminfo = new LisIteminfo();
                    iteminfo.setAppy_no(String.valueOf(lisResult.getItemId()));
                    iteminfo.setRpotc_no(String.valueOf(lisResult.getItemId()));
                    iteminfo.setExam_item_detl_code(detail.getItemCode());
                    iteminfo.setExam_item_detl_name(detail.getItemName());
                    iteminfo.setExam_rslt_abn(detail.getResultStatus());
                    iteminfo.setExam_rslt_dicm(detail.getResultStatus());
                    iteminfo.setExam_rslt_val(this.changeToBigDecimal(detail.getResult()));
                    iteminfo.setRef_val(detail.getReferrenceRange());
                    lisIteminfoList.add(iteminfo);
                }
                request.setIteminfo(lisIteminfoList);
            }
            request.setTenantId(Integer.valueOf(1));
            this.hsServiceFeign.lisRecord(request);
        }
    }

    public BigDecimal changeToBigDecimal(String result) {
        if (StrUtil.isEmpty((CharSequence)result)) {
            return null;
        }
        try {
            return new BigDecimal(result).setScale(0, RoundingMode.DOWN);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Transactional(rollbackFor={BusinessException.class})
    public OutLisResultEntity selectListResultList(QueryLisResultDto dto) {
        LambdaQueryWrapper lisResultQuery = Wrappers.lambdaQuery();
        lisResultQuery.eq(dto.getTenantId() != null, OutLisResultEntity::getTenantId, (Object)dto.getTenantId());
        lisResultQuery.eq(OutLisResultEntity::getHisId, (Object)dto.getHisId());
        OutLisResultEntity lisResult = (OutLisResultEntity)this.outLisResultMapper.selectOne((Wrapper)lisResultQuery);
        if (lisResult == null) {
            OutFrontConfig outFrontConfig = this.outFrontConfigMapper.queryByTenantId(dto.getTenantId(), FrontMethodEnum.LIS_RESULT.getValue());
            FrontRequest frontRequest = new FrontRequest();
            frontRequest.setBody((Object)dto);
            String result = HttpUtil.post((String)outFrontConfig.getInterfaceUrl(), (String)JSONObject.toJSONString((Object)frontRequest));
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            String code = jsonObject.getString("code");
            if ("1".equals(code)) {
                LinkedHashMap uploadMap = new LinkedHashMap();
                JSONArray jsonArray = jsonObject.getJSONArray("body");
                ArrayList<OutLisResultDetailEntity> detailList = new ArrayList<OutLisResultDetailEntity>();
                OutLisResultEntity newLisResult = new OutLisResultEntity();
                int count = 0;
                for (Object object : jsonArray) {
                    JSONObject detailObject = (JSONObject)object;
                    if (count == 0) {
                        newLisResult.setTenantId(dto.getTenantId());
                        newLisResult.setOutpatientNo(dto.getOutpatientNo());
                        newLisResult.setDeptId(dto.getDeptId());
                        newLisResult.setDeptName(dto.getDeptName());
                        newLisResult.setDoctorId(dto.getDoctorId());
                        newLisResult.setDoctorName(dto.getDoctorName());
                        newLisResult.setPatientId(dto.getPatientId());
                        newLisResult.setItemId(dto.getTreatmentItemId());
                        newLisResult.setItemName(dto.getTreatmentItemName());
                        newLisResult.setHisId(dto.getHisId());
                        newLisResult.setCreateId(dto.getCreateId());
                        newLisResult.setCreateName(dto.getCreateName());
                        newLisResult.setSpecimenType(detailObject.getString("samplename"));
                        newLisResult.setOpter(detailObject.getString("opter"));
                        newLisResult.setAuditOpter(detailObject.getString("auditopter"));
                        newLisResult.setPrintOpter(detailObject.getString("printopter"));
                        newLisResult.setSampleDate(this.getDateValue(detailObject, "sampledate"));
                        newLisResult.setTestTime(this.getDateValue(detailObject, "testtime"));
                        newLisResult.setAuditTime(this.getDateValue(detailObject, "audittime"));
                        newLisResult.setPrintTime(this.getDateValue(detailObject, "printtime"));
                        newLisResult.setVisitType(detailObject.getString("pattype"));
                        newLisResult.setBarcode(detailObject.getString("barcode"));
                        newLisResult.setBarcodeTime(this.getDateValue(detailObject, "barcodetime"));
                        this.outLisResultMapper.insert((Object)newLisResult);
                    }
                    ++count;
                    OutLisResultDetailEntity detail = new OutLisResultDetailEntity();
                    detail.setLisResultId(newLisResult.getId());
                    detail.setTenantId(dto.getTenantId());
                    detail.setCreateId(dto.getCreateId());
                    detail.setCreateName(dto.getCreateName());
                    detail.setItemCode(detailObject.getString("itemename"));
                    detail.setItemName(detailObject.getString("itemcname"));
                    detail.setResult(detailObject.getString("result"));
                    detail.setUnit(detailObject.getString("unit"));
                    detail.setResultStatus(detailObject.getString("state"));
                    detail.setReferrenceRange(detailObject.getString("limit"));
                    detailList.add(detail);
                }
                if (!detailList.isEmpty()) {
                    this.outLisResultDetailMapper.insertList(detailList);
                    uploadMap.put(newLisResult, detailList);
                    this.pushEtube(uploadMap);
                    newLisResult.setDetailList(detailList);
                    return newLisResult;
                }
                return null;
            }
        } else {
            LambdaQueryWrapper detailQuery = Wrappers.lambdaQuery();
            detailQuery.eq(dto.getTenantId() != null, OutLisResultDetailEntity::getTenantId, (Object)dto.getTenantId());
            detailQuery.eq(OutLisResultDetailEntity::getLisResultId, (Object)lisResult.getId());
            List detailList = this.outLisResultDetailMapper.selectList((Wrapper)detailQuery);
            lisResult.setDetailList(detailList);
        }
        return lisResult;
    }

    private Date getDateValue(JSONObject jsonObject, String field) {
        String dateTimeStr = jsonObject.getString(field);
        if (StrUtil.isEmpty((CharSequence)dateTimeStr)) {
            return null;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(dateTimeStr, formatter);
        Date date = Date.from(zonedDateTime.toInstant());
        return date;
    }

    public Map<String, List<QueryTreatmentItemVo>> getOutLisTreatmentItemList(QueryTreatmentItemDto dto) {
        Map map;
        block9: {
            Map resultMap;
            List hisIds;
            List list;
            block10: {
                list = this.outLisResultMapper.selectNotRefundList(dto);
                map = list.stream().collect(Collectors.groupingBy(QueryTreatmentItemVo::getPaymentTime, TreeMap::new, Collectors.toList()));
                if (list.isEmpty()) break block9;
                hisIds = list.stream().distinct().filter(Objects::nonNull).map(QueryTreatmentItemVo::getHisId).collect(Collectors.toList());
                LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
                queryWrapper.eq(dto.getTenantId() != null, OutLisResultEntity::getTenantId, (Object)dto.getTenantId());
                queryWrapper.in(OutLisResultEntity::getHisId, hisIds);
                List resultList = this.outLisResultMapper.selectList((Wrapper)queryWrapper);
                resultMap = resultList.stream().collect(Collectors.toMap(OutLisResultEntity::getHisId, Function.identity()));
                if (list.size() != resultList.size()) break block10;
                for (Map.Entry entry : map.entrySet()) {
                    List queryList = (List)entry.getValue();
                    for (QueryTreatmentItemVo vo2 : queryList) {
                        if (resultMap.get(vo2.getHisId()) == null) continue;
                        vo2.setResultFlag("1");
                    }
                }
                break block9;
            }
            QueryLisResultDto lisResultDto = new QueryLisResultDto();
            lisResultDto.setHisIds(hisIds);
            OutFrontConfig outFrontConfig = this.outFrontConfigMapper.queryByTenantId(dto.getTenantId(), FrontMethodEnum.LIS_RESULT_BY_HISIDS.getValue());
            FrontRequest frontRequest = new FrontRequest();
            frontRequest.setBody((Object)lisResultDto);
            String result = HttpUtil.post((String)outFrontConfig.getInterfaceUrl(), (String)JSONObject.toJSONString((Object)frontRequest));
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            String code = jsonObject.getString("code");
            if (!"1".equals(code)) break block9;
            JSONArray jsonArray = jsonObject.getJSONArray("body");
            LinkedHashMap uploadMap = new LinkedHashMap();
            if (!jsonArray.isEmpty()) {
                Map listMap = list.stream().collect(Collectors.toMap(QueryTreatmentItemVo::getHisId, Function.identity()));
                LinkedHashMap<String, List> objectMap = new LinkedHashMap<String, List>();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject object = jsonArray.getJSONObject(i);
                    String hisId = object.getString("hisid");
                    Optional.ofNullable(listMap.get(hisId)).ifPresent(vo -> {
                        object.put("outpatientNo", (Object)vo.getOutpatientNo());
                        object.put("deptId", (Object)vo.getDeptId());
                        object.put("doctorId", (Object)vo.getDoctorId());
                        object.put("patientId", (Object)vo.getPatientId());
                        object.put("treatmentId", (Object)vo.getTreatmentItemId());
                    });
                    objectMap.computeIfAbsent(hisId, k -> new ArrayList()).add(object);
                }
                ArrayList<OutLisResultDetailEntity> detailList = new ArrayList<OutLisResultDetailEntity>();
                for (Map.Entry entry : objectMap.entrySet()) {
                    String hisId = (String)entry.getKey();
                    List jsonObjects = (List)entry.getValue();
                    OutLisResultEntity newLisResult = new OutLisResultEntity();
                    if (resultMap.get(hisId) != null) continue;
                    JSONObject detailObject = (JSONObject)jsonObjects.get(0);
                    newLisResult.setTenantId(dto.getTenantId());
                    newLisResult.setCreateId(dto.getUserId());
                    newLisResult.setCreateName(dto.getUserName());
                    newLisResult.setOutpatientNo(detailObject.getString("outpatientNo"));
                    newLisResult.setDeptId(detailObject.getInteger("deptId"));
                    newLisResult.setDeptName(detailObject.getString("department"));
                    newLisResult.setDoctorId(detailObject.getInteger("doctorId"));
                    newLisResult.setDoctorName(detailObject.getString("doctor"));
                    newLisResult.setPatientId(detailObject.getInteger("patientId"));
                    newLisResult.setItemId(detailObject.getInteger("treatmentId"));
                    newLisResult.setItemName(detailObject.getString("feename"));
                    newLisResult.setHisId(detailObject.getString("hisid"));
                    newLisResult.setSpecimenType(detailObject.getString("samplename"));
                    newLisResult.setOpter(detailObject.getString("opter"));
                    newLisResult.setAuditOpter(detailObject.getString("auditopter"));
                    newLisResult.setPrintOpter(detailObject.getString("printopter"));
                    newLisResult.setSampleDate(this.getDateValue(detailObject, "sampledate"));
                    newLisResult.setTestTime(this.getDateValue(detailObject, "testtime"));
                    newLisResult.setAuditTime(this.getDateValue(detailObject, "audittime"));
                    newLisResult.setPrintTime(this.getDateValue(detailObject, "printtime"));
                    newLisResult.setVisitType(detailObject.getString("pattype"));
                    newLisResult.setBarcode(detailObject.getString("barcode"));
                    newLisResult.setBarcodeTime(this.getDateValue(detailObject, "barcodetime"));
                    this.outLisResultMapper.insert((Object)newLisResult);
                    for (JSONObject object : jsonObjects) {
                        OutLisResultDetailEntity detail = new OutLisResultDetailEntity();
                        detail.setLisResultId(newLisResult.getId());
                        detail.setTenantId(Integer.valueOf(1));
                        detail.setCreateId(Integer.valueOf(1));
                        detail.setCreateName("\u51cc\u66682\u70b9\u534a\u751f\u6210LIS\u68c0\u9a8c\u7ed3\u679c");
                        detail.setItemCode(object.getString("itemename"));
                        detail.setItemName(object.getString("itemcname"));
                        detail.setResult(object.getString("result"));
                        detail.setUnit(object.getString("unit"));
                        detail.setResultStatus(object.getString("state"));
                        detail.setReferrenceRange(object.getString("limit"));
                        detailList.add(detail);
                    }
                    uploadMap.put(newLisResult, detailList);
                }
                if (!detailList.isEmpty()) {
                    this.outLisResultDetailMapper.insertList(detailList);
                    this.pushEtube(uploadMap);
                }
                for (Map.Entry entry : map.entrySet()) {
                    List queryList = (List)entry.getValue();
                    for (QueryTreatmentItemVo vo3 : queryList) {
                        if (objectMap.get(vo3.getHisId()) == null && resultMap.get(vo3.getHisId()) == null) continue;
                        vo3.setResultFlag("1");
                    }
                }
            }
        }
        return map;
    }

    public void test() {
        OutLisResultEntity outLisResultEntity = (OutLisResultEntity)this.outLisResultMapper.selectById((Serializable)Integer.valueOf(18));
        List outLisResultDetailEntities = this.outLisResultDetailMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(OutLisResultDetailEntity::getLisResultId, (Object)18));
        HashMap<OutLisResultEntity, List> uploadMap = new HashMap<OutLisResultEntity, List>();
        uploadMap.put(outLisResultEntity, outLisResultDetailEntities);
        this.pushEtube(uploadMap);
    }

    public List<OutListResultVo> queryOutListResultDetails(QueryTreatmentItemDto dto) {
        return this.outLisResultMapper.queryOutListResultDetails(dto);
    }

    private void pushEtube(Map<OutLisResultEntity, List<OutLisResultDetailEntity>> uploadMap) {
        for (Map.Entry<OutLisResultEntity, List<OutLisResultDetailEntity>> entry : uploadMap.entrySet()) {
            ResponseData indicatorGroupRsp;
            String code;
            OutLisResultEntity key = entry.getKey();
            List<OutLisResultDetailEntity> value = entry.getValue();
            Integer patientId = key.getPatientId();
            RequestDto requestDto = this.studioService.getByPatientId(patientId);
            String studioCode = requestDto.getStudioCode();
            requestDto.setCreateBy(requestDto.getDoctorCode());
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String timeStr = format.format(key.getTestTime());
            if (!StringUtil.isNotBlank((String)studioCode) || !(code = (indicatorGroupRsp = this.studioService.queryIndicatorGroup(requestDto)).getCode()).equals("200")) continue;
            JSONArray groupArray = JSONArray.parseArray((String)(indicatorGroupRsp.getData() + ""));
            ArrayList<Group> groupList = new ArrayList<Group>();
            for (int t = 0; t < groupArray.size(); ++t) {
                JSONObject groupJSON = (JSONObject)groupArray.get(t);
                String groupCode = groupJSON.get((Object)"groupCode").toString();
                requestDto.setGroupCode(groupCode);
                ResponseData indicatorInfoRsp = this.studioService.queryIndicatorInfo(requestDto);
                String rspCode = indicatorInfoRsp.getCode();
                if (!"200".equals(rspCode)) continue;
                Group group = new Group();
                group.setUploadTime(timeStr);
                group.setGroupCode(groupCode);
                ArrayList<Indicator> indicatorList = new ArrayList<Indicator>();
                JSONArray indicatorInfos = JSONArray.parseArray((String)(indicatorInfoRsp.getData() + ""));
                for (int j = 0; j < indicatorInfos.size(); ++j) {
                    boolean isPut = false;
                    JSONObject indicatorInfo = (JSONObject)indicatorInfos.get(j);
                    String indicatorName = indicatorInfo.get((Object)"indicatorName").toString();
                    String indicatorType = indicatorInfo.get((Object)"indicatorType").toString();
                    String indicatorCode = indicatorInfo.get((Object)"indicatorCode").toString();
                    String inputType = indicatorInfo.get((Object)"inputType").toString();
                    Indicator indicator = new Indicator();
                    indicator.setIndicatorCode(indicatorCode);
                    indicator.setIndicatorType(indicatorType);
                    ArrayList<DataInput> dataInputList = new ArrayList<DataInput>();
                    for (OutLisResultDetailEntity outLisResultDetailEntity : value) {
                        String itemName = outLisResultDetailEntity.getItemName();
                        if (!itemName.equals(indicatorName)) continue;
                        String detailResult = outLisResultDetailEntity.getResult();
                        DataInput dataInput = new DataInput();
                        dataInput.setName(itemName);
                        if (inputType.equals("3")) {
                            JSONObject optionsRule = (JSONObject)indicatorInfo.get((Object)"optionsRule");
                            JSONArray inputOptions = (JSONArray)optionsRule.get((Object)"inputOptions");
                            for (int l = 0; l < inputOptions.size(); ++l) {
                                JSONObject inputOption = (JSONObject)inputOptions.get(l);
                                String optionsName = inputOption.get((Object)"optionsName").toString();
                                if (!optionsName.equals(detailResult)) continue;
                                String optionsCode = inputOption.get((Object)"optionsCode").toString();
                                dataInput.setValue(detailResult);
                                dataInput.setValueCode(optionsCode);
                                dataInputList.add(dataInput);
                                isPut = true;
                                break;
                            }
                        } else {
                            dataInput.setValue(detailResult);
                            dataInputList.add(dataInput);
                            isPut = true;
                        }
                        if (!isPut) continue;
                        break;
                    }
                    if (!isPut) continue;
                    indicator.setDataInput(dataInputList);
                    indicatorList.add(indicator);
                }
                if (indicatorList.size() <= 0) continue;
                group.setIndicatorList(indicatorList);
                groupList.add(group);
            }
            if (groupList.size() <= 0) continue;
            requestDto.setGroupList(groupList);
            this.studioService.insertPatientIndicatorUpload(requestDto);
        }
    }
}

