/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.byh.outpatient.api.dto.pending.ChangePendingAccountsDto;
import com.byh.outpatient.api.dto.pending.ChargeDto;
import com.byh.outpatient.api.dto.pending.QuerySigningDetailsDto;
import com.byh.outpatient.api.dto.pending.QuerySigningListDto;
import com.byh.outpatient.api.dto.pending.UpdateSigning;
import com.byh.outpatient.api.dto.pending.UpdateSigningDetailsDto;
import com.byh.outpatient.api.enums.PaymentRecordsStatusEnum;
import com.byh.outpatient.api.enums.PaymentStatusEnum;
import com.byh.outpatient.api.enums.PendingStatusEnum;
import com.byh.outpatient.api.model.order.OutOrderPayment;
import com.byh.outpatient.api.model.pending.OutPendingAccountRecords;
import com.byh.outpatient.api.model.pending.OutPendingItems;
import com.byh.outpatient.api.model.pending.OutPendingRepayment;
import com.byh.outpatient.api.util.PageResult;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.UUIDUtils;
import com.byh.outpatient.api.vo.pending.FeeItems;
import com.byh.outpatient.api.vo.pending.QueryPendingAccountRecordsVo;
import com.byh.outpatient.api.vo.pending.QueryPendingDetailsVo;
import com.byh.outpatient.api.vo.pending.QueryPendingVo;
import com.byh.outpatient.api.vo.pending.QueryRepaymentRecordsVo;
import com.byh.outpatient.data.repository.OutOrderPaymentMapper;
import com.byh.outpatient.data.repository.OutPendingAccountRecordsMapper;
import com.byh.outpatient.data.repository.OutPendingItemsMapper;
import com.byh.outpatient.data.repository.OutPendingRepaymentMapper;
import com.byh.outpatient.web.mvc.exception.RunDisplayException;
import com.byh.outpatient.web.service.OutPendingService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class OutPendingServiceImpl
implements OutPendingService {
    @Autowired
    private OutPendingItemsMapper outPendingItemsMapper;
    @Autowired
    private OutPendingAccountRecordsMapper outPendingAccountRecordsMapper;
    @Autowired
    private OutPendingRepaymentMapper outPendingRepaymentMapper;
    @Autowired
    private OutOrderPaymentMapper outOrderPaymentMapper;

    public ResponseData<PageResult<QueryPendingVo>> pendingAccountManagement(QuerySigningListDto parameter) {
        if (parameter.getCurrent() == null || parameter.getSize() == null) {
            return ResponseData.error((String)"\u9875\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageHelper.startPage((int)parameter.getCurrent(), (int)parameter.getSize());
        List outPendingItems = this.outPendingItemsMapper.pendingAccountManagement(parameter);
        PageInfo pageInfo = new PageInfo(outPendingItems);
        PageResult pageResult = new PageResult(parameter.getCurrent().intValue(), parameter.getSize().intValue());
        pageResult.setTotal(Integer.parseInt(String.valueOf(pageInfo.getTotal())));
        pageResult.setPages(pageInfo.getPages());
        pageResult.setRecords(outPendingItems);
        pageResult.setCurrent(parameter.getCurrent().intValue());
        pageResult.setSize(parameter.getSize().intValue());
        return ResponseData.success((Object)pageResult);
    }

    public ResponseData<QueryPendingDetailsVo> pendingAccountDetails(QuerySigningDetailsDto parameter) {
        if (StringUtils.isEmpty((CharSequence)parameter.getProjectNo())) {
            return ResponseData.error((String)"\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        QueryWrapper outPendingItemsQueryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)outPendingItemsQueryWrapper.ne((Object)"status", (Object)PendingStatusEnum.STATUS_DELETE.getValue())).eq((Object)"tenant_id", (Object)parameter.getTenantId())).eq((Object)"project_no", (Object)parameter.getProjectNo());
        OutPendingItems outPendingItems = (OutPendingItems)this.outPendingItemsMapper.selectOne((Wrapper)outPendingItemsQueryWrapper);
        if (outPendingItems == null) {
            return ResponseData.error((String)"\u9879\u76ee\u7f16\u7801\u4e0d\u5b58\u5728");
        }
        QueryPendingDetailsVo queryPendingDetailsVo = new QueryPendingDetailsVo();
        BeanUtils.copyProperties((Object)outPendingItems, (Object)queryPendingDetailsVo);
        return ResponseData.success((Object)queryPendingDetailsVo);
    }

    public ResponseData<PageResult<QueryPendingAccountRecordsVo>> QueryPendingAccountRecords(QuerySigningDetailsDto parameter) {
        if (parameter.getCurrent() == null || parameter.getSize() == null) {
            return ResponseData.error((String)"\u9875\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageHelper.startPage((int)parameter.getCurrent(), (int)parameter.getSize());
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"status", (Object)PendingStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"tenant_id", (Object)parameter.getTenantId())).eq((Object)"project_no", (Object)parameter.getProjectNo())).eq(parameter.getInvoicingStatus() != null, (Object)"Invoicing_status", (Object)parameter.getInvoicingStatus());
        List outPendingAccountRecords = this.outPendingAccountRecordsMapper.selectList((Wrapper)queryWrapper);
        List queryPendingAccountRecordsVos = outPendingAccountRecords.stream().map(OutPendingAccountRecords2 -> {
            QueryPendingAccountRecordsVo queryPendingAccountRecordsVo = new QueryPendingAccountRecordsVo();
            BeanUtils.copyProperties((Object)OutPendingAccountRecords2, (Object)queryPendingAccountRecordsVo);
            return queryPendingAccountRecordsVo;
        }).collect(Collectors.toList());
        PageInfo pageInfo = new PageInfo(queryPendingAccountRecordsVos);
        PageResult pageResult = new PageResult(parameter.getCurrent().intValue(), parameter.getSize().intValue());
        pageResult.setTotal(Integer.parseInt(String.valueOf(pageInfo.getTotal())));
        pageResult.setPages(pageInfo.getPages());
        pageResult.setRecords(queryPendingAccountRecordsVos);
        pageResult.setCurrent(parameter.getCurrent().intValue());
        pageResult.setSize(parameter.getSize().intValue());
        return ResponseData.success((Object)pageResult);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<String> updatePendingAccountRecords(UpdateSigningDetailsDto parameter) {
        if (CollectionUtils.isEmpty((Collection)parameter.getUpdateSigningList())) {
            return ResponseData.error((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Map itemMap = parameter.getUpdateSigningList().stream().collect(Collectors.toMap(UpdateSigning::getId, Function.identity()));
        List collect = parameter.getUpdateSigningList().stream().map(UpdateSigning::getId).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.ne((Object)"status", (Object)PendingStatusEnum.STATUS_DELETE.getValue())).eq((Object)"tenant_id", (Object)parameter.getTenantId())).in((Object)"id", collect);
        List outPendingAccountRecords = this.outPendingAccountRecordsMapper.selectList((Wrapper)queryWrapper);
        for (OutPendingAccountRecords outPending : outPendingAccountRecords) {
            UpdateSigning updateSigning = (UpdateSigning)itemMap.get(outPending.getId());
            if (updateSigning == null) continue;
            if (updateSigning.getInvoicingAmount() != null && outPending.getPendingAmount().compareTo(updateSigning.getInvoicingAmount()) < 0) {
                throw new RunDisplayException("\u5f00\u7968\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u6302\u8d26\u91d1\u989d\uff01");
            }
            outPending.setInvoicingStatus(updateSigning.getInvoicingStatus());
            outPending.setInvoicingAmount(updateSigning.getInvoicingAmount());
            outPending.setInvoicingTime(updateSigning.getInvoicingTime());
            if (updateSigning.getInvoicingAmount() == null) {
                outPending.setInvoicingAmount(null);
            }
            if (updateSigning.getInvoicingTime() == null) {
                outPending.setInvoicingTime(null);
            }
            this.outPendingAccountRecordsMapper.updateById((Object)outPending);
        }
        return ResponseData.success((Object)"\u5b8c\u6210\uff01");
    }

    public ResponseData<PageResult<QueryRepaymentRecordsVo>> queryRepaymentRecords(QuerySigningDetailsDto parameter) {
        if (parameter.getCurrent() == null || parameter.getSize() == null) {
            return ResponseData.error((String)"\u9875\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageHelper.startPage((int)parameter.getCurrent(), (int)parameter.getSize());
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.ne((Object)"status", (Object)PendingStatusEnum.STATUS_DELETE.getValue())).eq((Object)"tenant_id", (Object)parameter.getTenantId())).eq((Object)"project_no", (Object)parameter.getProjectNo());
        List pendingRepaymentList = this.outPendingRepaymentMapper.selectList((Wrapper)queryWrapper);
        List queryRepaymentRecordsVos = pendingRepaymentList.stream().map(OutPendingAccountRecords2 -> {
            QueryRepaymentRecordsVo queryPendingAccountRecordsVo = new QueryRepaymentRecordsVo();
            BeanUtils.copyProperties((Object)OutPendingAccountRecords2, (Object)queryPendingAccountRecordsVo);
            queryPendingAccountRecordsVo.setPaymentMethod(JSONArray.parseArray((String)OutPendingAccountRecords2.getPaymentMethod(), FeeItems.class));
            return queryPendingAccountRecordsVo;
        }).collect(Collectors.toList());
        PageInfo pageInfo = new PageInfo(queryRepaymentRecordsVos);
        PageResult pageResult = new PageResult(parameter.getCurrent().intValue(), parameter.getSize().intValue());
        pageResult.setTotal(Integer.parseInt(String.valueOf(pageInfo.getTotal())));
        pageResult.setPages(pageInfo.getPages());
        pageResult.setRecords(queryRepaymentRecordsVos);
        pageResult.setCurrent(parameter.getCurrent().intValue());
        pageResult.setSize(parameter.getSize().intValue());
        return ResponseData.success((Object)pageResult);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<String> charge(ChargeDto parameter) {
        int size;
        if (StringUtils.isEmpty((CharSequence)parameter.getProjectNo())) {
            return ResponseData.error((String)"\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)parameter.getFeeItemsList())) {
            return ResponseData.error((String)"\u8d39\u7528\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        QueryWrapper outPendingItemsQueryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)outPendingItemsQueryWrapper.ne((Object)"status", (Object)PendingStatusEnum.STATUS_DELETE.getValue())).eq((Object)"tenant_id", (Object)parameter.getTenantId())).eq((Object)"project_no", (Object)parameter.getProjectNo());
        OutPendingItems outPendingItems = (OutPendingItems)this.outPendingItemsMapper.selectOne((Wrapper)outPendingItemsQueryWrapper);
        if (outPendingItems == null) {
            return ResponseData.error((String)"\u9879\u76ee\u7f16\u7801\u4e0d\u5b58\u5728");
        }
        BigDecimal amount = parameter.getFeeItemsList().stream().map(FeeItems::getActualPayment).reduce(BigDecimal.ZERO, BigDecimal::add);
        outPendingItems.setUpdateId(parameter.getOperatorId());
        outPendingItems.setUpdateName(parameter.getOperatorName());
        outPendingItems.setBalance(outPendingItems.getBalance().add(amount));
        outPendingItems.setPaymentAmount(outPendingItems.getPaymentAmount().add(amount));
        if (parameter.getActualPreferentialPayment() != null) {
            outPendingItems.setActualPreferentialPayment(outPendingItems.getActualPreferentialPayment().add(parameter.getActualPreferentialPayment()));
        }
        if ((size = this.outPendingItemsMapper.updateById((Object)outPendingItems)) != 1) {
            throw new RunDisplayException("\u53d8\u66f4\u5931\u8d25\uff01");
        }
        OutPendingRepayment outPendingRepayment = new OutPendingRepayment();
        outPendingRepayment.setCreateId(parameter.getOperatorId());
        outPendingRepayment.setCreateName(parameter.getOperatorName());
        outPendingRepayment.setTenantId(parameter.getTenantId());
        outPendingRepayment.setProjectNo(outPendingItems.getProjectNo());
        outPendingRepayment.setPayOrderNo(UUIDUtils.getPayOrderNo());
        outPendingRepayment.setPaymentStatus(PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
        outPendingRepayment.setPaymentMethod(JSON.toJSONString((Object)parameter.getFeeItemsList()));
        outPendingRepayment.setActualPreferentialPayment(parameter.getActualPreferentialPayment());
        outPendingRepayment.setActualPayment(amount);
        outPendingRepayment.setRemark(parameter.getRemark());
        outPendingRepayment.setCheckerId(parameter.getOperatorId());
        outPendingRepayment.setCheckerName(parameter.getOperatorName());
        outPendingRepayment.setCheckerTime(new Date());
        outPendingRepayment.setStatus(PendingStatusEnum.STATUS_NORMAL.getValue());
        int insert = this.outPendingRepaymentMapper.insert((Object)outPendingRepayment);
        if (insert != 1) {
            throw new RunDisplayException("\u8bb0\u5f55\u5931\u8d25\uff01");
        }
        return ResponseData.success((Object)"\u5b8c\u6210");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<String> refunds(ChargeDto parameter) {
        if (StringUtils.isEmpty((CharSequence)parameter.getProjectNo())) {
            return ResponseData.error((String)"\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)parameter.getRemark())) {
            return ResponseData.error((String)"\u9000\u6b3e\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)parameter.getFeeItemsList())) {
            return ResponseData.error((String)"\u8d39\u7528\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        QueryWrapper outPendingItemsQueryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)outPendingItemsQueryWrapper.ne((Object)"status", (Object)PendingStatusEnum.STATUS_DELETE.getValue())).eq((Object)"tenant_id", (Object)parameter.getTenantId())).eq((Object)"project_no", (Object)parameter.getProjectNo());
        OutPendingItems outPendingItems = (OutPendingItems)this.outPendingItemsMapper.selectOne((Wrapper)outPendingItemsQueryWrapper);
        if (outPendingItems == null) {
            return ResponseData.error((String)"\u9879\u76ee\u7f16\u7801\u4e0d\u5b58\u5728");
        }
        BigDecimal amount = parameter.getFeeItemsList().stream().map(FeeItems::getActualPayment).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (amount.compareTo(outPendingItems.getBalance()) > 0) {
            return ResponseData.error((String)"\u9000\u8d39\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5269\u4f59\u4f59\u989d\uff01");
        }
        outPendingItems.setUpdateId(parameter.getOperatorId());
        outPendingItems.setUpdateName(parameter.getOperatorName());
        outPendingItems.setBalance(outPendingItems.getBalance().subtract(amount));
        outPendingItems.setRefundAmount(outPendingItems.getRefundAmount().add(amount));
        int size = this.outPendingItemsMapper.updateById((Object)outPendingItems);
        if (size != 1) {
            throw new RunDisplayException("\u53d8\u66f4\u5931\u8d25\uff01");
        }
        OutPendingRepayment outPendingRepayment = new OutPendingRepayment();
        outPendingRepayment.setCreateId(parameter.getOperatorId());
        outPendingRepayment.setCreateName(parameter.getOperatorName());
        outPendingRepayment.setTenantId(parameter.getTenantId());
        outPendingRepayment.setProjectNo(outPendingItems.getProjectNo());
        outPendingRepayment.setPayOrderNo(UUIDUtils.getPayOrderNo());
        outPendingRepayment.setPaymentStatus(PaymentStatusEnum.PAYMENT_REFUNDED.getValue());
        outPendingRepayment.setPaymentMethod(JSON.toJSONString((Object)parameter.getFeeItemsList()));
        outPendingRepayment.setActualPreferentialPayment(new BigDecimal(0));
        outPendingRepayment.setActualPayment(amount.negate());
        outPendingRepayment.setRemark(parameter.getRemark());
        outPendingRepayment.setCheckerId(parameter.getOperatorId());
        outPendingRepayment.setCheckerName(parameter.getOperatorName());
        outPendingRepayment.setCheckerTime(new Date());
        outPendingRepayment.setStatus(PendingStatusEnum.STATUS_NORMAL.getValue());
        int insert = this.outPendingRepaymentMapper.insert((Object)outPendingRepayment);
        if (insert != 1) {
            throw new RunDisplayException("\u8bb0\u5f55\u5931\u8d25\uff01");
        }
        return ResponseData.success((Object)"\u5b8c\u6210");
    }

    public ResponseData<String> changePendingAccounts(ChangePendingAccountsDto parameter) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"pay_order_no", (Object)parameter.getPayOrderNo());
        OutOrderPayment outOrderPayment = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)queryWrapper);
        if (ObjectUtils.isEmpty((Object)outOrderPayment)) {
            return ResponseData.error((String)"\u652f\u4ed8\u8ba2\u5355\u67e5\u8be2\u5f02\u5e38\uff01");
        }
        QueryWrapper outPendingItemsQueryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)outPendingItemsQueryWrapper.in((Object)"status", Arrays.asList(PendingStatusEnum.STATUS_NORMAL.getValue(), PendingStatusEnum.STATUS_DISABLED.getValue()))).eq((Object)"project_no", (Object)parameter.getProjectNo())).eq((Object)"tenant_id", (Object)parameter.getTenantId());
        OutPendingItems outPendingItems = (OutPendingItems)this.outPendingItemsMapper.selectOne((Wrapper)outPendingItemsQueryWrapper);
        if (outPendingItems == null) {
            throw new RunDisplayException("\u6240\u9009\u9879\u76ee\u4e0d\u5b58\u5728\uff01");
        }
        if (outPendingItems.getStatus().equals(2)) {
            throw new RunDisplayException("\u6240\u9009\u9879\u76ee\u5f53\u524d\u7981\u7528\uff01");
        }
        QueryWrapper queryRecords = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryRecords.eq((Object)"status", (Object)PendingStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"tenant_id", (Object)parameter.getTenantId())).in((Object)"pay_order_no", new Object[]{outOrderPayment.getPayOrderNo()});
        OutPendingAccountRecords outPendingAccountRecords = (OutPendingAccountRecords)this.outPendingAccountRecordsMapper.selectOne((Wrapper)queryRecords);
        if (outPendingAccountRecords == null) {
            throw new RunDisplayException("\u6302\u8d26\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01");
        }
        QueryWrapper oldPendingItemsQueryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)oldPendingItemsQueryWrapper.in((Object)"status", Arrays.asList(PendingStatusEnum.STATUS_NORMAL.getValue(), PendingStatusEnum.STATUS_DISABLED.getValue()))).eq((Object)"project_no", (Object)outPendingAccountRecords.getProjectNo())).eq((Object)"tenant_id", (Object)parameter.getTenantId());
        OutPendingItems oldPendingItems = (OutPendingItems)this.outPendingItemsMapper.selectOne((Wrapper)oldPendingItemsQueryWrapper);
        if (oldPendingItems == null) {
            throw new RunDisplayException("\u9879\u76ee\u4e0d\u5b58\u5728\uff01");
        }
        if (oldPendingItems.getStatus().equals(2)) {
            throw new RunDisplayException("\u9879\u76ee\u5f53\u524d\u7981\u7528\uff01");
        }
        outPendingItems.setPendingAmount(outPendingItems.getPendingAmount().add(outPendingAccountRecords.getPendingAmount()));
        outPendingItems.setBalance(outPendingItems.getBalance().subtract(outPendingAccountRecords.getPendingAmount()));
        outPendingItems.setAmountUpdateTime(new Date());
        int update = this.outPendingItemsMapper.updateById((Object)outPendingItems);
        if (update == 0) {
            throw new RunDisplayException("\u53d8\u66f4\u6302\u8d26\u5931\u8d25");
        }
        oldPendingItems.setPendingAmount(outPendingItems.getPendingAmount().subtract(outPendingAccountRecords.getPendingAmount()));
        oldPendingItems.setBalance(outPendingItems.getBalance().add(outPendingAccountRecords.getPendingAmount()));
        oldPendingItems.setAmountUpdateTime(new Date());
        int oldupdate = this.outPendingItemsMapper.updateById((Object)oldPendingItems);
        if (oldupdate == 0) {
            throw new RunDisplayException("\u53d8\u66f4\u6302\u8d26\u5931\u8d25");
        }
        outPendingAccountRecords.setUpdateId(parameter.getOperatorId());
        outPendingAccountRecords.setUpdateName(parameter.getOperatorName());
        outPendingAccountRecords.setProjectNo(outPendingItems.getProjectNo());
        outPendingAccountRecords.setProjectName(outPendingItems.getProjectName());
        outPendingAccountRecords.setCheckerId(parameter.getOperatorId());
        outPendingAccountRecords.setCheckerName(parameter.getOperatorName());
        outPendingAccountRecords.setCheckerTime(new Date());
        int updatePending = this.outPendingAccountRecordsMapper.updateById((Object)outPendingAccountRecords);
        if (updatePending == 0) {
            throw new RunDisplayException("\u53d8\u66f4\u6302\u8d26\u4fe1\u606f\u5931\u8d25");
        }
        return ResponseData.success((Object)"\u64cd\u4f5c\u5b8c\u6210");
    }
}

