/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.byh.outpatient.api.dto.netHospital.ReservationDTO;
import com.byh.outpatient.api.dto.netHospital.ReservationVo;
import com.byh.outpatient.api.dto.reservation.InsertResevationDto;
import com.byh.outpatient.api.dto.reservation.QueryReservationDto;
import com.byh.outpatient.api.enums.ReservationStatusEnum;
import com.byh.outpatient.api.model.outpatienType.OutpatientTypeEntity;
import com.byh.outpatient.api.model.patient.PatientEntity;
import com.byh.outpatient.api.model.reservation.ReservationEntity;
import com.byh.outpatient.api.model.schedule.ScheduleRecordDetailEntity;
import com.byh.outpatient.api.util.DateUtils;
import com.byh.outpatient.api.util.HyposensitizationUtil;
import com.byh.outpatient.api.util.PageResult;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.UUIDUtils;
import com.byh.outpatient.api.vo.order.ExcelReservation;
import com.byh.outpatient.api.vo.reservation.ReservationDetailVo;
import com.byh.outpatient.data.repository.OutpatientTypeMapper;
import com.byh.outpatient.data.repository.PatientMapper;
import com.byh.outpatient.data.repository.ReservationMapper;
import com.byh.outpatient.data.repository.ScheduleRecordDetailMapper;
import com.byh.outpatient.data.repository.ScheduleRecordMapper;
import com.byh.outpatient.web.mvc.config.NodeConfig;
import com.byh.outpatient.web.mvc.controller.RocketMQProducerController;
import com.byh.outpatient.web.mvc.utils.RabbitMqUtils;
import com.byh.outpatient.web.rocket.RocketMQProducer;
import com.byh.outpatient.web.service.PatientService;
import com.byh.outpatient.web.service.ReservationService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.apache.rocketmq.client.producer.SendCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReservationServiceImpl
implements ReservationService {
    @Autowired
    private ReservationMapper reservationMapper;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private PatientService patientService;
    @Resource
    private RocketMQProducer rocketMQProducer;
    @Autowired
    private ScheduleRecordDetailMapper scheduleRecordDetailMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private OutpatientTypeMapper outpatientTypeMapper;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private NodeConfig nodeConfig;
    private ExecutorService executor = Executors.newCachedThreadPool();
    private static final String patientTopic = "rocketMQ-out-patientTopic";
    private static final Logger logger = LoggerFactory.getLogger(RocketMQProducerController.class);

    @Transactional(rollbackFor={Exception.class})
    public ResponseData insert(InsertResevationDto insertResevationDto) {
        if (insertResevationDto == null) {
            return ResponseData.error((String)"\u5fc5\u8981\u53c2\u6570\u7f3a\u5931");
        }
        try {
            PatientEntity patientEntity = this.checkPatient(insertResevationDto);
            ReservationEntity reservation = new ReservationEntity();
            BeanUtils.copyProperties((Object)insertResevationDto, (Object)reservation);
            reservation.setPatientId(patientEntity.getId());
            reservation.setMedicalRecordNo(patientEntity.getMedicalRecordNo());
            Integer scheduleRecordDetailId = reservation.getScheduleRecordDetailId();
            ScheduleRecordDetailEntity scheduleRecordDetailEntity = (ScheduleRecordDetailEntity)this.scheduleRecordDetailMapper.selectById((Serializable)scheduleRecordDetailId);
            scheduleRecordDetailEntity.setAvaliable(Integer.valueOf(scheduleRecordDetailEntity.getAvaliable() - 1));
            scheduleRecordDetailEntity.setStartNo(Integer.valueOf(scheduleRecordDetailEntity.getTotal() - scheduleRecordDetailEntity.getAvaliable() + 1));
            this.scheduleRecordDetailMapper.updateById((Object)scheduleRecordDetailEntity);
            this.scheduleRecordMapper.updateAvaliableByScheduleCode(scheduleRecordDetailEntity.getScheduleCode(), insertResevationDto.getTenantId());
            reservation.setScheduleNo(Integer.valueOf(scheduleRecordDetailEntity.getTotal() - scheduleRecordDetailEntity.getAvaliable()));
            reservation.setScheduleDate(scheduleRecordDetailEntity.getScheduleDate());
            this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            this.reservationMapper.insert((Object)reservation);
            Date endDate = DateUtils.stringToFullDate((String)(scheduleRecordDetailEntity.getScheduleDate() + " " + scheduleRecordDetailEntity.getEndTime() + ":00"));
            long delyTime = DateUtils.differFrom((Date)DateUtils.getCurrentDate(), (Date)DateUtils.afterOneHourToNowDate((Date)endDate));
            RabbitMqUtils.sendReservationTimeout((RabbitTemplate)this.rabbitTemplate, (String)String.valueOf(reservation.getId()), (Long)delyTime);
            Integer id = reservation.getId();
            return ResponseData.success((Object)id);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseData.error((String)"\u9884\u7ea6\u5931\u8d25\uff01");
        }
    }

    private PatientEntity checkPatient(InsertResevationDto insertResevationDto) {
        PatientEntity patientEntities = this.patientMapper.queryPatientByCardNoAndTenantId(insertResevationDto.getPatientCardNo(), insertResevationDto.getTenantId());
        if (Objects.isNull(patientEntities)) {
            PatientEntity patientEntity = new PatientEntity();
            patientEntity.setTenantId(insertResevationDto.getTenantId());
            patientEntity.setName(insertResevationDto.getPatientName());
            patientEntity.setPhone(insertResevationDto.getPhone());
            patientEntity.setSex(insertResevationDto.getSex());
            patientEntity.setCardType(insertResevationDto.getPatientCardType());
            patientEntity.setCardNo(insertResevationDto.getPatientCardNo());
            patientEntity.setAge(insertResevationDto.getAge());
            patientEntity.setRemark(insertResevationDto.getPatientRemark());
            patientEntity.setBirthday(insertResevationDto.getBirthday());
            patientEntity.setAddress(insertResevationDto.getAddress());
            patientEntity.setAddressDetail(insertResevationDto.getAddressDetail());
            ResponseData responseData = this.patientService.insert(patientEntity);
            Integer patientId = new Integer(responseData.getData().toString());
            patientEntities = (PatientEntity)this.patientMapper.selectById((Serializable)patientId);
        }
        patientEntities.setName(insertResevationDto.getPatientName());
        patientEntities.setPhone(insertResevationDto.getPhone());
        patientEntities.setSex(insertResevationDto.getSex());
        patientEntities.setCardType(insertResevationDto.getPatientCardType());
        patientEntities.setCardNo(insertResevationDto.getPatientCardNo());
        patientEntities.setAge(insertResevationDto.getAge());
        patientEntities.setRemark(insertResevationDto.getPatientRemark());
        patientEntities.setBirthday(insertResevationDto.getBirthday());
        patientEntities.setAddress(insertResevationDto.getAddress());
        patientEntities.setAddressDetail(insertResevationDto.getAddressDetail());
        this.patientMapper.updateById((Object)patientEntities);
        String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
        ArrayList<PatientEntity> westernMedicinePrescriptionsVos1 = new ArrayList<PatientEntity>();
        westernMedicinePrescriptionsVos1.add(patientEntities);
        String msg = JSONObject.toJSONString(westernMedicinePrescriptionsVos1);
        this.rocketMQProducer.asyncSendCallbackTimeoutLevel(patientTopic, "TAG3", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
        return patientEntities;
    }

    public ResponseData deleteById(Integer id) {
        if (this.reservationMapper.deleteById(id) > 0) {
            return ResponseData.success();
        }
        return ResponseData.error((String)"\u4fee\u6539\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\uff01");
    }

    public ResponseData updateById(ReservationEntity reservation) {
        if (ReservationStatusEnum.CANCEL.getValue().equals(reservation.getStatus())) {
            reservation.setCancelTime(DateUtils.getCurrentDate());
            if (this.reservationMapper.updateById((Object)reservation) > 0) {
                return ResponseData.success((Object)"\u53d6\u6d88\u6210\u529f\uff01");
            }
            return ResponseData.error((String)"\u53d6\u6d88\u5931\u8d25\uff01");
        }
        if (Objects.isNull(reservation.getScheduleTimeDetail()) || "".equals(reservation.getScheduleTimeDetail())) {
            return ResponseData.error((String)"\u8bf7\u9009\u62e9\u65f6\u95f4\u6bb5\uff01");
        }
        if (ReservationStatusEnum.BREAK_PROMISE.getValue().equals(reservation.getStatus())) {
            reservation.setStatus(ReservationStatusEnum.RESERVATION.getValue());
        }
        if (this.reservationMapper.updateById((Object)reservation) > 0) {
            Date newEndDate = DateUtils.stringToFullDate((String)(reservation.getScheduleDate() + " " + reservation.getScheduleTimeDetail().substring(reservation.getScheduleTimeDetail().indexOf("-") + 1) + ":00"));
            long newDelyTime = DateUtils.differFrom((Date)DateUtils.getCurrentDate(), (Date)DateUtils.afterOneHourToNowDate((Date)newEndDate));
            RabbitMqUtils.sendReservationTimeout((RabbitTemplate)this.rabbitTemplate, (String)String.valueOf(reservation.getId()), (Long)newDelyTime);
            return ResponseData.success();
        }
        return ResponseData.error((String)"\u4fee\u6539\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\uff01");
    }

    public ResponseData<ReservationDetailVo> queryById(Integer id) {
        ReservationDetailVo reservationDetailVo = new ReservationDetailVo();
        ReservationEntity reservation = this.reservationMapper.queryById(id);
        BeanUtils.copyProperties((Object)reservation, (Object)reservationDetailVo);
        PatientEntity patientEntity = this.patientMapper.queryById(reservation.getPatientId().intValue());
        reservationDetailVo.setAddress(patientEntity.getAddress());
        reservationDetailVo.setAddressDetail(patientEntity.getAddressDetail());
        reservationDetailVo.setAge(patientEntity.getAge());
        ScheduleRecordDetailEntity scheduleRecordDetailEntity = (ScheduleRecordDetailEntity)this.scheduleRecordDetailMapper.selectById((Serializable)reservation.getScheduleRecordDetailId());
        reservationDetailVo.setStartTime(scheduleRecordDetailEntity.getStartTime());
        reservationDetailVo.setEndTime(scheduleRecordDetailEntity.getEndTime());
        reservationDetailVo.setScheduleTimeRange(scheduleRecordDetailEntity.getScheduleTimeRange());
        OutpatientTypeEntity outpatientTypeEntity = this.outpatientTypeMapper.queryOutpatientTypeByType(reservation.getOutpatientType(), reservation.getTenantId());
        reservationDetailVo.setOutpatientTypeName(outpatientTypeEntity.getOutpatientTypeName());
        reservationDetailVo.setRegType(outpatientTypeEntity.getRegType());
        reservationDetailVo.setBirthday(patientEntity.getBirthday());
        reservationDetailVo.setSex(patientEntity.getSex());
        reservationDetailVo.setPatientRemark(patientEntity.getRemark());
        reservationDetailVo.setPatientCardType(patientEntity.getCardType());
        return ResponseData.success((Object)reservationDetailVo);
    }

    public ResponseData<PageResult<ReservationEntity>> queryReservation(QueryReservationDto queryReservationTypeDto) {
        PageHelper.startPage((int)queryReservationTypeDto.getCurrent(), (int)queryReservationTypeDto.getSize());
        List outpatientTypeList = this.reservationMapper.queryReservation(queryReservationTypeDto);
        for (ReservationEntity record : outpatientTypeList) {
            String patientName = HyposensitizationUtil.hyposensitizationForName((String)record.getPatientName());
            String phone = HyposensitizationUtil.hyposensitizationForPhone((String)record.getPhone());
            record.setPatientName(patientName);
            record.setPhone(phone);
        }
        PageInfo pageInfo = new PageInfo(outpatientTypeList);
        PageResult pageResult = new PageResult(queryReservationTypeDto.getCurrent().intValue(), queryReservationTypeDto.getSize().intValue());
        pageResult.setTotal(Integer.parseInt(String.valueOf(pageInfo.getTotal())));
        pageResult.setPages(pageInfo.getPages());
        pageResult.setRecords(outpatientTypeList);
        pageResult.setCurrent(queryReservationTypeDto.getCurrent().intValue());
        pageResult.setSize(queryReservationTypeDto.getSize().intValue());
        return ResponseData.success((Object)pageResult);
    }

    public ResponseData<Map<String, Object>> queryReservationCount(QueryReservationDto queryReservationDto) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar instance = Calendar.getInstance();
        instance.add(5, -7);
        String format = sdf.format(instance.getTime());
        queryReservationDto.setScheduleDateStart(format);
        instance.add(5, -7);
        format = sdf.format(instance.getTime());
        queryReservationDto.setScheduleDateStartWeek(format);
        Map data = this.reservationMapper.queryReservationCount(queryReservationDto);
        Integer c3 = Integer.valueOf(data.get("c3") + "");
        Integer c4 = Integer.valueOf(data.get("c4") + "");
        Integer c5 = Integer.valueOf(data.get("c5") + "");
        Integer c6 = Integer.valueOf(data.get("c6") + "");
        String c7 = c3 == 0 || c5 == 0 ? "0%" : new BigDecimal(c3 * 100).divide(new BigDecimal(c5), 1, RoundingMode.HALF_UP).subtract(new BigDecimal(100)) + "%";
        String c8 = c4 == 0 || c6 == 0 ? "0%" : new BigDecimal(c4 * 100).divide(new BigDecimal(c6), 2, RoundingMode.HALF_UP).subtract(new BigDecimal(100)) + "%";
        data.put("c7", c7);
        data.put("c8", c8);
        return ResponseData.success((Object)data);
    }

    public ResponseData<List<Map<String, Object>>> queryReservationCountByTime(QueryReservationDto queryReservationDto) throws ParseException {
        String scheduleDateStart = queryReservationDto.getScheduleDateStart();
        String scheduleDateEnd = queryReservationDto.getScheduleDateEnd();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar instance = Calendar.getInstance();
        scheduleDateStart = scheduleDateStart == null || scheduleDateStart.equals("") ? sdf.format(instance.getTime()) : scheduleDateStart;
        scheduleDateEnd = scheduleDateEnd == null || scheduleDateEnd.equals("") ? sdf.format(instance.getTime()) : scheduleDateEnd;
        List maps = this.reservationMapper.queryReservationCountByTime(queryReservationDto);
        return ResponseData.success((Object)maps);
    }

    public ResponseData<List<ExcelReservation>> queryReservationCountExport(QueryReservationDto queryReservationDto) throws ParseException {
        String scheduleDateStart = queryReservationDto.getScheduleDateStart();
        String scheduleDateEnd = queryReservationDto.getScheduleDateEnd();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar instance = Calendar.getInstance();
        scheduleDateStart = scheduleDateStart == null || scheduleDateStart.equals("") ? sdf.format(instance.getTime()) : scheduleDateStart;
        scheduleDateEnd = scheduleDateEnd == null || scheduleDateEnd.equals("") ? sdf.format(instance.getTime()) : scheduleDateEnd;
        queryReservationDto.setScheduleDateStart(scheduleDateStart + " 00:00:00");
        queryReservationDto.setScheduleDateEnd(scheduleDateEnd + " 23:59:59");
        List excelReservations = this.reservationMapper.queryReservationCountExport(queryReservationDto);
        return ResponseData.success((Object)excelReservations);
    }

    public ResponseData<List<Map<String, Object>>> queryReservationCountByDept(QueryReservationDto queryReservationDto) {
        String scheduleDateStart = queryReservationDto.getScheduleDateStart();
        String scheduleDateEnd = queryReservationDto.getScheduleDateEnd();
        if (scheduleDateStart != null) {
            queryReservationDto.setScheduleDateStart(scheduleDateStart + " 00:00:00");
        }
        if (scheduleDateEnd != null) {
            queryReservationDto.setScheduleDateEnd(scheduleDateEnd + " 23:59:59");
        }
        List stringObjectMap = this.reservationMapper.queryReservationCountByDept(queryReservationDto);
        Integer sortType = queryReservationDto.getSortType();
        sortType = sortType == null ? 0 : sortType;
        switch (sortType) {
            case 0: {
                Collections.sort(stringObjectMap, new /* Unavailable Anonymous Inner Class!! */);
                break;
            }
            case 1: {
                Collections.sort(stringObjectMap, new /* Unavailable Anonymous Inner Class!! */);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + sortType);
            }
        }
        return ResponseData.success((Object)stringObjectMap);
    }

    public ResponseData<List<Map<String, Object>>> queryReservationCountByReservationSource(QueryReservationDto queryReservationDto) {
        String scheduleDateStart = queryReservationDto.getScheduleDateStart();
        String scheduleDateEnd = queryReservationDto.getScheduleDateEnd();
        if (scheduleDateStart != null) {
            queryReservationDto.setScheduleDateStart(scheduleDateStart + " 00:00:00");
        }
        if (scheduleDateEnd != null) {
            queryReservationDto.setScheduleDateEnd(scheduleDateEnd + " 23:59:59");
        }
        List maps = this.reservationMapper.queryReservationCountByReservationSource(queryReservationDto);
        return ResponseData.success((Object)maps);
    }

    public List<ReservationVo> queryReservationList(ReservationDTO dto) {
        return this.reservationMapper.queryReservationList(dto);
    }

    static /* synthetic */ NodeConfig access$000(ReservationServiceImpl x0) {
        return x0.nodeConfig;
    }

    static /* synthetic */ Logger access$100() {
        return logger;
    }
}

