/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.byh.outpatient.api.dto.RequestDto;
import com.byh.outpatient.api.model.OutEtubePatientDossierEntity;
import com.byh.outpatient.api.model.OutEtubePatientInfoEntity;
import com.byh.outpatient.api.model.OutExpertStudioRecordEntity;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.ExpertStudioService;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/expertStudio"})
public class ExpertStudioController {
    @Autowired
    private ExpertStudioService studioService;
    @Autowired
    private CommonRequest commonRequest;

    @PostMapping(value={"/insertStudio"})
    public ResponseData insertStudio(@RequestBody OutExpertStudioRecordEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        Integer patientId = entity.getPatientId();
        Integer doctorId = entity.getDoctorId();
        if (patientId == null) {
            return ResponseData.error((String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        entity.setTenantId(tenant);
        return this.studioService.pushStudioPatient(entity);
    }

    @PostMapping(value={"/pushRecord"})
    public ResponseData pushRecord(@RequestBody OutExpertStudioRecordEntity entity) throws IOException {
        return this.studioService.pushRecord();
    }

    @PostMapping(value={"/checkRecord"})
    public ResponseData checkRecord(@RequestBody OutExpertStudioRecordEntity entity) throws IOException {
        return this.studioService.checkRecord();
    }

    @PostMapping(value={"/pushToStudioByPatients"})
    public ResponseData pushToStudioByPatients(@RequestBody OutExpertStudioRecordEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        List patientIds = entity.getPatientIds();
        Integer doctorId = entity.getDoctorId();
        if (patientIds.size() < 1 || doctorId == null) {
            return ResponseData.error((String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        entity.setTenantId(tenant);
        return this.studioService.pushStudioPatients(entity);
    }

    @PostMapping(value={"/pushTag"})
    public ResponseData pushTag(@RequestBody RequestDto dto) {
        String[] tagType = new String[]{"PATIENT_ONLINE_TAG", "OPERATION_TAG"};
        Integer tenant = this.commonRequest.getTenant();
        dto.setTenantId(tenant);
        for (String s : tagType) {
            dto.setSourceType(s);
            this.studioService.pushTag(dto);
        }
        return ResponseData.success();
    }

    @PostMapping(value={"/batchPush"})
    public ResponseData batchPush() {
        Integer tenant = this.commonRequest.getTenant();
        ResponseData responseData = this.studioService.batchPush(tenant);
        return responseData;
    }

    @PostMapping(value={"/test"})
    public ResponseData test() {
        Integer tenant = this.commonRequest.getTenant();
        RequestDto dto = new RequestDto();
        ResponseData responseData = this.studioService.test(dto);
        return responseData;
    }

    @PostMapping(value={"/pushTagInfo"})
    public ResponseData pushDrugTag(@RequestBody RequestDto dto) {
        Integer tenant = this.commonRequest.getTenant();
        ResponseData responseData = this.studioService.pushTagInfo(dto);
        return responseData;
    }

    @PostMapping(value={"/pushTagNetwork"})
    public ResponseData pushTagNetwork(@RequestBody RequestDto dto) throws ParseException {
        Integer tenant = this.commonRequest.getTenant();
        ResponseData responseData = this.studioService.pushTagNetwork(dto);
        return responseData;
    }

    @PostMapping(value={"/queryTagTree"})
    public ResponseData queryTagTree(@RequestBody RequestDto dto) {
        return this.studioService.queryTagTree(dto);
    }

    @PostMapping(value={"/insertPatientTagInfo"})
    public ResponseData insertPatientTagInfo(@RequestBody RequestDto dto) {
        return this.studioService.insertPatientTagInfo(dto);
    }

    @PostMapping(value={"/deletePatientTagInfo"})
    public ResponseData deletePatientTagInfo(@RequestBody RequestDto dto) {
        return this.studioService.deletePatientTagInfo(dto);
    }

    @PostMapping(value={"/queryIndicatorInfo"})
    public ResponseData queryIndicatorInfo(@RequestBody RequestDto dto) {
        return this.studioService.queryIndicatorInfo(dto);
    }

    @PostMapping(value={"/insertPatientIndicatorUpload"})
    public ResponseData insertPatientIndicatorUpload(@RequestBody RequestDto dto) {
        return this.studioService.insertPatientIndicatorUpload(dto);
    }

    @PostMapping(value={"/queryPatient"})
    public ResponseData<OutEtubePatientInfoEntity> queryPatient(@RequestBody OutEtubePatientInfoEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        String patientCode = entity.getPatientCode();
        if (StringUtils.isBlank((CharSequence)patientCode)) {
            return ResponseData.error((String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        entity.setTenantId(tenant);
        return this.studioService.queryPatient(entity);
    }

    @PostMapping(value={"/updatePatient"})
    public ResponseData<OutEtubePatientInfoEntity> updatePatient(@RequestBody OutEtubePatientInfoEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        String patientCode = entity.getPatientCode();
        if (StringUtils.isBlank((CharSequence)patientCode)) {
            return ResponseData.error((String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        entity.setTenantId(tenant);
        return this.studioService.updatePatient(entity);
    }

    @PostMapping(value={"/queryPatientDossier"})
    public ResponseData queryPatientDossier(@RequestBody OutEtubePatientDossierEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        String patientCode = entity.getPatientCode();
        String studioCode = entity.getStudioCode();
        if (StringUtils.isBlank((CharSequence)patientCode) || StringUtils.isBlank((CharSequence)studioCode)) {
            return ResponseData.error((String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        entity.setTenantId(tenant);
        return this.studioService.queryPatientDossier(entity);
    }

    @PostMapping(value={"/updatePatientDossier"})
    public ResponseData updatePatientDossier(@RequestBody OutEtubePatientDossierEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        String patientCode = entity.getPatientCode();
        String studioCode = entity.getStudioCode();
        if (StringUtils.isBlank((CharSequence)patientCode) || StringUtils.isBlank((CharSequence)studioCode)) {
            return ResponseData.error((String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        entity.setTenantId(tenant);
        return this.studioService.updatePatientDossier(entity);
    }
}

