/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.alibaba.fastjson.JSON;
import com.byh.outpatient.api.dto.MedicationDeliveryOrderDto;
import com.byh.outpatient.api.model.MedicationDeliveryOrderEntity;
import com.byh.outpatient.api.util.HttpUtils;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.MedicationDeliveryOrderService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiOperation;
import io.swagger.v3.oas.annotations.Operation;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/medicationDeliveryOrder"})
public class MedicationDeliveryOrderController {
    @Autowired
    private CommonRequest commonRequest;
    @Autowired
    private MedicationDeliveryOrderService medicationDeliveryOrderService;

    @PostMapping(value={"/searchMedicationDeliveryOrderList"})
    @Operation(description="\u5357\u534e\u4e91\u836f\u623f\u8ba2\u5355\u67e5\u8be2")
    @ApiOperation(value="\u5357\u534e\u4e91\u836f\u623f\u8ba2\u5355\u67e5\u8be2", httpMethod="POST", notes="\u5357\u534e\u4e91\u836f\u623f\u8ba2\u5355\u67e5\u8be2")
    public ResponseData<PageInfo<MedicationDeliveryOrderDto>> searchMedicationDeliveryOrderList(@RequestBody @Valid MedicationDeliveryOrderDto dto) {
        Integer tenant = this.commonRequest.getTenant();
        dto.setTenantId(tenant + "");
        ResponseData pageInfoResponseData = this.medicationDeliveryOrderService.searchMedicationDeliveryOrderList(dto);
        return pageInfoResponseData;
    }

    @PostMapping(value={"/searchMedicationDeliveryOrderByOne"})
    @Operation(description="\u67e5\u8be2\u5355\u4e2a\u9001\u836f\u8ba2\u5355")
    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u9001\u836f\u8ba2\u5355", httpMethod="POST", notes="\u67e5\u8be2\u5355\u4e2a\u9001\u836f\u8ba2\u5355")
    public ResponseData<MedicationDeliveryOrderDto> searchMedicationDeliveryOrderByOne(@RequestBody @Valid MedicationDeliveryOrderDto dto) {
        Integer tenant = this.commonRequest.getTenant();
        dto.setTenantId(tenant + "");
        return this.medicationDeliveryOrderService.searchMedicationDeliveryOrderByOne(dto);
    }

    @PostMapping(value={"/saveMedicationDeliveryOrder"})
    @Operation(description="\u4fdd\u5b58\u5e76\u5411\u5357\u534e\u53d1\u9001\u8ba2\u5355\u4fe1\u606f")
    @ApiOperation(value="\u4fdd\u5b58\u5e76\u5411\u5357\u534e\u53d1\u9001\u8ba2\u5355\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u5e76\u5411\u5357\u534e\u53d1\u9001\u8ba2\u5355\u4fe1\u606f")
    public ResponseData saveMedicationDeliveryOrder(@RequestBody @Valid MedicationDeliveryOrderDto dto) throws IOException {
        Integer tenant = this.commonRequest.getTenant();
        dto.setTenantId(tenant + "");
        System.out.println(dto.getOrderNo() + "---------------------------------------");
        return this.medicationDeliveryOrderService.saveMedicationDeliveryOrder(dto);
    }

    @PostMapping(value={"/cancelMedicationDeliveryOrder"})
    @Operation(description="\u53d1\u9001\u53d6\u6d88\u9001\u8d27\u8ba2\u5355\u8bf7\u6c42\uff0c\u5e76\u66f4\u65b0\u8ba2\u5355\u72b6\u6001")
    @ApiOperation(value="\u53d1\u9001\u53d6\u6d88\u9001\u8d27\u8ba2\u5355\u8bf7\u6c42\uff0c\u5e76\u66f4\u65b0\u8ba2\u5355\u72b6\u6001", httpMethod="POST", notes="\u53d1\u9001\u53d6\u6d88\u9001\u8d27\u8ba2\u5355\u8bf7\u6c42\uff0c\u5e76\u66f4\u65b0\u8ba2\u5355\u72b6\u6001")
    public ResponseData cancelMedicationDeliveryOrder(@RequestBody @Valid MedicationDeliveryOrderEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant + "");
        return this.medicationDeliveryOrderService.cancelOrder(entity);
    }

    @PostMapping(value={"/excelMedicationDeliveryOrder"})
    @Operation(description="\u5357\u534e\u8ba2\u5355\u5bfc\u51fa")
    @ApiOperation(value="\u5357\u534e\u8ba2\u5355\u5bfc\u51fa", httpMethod="POST", notes="\u5357\u534e\u8ba2\u5355\u5bfc\u51fa")
    public void excelMedicationDeliveryOrder(HttpServletResponse response, @RequestBody @Valid MedicationDeliveryOrderDto dto) throws Exception {
        Integer tenant = this.commonRequest.getTenant();
        dto.setTenantId(tenant + "");
        this.medicationDeliveryOrderService.excelMedicationDeliveryOrder(response, dto);
    }

    @PostMapping(value={"/receiveMedicationDeliveryOrder"})
    @Operation(description="\u63a5\u6536\u5357\u534e\u7684\u53d1\u8d27\u4fe1\u606f")
    @ApiOperation(value="\u63a5\u6536\u5357\u534e\u7684\u53d1\u8d27\u4fe1\u606f", httpMethod="POST", notes="\u63a5\u6536\u5357\u534e\u7684\u53d1\u8d27\u4fe1\u606f")
    @ResponseBody
    public Map<String, Object> receiveMedicationDeliveryOrder(@RequestBody @Valid MedicationDeliveryOrderDto dto) {
        return this.medicationDeliveryOrderService.receiveOrder(dto);
    }

    @PostMapping(value={"/test"})
    @Operation(description="\u6d4b\u8bd5")
    @ApiOperation(value="\u6d4b\u8bd5", httpMethod="POST", notes="\u6d4b\u8bd5")
    public ResponseData test() throws IOException {
        String url = "http://localhost:8895/outpatient-service/medicationDeliveryOrder/receiveMedicationDeliveryOrder";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("orderid", "1W202312132211110991131");
        param.put("status", "\u8ba2\u5355\u5df2\u53d1\u8d27");
        param.put("verificationTime", "2024-03-06 15:20:20");
        param.put("express", "\u987a\u4e30\u5feb\u9012");
        param.put("expressno", "aaaa");
        String s = HttpUtils.doPost((String)url, (String)JSON.toJSONString(param), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
        System.out.println(s);
        return ResponseData.success();
    }
}

