/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.Task;

import com.byh.outpatient.web.mvc.utils.RedisUtil;
import com.byh.outpatient.web.service.AdmissionService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ArchivingTask {
    private static final Logger log = LoggerFactory.getLogger(ArchivingTask.class);
    private static final String archivingTaskKey = "redis_archiving_task_lock_1";
    private static final String narchivingValue = "1";
    private static final Long timeOut = 5000L;
    @Autowired
    private AdmissionService admissionService;
    @Autowired
    private RedisUtil redisUtil;

    public void MedicalRecordArchiving() {
        log.info("==============================\u75c5\u5386\u5f52\u6863=========================");
        if (!this.redisUtil.lock(archivingTaskKey, narchivingValue, timeOut)) {
            log.info("====\u672a\u83b7\u53d6\u5230\u9501====\u75c5\u5386\u5f52\u6863=====");
            return;
        }
        try {
            Date newDate = new Date();
            log.info("=====\u83b7\u5f97\u9501==\u75c5\u5386\u5f52\u6863=====");
            this.admissionService.archivingByDate(newDate);
        }
        catch (Exception e) {
            log.error("\u75c5\u5386\u5f52\u6863\u5f02\u5e38,msg:{},e:{}", (Object)e.getMessage(), (Object)e);
            e.printStackTrace();
        }
        finally {
            this.redisUtil.unlock(archivingTaskKey);
        }
    }
}

