/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.utils;

import io.minio.BucketExistsArgs;
import io.minio.DownloadObjectArgs;
import io.minio.GetObjectArgs;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.ListObjectsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.ObjectStat;
import io.minio.PutObjectArgs;
import io.minio.PutObjectOptions;
import io.minio.RemoveBucketArgs;
import io.minio.RemoveObjectArgs;
import io.minio.RemoveObjectsArgs;
import io.minio.Result;
import io.minio.StatObjectArgs;
import io.minio.UploadObjectArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidBucketNameException;
import io.minio.errors.InvalidExpiresRangeException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.RegionConflictException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.http.Method;
import io.minio.messages.Bucket;
import io.minio.messages.DeleteError;
import io.minio.messages.DeleteObject;
import io.minio.messages.Item;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class MinioClientUtils {
    private static final Logger log = LoggerFactory.getLogger(MinioClientUtils.class);
    @Autowired
    private MinioClient minioClient;
    private static final int DEFAULT_EXPIRY_TIME = 604800;

    public boolean bucketExists(String bucketName) throws IOException, InvalidKeyException, InvalidResponseException, InsufficientDataException, NoSuchAlgorithmException, ServerException, InternalException, XmlParserException, InvalidBucketNameException, ErrorResponseException {
        boolean flag = false;
        flag = this.minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build());
        return flag;
    }

    public boolean makeBucket(String bucketName) throws IOException, InvalidKeyException, InvalidResponseException, RegionConflictException, InsufficientDataException, NoSuchAlgorithmException, ServerException, InternalException, XmlParserException, InvalidBucketNameException, ErrorResponseException {
        boolean flag = this.bucketExists(bucketName);
        if (!flag) {
            this.minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
            return true;
        }
        return false;
    }

    public List<String> listBucketNames() throws IOException, InvalidResponseException, InvalidKeyException, NoSuchAlgorithmException, ServerException, ErrorResponseException, XmlParserException, InvalidBucketNameException, InsufficientDataException, InternalException {
        List bucketList = this.listBuckets();
        ArrayList<String> bucketListName = new ArrayList<String>();
        for (Bucket bucket : bucketList) {
            bucketListName.add(bucket.name());
        }
        return bucketListName;
    }

    public List<Bucket> listBuckets() throws IOException, InvalidKeyException, InvalidResponseException, InsufficientDataException, NoSuchAlgorithmException, ServerException, InternalException, XmlParserException, InvalidBucketNameException, ErrorResponseException {
        return this.minioClient.listBuckets();
    }

    public boolean removeBucket(String bucketName) throws IOException, InvalidKeyException, InvalidResponseException, InsufficientDataException, NoSuchAlgorithmException, ServerException, InternalException, XmlParserException, InvalidBucketNameException, ErrorResponseException {
        boolean flag = this.bucketExists(bucketName);
        if (flag) {
            Iterable myObjects = this.listObjects(bucketName);
            for (Result result : myObjects) {
                Item item = (Item)result.get();
                if (item.size() <= 0L) continue;
                return false;
            }
            this.minioClient.removeBucket((RemoveBucketArgs)((RemoveBucketArgs.Builder)RemoveBucketArgs.builder().bucket(bucketName)).build());
            flag = this.bucketExists(bucketName);
            if (!flag) {
                return true;
            }
        }
        return false;
    }

    public List<String> listObjectNames(String bucketName) throws XmlParserException, IOException, InvalidResponseException, InvalidKeyException, NoSuchAlgorithmException, ServerException, ErrorResponseException, InvalidBucketNameException, InsufficientDataException, InternalException {
        ArrayList<String> listObjectNames = new ArrayList<String>();
        boolean flag = this.bucketExists(bucketName);
        if (flag) {
            Iterable myObjects = this.listObjects(bucketName);
            for (Result result : myObjects) {
                Item item = (Item)result.get();
                listObjectNames.add(item.objectName());
            }
        }
        return listObjectNames;
    }

    public Iterable<Result<Item>> listObjects(String bucketName) throws XmlParserException, IOException, InvalidResponseException, InvalidKeyException, NoSuchAlgorithmException, ServerException, ErrorResponseException, InvalidBucketNameException, InsufficientDataException, InternalException {
        boolean flag = this.bucketExists(bucketName);
        if (flag) {
            return this.minioClient.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucketName)).build());
        }
        return null;
    }

    public boolean uploadObject(String bucketName, String objectName, String fileName) throws IOException, InvalidKeyException, InvalidResponseException, InsufficientDataException, NoSuchAlgorithmException, ServerException, InternalException, XmlParserException, InvalidBucketNameException, ErrorResponseException {
        boolean flag = this.bucketExists(bucketName);
        if (flag) {
            this.minioClient.uploadObject((UploadObjectArgs)((UploadObjectArgs.Builder)((UploadObjectArgs.Builder)UploadObjectArgs.builder().bucket(bucketName)).object(objectName)).filename(fileName).build());
            ObjectStat statObject = this.statObject(bucketName, objectName);
            if (statObject != null && statObject.length() > 0L) {
                return true;
            }
        }
        return false;
    }

    public void putObject(String bucketName, MultipartFile multipartFile, String filename) throws IOException, InvalidKeyException, InvalidResponseException, InsufficientDataException, NoSuchAlgorithmException, ServerException, InternalException, XmlParserException, InvalidBucketNameException, ErrorResponseException {
        PutObjectOptions putObjectOptions = new PutObjectOptions(multipartFile.getSize(), 0x500000L);
        putObjectOptions.setContentType(multipartFile.getContentType());
        this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(filename)).stream(multipartFile.getInputStream(), multipartFile.getSize(), -1L).contentType(multipartFile.getContentType()).build());
    }

    public boolean putObject(String bucketName, String objectName, InputStream inputStream, String contentType) throws IOException, InvalidResponseException, InvalidKeyException, NoSuchAlgorithmException, ServerException, ErrorResponseException, XmlParserException, InvalidBucketNameException, InsufficientDataException, InternalException {
        boolean flag = this.bucketExists(bucketName);
        if (flag) {
            this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(objectName)).stream(inputStream, -1L, 0xA00000L).contentType(contentType).build());
            ObjectStat statObject = this.statObject(bucketName, objectName);
            if (statObject != null && statObject.length() > 0L) {
                return true;
            }
        }
        return false;
    }

    public InputStream getObject(String bucketName, String objectName) throws IOException, InvalidKeyException, InvalidResponseException, InsufficientDataException, NoSuchAlgorithmException, ServerException, InternalException, XmlParserException, InvalidBucketNameException, ErrorResponseException {
        ObjectStat statObject;
        boolean flag = this.bucketExists(bucketName);
        if (flag && (statObject = this.statObject(bucketName, objectName)) != null && statObject.length() > 0L) {
            InputStream stream = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(objectName)).build());
            return stream;
        }
        return null;
    }

    public InputStream getObject(String bucketName, String objectName, long offset, Long length) throws IOException, InvalidKeyException, InvalidResponseException, InsufficientDataException, NoSuchAlgorithmException, ServerException, InternalException, XmlParserException, InvalidBucketNameException, ErrorResponseException {
        ObjectStat statObject;
        boolean flag = this.bucketExists(bucketName);
        if (flag && (statObject = this.statObject(bucketName, objectName)) != null && statObject.length() > 0L) {
            InputStream stream = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(objectName)).offset(Long.valueOf(1024L))).length(Long.valueOf(4096L))).build());
            return stream;
        }
        return null;
    }

    public boolean downloadObject(String bucketName, String objectName, String fileName) throws IOException, InvalidKeyException, InvalidResponseException, InsufficientDataException, NoSuchAlgorithmException, ServerException, InternalException, XmlParserException, InvalidBucketNameException, ErrorResponseException {
        ObjectStat statObject;
        boolean flag = this.bucketExists(bucketName);
        if (flag && (statObject = this.statObject(bucketName, objectName)) != null && statObject.length() > 0L) {
            this.minioClient.downloadObject((DownloadObjectArgs)((DownloadObjectArgs.Builder)((DownloadObjectArgs.Builder)DownloadObjectArgs.builder().bucket(bucketName)).object(objectName)).filename(fileName).build());
            return true;
        }
        return false;
    }

    public boolean removeObject(String bucketName, String objectName) throws IOException, InvalidKeyException, InvalidResponseException, InsufficientDataException, NoSuchAlgorithmException, ServerException, InternalException, XmlParserException, InvalidBucketNameException, ErrorResponseException {
        boolean flag = this.bucketExists(bucketName);
        if (flag) {
            this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucketName)).object(objectName)).build());
            return true;
        }
        return false;
    }

    public List<String> removeObjects(String bucketName, List<DeleteObject> objectNames) throws IOException, InvalidKeyException, InvalidResponseException, InsufficientDataException, NoSuchAlgorithmException, ServerException, InternalException, XmlParserException, InvalidBucketNameException, ErrorResponseException {
        ArrayList<String> deleteErrorNames = new ArrayList<String>();
        boolean flag = this.bucketExists(bucketName);
        if (flag) {
            Iterable results = this.minioClient.removeObjects((RemoveObjectsArgs)((RemoveObjectsArgs.Builder)RemoveObjectsArgs.builder().bucket(bucketName)).objects(objectNames).build());
            for (Result result : results) {
                DeleteError error = (DeleteError)result.get();
                deleteErrorNames.add(error.objectName());
            }
        }
        return deleteErrorNames;
    }

    public String getPresignedObjectUrl(String bucketName, String objectName, Integer expires) throws InvalidExpiresRangeException, IOException, InvalidResponseException, InvalidKeyException, NoSuchAlgorithmException, ServerException, ErrorResponseException, XmlParserException, InvalidBucketNameException, InsufficientDataException, InternalException {
        boolean flag = this.bucketExists(bucketName);
        String url = "";
        if (flag) {
            if (expires < 1 || expires > 604800) {
                throw new InvalidExpiresRangeException(expires.intValue(), "expires must be in range of 1 to 604800");
            }
            try {
                url = this.minioClient.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucketName)).object(objectName)).expiry(expires.intValue()).build());
            }
            catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidBucketNameException | InvalidExpiresRangeException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        return url;
    }

    public String presignedPutObject(String bucketName, String objectName, Integer expires) throws IOException, InvalidResponseException, InvalidKeyException, NoSuchAlgorithmException, ServerException, ErrorResponseException, XmlParserException, InvalidBucketNameException, InsufficientDataException, InternalException {
        boolean flag = this.bucketExists(bucketName);
        String url = "";
        if (flag) {
            if (expires < 1 || expires > 604800) {
                try {
                    throw new InvalidExpiresRangeException(expires.intValue(), "expires must be in range of 1 to 604800");
                }
                catch (InvalidExpiresRangeException e) {
                    e.printStackTrace();
                }
            }
            try {
                url = this.minioClient.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.PUT).bucket(bucketName)).object(objectName)).expiry(expires.intValue()).build());
            }
            catch (ErrorResponseException | InsufficientDataException e) {
                e.printStackTrace();
            }
            catch (InternalException e) {
                log.error("InternalException", (Throwable)e);
            }
            catch (InvalidBucketNameException e) {
                log.error("InvalidBucketNameException", (Throwable)e);
            }
            catch (InvalidExpiresRangeException e) {
                log.error("InvalidExpiresRangeException", (Throwable)e);
            }
            catch (InvalidKeyException e) {
                log.error("InvalidKeyException", (Throwable)e);
            }
            catch (InvalidResponseException e) {
                log.error("InvalidResponseException", (Throwable)e);
            }
            catch (IOException e) {
                log.error("IOException", (Throwable)e);
            }
            catch (NoSuchAlgorithmException e) {
                log.error("NoSuchAlgorithmException", (Throwable)e);
            }
            catch (ServerException e) {
                log.error("ServerException", (Throwable)e);
            }
            catch (XmlParserException e) {
                log.error("XmlParserException", (Throwable)e);
            }
        }
        return url;
    }

    public ObjectStat statObject(String bucketName, String objectName) throws IOException, InvalidResponseException, InvalidKeyException, NoSuchAlgorithmException, ServerException, ErrorResponseException, XmlParserException, InvalidBucketNameException, InsufficientDataException, InternalException {
        boolean flag = this.bucketExists(bucketName);
        if (flag) {
            ObjectStat statObject = null;
            try {
                statObject = this.minioClient.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(bucketName)).object(objectName)).build());
            }
            catch (ErrorResponseException e) {
                log.error("ErrorResponseException", (Throwable)e);
            }
            catch (InsufficientDataException e) {
                log.error("ErrorResponseException", (Throwable)e);
                e.printStackTrace();
            }
            catch (InternalException e) {
                log.error("InternalException", (Throwable)e);
            }
            catch (InvalidBucketNameException e) {
                log.error("InvalidBucketNameException", (Throwable)e);
            }
            catch (InvalidKeyException e) {
                log.error("InvalidKeyException", (Throwable)e);
            }
            catch (InvalidResponseException e) {
                log.error("InvalidResponseException", (Throwable)e);
            }
            catch (IOException e) {
                log.error("IOException", (Throwable)e);
            }
            catch (NoSuchAlgorithmException e) {
                log.error("NoSuchAlgorithmException", (Throwable)e);
            }
            catch (ServerException e) {
                log.error("ServerException", (Throwable)e);
            }
            catch (XmlParserException e) {
                log.error("XmlParserException", (Throwable)e);
            }
            return statObject;
        }
        return null;
    }

    public String getObjectUrl(String bucketName, String objectName) throws IOException, InvalidResponseException, InvalidKeyException, NoSuchAlgorithmException, ServerException, ErrorResponseException, XmlParserException, InvalidBucketNameException, InsufficientDataException, InternalException {
        boolean flag = this.bucketExists(bucketName);
        String url = "";
        if (flag) {
            try {
                url = this.minioClient.getObjectUrl(bucketName, objectName);
            }
            catch (ErrorResponseException e) {
                log.error("XmlParserException", (Throwable)e);
            }
            catch (InsufficientDataException e) {
                log.error("InsufficientDataException", (Throwable)e);
            }
            catch (InternalException e) {
                log.error("InternalException", (Throwable)e);
            }
            catch (InvalidBucketNameException e) {
                log.error("InvalidBucketNameException", (Throwable)e);
            }
            catch (InvalidKeyException e) {
                log.error("InvalidKeyException", (Throwable)e);
            }
            catch (InvalidResponseException e) {
                log.error("InvalidResponseException", (Throwable)e);
            }
            catch (IOException e) {
                log.error("IOException", (Throwable)e);
            }
            catch (NoSuchAlgorithmException e) {
                log.error("NoSuchAlgorithmException", (Throwable)e);
            }
            catch (ServerException e) {
                log.error("ServerException", (Throwable)e);
            }
            catch (XmlParserException e) {
                log.error("XmlParserException", (Throwable)e);
            }
        }
        return url;
    }

    public void downloadFile(String bucketName, String fileName, String originalName, HttpServletResponse response) {
        try {
            int len;
            InputStream file = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(fileName)).build());
            String filename = new String(fileName.getBytes("ISO8859-1"), StandardCharsets.UTF_8);
            if (StringUtils.isNotEmpty((String)originalName)) {
                fileName = originalName;
            }
            response.setHeader("Content-Disposition", "attachment;filename=" + filename);
            ServletOutputStream servletOutputStream = response.getOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = file.read(buffer)) > 0) {
                servletOutputStream.write(buffer, 0, len);
            }
            servletOutputStream.flush();
            file.close();
            servletOutputStream.close();
        }
        catch (ErrorResponseException e) {
            log.error("ErrorResponseException", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Exception", (Throwable)e);
        }
    }
}

