/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.byh.outpatient.api.enums.DeliveryStatusEnum;
import com.byh.outpatient.api.model.prescription.OutPrescription;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.data.repository.OutOrderMapper;
import com.byh.outpatient.data.repository.OutPrescriptionMapper;
import com.byh.outpatient.web.service.HisRemoteService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class HisManage {
    private static final Logger log = LoggerFactory.getLogger(HisManage.class);
    @Autowired
    private HisRemoteService hisRemoteService;
    @Autowired
    private OutPrescriptionMapper outPrescriptionMapper;
    @Autowired
    private OutOrderMapper outOrderMapper;

    public ResponseData onlinePresDispenseMedicine(OutPrescription prescription, Integer statusValue) {
        ResponseData onlineBaseData;
        String prescriptionNo = prescription.getPrescriptionNo();
        String mainId = prescription.getMainId();
        QueryWrapper prescriptionQueryWrapper = new QueryWrapper();
        prescriptionQueryWrapper.eq((Object)"tenant_id", (Object)prescription.getTenantId());
        prescriptionQueryWrapper.eq((Object)"outpatient_no", (Object)prescription.getOutpatientNo());
        prescriptionQueryWrapper.eq((Object)"main_id", (Object)prescription.getMainId());
        List prescriptionList = this.outPrescriptionMapper.selectList((Wrapper)prescriptionQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)prescriptionList)) {
            return ResponseData.error((String)"\u5904\u65b9\u67e5\u8be2\u4e3a\u7a7a:{}", (String)prescription.getMainId());
        }
        if (prescriptionList.size() > 1) {
            log.info("mianId\u5bf9\u5e94\u7684\u5904\u65b9\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)prescriptionList));
            List prescriptionNos = prescriptionList.stream().filter(x -> !prescriptionNo.equals(x.getPrescriptionNo())).map(OutPrescription::getPrescriptionNo).collect(Collectors.toList());
            QueryWrapper orderQueryWrapper = new QueryWrapper();
            orderQueryWrapper.in((Object)"prescription_no", prescriptionNos);
            orderQueryWrapper.eq((Object)"outpatient_no", (Object)prescription.getOutpatientNo());
            orderQueryWrapper.eq((Object)"tenant_id", (Object)prescription.getTenantId());
            List orderList = this.outOrderMapper.selectList((Wrapper)orderQueryWrapper);
            log.info("mianId\u5bf9\u5e94\u7684\u8ba2\u5355\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)orderList));
            int size = orderList.stream().filter(x -> DeliveryStatusEnum.DELIVERY_SHIPPED.getValue().equals(x.getDeliveryStatus())).collect(Collectors.toList()).size();
            if (size > 0) {
                return ResponseData.success();
            }
        }
        if (!(onlineBaseData = this.hisRemoteService.onlinePresDispenseMedicine(mainId, statusValue)).isSuccess()) {
            return onlineBaseData;
        }
        return ResponseData.success();
    }
}

