/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.byh.outpatient.api.enums.FrontMethodEnum;
import com.byh.outpatient.api.model.front.FrontRequest;
import com.byh.outpatient.api.model.front.FrontResponse;
import com.byh.outpatient.api.model.front.OutFrontConfig;
import com.byh.outpatient.api.model.report.OutViewPatientresultDto;
import com.byh.outpatient.api.model.report.OutViewPatientresultEntity;
import com.byh.outpatient.api.model.report.OutViewResultDto;
import com.byh.outpatient.api.model.report.OutViewResultEntity;
import com.byh.outpatient.api.util.PageResult;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.data.repository.OutFrontConfigMapper;
import com.byh.outpatient.web.service.ReportService;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportServiceImpl
implements ReportService {
    private static final Logger log = LoggerFactory.getLogger(ReportServiceImpl.class);
    @Autowired
    private OutFrontConfigMapper outFrontConfigMapper;

    public ResponseData<PageResult<OutViewResultEntity>> reportList(OutViewResultDto outViewResultDto) {
        OutFrontConfig outFrontConfig = this.outFrontConfigMapper.queryByTenantId(outViewResultDto.getTenantId(), FrontMethodEnum.REPORT_LIST.getValue());
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setBody((Object)outViewResultDto);
        frontRequest.setCurrent(outViewResultDto.getCurrent());
        frontRequest.setSize(outViewResultDto.getSize());
        String result = HttpUtil.post((String)outFrontConfig.getInterfaceUrl(), (String)JSONObject.toJSONString((Object)frontRequest));
        if (Objects.isNull(result)) {
            return ResponseData.error((String)"\u524d\u7f6e\u673a\u8bf7\u6c42\u5931\u8d25\uff01");
        }
        FrontResponse frontResponse = (FrontResponse)JSONObject.parseObject((String)result, FrontResponse.class);
        if (frontResponse.isSuccess().booleanValue() && !Objects.isNull(frontResponse.getBody())) {
            PageResult pageResult = (PageResult)JSONObject.parseObject((String)frontResponse.getBody().toString(), PageResult.class);
            return ResponseData.success((Object)pageResult);
        }
        return ResponseData.error((String)"\u67e5\u8be2\u5931\u8d25");
    }

    public ResponseData<OutViewPatientresultEntity> reportDetail(OutViewPatientresultEntity outViewPatientresultEntity) {
        OutFrontConfig outFrontConfig = this.outFrontConfigMapper.queryByTenantId(outViewPatientresultEntity.getTenantId(), FrontMethodEnum.REPOSRT_DETAIL.getValue());
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setBody((Object)outViewPatientresultEntity);
        String result = HttpUtil.post((String)outFrontConfig.getInterfaceUrl(), (String)JSONObject.toJSONString((Object)frontRequest));
        if (Objects.isNull(result)) {
            return ResponseData.error((String)"\u524d\u7f6e\u673a\u8bf7\u6c42\u5931\u8d25\uff01");
        }
        FrontResponse frontResponse = (FrontResponse)JSONObject.parseObject((String)result, FrontResponse.class);
        if (frontResponse.isSuccess().booleanValue() && !Objects.isNull(frontResponse.getBody())) {
            OutViewPatientresultEntity outViewPatientresult = (OutViewPatientresultEntity)JSONObject.parseObject((String)frontResponse.getBody().toString(), OutViewPatientresultEntity.class);
            return ResponseData.success((Object)outViewPatientresult);
        }
        return ResponseData.error((String)"\u67e5\u8be2\u5931\u8d25");
    }

    public ResponseData<PageResult<OutViewPatientresultEntity>> reportDetailList(OutViewPatientresultDto outViewPatientresultDto) {
        OutFrontConfig outFrontConfig = this.outFrontConfigMapper.queryByTenantId(outViewPatientresultDto.getTenantId(), FrontMethodEnum.REPOSRT_DETAIL_LIST.getValue());
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setBody((Object)outViewPatientresultDto);
        frontRequest.setCurrent(outViewPatientresultDto.getCurrent());
        frontRequest.setSize(outViewPatientresultDto.getSize());
        log.info("\u8bf7\u6c42\u524d\u7f6e\u673a\u63a5\u53e3url:{},\u5165\u53c2\uff1a{}", (Object)outFrontConfig.getInterfaceUrl(), (Object)JSONObject.toJSONString((Object)frontRequest));
        String result = HttpUtil.post((String)outFrontConfig.getInterfaceUrl(), (String)JSONObject.toJSONString((Object)frontRequest));
        log.info("\u8bf7\u6c42\u524d\u7f6e\u673a\u63a5\u53e3\u51fa\u53c2\uff1a{}", (Object)result);
        if (Objects.isNull(result)) {
            return ResponseData.error((String)"\u524d\u7f6e\u673a\u8bf7\u6c42\u5931\u8d25\uff01");
        }
        FrontResponse frontResponse = (FrontResponse)JSONObject.parseObject((String)result, FrontResponse.class);
        if (frontResponse.isSuccess().booleanValue() && !Objects.isNull(frontResponse.getBody())) {
            PageResult pageResult = (PageResult)JSONObject.parseObject((String)frontResponse.getBody().toString(), PageResult.class);
            return ResponseData.success((Object)pageResult);
        }
        return ResponseData.error((String)"\u67e5\u8be2\u5931\u8d25");
    }
}

