/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.byh.outpatient.api.model.ArchivalRecordsEntity;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.vo.ArchivalRecordsVo;
import com.byh.outpatient.web.aspect.AntiRefresh;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.ArchivalRecordsService;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiOperation(value="\u8bca\u65ad\u8bb0\u5f55", notes="\u8bca\u65ad\u8bb0\u5f55")
@RestController
@RequestMapping(value={"/archivalRecords"})
public class ArchivalRecordsController {
    @Autowired
    private ArchivalRecordsService archivalRecordsService;
    @Autowired
    private CommonRequest commonRequest;

    @ApiOperation(value="\u6839\u636e\u60a3\u8005id\u67e5\u8be2\u8bca\u65ad\u8bb0\u5f55", notes="\u6839\u636e\u60a3\u8005id\u67e5\u8be2\u8bca\u65ad\u8bb0\u5f55")
    @GetMapping(value={"/pageList"})
    @AntiRefresh
    public ResponseData<List<ArchivalRecordsVo>> pageList(ArchivalRecordsEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        return ResponseData.success((Object)this.archivalRecordsService.pageList(entity));
    }

    @ApiOperation(value="\u6839\u636e\u60a3\u8005id\u4fdd\u5b58\u8bca\u65ad\u8bb0\u5f55", notes="\u6839\u636e\u60a3\u8005id\u4fdd\u5b58\u8bca\u65ad\u8bb0\u5f55")
    @PostMapping(value={"/save"})
    @AntiRefresh
    public ResponseData<List<ArchivalRecordsVo>> save(HttpServletResponse response, @RequestBody ArchivalRecordsEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        return this.archivalRecordsService.save(entity);
    }

    @ApiOperation(value="\u5220\u9664\u60a3\u8005\u8bca\u65ad\u8bb0\u5f55", notes="\u5220\u9664\u60a3\u8005\u8bca\u65ad\u8bb0\u5f55")
    @PostMapping(value={"/del"})
    @AntiRefresh
    public ResponseData del(HttpServletResponse response, @RequestBody ArchivalRecordsEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        Integer del = this.archivalRecordsService.del(entity);
        if (del == 0) {
            return ResponseData.error((String)"\u5220\u9664\u5931\u8d25");
        }
        return ResponseData.success();
    }

    @ApiOperation(value="\u7f16\u8f91\u8bca\u65ad\u8bb0\u5f55", notes="\u7f16\u8f91\u8bca\u65ad\u8bb0\u5f55")
    @PostMapping(value={"/edit"})
    @AntiRefresh
    public ResponseData edit(@RequestBody ArchivalRecordsEntity entity) {
        entity.setTenantId(this.commonRequest.getTenant());
        Integer update = this.archivalRecordsService.update(entity);
        if (update == 0) {
            return ResponseData.error((String)"\u7f16\u8f91\u5931\u8d25");
        }
        return ResponseData.success();
    }
}

