/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.byh.outpatient.api.dto.QueryOutIcdItemDto;
import com.byh.outpatient.api.model.OutIcdItem;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.OutIcdItemService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="icd\u4fe1\u606f")
@RestController
@RequestMapping(value={"/outIcdItem"})
public class OutIcdItemController {
    @Resource
    private OutIcdItemService outIcdItemService;
    @Autowired
    private CommonRequest commonRequest;

    @ApiOperation(value="\u5237\u65b0\u8bca\u65ad\u8868\u5185\u7684\u62fc\u97f3\u7801")
    @PostMapping(value={"/changeForPyCode"})
    public ResponseData changeForPyCode() {
        this.outIcdItemService.changeForPyCode(this.commonRequest.getTenant());
        return ResponseData.success((Object)"\u62fc\u97f3\u7801\u5237\u65b0\u6210\u529f\uff01");
    }

    @PostMapping(value={"/v1/queryIcd"})
    @Operation(description="\u67e5\u8be2ICD\u4fe1\u606f")
    @ApiOperation(value="\u7ebf\u4e0b\u95e8\u8bca-\u67e5\u8be2ICD\u4fe1\u606f", httpMethod="POST", notes="\u7ebf\u4e0b\u95e8\u8bca-\u67e5\u8be2ICD\u4fe1\u606f")
    public ResponseData<PageInfo<OutIcdItem>> queryIcd(@RequestBody @Valid QueryOutIcdItemDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.outIcdItemService.queryIcd(parameter);
    }

    @PostMapping(value={"/v1/addIcd"})
    @Operation(description="\u65b0\u589eICD\u4fe1\u606f")
    @ApiOperation(value="\u7ebf\u4e0b\u95e8\u8bca-\u65b0\u589eICD\u4fe1\u606f", httpMethod="POST", notes="\u7ebf\u4e0b\u95e8\u8bca-\u65b0\u589eICD\u4fe1\u606f")
    public ResponseData addIcd(@RequestBody @Valid OutIcdItem parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        this.outIcdItemService.addIcd(parameter);
        return ResponseData.success();
    }

    @PostMapping(value={"/v1/editIcd"})
    @Operation(description="\u7f16\u8f91ICD\u4fe1\u606f")
    @ApiOperation(value="\u7ebf\u4e0b\u95e8\u8bca-\u7f16\u8f91ICD\u4fe1\u606f", httpMethod="POST", notes="\u7ebf\u4e0b\u95e8\u8bca-\u7f16\u8f91ICD\u4fe1\u606f")
    public ResponseData editIcd(@RequestBody @Valid OutIcdItem parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        this.outIcdItemService.editIcd(parameter);
        return ResponseData.success();
    }

    @PostMapping(value={"/v1/delIcd"})
    @Operation(description="\u5220\u9664ICD\u4fe1\u606f")
    @ApiOperation(value="\u7ebf\u4e0b\u95e8\u8bca-\u5220\u9664ICD\u4fe1\u606f", httpMethod="POST", notes="\u7ebf\u4e0b\u95e8\u8bca-\u5220\u9664ICD\u4fe1\u606f")
    public ResponseData delIcd(@RequestBody @Valid OutIcdItem parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        this.outIcdItemService.delIcd(parameter);
        return ResponseData.success();
    }

    @PostMapping(value={"/queryIcdByCode"})
    @Operation(description="\u67e5\u8be2ICD\u4fe1\u606f")
    @ApiOperation(value="\u7ebf\u4e0a\u95e8\u8bca-\u67e5\u8be2ICD\u4fe1\u606f", httpMethod="POST", notes="\u7ebf\u4e0a\u95e8\u8bca-\u67e5\u8be2ICD\u4fe1\u606f")
    public ResponseData<List<OutIcdItem>> queryIcdByCode(@RequestBody List<String> icdCodes) {
        Integer tenantId = this.commonRequest.getTenant();
        return this.outIcdItemService.queryIcdByCode(icdCodes, tenantId);
    }
}

