/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.api.R;
import com.byh.outpatient.api.model.ArchivalRecordsEntity;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.UUIDUtils;
import com.byh.outpatient.data.repository.AdmissionMapper;
import com.byh.outpatient.data.repository.ArchivalRecordsMapper;
import com.byh.outpatient.data.repository.OutOrderPaymentMapper;
import com.byh.outpatient.data.repository.OutPrescriptionMapper;
import com.byh.outpatient.data.repository.OutTreatmentItemsMapper;
import com.byh.outpatient.data.repository.PatientMapper;
import com.byh.outpatient.web.feign.SysServiceFeign;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.rocket.RocketMQProducer;
import java.util.List;
import org.apache.rocketmq.client.producer.SendCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/mq"})
@RestController
public class RocketMQProducerController {
    private static final Logger logger = LoggerFactory.getLogger(RocketMQProducerController.class);
    private static final Integer maxSize = 102400;
    private static final String topic = "rocketMQ-out-doctor";
    private static final String patientTopic = "rocketMQ-out-patientTopic";
    private static final String patientPaymentTopic = "rocketMQ-out-patientPaymentTopic";
    private static final String admissionTopic = "rocketMQ-out-admissionTopic";
    private static final String prescriptionDetailTopic = "rocketMQ-out-prescriptionDetailTopic";
    private static final String treatmentItemsTopic = "rocketMQ-out-treatmentItemsTopic";
    private static final String archivalFileTopic = "rocketMQ-out-archivalFileTopic";
    private final CommonRequest commonRequest;
    private final RocketMQProducer rocketMQProducer;
    private final PatientMapper patientMapper;
    private final OutOrderPaymentMapper outOrderPaymentMapper;
    private final OutPrescriptionMapper outPrescriptionMapper;
    private final OutTreatmentItemsMapper outTreatmentItemsMapper;
    private final AdmissionMapper admissionMapper;
    private final SysServiceFeign sysServiceFeign;
    @Autowired
    private ArchivalRecordsMapper archivalRecordsMapper;

    @GetMapping(value={"/convertAndSend"})
    public R convertAndSend() {
        String tag = "TAG1";
        String uuid = "100000000000002";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", (Object)"\u6d4b\u8bd5rocketMQ");
        jsonObject.put("age", (Object)"2024");
        jsonObject.put("phone", (Object)"13666668888");
        jsonObject.put("id", (Object)uuid);
        String msg = jsonObject.toString();
        this.rocketMQProducer.syncSendOrderlyKeyCallback(topic, tag, msg, uuid, (SendCallback)new /* Unavailable Anonymous Inner Class!! */);
        return R.ok((Object)"\u53d1\u9001\u7b80\u5355\u6d88\u606f");
    }

    @GetMapping(value={"/doctorSend"})
    public R doctorSend() {
        String tag = "TAG0";
        String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
        ResponseData responseData = this.sysServiceFeign.dataCenter();
        List data = (List)responseData.getData();
        if (!data.isEmpty()) {
            String msg = JSON.toJSONString((Object)data);
            this.rocketMQProducer.asyncSendCallbackTimeoutLevel(topic, tag, msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
            return R.ok((Object)"\u53d1\u9001\u533b\u751f\u6d88\u606f\u6210\u529f");
        }
        return R.ok((Object)"\u53d1\u9001\u533b\u751f\u6d88\u606f\u5931\u8d25");
    }

    @GetMapping(value={"/archivalFileConvertAndSend"})
    public R admissionConvertAndSend() {
        Integer tenant = this.commonRequest.getTenant();
        ArchivalRecordsEntity entity = new ArchivalRecordsEntity();
        entity.setTenantId(tenant);
        List list = this.archivalRecordsMapper.archivalRecordsList(entity);
        this.checkSize(list, archivalFileTopic, "TAG8");
        return R.ok((Object)"\u53d1\u9001\u7b80\u5355\u6d88\u606f");
    }

    @GetMapping(value={"/admissionConvertAndSend"})
    public R admissionConvertAndSend(@RequestParam(value="type") String type) {
        Integer tenant = this.commonRequest.getTenant();
        if (!"first".equals(type)) {
            type = "";
        }
        List list = this.admissionMapper.queryAdmissionByOutpatientNo2(tenant);
        this.checkSize(list, admissionTopic, "TAG7");
        return R.ok((Object)"\u53d1\u9001\u7b80\u5355\u6d88\u606f");
    }

    @GetMapping(value={"/patientItemsConvertAndSend"})
    public R patientItemsConvertAndSend(@RequestParam(value="type") String type) {
        if (!"first".equals(type)) {
            type = "";
        }
        List list = this.outTreatmentItemsMapper.queryItemsByPatientId(type);
        this.checkSize(list, treatmentItemsTopic, "TAG6");
        return R.ok((Object)"\u53d1\u9001\u7b80\u5355\u6d88\u606f");
    }

    @GetMapping(value={"/patientPrescriptionConvertAndSend"})
    public R patientPrescriptionConvertAndSend(@RequestParam(value="type") String type) {
        if (!"first".equals(type)) {
            type = "";
        }
        List list = this.outPrescriptionMapper.queryWesternMedicinePrescriptionsByPatientId(Integer.valueOf(1), type);
        this.checkSize(list, prescriptionDetailTopic, "TAG5");
        return R.ok((Object)"\u53d1\u9001\u7b80\u5355\u6d88\u606f");
    }

    @GetMapping(value={"/patientPaymentConvertAndSend"})
    public R patientPaymentConvertAndSend(@RequestParam(value="type") String type) {
        if (!"first".equals(type)) {
            type = "";
        }
        List paymentList = this.outOrderPaymentMapper.queryOrderPaymentByPatientId(type);
        this.checkSize(paymentList, patientPaymentTopic, "TAG4");
        return R.ok((Object)"\u53d1\u9001\u7b80\u5355\u6d88\u606f");
    }

    @GetMapping(value={"/patientConvertAndSend"})
    public R patientConvertAndSend(@RequestParam(value="type") String type) {
        if (!"first".equals(type)) {
            type = "";
        }
        List patientEntityList = this.patientMapper.queryPatientMedicalRecord();
        this.checkSize(patientEntityList, patientTopic, "TAG3");
        return R.ok((Object)"\u53d1\u9001\u7b80\u5355\u6d88\u606f");
    }

    public void checkSize(List<?> list, String topic, String tag) {
        String msg = JSONObject.toJSONString(list);
        int length = msg.getBytes().length;
        if (length >= maxSize) {
            System.out.println(length + ":\u8d85\u51fa list\u5927\u5c0f:" + list.size());
            this.checkSize(list.subList(0, list.size() / 2), topic, tag);
            this.checkSize(list.subList(list.size() / 2, list.size()), topic, tag);
        } else {
            System.out.println(length + ":\u672a\u8d85\u51fa list\u5927\u5c0f:" + list.size());
            String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
            this.rocketMQProducer.asyncSendCallbackTimeoutLevel(topic, tag, msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
        }
    }

    public RocketMQProducerController(CommonRequest commonRequest, RocketMQProducer rocketMQProducer, PatientMapper patientMapper, OutOrderPaymentMapper outOrderPaymentMapper, OutPrescriptionMapper outPrescriptionMapper, OutTreatmentItemsMapper outTreatmentItemsMapper, AdmissionMapper admissionMapper, SysServiceFeign sysServiceFeign) {
        this.commonRequest = commonRequest;
        this.rocketMQProducer = rocketMQProducer;
        this.patientMapper = patientMapper;
        this.outOrderPaymentMapper = outOrderPaymentMapper;
        this.outPrescriptionMapper = outPrescriptionMapper;
        this.outTreatmentItemsMapper = outTreatmentItemsMapper;
        this.admissionMapper = admissionMapper;
        this.sysServiceFeign = sysServiceFeign;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

