/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.Task;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.outpatient.api.exception.BusinessException;
import com.byh.outpatient.api.model.OutCustomerServiceSettingsEntity;
import com.byh.outpatient.api.model.OutFollowUpTasksEntity;
import com.byh.outpatient.api.model.patient.PatientEntity;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.vo.SysParamVo;
import com.byh.outpatient.api.vo.TaskByDispense;
import com.byh.outpatient.api.vo.TaskByDrugVo;
import com.byh.outpatient.api.vo.TaskByPatientVo;
import com.byh.outpatient.data.repository.OutCustomerServiceSettingsMapper;
import com.byh.outpatient.data.repository.OutFollowUpTasksMapper;
import com.byh.outpatient.data.repository.PatientMapper;
import com.byh.outpatient.web.feign.SysServiceFeign;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import java.net.InetAddress;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class FollowUpTask {
    private static final Logger log = LoggerFactory.getLogger(FollowUpTask.class);
    @Autowired
    private OutFollowUpTasksMapper tasksMapper;
    @Autowired
    private OutCustomerServiceSettingsMapper customerServiceSettingsMapper;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private SysServiceFeign sysServiceFeign;
    @Autowired
    private CommonRequest commonRequest;

    @Scheduled(cron="0 0 1 * * ?")
    public void allocationPatient() {
        log.info("=========================\u5f00\u59cb\u5206\u914d\u60a3\u8005\u7ed9\u5ba2\u670d========================");
        String localHostIp = this.getLocalHostIp();
        if (!"172.24.154.1".equals(localHostIp)) {
            log.info("\u670d\u52a1ip\u4e0d\u5bf9\uff0cip\u5730\u5740============>{}", (Object)localHostIp);
            return;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String timeStr = format.format(new Date());
        String maxPatientId = this.customerServiceSettingsMapper.queryMaxPatientId();
        ResponseData allocationPatient = this.sysServiceFeign.sysParamSelectByName2("allocationPatient", Integer.valueOf(1));
        String value = ((SysParamVo)allocationPatient.getData()).getValue();
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        List patientList = this.patientMapper.selectList((Wrapper)Wrappers.lambdaQuery().gt(PatientEntity::getId, (Object)maxPatientId));
        String[] split = value.split(",");
        ArrayList<OutCustomerServiceSettingsEntity> saveList = new ArrayList<OutCustomerServiceSettingsEntity>();
        for (int i = 0; i < patientList.size(); ++i) {
            OutCustomerServiceSettingsEntity param = new OutCustomerServiceSettingsEntity();
            PatientEntity patient = (PatientEntity)patientList.get(i);
            String userIdStr = split[i % 3];
            param.setUserId(Integer.valueOf(Integer.parseInt(userIdStr)));
            param.setPatientId(patient.getId());
            param.setChangeRecord(userIdStr);
            param.setUpdateTime(timeStr);
            param.setTenantId(Integer.valueOf(1));
            param.setEnable(Integer.valueOf(1));
            param.setSwitchs(Integer.valueOf(1));
            saveList.add(param);
            System.out.println("userId===============>" + userIdStr);
        }
        List lists = FollowUpTask.splitIntoFixedSizeLists(saveList, (int)1000);
        for (int i = 0; i < lists.size(); ++i) {
            try {
                this.customerServiceSettingsMapper.batchSave((List)lists.get(i));
                continue;
            }
            catch (Exception e) {
                log.info("\u5728\u5206\u914d\u7b2c{}\u7ec4\u5ba2\u670d\u65f6\u62a5\u9519\uff0c\u603b\u5171{}\u7ec4\u5ba2\u670d", (Object)i, (Object)lists.size());
            }
        }
        log.info("=========================\u5206\u914d\u5ba2\u670d\u7ed3\u675f========================");
    }

    public static <T> List<List<T>> splitIntoFixedSizeLists(List<T> sourceList, int chunkSize) {
        if (CollectionUtils.isEmpty(sourceList) || chunkSize <= 0) {
            return new ArrayList<List<T>>();
        }
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        int totalSize = sourceList.size();
        for (int i = 0; i < totalSize; i += chunkSize) {
            List<T> subList = sourceList.subList(i, Math.min(i + chunkSize, totalSize));
            result.add(new ArrayList<T>(subList));
        }
        return result;
    }

    @Scheduled(cron="0 0 2 * * ?")
    public void createTask() throws ParseException {
        System.out.println("============================================================\u5f00\u59cb\u751f\u6210\u4efb\u52a1");
        log.info("=========================FollowUpTask\u5f00\u59cb\u751f\u6210\u4efb\u52a1========================");
        String localHostIp = this.getLocalHostIp();
        if (!"172.24.154.1".equals(localHostIp)) {
            log.info("\u670d\u52a1ip\u4e0d\u5bf9\uff0cip\u5730\u5740============>{}", (Object)localHostIp);
            return;
        }
        ArrayList list = new ArrayList();
        this.checkByLast(list);
        if (list.size() > 0) {
            this.tasksMapper.createTask(list);
        }
        log.info("=========================FollowUpTask\u7ed3\u675f\u751f\u6210\u4efb\u52a1========================");
    }

    private String getLocalHostIp() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            throw new BusinessException("\u5b9a\u65f6\u751f\u6210\u590d\u8bca\u56de\u8bbf\u4efb\u52a1\u65f6\uff0c\u83b7\u53d6\u672c\u5730IP\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    private void checkByLast(List<OutFollowUpTasksEntity> list) throws ParseException {
        Integer tenant = 1;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String timeStr = format.format(new Date());
        Calendar calendar = Calendar.getInstance();
        Date nowDay = format.parse(timeStr);
        List taskByPatientVos = this.tasksMapper.queryDispenseDateByTaskLast();
        for (TaskByPatientVo taskByPatientVo : taskByPatientVos) {
            Integer userId = null;
            Integer patientId = null;
            Integer beforeEnd = taskByPatientVo.getBeforeEnd();
            Integer afterEnd = taskByPatientVo.getAfterEnd();
            Integer afterEndOver = taskByPatientVo.getAfterEndOver();
            OutFollowUpTasksEntity entity = new OutFollowUpTasksEntity();
            for (TaskByDrugVo drugVo : taskByPatientVo.getDrugVos()) {
                List dispenseList = drugVo.getDispenseList();
                String dispenseDate = null;
                String followUpDate = null;
                Integer medicationDays = 0;
                String opdId = null;
                String outpatientNo = null;
                String remark = null;
                for (int i = 0; i < dispenseList.size(); ++i) {
                    long followUpDateL;
                    TaskByDispense taskByDispense = (TaskByDispense)dispenseList.get(i);
                    opdId = taskByDispense.getOpdId();
                    outpatientNo = taskByDispense.getOutpatientNo();
                    String voDispenseDateTime = taskByDispense.getDispenseDateTime();
                    String voFollowUpDate = taskByDispense.getFollowUpDate();
                    if (dispenseDate == null) {
                        dispenseDate = voDispenseDateTime;
                        medicationDays = medicationDays + taskByDispense.getMedicationDays();
                        followUpDate = voFollowUpDate.substring(0, 10);
                        continue;
                    }
                    long dspenseDateL = format.parse(dispenseDate).getTime();
                    if (dspenseDateL > (followUpDateL = format.parse(voFollowUpDate).getTime())) break;
                    medicationDays = medicationDays + taskByDispense.getMedicationDays();
                    dispenseDate = voDispenseDateTime;
                    calendar.setTime(format.parse(voDispenseDateTime));
                    calendar.add(5, medicationDays);
                    followUpDate = format.format(calendar.getTime());
                    remark = "\u6b64\u836f\u6709" + (i + 1) + "\u6761\u6570\u636e\u5728\u7528\u836f\u65f6\u95f4\u7ed3\u675f\u524d\u518d\u6b21\u8d2d\u836f\uff0c\u5df2\u6839\u636e\u7528\u836f\u5929\u6570\u5185\u91cd\u5408\u7684\u65f6\u95f4\u7d2f\u52a0\u8ba1\u7b97\u7528\u836f\u7ed3\u675f\u65f6\u95f4";
                }
                if (medicationDays <= entity.getMedicationDays()) continue;
                Integer type = null;
                userId = taskByPatientVo.getUserId();
                patientId = taskByPatientVo.getPatientId();
                entity.setFollowType(type);
                entity.setCreateTime(timeStr);
                entity.setStatus(Integer.valueOf(1));
                entity.setUserId(userId);
                entity.setPatientId(patientId);
                entity.setTenantId(tenant);
                entity.setDrugName(drugVo.getDrugName());
                entity.setOpdId(opdId);
                entity.setOutpatientNo(outpatientNo);
                entity.setFollowUpDate(followUpDate);
                entity.setMedicationDays(medicationDays);
                if (StringUtils.isNotBlank(remark)) {
                    entity.setRemark(remark);
                }
                if (!StringUtils.isNotBlank((CharSequence)followUpDate)) continue;
                calendar.setTime(format.parse(followUpDate));
                Date followUpDateTime = calendar.getTime();
                calendar.add(5, -afterEndOver.intValue());
                long l = calendar.getTime().getTime() - nowDay.getTime();
                if (l > 0L) continue;
                calendar.setTime(nowDay);
                calendar.add(5, beforeEnd);
                if (calendar.getTime().getTime() - followUpDateTime.getTime() == 0L) {
                    type = 1;
                }
                calendar.setTime(nowDay);
                calendar.add(5, -afterEnd.intValue());
                if (calendar.getTime().getTime() - followUpDateTime.getTime() == 0L) {
                    type = 2;
                }
                if (type == null) continue;
                entity.setFollowType(type);
            }
            if (entity.getFollowType() == null) continue;
            list.add(entity);
        }
    }

    private void checkByTotal(List<OutFollowUpTasksEntity> list) throws ParseException {
        Integer tenant = 1;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String timeStr = format.format(new Date());
        Calendar calendar = Calendar.getInstance();
        Date nowDay = format.parse(timeStr);
        List taskByPatientVos = this.tasksMapper.queryDispenseDateByTask();
        block0: for (TaskByPatientVo taskByPatientVo : taskByPatientVos) {
            Integer userId = null;
            Integer patientId = null;
            Integer beforeEnd = taskByPatientVo.getBeforeEnd();
            Integer afterEnd = taskByPatientVo.getAfterEnd();
            Integer afterEndOver = taskByPatientVo.getAfterEndOver();
            for (TaskByDrugVo drugVo : taskByPatientVo.getDrugVos()) {
                List dispenseList = drugVo.getDispenseList();
                String dispenseDate = null;
                String followUpDate = null;
                Integer medicationDays = 0;
                String opdId = null;
                String outpatientNo = null;
                String remark = null;
                for (int i = 0; i < dispenseList.size(); ++i) {
                    long followUpDateL;
                    TaskByDispense taskByDispense = (TaskByDispense)dispenseList.get(i);
                    opdId = taskByDispense.getOpdId();
                    outpatientNo = taskByDispense.getOutpatientNo();
                    String voDispenseDateTime = taskByDispense.getDispenseDateTime();
                    String voFollowUpDate = taskByDispense.getFollowUpDate();
                    if (dispenseDate == null) {
                        dispenseDate = voDispenseDateTime;
                        followUpDate = voFollowUpDate.substring(0, 10);
                        continue;
                    }
                    long dspenseDateL = format.parse(dispenseDate).getTime();
                    if (dspenseDateL > (followUpDateL = format.parse(voFollowUpDate).getTime())) break;
                    medicationDays = medicationDays + taskByDispense.getMedicationDays();
                    dispenseDate = voDispenseDateTime;
                    calendar.setTime(format.parse(voDispenseDateTime));
                    calendar.add(5, medicationDays);
                    followUpDate = format.format(calendar.getTime());
                    remark = "\u6b64\u836f\u6709" + (i + 1) + "\u6761\u6570\u636e\u5728\u7528\u836f\u65f6\u95f4\u7ed3\u675f\u524d\u518d\u6b21\u8d2d\u836f\uff0c\u5df2\u6839\u636e\u7528\u836f\u5929\u6570\u5185\u91cd\u5408\u7684\u65f6\u95f4\u7d2f\u52a0\u8ba1\u7b97\u7528\u836f\u7ed3\u675f\u65f6\u95f4";
                }
                if (!StringUtils.isNotBlank(followUpDate)) continue;
                calendar.setTime(format.parse(followUpDate));
                Date followUpDateTime = calendar.getTime();
                calendar.add(5, -afterEndOver.intValue());
                long l = calendar.getTime().getTime() - nowDay.getTime();
                if (l > 0L) continue;
                Integer type = null;
                calendar.setTime(nowDay);
                calendar.add(5, beforeEnd);
                if (calendar.getTime().getTime() - followUpDateTime.getTime() == 0L) {
                    type = 1;
                }
                calendar.setTime(nowDay);
                calendar.add(5, -afterEnd.intValue());
                if (calendar.getTime().getTime() - followUpDateTime.getTime() == 0L) {
                    type = 2;
                }
                if (type == null) continue;
                userId = taskByPatientVo.getUserId();
                patientId = taskByPatientVo.getPatientId();
                OutFollowUpTasksEntity entity = new OutFollowUpTasksEntity();
                entity.setFollowType(type);
                entity.setCreateTime(timeStr);
                entity.setStatus(Integer.valueOf(1));
                entity.setUserId(userId);
                entity.setPatientId(patientId);
                entity.setTenantId(tenant);
                entity.setDrugName(drugVo.getDrugName());
                entity.setOpdId(opdId);
                entity.setOutpatientNo(outpatientNo);
                entity.setFollowUpDate(followUpDate);
                if (StringUtils.isNotBlank((CharSequence)remark)) {
                    entity.setRemark(remark);
                }
                list.add(entity);
                continue block0;
            }
        }
    }
}

