/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import com.byh.outpatient.api.dto.QueryOutpatientTypeDto;
import com.byh.outpatient.api.model.outpatienType.OutpatientTypeEntity;
import com.byh.outpatient.api.model.schedule.ScheduleRecordEntity;
import com.byh.outpatient.api.util.PageResult;
import com.byh.outpatient.api.util.RandomCodeUtils;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.data.repository.OutpatientTypeMapper;
import com.byh.outpatient.data.repository.ScheduleRecordMapper;
import com.byh.outpatient.web.service.OutpatientTypeService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OutpatientTypeServiceImpl
implements OutpatientTypeService {
    @Autowired
    private OutpatientTypeMapper outpatientTypeMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;

    public List<OutpatientTypeEntity> selectListByDeptId(QueryOutpatientTypeDto dto) {
        List list = this.outpatientTypeMapper.selectListByDeptId(dto);
        list.forEach(entity -> {
            String typeName = entity.getOutpatientTypeName() + "\uff08" + entity.getRegFee().stripTrailingZeros().toPlainString() + " \u5143\uff09";
            entity.setTypeName(typeName);
        });
        return list;
    }

    public ResponseData insert(OutpatientTypeEntity outpatientType) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("outpatient_type_name", outpatientType.getOutpatientTypeName());
        List outpatientTypeEntityList = this.outpatientTypeMapper.selectByMap(map);
        if (outpatientTypeEntityList.size() > 0) {
            return ResponseData.error((String)"\u95e8\u8bca\u7c7b\u578b\u540d\u5b57\u91cd\u590d\uff01");
        }
        outpatientType.setOutpatientType(RandomCodeUtils.sixRandom());
        if (this.outpatientTypeMapper.insert((Object)outpatientType) > 0) {
            return ResponseData.success();
        }
        return ResponseData.error((String)"\u65b0\u589e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\uff01");
    }

    public ResponseData updateById(OutpatientTypeEntity outpatientType) {
        if (this.outpatientTypeMapper.updateById(outpatientType) > 0) {
            return ResponseData.success();
        }
        return ResponseData.error((String)"\u4fee\u6539\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\uff01");
    }

    public ResponseData<OutpatientTypeEntity> queryById(Integer id) {
        OutpatientTypeEntity outpatientTypeEntity = (OutpatientTypeEntity)this.outpatientTypeMapper.selectById((Serializable)id);
        if (Objects.isNull(outpatientTypeEntity)) {
            return ResponseData.error((String)"\u67e5\u8be2\u4e3a\u7a7a\uff01");
        }
        return ResponseData.success((Object)outpatientTypeEntity);
    }

    public ResponseData updateStatus(Integer id, String status) {
        if ("0".equals(status)) {
            OutpatientTypeEntity outpatientTypeEntity = (OutpatientTypeEntity)this.outpatientTypeMapper.selectById((Serializable)id);
            ScheduleRecordEntity scheduleRecordEntity = new ScheduleRecordEntity();
            scheduleRecordEntity.setOutpatientType(outpatientTypeEntity.getOutpatientType());
            Integer integer = this.scheduleRecordMapper.checkSchedule(scheduleRecordEntity);
            if (integer > 0) {
                ResponseData.error((String)"\u95e8\u8bca\u7c7b\u578b\u6709\u6392\u73ed\uff0c\u4e0d\u80fd\u5220\u9664");
            }
        }
        OutpatientTypeEntity outpatientType = new OutpatientTypeEntity();
        outpatientType.setId(id);
        outpatientType.setStatus(status);
        if (this.outpatientTypeMapper.updateById(outpatientType) > 0) {
            return ResponseData.success();
        }
        return ResponseData.error((String)"\u4fee\u6539\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\uff01");
    }

    public ResponseData<PageResult<OutpatientTypeEntity>> queryOutpatientType(QueryOutpatientTypeDto queryOutpatientTypeDto) {
        PageHelper.startPage((int)queryOutpatientTypeDto.getCurrent(), (int)queryOutpatientTypeDto.getSize());
        List outpatientTypeList = this.outpatientTypeMapper.queryOutpatientType(queryOutpatientTypeDto);
        PageInfo pageInfo = new PageInfo(outpatientTypeList);
        PageResult pageResult = new PageResult(queryOutpatientTypeDto.getCurrent().intValue(), queryOutpatientTypeDto.getSize().intValue());
        pageResult.setTotal(Integer.parseInt(String.valueOf(pageInfo.getTotal())));
        pageResult.setPages(pageInfo.getPages());
        pageResult.setRecords(outpatientTypeList);
        pageResult.setCurrent(queryOutpatientTypeDto.getCurrent().intValue());
        pageResult.setSize(queryOutpatientTypeDto.getSize().intValue());
        return ResponseData.success((Object)pageResult);
    }

    public ResponseData<List<OutpatientTypeEntity>> queryOutpatientTypeByName(QueryOutpatientTypeDto queryOutpatientTypeDto) {
        queryOutpatientTypeDto.setStatus(Integer.valueOf(1));
        List outpatientTypeList = this.outpatientTypeMapper.queryOutpatientTypeByName(queryOutpatientTypeDto);
        return ResponseData.success((Object)outpatientTypeList);
    }

    public ResponseData<OutpatientTypeEntity> queryOutpatientTypeByType(String outpatientType, Integer tenantId) {
        OutpatientTypeEntity outpatientTypeEntity = this.outpatientTypeMapper.queryOutpatientTypeByType(outpatientType, tenantId);
        return ResponseData.success((Object)outpatientTypeEntity);
    }
}

