/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.byh.outpatient.api.dto.lisResult.QueryLisResultDto;
import com.byh.outpatient.api.dto.lisResult.QueryTreatmentItemDto;
import com.byh.outpatient.api.model.lisResult.OutLisResultEntity;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.web.aspect.UserOptLogger;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.OutLisResultService;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/lisResult"})
public class OutLisResultController {
    @Autowired
    private CommonRequest commonRequest;
    @Autowired
    private OutLisResultService outLisResultService;

    @ApiOperation(value="\u6839\u636eHIS\u7533\u8bf7\u5355\u53f7\u67e5\u8be2\u5bf9\u5e94\u7684\u68c0\u9a8c\u7ed3\u679c")
    @PostMapping(value={"/selectListResultList"})
    @UserOptLogger(operation="\u6839\u636eHIS\u7533\u8bf7\u5355\u53f7\u67e5\u8be2\u5bf9\u5e94\u7684\u68c0\u9a8c\u7ed3\u679c")
    public ResponseData selectListResultList(@RequestBody @Valid QueryLisResultDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setCreateId(this.commonRequest.getUserId());
        dto.setCreateName(this.commonRequest.getUserName());
        OutLisResultEntity lisResult = this.outLisResultService.selectListResultList(dto);
        if (lisResult == null) {
            return ResponseData.success(new ArrayList());
        }
        return ResponseData.success((Object)lisResult);
    }

    @ApiOperation(value="\u83b7\u53d6\u60a3\u8005\u6240\u6709\u7684\u68c0\u9a8c\u9879\u76ee\u8bb0\u5f55")
    @PostMapping(value={"/getOutLisTreatmentItemList"})
    public ResponseData getOutLisTreatmentItemList(@RequestBody @Valid QueryTreatmentItemDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setUserId(this.commonRequest.getUserId());
        dto.setUserName(this.commonRequest.getUserName());
        return ResponseData.success((Object)this.outLisResultService.getOutLisTreatmentItemList(dto));
    }

    @ApiOperation(value="\u6839\u636e\u60a3\u8005id\u67e5\u8be2\u68c0\u9a8c\u9879\u76ee\u548c\u7ed3\u679c\u660e\u7ec6")
    @PostMapping(value={"/queryOutListResultDetails"})
    public ResponseData queryOutListResultDetails(@RequestBody @Valid QueryTreatmentItemDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.outLisResultService.queryOutListResultDetails(dto));
    }

    @ApiOperation(value="test")
    @PostMapping(value={"/test"})
    public ResponseData test() {
        this.outLisResultService.test();
        return ResponseData.success();
    }
}

