/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.outpatient.api.dto.ArchivalFileDto;
import com.byh.outpatient.api.model.ArchivalFileEntity;
import com.byh.outpatient.api.model.ArchivalFileTypeEntity;
import com.byh.outpatient.api.model.ArchivalRecordsDto;
import com.byh.outpatient.api.model.ArchivalRecordsEntity;
import com.byh.outpatient.api.sysModel.request.SysDictValueDTO;
import com.byh.outpatient.api.sysModel.respones.SysDictValueVo;
import com.byh.outpatient.api.util.BeanUtil;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.UUIDUtils;
import com.byh.outpatient.api.vo.ArchivalFileTypeVo;
import com.byh.outpatient.api.vo.ArchivalRecordsVo;
import com.byh.outpatient.data.repository.ArchivalFileMapper;
import com.byh.outpatient.data.repository.ArchivalRecordsMapper;
import com.byh.outpatient.web.feign.SysServiceFeign;
import com.byh.outpatient.web.mvc.controller.RocketMQProducerController;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.rocket.RocketMQProducer;
import com.byh.outpatient.web.service.ArchivalFileService;
import com.byh.outpatient.web.service.ArchivalFileTypeService;
import com.byh.outpatient.web.service.ArchivalRecordsService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.SendCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArchivalRecordsServiceImpl
implements ArchivalRecordsService {
    @Autowired
    private ArchivalRecordsMapper mapper;
    @Autowired
    private ArchivalFileMapper archivalFileMapper;
    @Autowired
    private ArchivalFileTypeService fileTypeService;
    @Autowired
    private ArchivalFileTypeService ArchivalFileTypeService;
    @Autowired
    private ArchivalFileService fileService;
    @Autowired
    private SysServiceFeign sysServiceFeign;
    private static final Logger logger = LoggerFactory.getLogger(RocketMQProducerController.class);
    private static final String archivalFileTopic = "rocketMQ-out-archivalFileTopic";
    private final CommonRequest commonRequest;
    private final RocketMQProducer rocketMQProducer;

    public ResponseData<List<ArchivalRecordsVo>> save(ArchivalRecordsEntity entity) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        entity.setCreateTime(format.format(new Date()));
        String visitingHospital = entity.getVisitingHospital();
        String visitingTime = entity.getVisitingTime();
        String diagnosis = entity.getDiagnosis();
        if (StringUtils.isBlank((CharSequence)visitingHospital)) {
            visitingHospital = "\u672a\u77e5";
        }
        if (StringUtils.isBlank((CharSequence)visitingTime)) {
            visitingTime = "\u672a\u77e5";
        }
        if (StringUtils.isBlank((CharSequence)diagnosis)) {
            diagnosis = "\u672a\u77e5";
        }
        entity.setVisitingTime(visitingTime);
        entity.setDiagnosis(diagnosis);
        entity.setVisitingHospital(visitingHospital);
        this.mapper.insert((Object)entity);
        int arId = 1;
        List archivalRecordsEntities = this.mapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ArchivalRecordsEntity::getVisitingTime, (Object)entity.getVisitingTime())).eq(ArchivalRecordsEntity::getDiagnosis, (Object)entity.getDiagnosis())).eq(ArchivalRecordsEntity::getVisitingHospital, (Object)entity.getVisitingHospital())).eq(ArchivalRecordsEntity::getPatientId, (Object)entity.getPatientId())).orderByDesc(ArchivalRecordsEntity::getId));
        if (archivalRecordsEntities.size() != 0) {
            arId = ((ArchivalRecordsEntity)archivalRecordsEntities.get(0)).getId().intValue();
            try {
                List list = BeanUtil.copyList((List)archivalRecordsEntities, ArchivalRecordsDto.class);
                String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
                String msg = JSONObject.toJSONString((Object)list);
                this.rocketMQProducer.asyncSendCallbackTimeoutLevel(archivalFileTopic, "TAG8", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int count = 1;
        SysDictValueDTO sysDictValueDTO = new SysDictValueDTO();
        sysDictValueDTO.setType("archival_file_type");
        ResponseData pageResponseData = this.sysServiceFeign.sysDictValueById(sysDictValueDTO, entity.getTenantId() + "");
        List data = ((Page)pageResponseData.getData()).getRecords();
        for (SysDictValueVo datum : data) {
            List files;
            ArchivalFileTypeEntity archivalFileTypeEntity = new ArchivalFileTypeEntity();
            String label = datum.getLabel();
            archivalFileTypeEntity.setTenantId(entity.getTenantId());
            archivalFileTypeEntity.setArchivalRecordsId(Integer.valueOf(arId));
            archivalFileTypeEntity.setTypeName(label);
            Integer save = this.ArchivalFileTypeService.save(archivalFileTypeEntity);
            if (save <= 0 || (files = entity.getFiles()) == null || files.size() <= 0) continue;
            for (ArchivalFileDto dto : files) {
                String typeName = dto.getTypeName();
                if (!typeName.equals(label)) continue;
                List urlList = dto.getUrlList();
                for (int i = 0; i < urlList.size(); ++i) {
                    String url = (String)urlList.get(i);
                    String substring = url.substring(url.lastIndexOf("."), url.length());
                    ArchivalFileEntity archivalFile = new ArchivalFileEntity();
                    archivalFile.setSort("0");
                    archivalFile.setTenantId(entity.getTenantId());
                    archivalFile.setUrl(url);
                    archivalFile.setCreateTime(format.format(new Date()));
                    archivalFile.setIsDel("0");
                    archivalFile.setName("name" + substring);
                    archivalFile.setFileTypeId(Integer.valueOf(archivalFileTypeEntity.getId().intValue()));
                    int insert = this.archivalFileMapper.insert((Object)archivalFile);
                    if (insert <= 0) continue;
                    System.out.println("\u5ba1\u6279\u6279\u91cf\u65b0\u589e============\u65b0\u589e\u65f6\u95f4\uff1a" + format.format(new Date()) + "===============\u6587\u4ef6\u5e8f\u53f7:" + count + "=============\u6587\u4ef6\u7c7b\u578b\uff1a" + label + "==============\u6587\u4ef6url\uff1a" + url);
                    ++count;
                }
            }
        }
        return this.pageList(entity);
    }

    public Integer del(ArchivalRecordsEntity entity) {
        int i = this.mapper.deleteById((Serializable)entity.getId());
        if (i > 0) {
            try {
                ArrayList<ArchivalRecordsDto> list = new ArrayList<ArchivalRecordsDto>();
                ArchivalRecordsDto dto = new ArchivalRecordsDto();
                dto.setId(entity.getId());
                list.add(dto);
                String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
                String msg = JSONObject.toJSONString(list);
                this.rocketMQProducer.asyncSendCallbackTimeoutLevel(archivalFileTopic, "TAG8", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return i;
    }

    public Integer update(ArchivalRecordsEntity entity) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        entity.setUpdateTime(format.format(new Date()));
        List archivalRecordsEntities = this.mapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ArchivalRecordsEntity::getVisitingTime, (Object)entity.getVisitingTime())).eq(ArchivalRecordsEntity::getDiagnosis, (Object)entity.getDiagnosis())).eq(ArchivalRecordsEntity::getVisitingHospital, (Object)entity.getVisitingHospital())).eq(ArchivalRecordsEntity::getPatientId, (Object)entity.getPatientId())).orderByDesc(ArchivalRecordsEntity::getId));
        try {
            ArrayList<ArchivalRecordsDto> list = new ArrayList<ArchivalRecordsDto>();
            ArchivalRecordsDto dto = new ArchivalRecordsDto();
            BeanUtils.copyProperties((Object)entity, (Object)dto);
            list.add(dto);
            String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
            String msg = JSONObject.toJSONString(list);
            this.rocketMQProducer.asyncSendCallbackTimeoutLevel(archivalFileTopic, "TAG8", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.mapper.updateById((Object)entity);
    }

    public ResponseData<List<ArchivalRecordsVo>> pageList(ArchivalRecordsEntity entity) {
        Long id1 = entity.getId();
        if (id1 != null) {
            entity.setIdStr(entity.getId() + "");
        }
        List archivalRecordsEntities = this.mapper.selectListByPatientId2(entity);
        List collect = archivalRecordsEntities.stream().map(record -> {
            ArchivalRecordsVo archivalRecordsVo = new ArchivalRecordsVo();
            BeanUtils.copyProperties((Object)record, (Object)archivalRecordsVo);
            Long id = archivalRecordsVo.getId();
            ArchivalFileTypeEntity archivalFileTypeEntity = new ArchivalFileTypeEntity();
            archivalFileTypeEntity.setArchivalRecordsId(Integer.valueOf(id.intValue()));
            archivalFileTypeEntity.setTenantId(entity.getTenantId());
            ResponseData responseData = this.fileTypeService.pageList(archivalFileTypeEntity);
            List archivalFileTypeEntityList = (List)responseData.getData();
            List archivalFileTypeVoStream = archivalFileTypeEntityList.stream().map(archivalFileType -> {
                Long typeId = archivalFileType.getId();
                ArchivalFileEntity fileEntity = new ArchivalFileEntity();
                fileEntity.setFileTypeId(Integer.valueOf(typeId.intValue()));
                fileEntity.setTenantId(entity.getTenantId());
                ResponseData responseData1 = this.fileService.pageList(fileEntity);
                List fileList = (List)responseData1.getData();
                ArchivalFileTypeVo archivalFileTypeVo = new ArchivalFileTypeVo();
                BeanUtils.copyProperties((Object)archivalFileType, (Object)archivalFileTypeVo);
                archivalFileTypeVo.setFiles(fileList);
                return archivalFileTypeVo;
            }).collect(Collectors.toList());
            archivalRecordsVo.setFileTypes(archivalFileTypeVoStream);
            return archivalRecordsVo;
        }).collect(Collectors.toList());
        return ResponseData.success(collect);
    }

    public ResponseData searchOne(ArchivalRecordsEntity entity) {
        return null;
    }

    public ArchivalRecordsServiceImpl(CommonRequest commonRequest, RocketMQProducer rocketMQProducer) {
        this.commonRequest = commonRequest;
        this.rocketMQProducer = rocketMQProducer;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

