/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.byh.outpatient.api.dto.ArchivalFileDto;
import com.byh.outpatient.api.model.ArchivalFileEntity;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.web.aspect.AntiRefresh;
import com.byh.outpatient.web.mvc.controller.MinioFileController;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.ArchivalFileService;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/archivalFile"})
public class ArchivalFileController {
    @Autowired
    private ArchivalFileService ArchivalFileService;
    @Autowired
    private CommonRequest commonRequest;
    @Autowired
    private MinioFileController minioFileController;

    @ApiOperation(value="\u6839\u636e\u7c7b\u578bid\u67e5\u8be2\u6587\u4ef6")
    @GetMapping(value={"/pageList"})
    @AntiRefresh
    public ResponseData<List<ArchivalFileEntity>> pageList(@RequestBody ArchivalFileEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        Integer fileTypeId = entity.getFileTypeId();
        if (fileTypeId == null) {
            return ResponseData.error((String)"\u7c7b\u578bid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return ResponseData.success((Object)this.ArchivalFileService.pageList(entity));
    }

    @ApiOperation(value="\u6839\u636e\u6587\u4ef6\u7c7b\u578bid\u4fdd\u5b58\u6863\u6848\u6587\u4ef6")
    @PostMapping(value={"/save"})
    @AntiRefresh
    public ResponseData save(HttpServletResponse response, @RequestBody ArchivalFileDto dto) {
        Integer tenant = this.commonRequest.getTenant();
        dto.setTenantId(tenant);
        Long save = this.ArchivalFileService.save(dto);
        return ResponseData.success((Object)save);
    }

    @ApiOperation(value="\u6839\u636e\u6587\u4ef6\u7c7b\u578bid\u6279\u91cf\u4fdd\u5b58\u6863\u6848\u6587\u4ef6")
    @PostMapping(value={"/batchSave"})
    public ResponseData batchSave(HttpServletResponse response, @RequestBody ArchivalFileDto dto) {
        Integer tenant = this.commonRequest.getTenant();
        dto.setTenantId(tenant);
        this.ArchivalFileService.batchSave(dto);
        return ResponseData.success((Object)"success");
    }

    @ApiOperation(value="\u5220\u9664\u6587\u4ef6\u7c7b\u578b")
    @PostMapping(value={"/del"})
    @AntiRefresh
    public ResponseData del(HttpServletResponse response, @RequestBody ArchivalFileEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        this.ArchivalFileService.del(entity);
        return ResponseData.success();
    }

    @ApiOperation(value="\u66f4\u65b0\u6587\u4ef6\u7684\u6587\u4ef6\u7c7b\u578b")
    @PostMapping(value={"/updateFileType"})
    @AntiRefresh
    public ResponseData updateFileType(HttpServletResponse response, @RequestBody List<ArchivalFileDto> dto) {
        Integer tenant = this.commonRequest.getTenant();
        this.ArchivalFileService.updateFileType(dto);
        return ResponseData.success();
    }
}

