/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.outpatient.api.dto.OutDrugDeliveryDto;
import com.byh.outpatient.api.model.OutDrugDeliveryEntity;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.web.aspect.UserOptLogger;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.OutDrugDeliveryService;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/outDrugDelivery"})
public class OutDrugDeliveryController {
    @Autowired
    private CommonRequest commonRequest;
    @Autowired
    private OutDrugDeliveryService outDrugDeliveryService;

    @UserOptLogger(operation="\u4fee\u6539\u836f\u54c1\u914d\u9001\u4fe1\u606f")
    @ApiOperation(value="\u4fee\u6539\u836f\u54c1\u914d\u9001\u4fe1\u606f")
    @PostMapping(value={"/update"})
    public ResponseData update(@RequestBody OutDrugDeliveryEntity entity) {
        entity.setCreateId(this.commonRequest.getUserId());
        entity.setCreateName(this.commonRequest.getUserName());
        this.outDrugDeliveryService.update(entity);
        return ResponseData.success((Object)"\u4fee\u6539\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u5bfc\u51fa\u836f\u54c1\u914d\u9001\u4fe1\u606f")
    @PostMapping(value={"/exportDrugDeliveryList"})
    public void exportDrugDeliveryList(HttpServletResponse response, @RequestBody OutDrugDeliveryDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.outDrugDeliveryService.exportDrugDeliveryList(response, dto);
    }

    @ApiOperation(value="\u83b7\u53d6\u751f\u4ea7\u5382\u5546\u5217\u8868\u540d\u79f0")
    @PostMapping(value={"/getManufacturerByGroup"})
    public ResponseData getManufacturerByGroup() {
        return ResponseData.success((Object)this.outDrugDeliveryService.getManufacturerByGroup(this.commonRequest.getTenant()));
    }

    @ApiOperation(value="\u67e5\u8be2\u836f\u54c1\u914d\u9001\u5206\u9875\u5217\u8868\u4fe1\u606f")
    @PostMapping(value={"/selectPageList"})
    public ResponseData selectPageList(@RequestBody OutDrugDeliveryDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        Page page = this.outDrugDeliveryService.selectPageList(dto);
        return ResponseData.success((Object)page);
    }

    @UserOptLogger(operation="\u91c7\u96c6\u6307\u5b9a\u65f6\u95f4\u8303\u56f4\u5185\u7684\u836f\u54c1\u914d\u9001\u4fe1\u606f")
    @ApiOperation(value="\u91c7\u96c6\u6307\u5b9a\u65f6\u95f4\u8303\u56f4\u5185\u7684\u836f\u54c1\u914d\u9001\u4fe1\u606f")
    @PostMapping(value={"/getOutDrugDeliveryList"})
    public ResponseData getOutDrugDeliveryList(@RequestBody OutDrugDeliveryDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setCreateId(this.commonRequest.getUserId());
        dto.setCreateName(this.commonRequest.getUserName());
        this.outDrugDeliveryService.getOutDrugDeliveryList(dto);
        return ResponseData.success((Object)"\u91c7\u96c6\u6210\u529f");
    }
}

