/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.outpatient.api.model.OutEtubePatientInfoEntity;
import com.byh.outpatient.api.model.OutEtubeStudioPatientEntity;
import com.byh.outpatient.api.model.OutEtubeStudioPatientTagEntity;
import com.byh.outpatient.api.model.patient.PatientEntity;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.StringUtil;
import com.byh.outpatient.data.repository.OutEtubeStudioPatientMapper;
import com.byh.outpatient.data.repository.OutEtubeStudioPatientTagMapper;
import com.byh.outpatient.data.repository.PatientMapper;
import com.byh.outpatient.web.service.OutEtubePatientInfoService;
import com.byh.outpatient.web.service.OutEtubeStudioPatientService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OutEtubeStudioPatientServiceImpl
implements OutEtubeStudioPatientService {
    @Autowired
    private OutEtubeStudioPatientMapper studioPatientMapper;
    @Autowired
    private OutEtubePatientInfoService outEtubePatientInfoService;
    @Autowired
    private OutEtubeStudioPatientTagMapper outEtubeStudioPatientTagMapper;
    @Autowired
    private PatientMapper patientMapper;

    public ResponseData<PageInfo<PatientEntity>> queryPatientByStudio(OutEtubeStudioPatientEntity entity) {
        PageHelper.startPage((int)entity.getCurrent(), (int)entity.getSize());
        List list = this.studioPatientMapper.queryPatientListByStudio(entity);
        for (PatientEntity patient : list) {
            OutEtubePatientInfoEntity param = new OutEtubePatientInfoEntity();
            param.setPatientId(patient.getId());
            param.setTenantId(Integer.valueOf(1));
            param.setSize(Integer.valueOf(999999));
            long startTime = new Date().getTime();
            startTime = new Date().getTime();
            List list2 = this.outEtubePatientInfoService.queryDiagnosisByPatient(param);
            patient.setDiagnosis(list2);
            System.out.println("\u65f6\u95f42==================>" + (startTime - new Date().getTime()));
        }
        PageInfo page = new PageInfo(list);
        return ResponseData.success((Object)page);
    }

    public ResponseData<List<OutEtubeStudioPatientTagEntity>> queryTag(OutEtubeStudioPatientTagEntity entity) {
        Integer patientId = entity.getPatientId();
        if (patientId == null) {
            return ResponseData.error((String)"\u60a3\u8005id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List list = this.outEtubeStudioPatientTagMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutEtubeStudioPatientTagEntity::getPatientId, (Object)patientId)).eq(OutEtubeStudioPatientTagEntity::getDelFlag, (Object)"0"));
        return ResponseData.success((Object)list);
    }

    public ResponseData delTag(OutEtubeStudioPatientTagEntity entity) {
        Integer id = entity.getId();
        if (id == null) {
            return ResponseData.error((String)"id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        entity.setDelFlag("1");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        entity.setDelTime(format.format(new Date()));
        int i = this.outEtubeStudioPatientTagMapper.updateById((Object)entity);
        if (i != 1) {
            return ResponseData.error((String)"\u5220\u9664\u5931\u8d25\uff01");
        }
        return ResponseData.error((String)"\u5220\u9664\u5931\u8d25\uff01").delete();
    }

    public ResponseData addTag(OutEtubeStudioPatientTagEntity entity) {
        Integer patientId = entity.getPatientId();
        if (patientId == null) {
            return ResponseData.error((String)"\u60a3\u8005id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String tagName = entity.getTagName();
        if (StringUtil.isBlank((String)tagName)) {
            return ResponseData.error((String)"\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        entity.setCreateTime(format.format(new Date()));
        int insert = this.outEtubeStudioPatientTagMapper.insert((Object)entity);
        if (insert != 1) {
            return ResponseData.error((String)"\u6dfb\u52a0\u5931\u8d25\uff01");
        }
        return ResponseData.success().save();
    }

    public ResponseData removePatient(OutEtubeStudioPatientEntity entity) {
        int delete = this.studioPatientMapper.delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutEtubeStudioPatientEntity::getPatientId, (Object)entity.getPatientId())).eq(OutEtubeStudioPatientEntity::getStudioCode, (Object)entity.getStudioCode()));
        if (delete == 0) {
            return ResponseData.error((String)"\u64cd\u4f5c\u5931\u8d25!");
        }
        PatientEntity patient = new PatientEntity();
        patient.setEtubePushType(Integer.valueOf(0));
        int update = this.patientMapper.update((Object)patient, (Wrapper)Wrappers.lambdaUpdate().eq(PatientEntity::getId, (Object)entity.getPatientId()));
        return ResponseData.success((Object)"\u60a3\u8005\u5df2\u79fb\u9664\u5de5\u4f5c\u5ba4\uff01");
    }
}

