/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.rabbitListener;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.byh.outpatient.api.enums.PaymentRecordsStatusEnum;
import com.byh.outpatient.api.enums.PaymentStatusEnum;
import com.byh.outpatient.api.model.order.OutOrderPayment;
import com.byh.outpatient.data.repository.OutOrderPaymentMapper;
import com.rabbitmq.client.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class OrderTimeoutAndUnpaidListener {
    private static final Logger log = LoggerFactory.getLogger(OrderTimeoutAndUnpaidListener.class);
    @Autowired
    private OutOrderPaymentMapper outOrderPaymentMapper;

    @RabbitHandler
    @RabbitListener(queues={"outpatient.delayed.orderOvertime.queue"})
    public void orderTimeoutAndUnpaid(Channel channel, Message message) throws Exception {
        String payOrderNo = new String(message.getBody());
        String messageId = message.getMessageProperties().getMessageId();
        log.info("\u3010\u5ef6\u65f6\u8ba2\u5355\u8d85\u65f6MQ\u3011 \u652f\u4ed8\u5355\u53f7\uff1a\u3010{}\u3011\u3002messageId \u3010{}\u3011", (Object)payOrderNo, (Object)messageId);
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"pay_order_no", (Object)payOrderNo);
            OutOrderPayment outOrderPayment = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)queryWrapper);
            QueryWrapper voidQueryWrapper = new QueryWrapper();
            ((QueryWrapper)voidQueryWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_VOID.getValue())).eq((Object)"pay_order_no", (Object)payOrderNo);
            OutOrderPayment outOrderPaymentVoid = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)queryWrapper);
            if (ObjectUtils.isEmpty((Object)outOrderPayment)) {
                if (!ObjectUtils.isEmpty((Object)outOrderPaymentVoid)) {
                    log.info("\u3010\u5ef6\u65f6\u8ba2\u5355\u8d85\u65f6MQ\u3011 \u652f\u4ed8\u5355\u53f7\uff1a\u3010{}\u3011\u3002messageId \u3010{}\u3011\u3002\u8be5\u652f\u4ed8\u8ba2\u5355\u5df2\u88ab\u66f4\u65b0", (Object)payOrderNo, (Object)messageId);
                    return;
                }
                log.info("\u3010\u5ef6\u65f6\u8ba2\u5355\u8d85\u65f6MQ\u3011 \u652f\u4ed8\u5355\u53f7\uff1a\u3010{}\u3011\u3002messageId \u3010{}\u3011\u3002\u627e\u4e0d\u5230\u652f\u4ed8\u5355\u53f7\u6240\u5728\u8bb0\u5f55\uff01", (Object)payOrderNo, (Object)messageId);
                return;
            }
            if (!PaymentStatusEnum.PAYMENT_CONFIRMED.getValue().equals(outOrderPayment.getPaymentStatus())) {
                log.info("\u3010\u5ef6\u65f6\u8ba2\u5355\u8d85\u65f6MQ\u3011 \u652f\u4ed8\u5355\u53f7\uff1a\u3010{}\u3011\u3002messageId \u3010{}\u3011\u3002\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u53d6\u6d88\uff01", (Object)payOrderNo, (Object)messageId);
                return;
            }
            outOrderPayment.setStatus(PaymentRecordsStatusEnum.STATUS_EXPIRED.getValue());
            outOrderPayment.setPaymentStatus(PaymentStatusEnum.PAYMENT_OVERTIME_UNPAID.getValue());
            int szie = this.outOrderPaymentMapper.updateById((Object)outOrderPayment);
            if (szie != 1) {
                log.info("\u3010\u5ef6\u65f6\u8ba2\u5355\u8d85\u65f6MQ\u3011 \u652f\u4ed8\u5355\u53f7\uff1a\u3010{}\u3011\u3002messageId \u3010{}\u3011\u3002\u66f4\u6539\u72b6\u6001\u5931\u8d25\uff01", (Object)payOrderNo, (Object)messageId);
            }
            log.info("\u3010\u5ef6\u65f6\u8ba2\u5355\u8d85\u65f6MQ\u3011 \u652f\u4ed8\u5355\u53f7\uff1a\u3010{}\u3011\u3002messageId \u3010{}\u3011\u3002\u66f4\u6539\u72b6\u6001:\u8d85\u65f6\u672a\u652f\u4ed8\uff01", (Object)payOrderNo, (Object)messageId);
        }
        catch (Exception e) {
            log.error("\u6d88\u606f\u5904\u7406\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
    }
}

