/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.aspect;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;

public class IpUtils {
    static final String UNKNOWN = "unknown";
    static final String LOCAL_HOST = "127.0.0.1";
    static final String X_REAL_IP = "X-Real-IP";
    static final String PROXY_CLIENT_IP = "Proxy-Client-IP";
    static final String WL_PROXY_CLIENT_IP = "WL-Proxy-Client-IP";

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip != null && !"".equals(ip) && !UNKNOWN.equalsIgnoreCase(ip)) {
            if (ip.indexOf(",") > 0) {
                ip = ip.substring(0, ip.indexOf(","));
            }
            if (LOCAL_HOST.equals(ip)) {
                InetAddress inet = null;
                try {
                    System.out.println("\u83b7\u53d6===25252555555555=====" + InetAddress.getLocalHost());
                    inet = InetAddress.getLocalHost();
                    ip = inet.getHostAddress();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (request.getHeader(X_REAL_IP) != null && !"".equals(request.getHeader(X_REAL_IP)) && !UNKNOWN.equalsIgnoreCase(request.getHeader(X_REAL_IP))) {
            ip = request.getHeader(X_REAL_IP);
        }
        if (request.getHeader(PROXY_CLIENT_IP) != null && !"".equals(request.getHeader(PROXY_CLIENT_IP)) && UNKNOWN.equalsIgnoreCase(request.getHeader(PROXY_CLIENT_IP))) {
            ip = request.getHeader(PROXY_CLIENT_IP);
        }
        if (request.getHeader(WL_PROXY_CLIENT_IP) != null && !"".equals(request.getHeader(WL_PROXY_CLIENT_IP)) && !UNKNOWN.equalsIgnoreCase(request.getHeader(WL_PROXY_CLIENT_IP))) {
            ip = request.getHeader(WL_PROXY_CLIENT_IP);
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static String getIpAddress(HttpServletRequest request) {
        InetAddress inet;
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader(PROXY_CLIENT_IP);
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader(WL_PROXY_CLIENT_IP);
        }
        if ((ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) && ((ip = request.getRemoteAddr()).equals(LOCAL_HOST) || ip.equals("0:0:0:0:0:0:0:1"))) {
            inet = null;
            try {
                inet = InetAddress.getLocalHost();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (inet != null) {
                ip = inet.getHostAddress();
            }
        }
        if (ip != null && ip.length() > 15 && ip.indexOf(",") > 0) {
            ip = ip.substring(0, ip.indexOf(","));
        }
        if ("localhost".equalsIgnoreCase(ip) || LOCAL_HOST.equalsIgnoreCase(ip) || "0:0:0:0:0:0:0:1".equalsIgnoreCase(ip)) {
            try {
                inet = InetAddress.getLocalHost();
                ip = inet.getHostAddress();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        if (ip == null) {
            return LOCAL_HOST;
        }
        return ip;
    }

    public static String getMacAddress() throws Exception {
        byte[] macAddressBytes = NetworkInterface.getByInetAddress(InetAddress.getLocalHost()).getHardwareAddress();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < macAddressBytes.length; ++i) {
            String s;
            if (i != 0) {
                sb.append("-");
            }
            sb.append((s = Integer.toHexString(macAddressBytes[i] & 0xFF)).length() == 1 ? 0 + s : s);
        }
        return sb.toString().trim().toUpperCase();
    }
}

