/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.manger;

import com.alibaba.fastjson.JSON;
import com.byh.outpatient.api.dto.pay.ApplyForARefundDto;
import com.byh.outpatient.api.dto.pay.ICBCPrePayDto;
import com.byh.outpatient.api.dto.pay.PayOrderDto;
import com.byh.outpatient.api.dto.pay.PayReqDto;
import com.byh.outpatient.api.enums.ReturnCodeEnum;
import com.byh.outpatient.api.util.HttpUtils;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.SignUtil;
import com.byh.outpatient.api.vo.pay.ApplyRefundReq;
import com.byh.outpatient.web.mvc.config.NodeConfig;
import java.io.IOException;
import java.util.Map;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderPayManage {
    private static Logger log = LoggerFactory.getLogger(OrderPayManage.class);
    @Autowired
    private NodeConfig nodeConfig;

    public ResponseData<String> createTradeServer(PayReqDto payReqVO) {
        log.info("=====payReqVO========:{}", (Object)JSON.toJSONString((Object)payReqVO));
        PayOrderDto payOrderDto = new PayOrderDto();
        payOrderDto.setPayChannel(payReqVO.getPayChannel());
        payOrderDto.setPayType(payReqVO.getPayType());
        payOrderDto.setMchCode(payReqVO.getMerchantId());
        payOrderDto.setApplyCode(payReqVO.getApplyCode());
        payOrderDto.setOutTradeNo(payReqVO.getOrderSeq());
        payOrderDto.setTotalAmount(payReqVO.getTotalAmount());
        payOrderDto.setActuallyAmount(payReqVO.getPayAmount());
        payOrderDto.setServiceCode(payReqVO.getBizSysSeq());
        payOrderDto.setNonceStr(SignUtil.getNonceStr());
        payOrderDto.setPayNotifyUrl(this.nodeConfig.getPaymentCallbackUrl());
        payOrderDto.setProductInfo(payReqVO.getProductInfo());
        payOrderDto.setAuthCode(payReqVO.getAuthCode());
        Map paramMap = SignUtil.getKeyAndValue((Object)payOrderDto);
        String sign = SignUtil.createSign((Map)paramMap, (String)payReqVO.getApplyKey(), (String[])new String[0]);
        payOrderDto.setSign(sign);
        String url = new StringBuffer(this.nodeConfig.getPaySite()).append("/trade/create-order").toString();
        try {
            log.info("=======>\u8bf7\u6c42\u652f\u4ed8--->url:{},\u53c2\u6570:{}", (Object)url, (Object)JSON.toJSONString((Object)payOrderDto));
            String respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)payOrderDto), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("======>\u8bf7\u6c42\u652f\u4ed8\u54cd\u5e94\u7ed3\u679c\u662f:{}", (Object)respStr);
            String code = JSON.parseObject((String)respStr).getString("code");
            if (ReturnCodeEnum.SUCCEED.getValue().equals(code) && JSON.parseObject((String)respStr).getString("data") != null) {
                return ResponseData.success((Object)JSON.parseObject((String)respStr).getString("data"));
            }
            if (ReturnCodeEnum.IN_PAYMENT.getValue().equals(code) && JSON.parseObject((String)respStr).getString("data") != null) {
                return ResponseData.success((Object)JSON.parseObject((String)respStr).getString("data"));
            }
            return ResponseData.error((String)JSON.parseObject((String)respStr).getString("msg"));
        }
        catch (IOException e) {
            log.error("\u8c03\u7528\u652f\u4ed8\u670d\u52a1\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            return ResponseData.error((String)"\u8c03\u7528\u652f\u4ed8\u670d\u52a1\u5931\u8d25");
        }
    }

    public String createPrePay(ICBCPrePayDto dto) {
        log.info("=====dto========:{}", (Object)JSON.toJSONString((Object)dto));
        PayOrderDto payOrderDto = new PayOrderDto();
        payOrderDto.setPayChannel(dto.getPayChannel());
        payOrderDto.setPayType(dto.getPayType());
        payOrderDto.setMchCode(dto.getMerchantId());
        payOrderDto.setApplyCode(dto.getApplyCode());
        payOrderDto.setOutTradeNo(dto.getOrderSeq());
        payOrderDto.setTotalAmount(dto.getTotalAmount());
        payOrderDto.setActuallyAmount(dto.getPayAmount());
        payOrderDto.setServiceCode(dto.getBizSysSeq());
        payOrderDto.setNonceStr(SignUtil.getNonceStr());
        payOrderDto.setPayNotifyUrl(this.nodeConfig.getPaymentCallbackUrl());
        payOrderDto.setProductInfo(dto.getProductInfo());
        payOrderDto.setAuthCode(dto.getAuthCode());
        payOrderDto.setUserSign("oDGOy5Und8FD0c9nAJBgJaFrq1UY");
        Map paramMap = SignUtil.getKeyAndValue((Object)payOrderDto);
        String sign = SignUtil.createSign((Map)paramMap, (String)dto.getApplyKey(), (String[])new String[0]);
        payOrderDto.setSign(sign);
        String url = new StringBuffer(this.nodeConfig.getPaySite()).append("/trade/create-order").toString();
        try {
            log.info("=======>\u8bf7\u6c42\u652f\u4ed8--->url:{},\u53c2\u6570:{}", (Object)url, (Object)JSON.toJSONString((Object)payOrderDto));
            String respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)payOrderDto), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("======>\u8bf7\u6c42\u652f\u4ed8\u54cd\u5e94\u7ed3\u679c\u662f:{}", (Object)respStr);
            String code = JSON.parseObject((String)respStr).getString("code");
            if (ReturnCodeEnum.SUCCEED.getValue().equals(code) && JSON.parseObject((String)respStr).getString("data") != null) {
                return JSON.parseObject((String)respStr).getString("data");
            }
            if (ReturnCodeEnum.IN_PAYMENT.getValue().equals(code) && JSON.parseObject((String)respStr).getString("data") != null) {
                return JSON.parseObject((String)respStr).getString("data");
            }
            return JSON.parseObject((String)respStr).getString("msg");
        }
        catch (IOException e) {
            log.error("\u8c03\u7528\u652f\u4ed8\u670d\u52a1\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public ResponseData<String> applyForARefund(ApplyForARefundDto applyForARefundDto) {
        ApplyRefundReq applyRefundReq = new ApplyRefundReq();
        applyRefundReq.setPayChannel(applyForARefundDto.getPayChannel());
        applyRefundReq.setMchCode(applyForARefundDto.getMchCode());
        applyRefundReq.setOutTradeNo(applyForARefundDto.getOutTradeNo());
        applyRefundReq.setDealTradeNo(applyForARefundDto.getDealTradeNo());
        applyRefundReq.setTotalAmount(applyForARefundDto.getTotalAmount());
        applyRefundReq.setRefundAmount(applyForARefundDto.getRefundAmount());
        applyRefundReq.setApplyCode(applyForARefundDto.getApplyCode());
        applyRefundReq.setNonceStr(SignUtil.getNonceStr());
        applyRefundReq.setRefundNotifyUrl(this.nodeConfig.getRefundCallbackUrl());
        Map paramMap = SignUtil.getKeyAndValue((Object)applyRefundReq);
        String sign = SignUtil.createSign((Map)paramMap, (String)applyForARefundDto.getApplyKey(), (String[])new String[0]);
        applyRefundReq.setSign(sign);
        String url = new StringBuffer(this.nodeConfig.getPaySite()).append("/trade/refund").toString();
        try {
            log.info("\u8bf7\u6c42\u9000\u6b3e\u7684url\u662f:{}======\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)url, (Object)JSON.toJSONString((Object)applyRefundReq));
            String respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)applyRefundReq), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("\u9000\u6b3e\u8fd4\u56de\u7684\u4fe1\u606f\u662f:{}", (Object)respStr);
            if (ReturnCodeEnum.SUCCEED.getValue().equals(JSON.parseObject((String)respStr).getString("code"))) {
                return ResponseData.success((Object)JSON.parseObject((String)respStr).getString("data"));
            }
            return ResponseData.error((String)JSON.parseObject((String)respStr).getString("msg"));
        }
        catch (IOException e) {
            log.error("\u8c03\u7528\u652f\u4ed8\u670d\u52a1\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            return ResponseData.error((String)"\u8c03\u7528\u652f\u4ed8\u670d\u52a1\u5931\u8d25");
        }
    }
}

