/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.outpatient.api.sysModel.invoice.SysInvoiceDto;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.web.aspect.AntiRefresh;
import com.byh.outpatient.web.aspect.UserOptLogger;
import com.byh.outpatient.web.feign.SysServiceFeign;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.OutInvoiceService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/outInvoice"})
public class OutInvoiceController {
    private final SysServiceFeign sysServiceFeign;
    @Autowired
    private OutInvoiceService outInvoiceService;
    @Autowired
    private CommonRequest commonRequest;

    @UserOptLogger(operation="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5bf9\u5e94\u7684\u7cfb\u7edf\u53d1\u7968\u5206\u9875\u5217\u8868\u6570\u636e")
    @AntiRefresh
    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5bf9\u5e94\u7684\u7cfb\u7edf\u53d1\u7968\u5206\u9875\u5217\u8868\u6570\u636e", httpMethod="POST", notes="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5bf9\u5e94\u7684\u7cfb\u7edf\u53d1\u7968\u5206\u9875\u5217\u8868\u6570\u636e")
    @PostMapping(value={"/page/list/select"})
    public ResponseData selectPageList(@RequestBody SysInvoiceDto dto) {
        Page page = this.sysServiceFeign.selectInvoicePageList(dto);
        return ResponseData.success((Object)page);
    }

    @UserOptLogger(operation="\u95e8\u8bca\u53d1\u7968\u5f00\u5177")
    @ApiOperation(value="\u95e8\u8bca\u53d1\u7968\u5f00\u5177", httpMethod="POST", notes="\u95e8\u8bca\u53d1\u7968\u5f00\u5177")
    @PostMapping(value={"/outInvoicing"})
    public ResponseData outInvoicing(@RequestBody SysInvoiceDto dto) {
        String signNo = this.commonRequest.getSignNo();
        Integer tenantId = this.commonRequest.getTenant();
        boolean result = this.outInvoiceService.outInvoicing(dto.getOrderNo(), signNo, dto.getInvoiceRemark(), tenantId);
        if (result) {
            return ResponseData.success();
        }
        return ResponseData.error((String)"\u95e8\u8bca\u53d1\u7968\u5f00\u5177\u5931\u8d25\uff01");
    }

    @UserOptLogger(operation="\u95e8\u8bca\u53d1\u7968\u4f5c\u5e9f")
    @ApiOperation(value="\u95e8\u8bca\u53d1\u7968\u4f5c\u5e9f", httpMethod="POST", notes="\u95e8\u8bca\u53d1\u7968\u4f5c\u5e9f")
    @PostMapping(value={"/cancel"})
    @AntiRefresh
    public ResponseData cancel(@RequestBody SysInvoiceDto dto) {
        Integer tenantId = this.commonRequest.getTenant();
        boolean result = this.outInvoiceService.cancel(dto.getOrderNo(), tenantId);
        if (result) {
            return ResponseData.success();
        }
        return ResponseData.error((String)"\u95e8\u8bca\u53d1\u7968\u4f5c\u5e9f\u5931\u8d25\uff01");
    }

    @UserOptLogger(operation="\u751f\u6210\u5f00\u7968\u53c2\u6570")
    @ApiOperation(value="\u751f\u6210\u5f00\u7968\u53c2\u6570", httpMethod="POST", notes="\u751f\u6210\u5f00\u7968\u53c2\u6570")
    @PostMapping(value={"/createInvoiceParams"})
    @AntiRefresh
    public ResponseData createInvoiceParams(@RequestBody SysInvoiceDto dto) {
        Integer tenantId = this.commonRequest.getTenant();
        String signNo = this.commonRequest.getSignNo();
        return this.outInvoiceService.createInvoiceParams(dto.getOrderNo(), tenantId, signNo);
    }

    @UserOptLogger(operation="\u66f4\u65b0\u53d1\u7968\u6570\u636e")
    @ApiOperation(value="\u66f4\u65b0\u53d1\u7968\u6570\u636e", httpMethod="POST", notes="\u66f4\u65b0\u53d1\u7968\u6570\u636e")
    @PostMapping(value={"/updateInvoice"})
    @AntiRefresh
    public ResponseData updateInvoice(@RequestBody SysInvoiceDto dto) {
        return this.outInvoiceService.updateInvoice(dto);
    }

    public OutInvoiceController(SysServiceFeign sysServiceFeign) {
        this.sysServiceFeign = sysServiceFeign;
    }
}

