/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.outpatient.api.dto.doctorRegFee.InsertDoctorRegFeeDto;
import com.byh.outpatient.api.dto.doctorRegFee.QueryByDoctorIdDto;
import com.byh.outpatient.api.dto.doctorRegFee.QueryDoctorRegFeeDto;
import com.byh.outpatient.api.enums.DoctorOutpatientTypeEnum;
import com.byh.outpatient.api.exception.BusinessException;
import com.byh.outpatient.api.model.BaseEntity;
import com.byh.outpatient.api.model.doctorRegFee.OutDoctorRegfeeEntity;
import com.byh.outpatient.api.model.outpatienType.OutpatientTypeEntity;
import com.byh.outpatient.api.model.schedule.ScheduleRecordEntity;
import com.byh.outpatient.api.util.ExceptionUtils;
import com.byh.outpatient.api.vo.doctorRegFee.DoctorRegFeeVo;
import com.byh.outpatient.api.vo.schedule.OutpatientTypeVo;
import com.byh.outpatient.data.repository.OutDoctorRegFeeMapper;
import com.byh.outpatient.data.repository.OutpatientTypeMapper;
import com.byh.outpatient.data.repository.ScheduleRecordMapper;
import com.byh.outpatient.web.service.OutDoctorRegFeeService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OutDoctorRegFeeServiceImpl
implements OutDoctorRegFeeService {
    private static final Logger log = LoggerFactory.getLogger(OutDoctorRegFeeServiceImpl.class);
    private Logger logger = LoggerFactory.getLogger(OutDoctorRegFeeServiceImpl.class);
    @Resource
    private OutDoctorRegFeeMapper outDoctorRegFeeMapper;
    @Resource
    private ScheduleRecordMapper scheduleRecordMapper;
    @Resource
    private OutpatientTypeMapper outpatientTypeMapper;

    public List<OutpatientTypeVo> selectListByDoctorId(QueryByDoctorIdDto dto) {
        Integer tenantId = dto.getTenantId();
        Integer doctorId = dto.getDoctorId();
        ArrayList<OutpatientTypeVo> typeList = new ArrayList<OutpatientTypeVo>();
        LambdaQueryWrapper regFeeQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(tenantId != null, OutDoctorRegfeeEntity::getTenantId, (Object)tenantId)).eq(OutDoctorRegfeeEntity::getDoctorId, (Object)doctorId);
        List regFeeList = this.outDoctorRegFeeMapper.selectList((Wrapper)regFeeQueryWrapper);
        if (!regFeeList.isEmpty()) {
            List outpatientTypeIds = regFeeList.stream().map(OutDoctorRegfeeEntity::getOutpatientTypeId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper typeQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(tenantId != null, OutpatientTypeEntity::getTenantId, (Object)tenantId)).eq(OutpatientTypeEntity::getStatus, (Object)"1")).in(BaseEntity::getId, outpatientTypeIds);
            List outpatientTypeList = this.outpatientTypeMapper.selectList((Wrapper)typeQueryWrapper);
            Map typeMap = outpatientTypeList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
            for (OutDoctorRegfeeEntity regFee : regFeeList) {
                String outpatientTypeName;
                OutpatientTypeEntity typeEntity = (OutpatientTypeEntity)typeMap.get(regFee.getOutpatientTypeId());
                if (typeEntity == null) continue;
                OutpatientTypeVo outpatientTypeVo = new OutpatientTypeVo();
                BigDecimal doctorRegFee = typeEntity.getRegFee();
                outpatientTypeVo.setRegFee(doctorRegFee);
                outpatientTypeVo.setOutpatientType(typeEntity.getOutpatientType());
                if (DoctorOutpatientTypeEnum.FIRST_TUMOR.getValue().equals(regFee.getVisitFlag())) {
                    outpatientTypeName = DoctorOutpatientTypeEnum.FIRST_TUMOR.getLabel() + typeEntity.getOutpatientTypeName() + "\uff08 " + doctorRegFee.stripTrailingZeros().toPlainString() + " \u5143\uff09";
                    outpatientTypeVo.setOutpatientTypeName(outpatientTypeName);
                    typeList.add(outpatientTypeVo);
                    continue;
                }
                if (DoctorOutpatientTypeEnum.FIRST_CHRONIC.getValue().equals(regFee.getVisitFlag())) {
                    outpatientTypeName = DoctorOutpatientTypeEnum.FIRST_CHRONIC.getLabel() + typeEntity.getOutpatientTypeName() + "\uff08 " + doctorRegFee.stripTrailingZeros().toPlainString() + " \u5143\uff09";
                    outpatientTypeVo.setOutpatientTypeName(outpatientTypeName);
                    typeList.add(outpatientTypeVo);
                    continue;
                }
                if (!DoctorOutpatientTypeEnum.REPEAT_FLAG.getValue().equals(regFee.getVisitFlag())) continue;
                outpatientTypeName = "\uff08" + DoctorOutpatientTypeEnum.REPEAT_FLAG.getLabel() + "\uff09" + typeEntity.getOutpatientTypeName() + "\uff08 " + doctorRegFee.stripTrailingZeros().toPlainString() + " \u5143\uff09";
                outpatientTypeVo.setOutpatientTypeName(outpatientTypeName);
                typeList.add(outpatientTypeVo);
            }
        }
        OutpatientTypeVo typeVo = new OutpatientTypeVo();
        typeVo.setRegFee(BigDecimal.ZERO);
        typeVo.setOutpatientType("316680");
        typeVo.setOutpatientTypeName("\u514d\u8d39\u95e8\u8bca\uff080\u5143\uff09");
        typeList.add(typeVo);
        return typeList;
    }

    public Page<DoctorRegFeeVo> selectPageList(QueryDoctorRegFeeDto dto) {
        Integer tenantId = dto.getTenantId();
        Page page = new Page((long)dto.getCurrent().intValue(), (long)dto.getSize().intValue());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(tenantId != null, OutDoctorRegfeeEntity::getTenantId, (Object)tenantId);
        List doctorRegFeeList = this.outDoctorRegFeeMapper.selectList((Wrapper)queryWrapper);
        if (!doctorRegFeeList.isEmpty()) {
            List doctorIds = doctorRegFeeList.stream().map(OutDoctorRegfeeEntity::getDoctorId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            dto.setDoctorIds(doctorIds);
            List list = this.outDoctorRegFeeMapper.selectPageList(page, dto);
            List outpatientTypeIds = doctorRegFeeList.stream().map(OutDoctorRegfeeEntity::getOutpatientTypeId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            LambdaQueryWrapper outpatientTypeQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(tenantId != null, OutpatientTypeEntity::getTenantId, (Object)tenantId)).in(BaseEntity::getId, outpatientTypeIds)).eq(OutpatientTypeEntity::getStatus, (Object)"1");
            List outpatientTypeList = this.outpatientTypeMapper.selectList((Wrapper)outpatientTypeQueryWrapper);
            Map typeMap = outpatientTypeList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
            doctorRegFeeList.forEach(regfee -> Optional.ofNullable(typeMap.get(regfee.getOutpatientTypeId())).ifPresent(arg_0 -> ((OutDoctorRegfeeEntity)regfee).setOutpatientType(arg_0)));
            Map<Integer, List<OutDoctorRegfeeEntity>> regfeeMap = doctorRegFeeList.stream().collect(Collectors.groupingBy(OutDoctorRegfeeEntity::getDoctorId));
            for (DoctorRegFeeVo vo : list) {
                List<OutDoctorRegfeeEntity> regFeeList = regfeeMap.get(vo.getId());
                if (regFeeList.isEmpty()) continue;
                for (OutDoctorRegfeeEntity regfee2 : regFeeList) {
                    OutpatientTypeEntity typeEntity = regfee2.getOutpatientType();
                    if (typeEntity == null) continue;
                    String visitFlag = regfee2.getVisitFlag();
                    Integer outpatientTypeId = typeEntity.getId();
                    if (DoctorOutpatientTypeEnum.FIRST_TUMOR.getValue().equals(visitFlag)) {
                        vo.setFirstTumorId(outpatientTypeId);
                        continue;
                    }
                    if (DoctorOutpatientTypeEnum.FIRST_CHRONIC.getValue().equals(visitFlag)) {
                        vo.setFirstChronicId(outpatientTypeId);
                        continue;
                    }
                    if (!DoctorOutpatientTypeEnum.REPEAT_FLAG.getValue().equals(visitFlag)) continue;
                    vo.setRepeatId(outpatientTypeId);
                }
            }
            page.setRecords(list);
        }
        return page;
    }

    public void deleteRelation(InsertDoctorRegFeeDto dto) {
        Integer tenantId = dto.getTenantId();
        Integer doctorId = dto.getDoctorId();
        LocalDate today = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String todayStr = today.format(formatter);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(tenantId != null, ScheduleRecordEntity::getTenantId, (Object)tenantId)).eq(ScheduleRecordEntity::getDoctorId, (Object)doctorId)).ge(ScheduleRecordEntity::getScheduleDate, (Object)todayStr);
        List scheduleRecordList = this.scheduleRecordMapper.selectList((Wrapper)queryWrapper);
        if (!scheduleRecordList.isEmpty()) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u5f53\u524d\u533b\u751f\u5b58\u5728\u6392\u73ed\u4fe1\u606f\uff0c\u5220\u9664\u5931\u8d25\uff01");
        }
        LambdaQueryWrapper deleteWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(tenantId != null, OutDoctorRegfeeEntity::getTenantId, (Object)tenantId)).eq(OutDoctorRegfeeEntity::getDoctorId, (Object)doctorId);
        this.outDoctorRegFeeMapper.delete((Wrapper)deleteWrapper);
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void updateRelation(InsertDoctorRegFeeDto dto) {
        Integer tenantId = dto.getTenantId();
        LambdaQueryWrapper deleteWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(tenantId != null, OutDoctorRegfeeEntity::getTenantId, (Object)tenantId)).eq(OutDoctorRegfeeEntity::getDoctorId, (Object)dto.getDoctorId());
        this.outDoctorRegFeeMapper.delete((Wrapper)deleteWrapper);
        List list = this.setCommonList(dto);
        if (list.isEmpty()) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u81f3\u5c11\u9700\u8981\u9009\u62e9\u4e00\u9879\u95e8\u8bca\u7c7b\u578b\uff01");
        }
        this.outDoctorRegFeeMapper.insertList(list);
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void insertRelation(InsertDoctorRegFeeDto dto) {
        List list = this.setCommonList(dto);
        if (list.isEmpty()) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u81f3\u5c11\u9700\u8981\u9009\u62e9\u4e00\u9879\u95e8\u8bca\u7c7b\u578b\uff01");
        }
        this.outDoctorRegFeeMapper.insertList(list);
    }

    private List<OutDoctorRegfeeEntity> setCommonList(InsertDoctorRegFeeDto dto) {
        Integer repeatId;
        Integer firstChronicId;
        ArrayList<OutDoctorRegfeeEntity> list = new ArrayList<OutDoctorRegfeeEntity>();
        Integer firstTumorId = dto.getFirstTumorId();
        if (firstTumorId != null) {
            OutDoctorRegfeeEntity outDoctorRegfee = this.setCommon(dto, firstTumorId, DoctorOutpatientTypeEnum.FIRST_TUMOR.getValue());
            list.add(outDoctorRegfee);
        }
        if ((firstChronicId = dto.getFirstChronicId()) != null) {
            OutDoctorRegfeeEntity outDoctorRegfee = this.setCommon(dto, firstChronicId, DoctorOutpatientTypeEnum.FIRST_CHRONIC.getValue());
            list.add(outDoctorRegfee);
        }
        if ((repeatId = dto.getRepeatId()) != null) {
            OutDoctorRegfeeEntity outDoctorRegfee = this.setCommon(dto, repeatId, DoctorOutpatientTypeEnum.REPEAT_FLAG.getValue());
            list.add(outDoctorRegfee);
        }
        return list;
    }

    private OutDoctorRegfeeEntity setCommon(InsertDoctorRegFeeDto dto, Integer outpatientTypeId, String visitFlag) {
        OutDoctorRegfeeEntity outDoctorRegfee = new OutDoctorRegfeeEntity();
        outDoctorRegfee.setDoctorId(dto.getDoctorId());
        outDoctorRegfee.setOutpatientTypeId(outpatientTypeId);
        outDoctorRegfee.setVisitFlag(visitFlag);
        outDoctorRegfee.setTenantId(dto.getTenantId());
        outDoctorRegfee.setCreateId(dto.getOperatorId());
        outDoctorRegfee.setCreateName(dto.getOperatorName());
        return outDoctorRegfee;
    }
}

