/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.byh.outpatient.api.model.OutEtubeStudioPatientEntity;
import com.byh.outpatient.api.model.OutEtubeStudioPatientTagEntity;
import com.byh.outpatient.api.model.patient.PatientEntity;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.StringUtil;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.OutEtubeStudioPatientService;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/studioPatient"})
public class OutEtubeStudioPatientController {
    @Autowired
    private OutEtubeStudioPatientService studioPatientService;
    @Autowired
    private CommonRequest commonRequest;

    @PostMapping(value={"/queryPatientByStudio"})
    private ResponseData<PageInfo<PatientEntity>> queryPatientByStudio(@RequestBody OutEtubeStudioPatientEntity entity) {
        return this.studioPatientService.queryPatientByStudio(entity);
    }

    @PostMapping(value={"/removePatient"})
    private ResponseData removePatient(@RequestBody OutEtubeStudioPatientEntity entity) {
        Integer patientId = entity.getPatientId();
        String studioCode = entity.getStudioCode();
        if (patientId == null || StringUtil.isBlank((String)studioCode)) {
            return ResponseData.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.studioPatientService.removePatient(entity);
    }

    @PostMapping(value={"/queryTag"})
    private ResponseData<List<OutEtubeStudioPatientTagEntity>> queryTag(@RequestBody OutEtubeStudioPatientTagEntity entity) {
        return this.studioPatientService.queryTag(entity);
    }

    @PostMapping(value={"/delTag"})
    private ResponseData<PageInfo<PatientEntity>> delTag(@RequestBody OutEtubeStudioPatientTagEntity entity) {
        Integer userId = this.commonRequest.getUserId();
        entity.setDelFlag("1");
        entity.setDelUserId(userId);
        return this.studioPatientService.delTag(entity);
    }

    @PostMapping(value={"/addTag"})
    private ResponseData addTag(@RequestBody OutEtubeStudioPatientTagEntity entity) {
        Integer userId = this.commonRequest.getUserId();
        entity.setCreateUserId(userId);
        return this.studioPatientService.addTag(entity);
    }
}

