/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.byh.outpatient.api.dto.order.OutpatientDaySettlementDto;
import com.byh.outpatient.api.dto.order.PaymentRecordsDto;
import com.byh.outpatient.api.dto.order.QueryFeeDetailsListDto;
import com.byh.outpatient.api.model.order.OutOrder;
import com.byh.outpatient.api.util.EasyExcelUtil;
import com.byh.outpatient.api.util.PageResult;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.vo.order.ExcelPaymentRecords;
import com.byh.outpatient.api.vo.order.ExcelPaymentRecordsByDept;
import com.byh.outpatient.api.vo.order.ExcelPaymentRecordsByDoctor;
import com.byh.outpatient.api.vo.order.ExcelPaymentRecordsDetails;
import com.byh.outpatient.api.vo.order.OutpatientDaySettlementVo;
import com.byh.outpatient.api.vo.order.PayVo;
import com.byh.outpatient.api.vo.order.PaymentDetailsVo;
import com.byh.outpatient.api.vo.order.QueryFeeOrderDetailsVo;
import com.byh.outpatient.api.vo.order.QueryPaymentRecordDetailsPrintVo;
import com.byh.outpatient.api.vo.order.QueryPaymentRecordDetailsVo;
import com.byh.outpatient.api.vo.order.QueryPaymentRecords;
import com.byh.outpatient.api.vo.order.QueryPaymentRecordsDetails;
import com.byh.outpatient.api.vo.order.QueryPaymentRecordsVo;
import com.byh.outpatient.data.repository.OutOrderMapper;
import com.byh.outpatient.web.aspect.UserOptLogger;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.OutOrderPaymentService;
import io.swagger.annotations.ApiOperation;
import io.swagger.v3.oas.annotations.Operation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/outOrderPayment"})
public class OutOrderPaymentController {
    @Resource
    private OutOrderPaymentService outOrderPaymentService;
    @Autowired
    private CommonRequest commonRequest;
    @Autowired
    private OutOrderMapper outOrderMapper;

    @PostMapping(value={"/v1/paymentRecords"})
    @Operation(description="\u652f\u4ed8\u8bb0\u5f55")
    @ApiOperation(value="\u652f\u4ed8\u8bb0\u5f55-\u67e5\u8be2", httpMethod="POST", notes="\u652f\u4ed8\u8bb0\u5f55-\u67e5\u8be2")
    public ResponseData<PageResult<QueryPaymentRecords>> paymentRecords(@RequestBody @Valid PaymentRecordsDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.outOrderPaymentService.paymentRecords(parameter);
    }

    @PostMapping(value={"/v1/paymentRecordsDetail"})
    @Operation(description="\u652f\u4ed8\u8bb0\u5f55")
    @ApiOperation(value="\u652f\u4ed8\u8bb0\u5f55-\u67e5\u8be2", httpMethod="POST", notes="\u652f\u4ed8\u8bb0\u5f55-\u67e5\u8be2")
    public ResponseData<PageResult<QueryPaymentRecordsDetails>> paymentRecordsDetails(@RequestBody @Valid PaymentRecordsDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.outOrderPaymentService.paymentRecordsDetails(parameter);
    }

    @PostMapping(value={"/v1/paymentRecordsByDept"})
    @Operation(description="\u90e8\u95e8\u652f\u4ed8\u8bb0\u5f55")
    @ApiOperation(value="\u90e8\u95e8\u652f\u4ed8\u8bb0\u5f55-\u67e5\u8be2", httpMethod="POST", notes="\u90e8\u95e8\u652f\u4ed8\u8bb0\u5f55-\u67e5\u8be2")
    public ResponseData<PageResult<Map<String, Object>>> paymentRecordsByDept(@RequestBody @Valid PaymentRecordsDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.outOrderPaymentService.paymentRecordsByDept(parameter);
    }

    @PostMapping(value={"/v1/paymentRecordsByDeptExport"})
    @Operation(description="\u90e8\u95e8\u652f\u4ed8\u8bb0\u5f55\u5bfc\u51fa")
    @ApiOperation(value="\u90e8\u95e8\u652f\u4ed8\u8bb0\u5f55-\u5bfc\u51fa", httpMethod="POST", notes="\u90e8\u95e8\u652f\u4ed8\u8bb0\u5f55-\u5bfc\u51fa")
    public void paymentRecordsByDeptExport(@RequestBody @Valid PaymentRecordsDto parameter, HttpServletResponse response) {
        Integer tenant = this.commonRequest.getTenant();
        parameter.setTenantId(tenant);
        String groupType = parameter.getGroupType();
        Boolean flag = groupType == null || !groupType.equals("doctor");
        ResponseData pageResultResponseData = this.outOrderPaymentService.paymentRecordsByDept(parameter);
        List records = ((PageResult)pageResultResponseData.getData()).getRecords();
        List maps = (List)((Map)records.get(0)).get("data");
        List collect = maps.stream().map(map -> {
            Set keySet = map.keySet();
            ExcelPaymentRecordsByDept excelPaymentRecordsByDept = new ExcelPaymentRecordsByDept();
            ExcelPaymentRecordsByDoctor excelPaymentRecordsByDoctor = new ExcelPaymentRecordsByDoctor();
            for (String s : keySet) {
                try {
                    Method method;
                    if (flag.booleanValue()) {
                        method = ExcelPaymentRecordsByDept.class.getMethod("set" + s.substring(0, 1).toUpperCase() + s.substring(1), String.class);
                        if (method == null) continue;
                        method.invoke((Object)excelPaymentRecordsByDept, map.get(s) + "");
                        continue;
                    }
                    method = ExcelPaymentRecordsByDoctor.class.getMethod("set" + s.substring(0, 1).toUpperCase() + s.substring(1), String.class);
                    if (method == null) continue;
                    method.invoke((Object)excelPaymentRecordsByDoctor, map.get(s) + "");
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            if (flag.booleanValue()) {
                return excelPaymentRecordsByDept;
            }
            return excelPaymentRecordsByDoctor;
        }).collect(Collectors.toList());
        ArrayList data = new ArrayList();
        data.add(collect);
        String excelName = "\u652f\u4ed8\u7edf\u8ba1";
        String sheetName = "\u666e\u901a";
        ArrayList<String> sheetNames = new ArrayList<String>();
        sheetNames.add(sheetName);
        ArrayList<Class> classList = new ArrayList<Class>();
        if (flag.booleanValue()) {
            classList.add(ExcelPaymentRecordsByDept.class);
        } else {
            classList.add(ExcelPaymentRecordsByDoctor.class);
        }
        EasyExcelUtil.exportExcelPaging((HttpServletResponse)response, (String)excelName, sheetNames, data, classList);
    }

    @PostMapping(value={"/v1/paymentRecords/export"})
    @Operation(description="\u5bfc\u51fa\u652f\u4ed8\u8bb0\u5f55")
    @ApiOperation(value="\u5bfc\u51fa\u652f\u4ed8\u8bb0\u5f55-\u67e5\u8be2", httpMethod="POST", notes="\u5bfc\u51fa\u652f\u4ed8\u8bb0\u5f55-\u67e5\u8be2")
    public void paymentRecordsExport(HttpServletResponse response, @RequestBody PaymentRecordsDto parameter) {
        parameter.setTenantId(this.commonRequest.getTenant());
        ResponseData pageResultResponseData = this.outOrderPaymentService.paymentRecords(parameter);
        List records = ((PageResult)pageResultResponseData.getData()).getRecords();
        List excelPaymentRecordsList = records.stream().map(excelPaymentRecords -> {
            ExcelPaymentRecords paymentRecords = new ExcelPaymentRecords();
            BeanUtils.copyProperties((Object)excelPaymentRecords, (Object)paymentRecords);
            paymentRecords.setPaymentMethod(excelPaymentRecords.getPaymentMethod());
            return paymentRecords;
        }).collect(Collectors.toList());
        String excelName = "\u652f\u4ed8\u8bb0\u5f55";
        String sheetName = "\u666e\u901a";
        EasyExcelUtil.normalExport((HttpServletResponse)response, (String)excelName, (String)sheetName, excelPaymentRecordsList, ExcelPaymentRecords.class);
    }

    @PostMapping(value={"/v1/paymentRecordsDetails/export"})
    @Operation(description="\u5bfc\u51fa\u652f\u4ed8\u8bb0\u5f55\u8be6\u60c5")
    @ApiOperation(value="\u5bfc\u51fa\u652f\u4ed8\u8bb0\u5f55-\u67e5\u8be2", httpMethod="POST", notes="\u5bfc\u51fa\u652f\u4ed8\u8bb0\u5f55-\u67e5\u8be2")
    public void paymentRecordsDetailsExport(HttpServletResponse response, @RequestBody PaymentRecordsDto parameter) {
        parameter.setTenantId(this.commonRequest.getTenant());
        ResponseData pageResultResponseData = this.outOrderPaymentService.paymentRecords(parameter);
        List records = ((PageResult)pageResultResponseData.getData()).getRecords();
        List excelPaymentRecordsList = records.stream().map(excelPaymentRecords -> {
            ExcelPaymentRecordsDetails paymentRecords = new ExcelPaymentRecordsDetails();
            BeanUtils.copyProperties((Object)excelPaymentRecords, (Object)paymentRecords);
            for (QueryFeeOrderDetailsVo queryFeeOrderDetailsVo : excelPaymentRecords.getDetailsList()) {
                String orderType = queryFeeOrderDetailsVo.getOrderType();
                if (queryFeeOrderDetailsVo.getPaymentStatus() != 20) continue;
                switch (orderType) {
                    case "10": {
                        paymentRecords.setGuaHao(queryFeeOrderDetailsVo.getTotalAmount().add(new BigDecimal(paymentRecords.getGuaHao())).toString());
                        break;
                    }
                    case "20": {
                        paymentRecords.setXiYao(queryFeeOrderDetailsVo.getTotalAmount().add(new BigDecimal(paymentRecords.getXiYao())).toString());
                        break;
                    }
                    case "30": {
                        paymentRecords.setZhongCaoYao(queryFeeOrderDetailsVo.getTotalAmount().add(new BigDecimal(paymentRecords.getZhongCaoYao())).toString());
                        break;
                    }
                    case "40": {
                        paymentRecords.setZhongChengYao(queryFeeOrderDetailsVo.getTotalAmount().add(new BigDecimal(paymentRecords.getZhongChengYao())).toString());
                        break;
                    }
                    case "50": {
                        paymentRecords.setJianYan(queryFeeOrderDetailsVo.getTotalAmount().add(new BigDecimal(paymentRecords.getJianYan())).toString());
                        break;
                    }
                    case "51": {
                        paymentRecords.setJianCha(queryFeeOrderDetailsVo.getTotalAmount().add(new BigDecimal(paymentRecords.getJianCha())).toString());
                        break;
                    }
                    case "53": {
                        paymentRecords.setZhiLiao(queryFeeOrderDetailsVo.getTotalAmount().add(new BigDecimal(paymentRecords.getZhiLiao())).toString());
                        break;
                    }
                    case "54": {
                        paymentRecords.setShouShu(queryFeeOrderDetailsVo.getTotalAmount().add(new BigDecimal(paymentRecords.getShouShu())).toString());
                        break;
                    }
                    case "55": {
                        paymentRecords.setMaZui(queryFeeOrderDetailsVo.getTotalAmount().add(new BigDecimal(paymentRecords.getMaZui())).toString());
                        break;
                    }
                    case "56": {
                        paymentRecords.setHuLi(queryFeeOrderDetailsVo.getTotalAmount().add(new BigDecimal(paymentRecords.getHuLi())).toString());
                        break;
                    }
                    case "57": {
                        paymentRecords.setYinShi(queryFeeOrderDetailsVo.getTotalAmount().add(new BigDecimal(paymentRecords.getYinShi())).toString());
                        break;
                    }
                    case "58": {
                        paymentRecords.setShuYang(queryFeeOrderDetailsVo.getTotalAmount().add(new BigDecimal(paymentRecords.getShuYang())).toString());
                        break;
                    }
                    case "59": {
                        paymentRecords.setCaiLiao(queryFeeOrderDetailsVo.getTotalAmount().add(new BigDecimal(paymentRecords.getCaiLiao())).toString());
                        break;
                    }
                    case "60": {
                        paymentRecords.setXunZhen(queryFeeOrderDetailsVo.getTotalAmount().add(new BigDecimal(paymentRecords.getXunZhen())).toString());
                        break;
                    }
                    case "70": {
                        paymentRecords.setQiTa(queryFeeOrderDetailsVo.getTotalAmount().add(new BigDecimal(paymentRecords.getQiTa())).toString());
                    }
                }
            }
            paymentRecords.setPaymentMethod(excelPaymentRecords.getPaymentMethod());
            return paymentRecords;
        }).collect(Collectors.toList());
        String excelName = "\u95e8\u8bca\u6d41\u6c34\u660e\u7ec6\u5bfc\u51fa";
        String sheetName = "\u666e\u901a";
        EasyExcelUtil.normalExport((HttpServletResponse)response, (String)excelName, (String)sheetName, excelPaymentRecordsList, ExcelPaymentRecordsDetails.class);
    }

    @PostMapping(value={"/v1/paymentRecordsDetails"})
    @Operation(description="\u652f\u4ed8\u8be6\u60c5")
    @ApiOperation(value="\u652f\u4ed8\u8be6\u60c5-\u67e5\u8be2", httpMethod="POST", notes="\u652f\u4ed8\u8be6\u60c5-\u67e5\u8be2")
    public ResponseData<QueryPaymentRecordsVo> paymentRecordsDetails(@RequestBody @Valid QueryFeeDetailsListDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.outOrderPaymentService.paymentRecordsDetails(parameter);
    }

    @PostMapping(value={"/v1/paymentRecordItemDetails"})
    @Operation(description="\u652f\u4ed8\u8bb0\u5f55\u5217\u8868\u8be6\u60c5")
    @ApiOperation(value="\u652f\u4ed8\u8bb0\u5f55\u8be6\u60c5-\u67e5\u8be2", httpMethod="POST", notes="\u652f\u4ed8\u8bb0\u5f55\u8be6\u60c5-\u67e5\u8be2")
    public ResponseData<QueryPaymentRecordDetailsVo> paymentRecordDetails(@RequestBody @Valid QueryFeeDetailsListDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.outOrderPaymentService.paymentRecordDetails(parameter);
    }

    @PostMapping(value={"/v1/paymentDetails"})
    @Operation(description="\u67e5\u8be2\u652f\u4ed8\u7ed3\u679c\u8be6\u60c5")
    @ApiOperation(value="\u652f\u4ed8\u7ed3\u679c\u8be6\u60c5-\u67e5\u8be2", httpMethod="POST", notes="\u652f\u4ed8\u7ed3\u679c\u8be6\u60c5-\u67e5\u8be2")
    public ResponseData<PayVo> paymentDetails(@RequestBody @Valid QueryFeeDetailsListDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.outOrderPaymentService.paymentDetails(parameter);
    }

    @PostMapping(value={"/v1/queryPaymentOrder"})
    @Operation(description="\u6839\u636e\u652f\u4ed8\u5355\u53f7\u67e5\u8be2")
    @ApiOperation(value="\u652f\u4ed8-\u6839\u636e\u652f\u4ed8\u5355\u53f7\u67e5\u8be2", httpMethod="POST", notes="\u652f\u4ed8-\u6839\u636e\u652f\u4ed8\u5355\u53f7\u67e5\u8be2")
    public ResponseData<PaymentDetailsVo> queryPaymentOrder(@RequestBody @Valid QueryFeeDetailsListDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        if (StringUtils.isEmpty((CharSequence)parameter.getPayOrderNo()) && StringUtils.isNotEmpty((CharSequence)parameter.getOrderNo())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"order_no", (Object)parameter.getOrderNo());
            OutOrder OutOrder2 = (OutOrder)this.outOrderMapper.selectOne((Wrapper)queryWrapper);
            if (OutOrder2 != null && StringUtils.isNotEmpty((CharSequence)OutOrder2.getPayOrderNo())) {
                parameter.setPayOrderNo(OutOrder2.getPayOrderNo());
            } else {
                return ResponseData.error((String)"201", (String)"\u652f\u4ed8\u8ba2\u5355\u53f7\u4e3a\u7a7a!");
            }
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.outOrderPaymentService.queryPaymentOrder(parameter);
    }

    @PostMapping(value={"/v1/queryPendingPaymentOrder"})
    @Operation(description="\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u5f85\u652f\u4ed8\u5355")
    @ApiOperation(value="\u652f\u4ed8-\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u5f85\u652f\u4ed8\u5355", httpMethod="POST", notes="\u652f\u4ed8-\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u5f85\u652f\u4ed8\u5355")
    public ResponseData<PaymentDetailsVo> queryPendingPaymentOrder(@RequestBody @Valid QueryFeeDetailsListDto parameter, BindingResult bindingResult) {
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.outOrderPaymentService.queryPendingPaymentOrder(parameter);
    }

    @UserOptLogger(operation="\u66f4\u6539\u652f\u4ed8\u5907\u6ce8")
    @PostMapping(value={"/v1/changeRemarks"})
    @Operation(description="\u66f4\u6539\u5907\u6ce8")
    @ApiOperation(value="\u652f\u4ed8-\u66f4\u6539\u5907\u6ce8", httpMethod="POST", notes="\u652f\u4ed8-\u66f4\u6539\u5907\u6ce8")
    public ResponseData<String> changeRemarks(@RequestBody @Valid QueryFeeDetailsListDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.outOrderPaymentService.changeRemarks(parameter);
    }

    @PostMapping(value={"/v1/outpatientDaySettlement"})
    @Operation(description="\u95e8\u8bca\u652f\u4ed8\u65e5\u7ed3\u5355")
    @ApiOperation(value="\u95e8\u8bca\u652f\u4ed8\u65e5\u7ed3\u5355", httpMethod="POST", notes="\u95e8\u8bca\u652f\u4ed8\u65e5\u7ed3\u5355")
    public ResponseData<OutpatientDaySettlementVo> outpatientDaySettlement(@RequestBody @Valid OutpatientDaySettlementDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        if (parameter.getCheckerId() == null) {
            parameter.setCheckerId(this.commonRequest.getUserId());
        }
        if (parameter.getCheckerId().equals(1) || parameter.getCheckerId().equals(39)) {
            parameter.setCheckerId(null);
        }
        return this.outOrderPaymentService.outpatientDaySettlement(parameter);
    }

    @GetMapping(value={"/v1/getTollCollector"})
    @Operation(description="\u83b7\u53d6\u6240\u6709\u6536\u8d39\u5458id")
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u6536\u8d39\u5458id", httpMethod="POST", notes="\u83b7\u53d6\u6240\u6709\u6536\u8d39\u5458id")
    public ResponseData<OutpatientDaySettlementVo> getTollCollector() {
        Integer tenant = this.commonRequest.getTenant();
        Integer userId = this.commonRequest.getUserId();
        if (userId.equals(1) || userId.equals(39) || userId.equals(51)) {
            return ResponseData.success((Object)this.outOrderPaymentService.getTollCollector(tenant));
        }
        return ResponseData.success(new ArrayList());
    }

    @PostMapping(value={"/v1/paymentRecordItemDetailsPrint"})
    @Operation(description="\u7f34\u8d39\u652f\u4ed8\u51ed\u8bc1\u6253\u5370\u660e\u7ec6\u9879\u76ee")
    @ApiOperation(value="\u7f34\u8d39\u652f\u4ed8\u51ed\u8bc1\u6253\u5370\u660e\u7ec6\u9879\u76ee", httpMethod="POST", notes="\u7f34\u8d39\u652f\u4ed8\u51ed\u8bc1\u6253\u5370\u660e\u7ec6\u9879\u76ee")
    public ResponseData<QueryPaymentRecordDetailsPrintVo> paymentRecordItemDetailsPrint(@RequestBody @Valid QueryFeeDetailsListDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.outOrderPaymentService.paymentRecordItemDetailsPrint(parameter);
    }

    @PostMapping(value={"/v1/paymentRecordItemPrint"})
    @ApiOperation(value="\u7f34\u8d39\u652f\u4ed8\u51ed\u8bc1\u6253\u5370\u590d\u5408\u9879\u76ee", httpMethod="POST", notes="\u7f34\u8d39\u652f\u4ed8\u51ed\u8bc1\u6253\u5370\u590d\u5408\u9879\u76ee")
    public ResponseData<QueryPaymentRecordDetailsPrintVo> paymentRecordItemPrint(@RequestBody @Valid QueryFeeDetailsListDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.outOrderPaymentService.paymentRecordItemPrint(parameter);
    }

    @GetMapping(value={"/v1/queryRecordByNumber"})
    @Operation(description="\u6839\u636e\u4ea4\u6613\u53f7\u67e5\u8be2\u652f\u4ed8\u8bb0\u5f55")
    @ApiOperation(value="\u652f\u4ed8\u8bb0\u5f55-\u67e5\u8be2", httpMethod="POST", notes="\u652f\u4ed8\u8bb0\u5f55-\u67e5\u8be2")
    public ResponseData queryRecordByNumber(@RequestParam(value="transactionNumber", required=true) String transactionNumber) {
        Integer tenant = this.commonRequest.getTenant();
        return this.outOrderPaymentService.queryRecordByNumber(transactionNumber, tenant);
    }
}

