/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.rabbitListener;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.outpatient.api.enums.OutPrescriptionRecordEnum;
import com.byh.outpatient.api.enums.OutpatientDataStatusEnum;
import com.byh.outpatient.api.enums.PaymentRecordsStatusEnum;
import com.byh.outpatient.api.enums.PaymentStatusEnum;
import com.byh.outpatient.api.enums.PrescriptionClassifyTypeEnum;
import com.byh.outpatient.api.enums.PrescriptionStatusEnum;
import com.byh.outpatient.api.enums.PrescriptionTypeEnum;
import com.byh.outpatient.api.model.admission.AdmissionEntity;
import com.byh.outpatient.api.model.order.OutOrder;
import com.byh.outpatient.api.model.patient.PatientEntity;
import com.byh.outpatient.api.model.prescription.OutPrescription;
import com.byh.outpatient.api.model.prescription.OutPrescriptionDrug;
import com.byh.outpatient.api.model.prescription.OutPrescriptionRecord;
import com.byh.outpatient.api.util.ExceptionUtils;
import com.byh.outpatient.api.util.StringUtil;
import com.byh.outpatient.api.util.UUIDUtils;
import com.byh.outpatient.api.vo.prescription.WesternMedicinePrescriptionsVo;
import com.byh.outpatient.data.repository.AdmissionMapper;
import com.byh.outpatient.data.repository.OutOrderMapper;
import com.byh.outpatient.data.repository.OutPrescriptionMapper;
import com.byh.outpatient.data.repository.OutPrescriptionRecordMapper;
import com.byh.outpatient.web.mvc.controller.RocketMQProducerController;
import com.byh.outpatient.web.rocket.RocketMQProducer;
import com.byh.outpatient.web.service.OutPrescriptionDrugService;
import com.byh.outpatient.web.service.OutPrescriptionService;
import com.rabbitmq.client.Channel;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.rocketmq.client.producer.SendCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Component
public class PrescriptionTimeoutAndUnpaidListener {
    private static final Logger logger = LoggerFactory.getLogger(PrescriptionTimeoutAndUnpaidListener.class);
    private static final Logger logger1 = LoggerFactory.getLogger(RocketMQProducerController.class);
    private static final String prescriptionDetailTopic = "rocketMQ-out-prescriptionDetailTopic";
    private RocketMQProducer rocketMQProducer;
    @Resource
    private OutPrescriptionMapper outPrescriptionMapper;
    @Resource
    private AdmissionMapper admissionMapper;
    @Resource
    private OutOrderMapper outOrderMapper;
    @Autowired
    private OutPrescriptionDrugService outPrescriptionDrugService;
    @Autowired
    private OutPrescriptionService outPrescriptionService;
    @Autowired
    private OutPrescriptionRecordMapper outPrescriptionRecordMapper;
    @Autowired
    private PlatformTransactionManager transactionManager;

    @RabbitHandler
    @RabbitListener(queues={"outpatient.delayed.prescriptionOvertime.queue"})
    @Transactional(rollbackFor={Exception.class})
    public void prescriptionTimeoutAndUnpaid(Channel channel, Message message) throws Exception {
        String prescription = new String(message.getBody());
        String messageId = message.getMessageProperties().getMessageId();
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)def);
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)prescription);
            String prescNo = jsonObject.getString("prescriptionNo");
            Integer tenantId = jsonObject.getInteger("tenantId");
            LambdaQueryWrapper outPrescQuery = Wrappers.lambdaQuery();
            outPrescQuery.eq(OutPrescription::getTenantId, (Object)tenantId);
            outPrescQuery.eq(OutPrescription::getPrescriptionNo, (Object)prescNo);
            outPrescQuery.and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(OutPrescription::getPrescriptionStatus, (Object)PrescriptionStatusEnum.STATUS_NORMAL.getValue())).or()).eq(OutPrescription::getPrescriptionStatus, (Object)PrescriptionStatusEnum.STATUS_FILE.getValue());
            });
            OutPrescription outPrescription = (OutPrescription)this.outPrescriptionMapper.selectOne((Wrapper)outPrescQuery);
            if (outPrescription == null) {
                ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)"\u8be5\u5904\u65b9\u4e0d\u5b58\u5728\uff01");
            }
            LambdaQueryWrapper admissionQuery = Wrappers.lambdaQuery();
            admissionQuery.eq(AdmissionEntity::getTenantId, (Object)tenantId);
            admissionQuery.eq(AdmissionEntity::getOutpatientNo, (Object)outPrescription.getOutpatientNo());
            AdmissionEntity admission = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)admissionQuery);
            if (admission == null) {
                ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u95e8\u8bca\u6302\u53f7\u8bb0\u5f55\uff01");
            }
            if (PrescriptionClassifyTypeEnum.NORMAL.getValue().equals(outPrescription.getPrescriptionClassifyType())) {
                LambdaQueryWrapper outOrderQuery = Wrappers.lambdaQuery();
                outOrderQuery.eq(OutOrder::getTenantId, (Object)tenantId);
                outOrderQuery.eq(OutOrder::getPrescriptionNo, (Object)outPrescription.getPrescriptionNo());
                outOrderQuery.eq(OutOrder::getStatus, (Object)OutpatientDataStatusEnum.NORMAL.getValue());
                outOrderQuery.eq(OutOrder::getPaymentStatus, (Object)PaymentStatusEnum.PAYMENT_PENDING.getValue());
                OutOrder outOrder = (OutOrder)this.outOrderMapper.selectOne((Wrapper)outOrderQuery);
                if (outOrder == null) {
                    ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u5546\u54c1\u8ba2\u5355\u4fe1\u606f\uff01");
                }
                outOrder.setStatus(PaymentRecordsStatusEnum.STATUS_EXPIRED.getValue());
                this.outOrderMapper.updateById((Object)outOrder);
            }
            OutPrescription updatePrescription = new OutPrescription();
            updatePrescription.setId(outPrescription.getId());
            updatePrescription.setPrescriptionStatus(PrescriptionStatusEnum.STATUS_VOID.getValue());
            updatePrescription.setUpdateId(Integer.valueOf(1));
            this.outPrescriptionMapper.updateById((Object)updatePrescription);
            try {
                ArrayList<PatientEntity> list = new ArrayList<PatientEntity>();
                PatientEntity patient = new PatientEntity();
                OutPrescription outPrescription1 = (OutPrescription)this.outPrescriptionMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(OutPrescription::getId, (Object)outPrescription.getId()));
                patient.setId(outPrescription1.getPatientId());
                ArrayList<WesternMedicinePrescriptionsVo> voList = new ArrayList<WesternMedicinePrescriptionsVo>();
                WesternMedicinePrescriptionsVo prescriptionsVo = new WesternMedicinePrescriptionsVo();
                BeanUtils.copyProperties((Object)outPrescription1, (Object)prescriptionsVo);
                prescriptionsVo.setId(outPrescription.getId());
                prescriptionsVo.setPrescriptionStatus(PrescriptionStatusEnum.STATUS_VOID.getValue());
                String source = prescriptionsVo.getSource();
                Integer prescriptionStatus = prescriptionsVo.getPrescriptionStatus();
                Integer rationalMedicationStatus = prescriptionsVo.getRationalMedicationStatus();
                Integer prescriptionAuditStatus = prescriptionsVo.getPrescriptionAuditStatus();
                Integer pharmacy = prescriptionsVo.getPharmacy();
                Integer isDecoction = prescriptionsVo.getIsDecoction();
                Integer isInsurancePrescription = prescriptionsVo.getIsInsurancePrescription();
                Integer insurancePrescriptionType = prescriptionsVo.getInsurancePrescriptionType();
                Integer prescriptionType = prescriptionsVo.getPrescriptionType();
                Integer prescriptionClassifyType = prescriptionsVo.getPrescriptionClassifyType();
                prescriptionsVo.setPrescriptionClassifyTypeName(PrescriptionClassifyTypeEnum.getValueEnum((Integer)prescriptionClassifyType));
                prescriptionsVo.setPrescriptionTypeName(PrescriptionTypeEnum.getValueEnum((Integer)prescriptionType));
                if (insurancePrescriptionType != null) {
                    switch (insurancePrescriptionType) {
                        case 1: {
                            prescriptionsVo.setInsurancePrescriptionTypeName("\u666e\u901a\u5904\u65b9");
                            break;
                        }
                        case 2: {
                            prescriptionsVo.setInsurancePrescriptionTypeName("\u95e8\u8bca\u6162\u7279\u75c5\u5904\u65b9");
                        }
                    }
                }
                if (isInsurancePrescription != null) {
                    switch (isInsurancePrescription) {
                        case 1: {
                            prescriptionsVo.setIsInsurancePrescriptionName("\u5426");
                            break;
                        }
                        case 2: {
                            prescriptionsVo.setIsInsurancePrescriptionName("\u662f");
                        }
                    }
                }
                if (isDecoction != null) {
                    switch (isDecoction) {
                        case 1: {
                            prescriptionsVo.setIsDecoctionName("\u5426");
                            break;
                        }
                        case 2: {
                            prescriptionsVo.setIsDecoctionName("\u662f");
                        }
                    }
                }
                if (pharmacy != null) {
                    switch (pharmacy) {
                        case 1: {
                            prescriptionsVo.setPharmacyName("\u9662\u5185");
                            break;
                        }
                        case 2: {
                            prescriptionsVo.setPharmacyName("\u9662\u5916");
                        }
                    }
                }
                if (prescriptionAuditStatus != null) {
                    switch (prescriptionAuditStatus) {
                        case 1: {
                            prescriptionsVo.setPrescriptionAuditStatusName("\u901a\u8fc7");
                            break;
                        }
                        case 2: {
                            prescriptionsVo.setPrescriptionAuditStatusName("\u4e0d\u901a\u8fc7");
                        }
                    }
                }
                if (StringUtil.isNotBlank((String)source)) {
                    switch (source) {
                        case "1": {
                            prescriptionsVo.setSourceName("\u7ebf\u4e0b");
                            break;
                        }
                        case "2": {
                            prescriptionsVo.setSourceName("\u7ebf\u4e0a");
                        }
                    }
                }
                prescriptionsVo.setPrescriptionStatusName(PrescriptionStatusEnum.getValueEnum((Integer)prescriptionStatus));
                if (rationalMedicationStatus != null) {
                    switch (rationalMedicationStatus) {
                        case 1: {
                            prescriptionsVo.setRationalMedicationStatusName("\u5408\u7406");
                            break;
                        }
                        case 2: {
                            prescriptionsVo.setRationalMedicationStatusName("\u4e0d\u5408\u7406");
                        }
                    }
                }
                voList.add(prescriptionsVo);
                patient.setPrescriptionsList(voList);
                list.add(patient);
                String msg = JSONObject.toJSONString(list);
                String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
                this.rocketMQProducer.asyncSendCallbackTimeoutLevel(prescriptionDetailTopic, "TAG5", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            List outPrescriptionDrugList = this.outPrescriptionDrugService.queryPrescriptionDrugsByPresNo(tenantId, prescNo);
            if (outPrescriptionDrugList.isEmpty()) {
                ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)"\u672a\u67e5\u8be2\u5230\u5904\u65b9\u836f\u54c1\u5217\u8868\u4fe1\u606f\uff01");
            }
            if (PrescriptionClassifyTypeEnum.NORMAL.getValue().equals(outPrescription.getPrescriptionClassifyType())) {
                this.outPrescriptionDrugService.sysDrugPharmacyOutUpdateStatus(outPrescription.getLnventoryNumber(), ((OutPrescriptionDrug)outPrescriptionDrugList.get(0)).getPharmacyId(), "3", tenantId);
            }
            OutPrescriptionRecord outPrescRecordEntity = new OutPrescriptionRecord();
            outPrescRecordEntity.setOperationRemark(OutPrescriptionRecordEnum.PRESCRIPTION_VOID.getOperationDescription());
            outPrescRecordEntity.setInspectId(Integer.valueOf(1));
            outPrescRecordEntity.setInspect("48\u5c0f\u65f6\u5904\u65b9\u8d85\u65f6\u4f5c\u5e9f");
            outPrescRecordEntity.setOperatorId(Integer.valueOf(1));
            outPrescRecordEntity.setOperator("48\u5c0f\u65f6\u5904\u65b9\u8d85\u65f6\u4f5c\u5e9f");
            outPrescRecordEntity.setTenantId(tenantId);
            outPrescRecordEntity.setPrescriptionNo(prescNo);
            outPrescRecordEntity.setOperationDescription(OutPrescriptionRecordEnum.PRESCRIPTION_VOID.getDesc());
            outPrescRecordEntity.setOperationResult(OutPrescriptionRecordEnum.PRESCRIPTION_VOID.getOperationDescription());
            outPrescRecordEntity.setOperationTime(new Date());
            this.outPrescriptionRecordMapper.insert((Object)outPrescRecordEntity);
            this.outPrescriptionService.deleteRationDrugUse(outPrescription, outPrescriptionDrugList, admission);
            System.out.println("\u5904\u65b9\u4f5c\u5e9f\u6210\u529f\uff01");
            channel.basicAck(message.getMessageProperties().getDeliveryTag(), false);
        }
        catch (Exception e) {
            this.transactionManager.rollback(status);
            channel.basicAck(message.getMessageProperties().getDeliveryTag(), false);
            return;
        }
    }

    static /* synthetic */ Logger access$000() {
        return logger1;
    }
}

