/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.byh.outpatient.api.dto.checkout.QueryCheckoutListDto;
import com.byh.outpatient.api.dto.checkout.QueryPendingAccountsDto;
import com.byh.outpatient.api.enums.CheckoutEnum;
import com.byh.outpatient.api.enums.OrderTypeEnum;
import com.byh.outpatient.api.enums.PaymentMethodEnum;
import com.byh.outpatient.api.enums.PaymentRecordsStatusEnum;
import com.byh.outpatient.api.model.checkout.OutCheckout;
import com.byh.outpatient.api.model.checkout.OutCheckoutPaymentRecords;
import com.byh.outpatient.api.model.checkout.OutCheckoutSubject;
import com.byh.outpatient.api.util.PageResult;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.StringUtil;
import com.byh.outpatient.api.util.UUIDUtils;
import com.byh.outpatient.api.vo.checkout.OutCheckListVo;
import com.byh.outpatient.api.vo.checkout.ProjectVo;
import com.byh.outpatient.api.vo.checkout.QueryPendingAccountsVo;
import com.byh.outpatient.data.repository.OutCheckoutMapper;
import com.byh.outpatient.data.repository.OutCheckoutPaymentRecordsMapper;
import com.byh.outpatient.data.repository.OutCheckoutSubjectMapper;
import com.byh.outpatient.web.service.OutCheckoutService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class OutCheckoutServiceImpl
implements OutCheckoutService {
    @Autowired
    private OutCheckoutMapper outCheckoutMapper;
    @Autowired
    private OutCheckoutSubjectMapper outCheckoutSubjectMapper;
    @Autowired
    private OutCheckoutPaymentRecordsMapper outCheckoutPaymentRecordsMapper;
    private static Logger log = LoggerFactory.getLogger(OutCheckoutServiceImpl.class);

    public ResponseData<QueryPendingAccountsVo> pendingBillingInformation(QueryPendingAccountsDto parameter) {
        if (StringUtils.isEmpty((CharSequence)parameter.getClosingDate())) {
            return ResponseData.error((String)"\u7ed3\u8d26\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DateTime time = DateUtil.parse((String)parameter.getClosingDate());
        DateTime endTime = DateUtil.offsetDay((Date)time, (int)1);
        List queryProjectByType = this.outCheckoutMapper.queryProjectByType(parameter.getOperatorId(), parameter.getTenantId(), time.toDateStr(), endTime.toDateStr());
        queryProjectByType.forEach(ProjectVo2 -> {
            OrderTypeEnum orderTypeEnum = OrderTypeEnum.getEnum((String)ProjectVo2.getOutpatientNo());
            ProjectVo2.setOutpatientName(orderTypeEnum == null ? null : orderTypeEnum.getRemark());
        });
        List queryProjectByPaymentMethod = this.outCheckoutMapper.queryProjectByPaymentMethod(parameter.getOperatorId(), parameter.getTenantId(), time.toDateStr(), endTime.toDateStr());
        queryProjectByPaymentMethod.forEach(ProjectVo2 -> {
            PaymentMethodEnum paymentMethodEnum = PaymentMethodEnum.getEnum((Integer)Integer.valueOf(ProjectVo2.getOutpatientNo()));
            ProjectVo2.setOutpatientName(paymentMethodEnum == null ? null : paymentMethodEnum.getRemark());
        });
        QueryPendingAccountsVo queryPendingAccountsVo = new QueryPendingAccountsVo();
        queryPendingAccountsVo.setSettlementAmount(queryProjectByType.stream().map(ProjectVo::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        queryPendingAccountsVo.setPaymentMethodAmount(queryProjectByPaymentMethod.stream().map(ProjectVo::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        queryPendingAccountsVo.setClosingDate(parameter.getClosingDate());
        queryPendingAccountsVo.setSettlementAccount(queryProjectByType);
        queryPendingAccountsVo.setPaymentMethod(queryProjectByPaymentMethod);
        return ResponseData.success((Object)queryPendingAccountsVo);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<String> generateBillingStatement(QueryPendingAccountsDto parameter) {
        if (StringUtils.isEmpty((CharSequence)parameter.getClosingDate())) {
            return ResponseData.error((String)"\u7ed3\u8d26\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DateTime time = DateUtil.parse((String)parameter.getClosingDate());
        DateTime endTime = DateUtil.offsetDay((Date)time, (int)1);
        List queryProjectByType = this.outCheckoutMapper.queryProjectByType(parameter.getOperatorId(), parameter.getTenantId(), time.toDateStr(), endTime.toDateStr());
        List queryProjectByPaymentMethod = this.outCheckoutMapper.queryProjectByPaymentMethod(parameter.getOperatorId(), parameter.getTenantId(), time.toDateStr(), endTime.toDateStr());
        OutCheckout outCheckout = this.outCheckoutMapper.queryAmount(parameter.getOperatorId(), parameter.getTenantId(), time.toDateStr(), endTime.toDateStr());
        List outCheckoutPaymentRecords = this.outCheckoutMapper.queryPaymentRecords(parameter.getOperatorId(), parameter.getTenantId(), time.toDateStr(), endTime.toDateStr());
        String checkoutNo = UUIDUtils.getCheckoutNo();
        outCheckout.setCreateId(parameter.getOperatorId());
        outCheckout.setTenantId(parameter.getTenantId());
        outCheckout.setCheckoutNo(checkoutNo);
        outCheckout.setCheckerId(parameter.getOperatorId());
        outCheckout.setCheckerName(parameter.getOperatorName());
        outCheckout.setCheckoutTime((Date)time);
        outCheckout.setCheckoutCreationTime(new Date());
        outCheckout.setStatus(PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
        int size = this.outCheckoutMapper.insert((Object)outCheckout);
        if (size < 1) {
            return ResponseData.error((String)"\u5931\u8d25\uff01");
        }
        List outCheckoutSubjects = OutCheckoutServiceImpl.getOutCheckoutSubjects((QueryPendingAccountsDto)parameter, (List)queryProjectByType, (String)checkoutNo, (OutCheckout)outCheckout, (List)queryProjectByPaymentMethod);
        this.outCheckoutSubjectMapper.batchInsert(outCheckoutSubjects);
        outCheckoutPaymentRecords.forEach(OutCheckoutPaymentRecords2 -> {
            OutCheckoutPaymentRecords2.setCreateId(parameter.getOperatorId());
            OutCheckoutPaymentRecords2.setTenantId(parameter.getTenantId());
            OutCheckoutPaymentRecords2.setCheckoutNo(checkoutNo);
            OutCheckoutPaymentRecords2.setStatus(PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
        });
        this.outCheckoutPaymentRecordsMapper.batchInsert(outCheckoutPaymentRecords);
        return ResponseData.success((Object)"\u5b8c\u6210");
    }

    public ResponseData<PageResult<OutCheckListVo>> queryCheckoutList(QueryCheckoutListDto parameter) {
        if (!StringUtil.isEmpty((String)parameter.getStarTime()) && !StringUtil.isEmpty((String)parameter.getEndTime())) {
            parameter.setStarTime(parameter.getStarTime() + " 00:00:00");
            parameter.setEndTime(parameter.getEndTime() + " 23:59:59");
        }
        PageHelper.startPage((int)parameter.getCurrent(), (int)parameter.getSize());
        List outCheckoutList = this.outCheckoutMapper.queryCheckoutList(parameter);
        PageInfo pageInfo = new PageInfo(outCheckoutList);
        PageResult pageResult = new PageResult(parameter.getCurrent().intValue(), parameter.getSize().intValue());
        pageResult.setTotal(Integer.parseInt(String.valueOf(pageInfo.getTotal())));
        pageResult.setPages(pageInfo.getPages());
        pageResult.setRecords(outCheckoutList);
        pageResult.setCurrent(parameter.getCurrent().intValue());
        pageResult.setSize(parameter.getSize().intValue());
        return ResponseData.success((Object)pageResult);
    }

    public ResponseData<QueryPendingAccountsVo> queryCheckoutDetails(QueryPendingAccountsDto parameter) {
        if (StringUtils.isEmpty((CharSequence)parameter.getCheckoutNo())) {
            return ResponseData.error((String)"\u7ed3\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryWrapper query = new QueryWrapper();
        ((QueryWrapper)query.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"checkout_no", (Object)parameter.getCheckoutNo());
        OutCheckout outCheckout = (OutCheckout)this.outCheckoutMapper.selectOne((Wrapper)query);
        if (ObjectUtils.isEmpty((Object)outCheckout)) {
            return ResponseData.error((String)"\u627e\u4e0d\u5230\u8bb0\u5f55\uff01");
        }
        QueryPendingAccountsVo queryPendingAccountsVo = new QueryPendingAccountsVo();
        BeanUtils.copyProperties((Object)outCheckout, (Object)queryPendingAccountsVo);
        queryPendingAccountsVo.setClosingDate(DateUtil.formatDate((Date)outCheckout.getCheckoutTime()));
        QueryWrapper checkoutQueryWrapper = new QueryWrapper();
        checkoutQueryWrapper.eq((Object)"checkout_no", (Object)outCheckout.getCheckoutNo());
        List outCheckoutSubjects = this.outCheckoutSubjectMapper.selectList((Wrapper)checkoutQueryWrapper);
        if (!CollectionUtils.isEmpty((Collection)outCheckoutSubjects)) {
            Map<Integer, List<OutCheckoutSubject>> collect = outCheckoutSubjects.stream().collect(Collectors.groupingBy(OutCheckoutSubject::getType));
            List settlementAccountList = collect.getOrDefault(CheckoutEnum.SUBJECT.getValue(), Collections.emptyList()).stream().map(subject -> {
                ProjectVo projectVo = new ProjectVo();
                projectVo.setOutpatientName(subject.getProjectName());
                projectVo.setOutpatientNo(subject.getProjectNo());
                projectVo.setAmount(subject.getAmount());
                return projectVo;
            }).collect(Collectors.toList());
            queryPendingAccountsVo.setSettlementAccount(settlementAccountList);
            List paymentMethodList = collect.getOrDefault(CheckoutEnum.PAYMENT_METHOD.getValue(), Collections.emptyList()).stream().map(subject -> {
                ProjectVo projectVo = new ProjectVo();
                projectVo.setOutpatientName(subject.getProjectName());
                projectVo.setOutpatientNo(subject.getProjectNo());
                projectVo.setAmount(subject.getAmount());
                return projectVo;
            }).collect(Collectors.toList());
            queryPendingAccountsVo.setPaymentMethod(paymentMethodList);
            queryPendingAccountsVo.setSettlementAmount(settlementAccountList.stream().map(ProjectVo::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
            queryPendingAccountsVo.setPaymentMethodAmount(paymentMethodList.stream().map(ProjectVo::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        return ResponseData.success((Object)queryPendingAccountsVo);
    }

    public ResponseData<PageResult<OutCheckoutPaymentRecords>> queryBillingPaymentRecords(QueryCheckoutListDto parameter) {
        if (StringUtils.isEmpty((CharSequence)parameter.getCheckoutNo())) {
            return ResponseData.error((String)"\u7ed3\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageHelper.startPage((int)parameter.getCurrent(), (int)parameter.getSize());
        QueryWrapper query = new QueryWrapper();
        ((QueryWrapper)query.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"checkout_no", (Object)parameter.getCheckoutNo());
        List outCheckoutPaymentRecords = this.outCheckoutPaymentRecordsMapper.selectList((Wrapper)query);
        PageInfo pageInfo = new PageInfo(outCheckoutPaymentRecords);
        PageResult pageResult = new PageResult(parameter.getCurrent().intValue(), parameter.getSize().intValue());
        pageResult.setTotal(Integer.parseInt(String.valueOf(pageInfo.getTotal())));
        pageResult.setPages(pageInfo.getPages());
        pageResult.setRecords(outCheckoutPaymentRecords);
        pageResult.setCurrent(parameter.getCurrent().intValue());
        pageResult.setSize(parameter.getSize().intValue());
        return ResponseData.success((Object)pageResult);
    }

    private static List<OutCheckoutSubject> getOutCheckoutSubjects(QueryPendingAccountsDto parameter, List<ProjectVo> queryProjectByType, String checkoutNo, OutCheckout outCheckout, List<ProjectVo> queryProjectByPaymentMethod) {
        ArrayList<OutCheckoutSubject> outCheckoutSubjects = new ArrayList<OutCheckoutSubject>();
        queryProjectByType.forEach(ProjectVo2 -> {
            OrderTypeEnum orderTypeEnum = OrderTypeEnum.getEnum((String)ProjectVo2.getOutpatientNo());
            ProjectVo2.setOutpatientName(orderTypeEnum == null ? null : orderTypeEnum.getRemark());
            OutCheckoutSubject outCheckoutSubject = new OutCheckoutSubject();
            outCheckoutSubject.setCreateId(parameter.getOperatorId());
            outCheckoutSubject.setTenantId(parameter.getTenantId());
            outCheckoutSubject.setCheckoutNo(checkoutNo);
            outCheckoutSubject.setProjectName(ProjectVo2.getOutpatientName());
            outCheckoutSubject.setProjectNo(ProjectVo2.getOutpatientNo());
            outCheckoutSubject.setAmount(ProjectVo2.getAmount());
            outCheckoutSubject.setCheckoutTime(outCheckout.getCheckoutTime());
            outCheckoutSubject.setType(CheckoutEnum.SUBJECT.getValue());
            outCheckoutSubjects.add(outCheckoutSubject);
        });
        queryProjectByPaymentMethod.forEach(ProjectVo2 -> {
            PaymentMethodEnum paymentMethodEnum = PaymentMethodEnum.getEnum((Integer)Integer.valueOf(ProjectVo2.getOutpatientNo()));
            ProjectVo2.setOutpatientName(paymentMethodEnum == null ? null : paymentMethodEnum.getRemark());
            OutCheckoutSubject outCheckoutSubject = new OutCheckoutSubject();
            outCheckoutSubject.setCreateId(parameter.getOperatorId());
            outCheckoutSubject.setTenantId(parameter.getTenantId());
            outCheckoutSubject.setCheckoutNo(checkoutNo);
            outCheckoutSubject.setProjectName(ProjectVo2.getOutpatientName());
            outCheckoutSubject.setProjectNo(ProjectVo2.getOutpatientNo());
            outCheckoutSubject.setAmount(ProjectVo2.getAmount());
            outCheckoutSubject.setCheckoutTime(outCheckout.getCheckoutTime());
            outCheckoutSubject.setType(CheckoutEnum.PAYMENT_METHOD.getValue());
            outCheckoutSubjects.add(outCheckoutSubject);
        });
        return outCheckoutSubjects;
    }
}

